/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.List;
import org.apache.ddlutils.alteration.IndexChange;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.Table;

public abstract class IndexChangeImplBase
extends TableChangeImplBase
implements IndexChange {
    private List _columnNames = new ArrayList();

    public IndexChangeImplBase(String tableName, Index index) {
        super(tableName);
        for (int colIdx = 0; colIdx < index.getColumnCount(); ++colIdx) {
            this._columnNames.add(index.getColumn(colIdx).getName());
        }
    }

    @Override
    public Index findChangedIndex(Database model, boolean caseSensitive) {
        Table table = this.findChangedTable(model, caseSensitive);
        if (table != null) {
            for (int indexIdx = 0; indexIdx < table.getIndexCount(); ++indexIdx) {
                Index curIndex = table.getIndex(indexIdx);
                if (curIndex.getColumnCount() != this._columnNames.size()) continue;
                for (int colIdx = 0; colIdx < curIndex.getColumnCount(); ++colIdx) {
                    String curColName = curIndex.getColumn(colIdx).getName();
                    String expectedColName = (String)this._columnNames.get(colIdx);
                    if ((!caseSensitive || !curColName.equals(expectedColName)) && (caseSensitive || !curColName.equalsIgnoreCase(expectedColName))) continue;
                    return curIndex;
                }
            }
        }
        return null;
    }
}

