/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class ColumnOrderChange
extends TableChangeImplBase {
    private Map _newPositions;

    public ColumnOrderChange(String tableName, Map newPositions) {
        super(tableName);
        this._newPositions = newPositions;
    }

    public int getNewPosition(String sourceColumnName, boolean caseSensitive) {
        Integer newPos = null;
        if (caseSensitive) {
            newPos = (Integer)this._newPositions.get(sourceColumnName);
        } else {
            for (Map.Entry entry : this._newPositions.entrySet()) {
                if (!sourceColumnName.equalsIgnoreCase((String)entry.getKey())) continue;
                newPos = (Integer)entry.getValue();
                break;
            }
        }
        return newPos == null ? -1 : newPos;
    }

    @Override
    public void apply(Database database, boolean caseSensitive) {
        int idx;
        Table table = this.findChangedTable(database, caseSensitive);
        ArrayList<Column> newColumns = new ArrayList<Column>();
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            newColumns.add(table.getColumn(idx));
        }
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            Column column = table.getColumn(idx);
            int newPos = this.getNewPosition(column.getName(), caseSensitive);
            if (newPos < 0) continue;
            newColumns.set(newPos, column);
        }
        table.removeAllColumns();
        table.addColumns(newColumns);
    }
}

