/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import org.apache.ddlutils.PlatformInfo;
import org.apache.ddlutils.alteration.ColumnChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.util.StringUtilsExt;

public class ColumnDefinitionChange
extends ColumnChangeImplBase {
    private Column _newColumnDef;

    public ColumnDefinitionChange(String tableName, String columnName, Column newColumnDef) {
        super(tableName, columnName);
        this._newColumnDef = newColumnDef;
    }

    public Column getNewColumn() {
        return this._newColumnDef;
    }

    public static boolean isChanged(PlatformInfo platformInfo, Column sourceColumn, Column targetColumn) {
        return ColumnDefinitionChange.isTypeChanged(platformInfo, sourceColumn, targetColumn) || ColumnDefinitionChange.isSizeChanged(platformInfo, sourceColumn, targetColumn) || ColumnDefinitionChange.isDefaultValueChanged(sourceColumn, targetColumn) || ColumnDefinitionChange.isRequiredStatusChanged(sourceColumn, targetColumn) || ColumnDefinitionChange.isAutoIncrementChanged(sourceColumn, targetColumn);
    }

    public static boolean isTypeChanged(PlatformInfo platformInfo, Column sourceColumn, Column targetColumn) {
        int targetTypeCode = platformInfo.getTargetJdbcType(targetColumn.getTypeCode());
        return targetTypeCode != sourceColumn.getTypeCode();
    }

    public static boolean isSizeChanged(PlatformInfo platformInfo, Column sourceColumn, Column targetColumn) {
        int targetTypeCode = platformInfo.getTargetJdbcType(targetColumn.getTypeCode());
        boolean sizeMatters = platformInfo.hasSize(targetTypeCode);
        boolean scaleMatters = platformInfo.hasPrecisionAndScale(targetTypeCode);
        if (sizeMatters && !StringUtilsExt.equals((String)sourceColumn.getSize(), (String)targetColumn.getSize())) {
            return true;
        }
        return scaleMatters && (sourceColumn.getPrecisionRadix() != targetColumn.getPrecisionRadix() || sourceColumn.getScale() != targetColumn.getScale());
    }

    public static boolean isSizeReduced(PlatformInfo platformInfo, Column sourceColumn, Column targetColumn) {
        int targetTypeCode = platformInfo.getTargetJdbcType(targetColumn.getTypeCode());
        boolean sizeMatters = platformInfo.hasSize(targetTypeCode);
        boolean scaleMatters = platformInfo.hasPrecisionAndScale(targetTypeCode);
        if (sizeMatters && sourceColumn.getSizeAsInt() > targetColumn.getSizeAsInt()) {
            return true;
        }
        return scaleMatters && (sourceColumn.getPrecisionRadix() > targetColumn.getPrecisionRadix() || sourceColumn.getScale() > targetColumn.getScale());
    }

    public static boolean isDefaultValueChanged(Column sourceColumn, Column targetColumn) {
        Object sourceDefaultValue = sourceColumn.getParsedDefaultValue();
        Object targetDefaultValue = targetColumn.getParsedDefaultValue();
        return sourceDefaultValue == null && targetDefaultValue != null || sourceDefaultValue != null && !sourceDefaultValue.equals(targetDefaultValue);
    }

    public static boolean isRequiredStatusChanged(Column sourceColumn, Column targetColumn) {
        return sourceColumn.isRequired() != targetColumn.isRequired();
    }

    public static boolean isAutoIncrementChanged(Column sourceColumn, Column targetColumn) {
        return sourceColumn.isAutoIncrement() != targetColumn.isAutoIncrement();
    }

    @Override
    public void apply(Database model, boolean caseSensitive) {
        Column column = this.findChangedColumn(model, caseSensitive);
        column.setTypeCode(this._newColumnDef.getTypeCode());
        column.setSize(this._newColumnDef.getSize());
        column.setAutoIncrement(this._newColumnDef.isAutoIncrement());
        column.setRequired(this._newColumnDef.isRequired());
        column.setDescription(this._newColumnDef.getDescription());
        column.setDefaultValue(this._newColumnDef.getDefaultValue());
    }
}

