/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.GemFireTerminateError;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.GfxdUtilLauncher;
import com.pivotal.gemfirexd.tools.internal.GfxdHelpFormatter;
import com.pivotal.gemfirexd.tools.internal.GfxdOption;
import com.pivotal.gemfirexd.tools.internal.GfxdOptionBuilder;
import com.pivotal.gemfirexd.tools.internal.GfxdParser;
import java.io.Console;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class ToolsBase {
    protected Options currentOpts;
    public static PrintStream outputStream;
    protected static final String CONNECTION_URL;
    protected static final String CLIENT_PORT;
    protected static final String CLIENT_BIND_ADDRESS;
    protected static final String MCAST_PORT;
    protected static final String MCAST_ADDRESS;
    protected static final String LOCATORS;
    protected static final String BIND_ADDRESS;
    protected static final String AUTH_PROVIDER;
    protected static final String USERNAME;
    protected static final String PASSWORD;
    protected static final String EXTRA_CONN_PROPS;
    protected static final String SYSTEM_PROPERTY;
    private static final String HELP;

    protected void invoke(String[] args) {
        String cmd = args[0];
        String cmdDescKey = this.getCommandToDescriptionKeyMap().get(cmd);
        GfxdParser parser = new GfxdParser();
        try {
            ProcessCommand processor = this.getCommandProcessor(cmd);
            if (processor == null) {
                throw new ParseException(args[0]);
            }
            this.currentOpts = this.buildCommandOptions(processor);
            CommandLine cmdLine = parser.parse(this.currentOpts, args);
            processor.executeCommand(cmdLine, cmd, cmdDescKey);
        }
        catch (ParseException pe) {
            GfxdHelpFormatter helpFormatter = new GfxdHelpFormatter();
            if (args.length == 2 && cmd != null && (args[1].equals(helpFormatter.getOptPrefix() + HELP) || args[1].equals(helpFormatter.getLongOptPrefix() + HELP))) {
                this.showUsage(null, cmd, cmdDescKey);
            }
            String errMsg = LocalizedResource.getMessage((String)"TOOLS_PARSE_EXCEPTION") + " " + pe.getMessage();
            if (cmd != null) {
                this.showUsage(errMsg, cmd, cmdDescKey);
            } else {
                System.err.println(errMsg);
            }
            throw new GemFireTerminateError("exiting due to parse exception", 1, (Throwable)pe);
        }
        catch (IOException ioe) {
            System.err.println(LocalizedResource.getMessage((String)"TOOLS_OTHER_EXCEPTION") + " " + ioe.getMessage());
            ioe.printStackTrace(System.err);
            throw new GemFireTerminateError("exiting due to IO exception", 1, (Throwable)ioe);
        }
        catch (SQLException sqle) {
            System.err.println(LocalizedResource.getMessage((String)"TOOLS_OTHER_EXCEPTION") + " " + sqle.getMessage());
            sqle.printStackTrace(System.err);
            throw new GemFireTerminateError("exiting due to SQL exception", 1, (Throwable)sqle);
        }
    }

    protected Options buildCommandOptions(ProcessCommand processor) {
        Options opts = new Options();
        this.addConnectionOptions(opts);
        this.addCommonOptions(opts);
        processor.addCommandOptions(opts);
        return opts;
    }

    protected void showUsage(String header, String cmd, String cmdDescKey) {
        ConsoleReader reader = GfxdUtilLauncher.getConsoleReader();
        int width = reader != null ? reader.getTerminal().getWidth() : 80;
        StringPrintWriter pw = new StringPrintWriter();
        if (header != null) {
            pw.println(header);
            pw.println();
        }
        GfxdHelpFormatter formatter = new GfxdHelpFormatter();
        formatter.printHelp((PrintWriter)pw, width, cmd, LocalizedResource.getMessage((String)cmdDescKey), this.currentOpts, 2, 3, this.getUsageString(cmd, cmdDescKey), true);
        this.printUsageExamples(formatter, pw, width, cmd, cmdDescKey);
        GfxdUtilLauncher.printUsage(pw.toString(), 23, reader);
    }

    protected abstract Map<String, String> getCommandToDescriptionKeyMap();

    protected abstract ProcessCommand getCommandProcessor(String var1);

    protected abstract String getUsageString(String var1, String var2);

    protected void printUsageExamples(GfxdHelpFormatter formatter, StringPrintWriter pw, int width, String cmd, String cmdDescKey) {
        String exampleKey;
        String example;
        int exampleNumber = 1;
        while (!(example = LocalizedResource.getMessage((String)(exampleKey = cmdDescKey + "_EXAMPLE" + exampleNumber), (Object)cmd)).startsWith(exampleKey)) {
            if (exampleNumber == 1) {
                pw.println();
                pw.println(LocalizedResource.getMessage((String)"TOOLS_EXAMPLES_HEADER"));
            }
            pw.println();
            formatter.printWrapped((PrintWriter)pw, width, example);
            ++exampleNumber;
        }
    }

    protected void addConnectionOptions(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_URL_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_CONNECTION_URL_MESSAGE")).create(CONNECTION_URL);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PORT_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_CLIENT_PORT_MESSAGE")).create(CLIENT_PORT);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_ADDRESS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_CLIENT_ADDRESS_MESSAGE")).create(CLIENT_BIND_ADDRESS);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PORT_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_MCAST_PORT_MESSAGE")).create(MCAST_PORT);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_ADDRESS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_MCAST_ADDRESS_MESSAGE")).create(MCAST_ADDRESS);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_LOCATORS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_LOCATORS_MESSAGE")).create(LOCATORS);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_ADDRESS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_BIND_ADDRESS_MESSAGE")).create(BIND_ADDRESS);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_AUTH_PROVIDER_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_AUTH_PROVIDER_MESSAGE")).create(AUTH_PROVIDER);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_USERNAME_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_USERNAME_MESSAGE")).create(USERNAME);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PASSWORD_ARG")).hasOptionalArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_PASSWORD_MESSAGE")).create(PASSWORD);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_EXTRA_CONN_PROPS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_EXTRA_CONN_PROPS_MESSAGE")).create(EXTRA_CONN_PROPS);
        opts.addOption((Option)opt);
    }

    protected void addCommonOptions(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_SYSTEM_PROPERTY_ARG")).hasArg().withValueSeparator('D').withDescription(LocalizedResource.getMessage((String)"TOOLS_SYSTEM_PROPERTY_MESSAGE")).create(SYSTEM_PROPERTY);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"TOOLS_HELP_MESSAGE")).withLongOpt(HELP).create(HELP);
        opts.addOption((Option)opt);
    }

    protected boolean handleCommonOption(GfxdOption opt, String cmd, String cmdDescKey) throws ParseException {
        int indexOfEquals;
        String optValue;
        if (SYSTEM_PROPERTY.equals(opt.getOpt())) {
            optValue = opt.getValue();
            indexOfEquals = optValue.indexOf(61);
            if (indexOfEquals < 0) {
                throw new MissingArgumentException((Option)opt);
            }
        } else {
            if (HELP.equals(opt.getOpt())) {
                this.showUsage(null, cmd, cmdDescKey);
                throw new GemFireTerminateError(null, 0);
            }
            return false;
        }
        System.setProperty(optValue.substring(0, indexOfEquals), optValue.substring(indexOfEquals + 1));
        return true;
    }

    protected boolean handleConnectionOption(GfxdOption opt, ConnectionOptions connOpts) {
        String optValue = opt.getOptionValue(MCAST_ADDRESS);
        if (optValue != null) {
            connOpts.properties.append(';').append(MCAST_ADDRESS).append('=').append(optValue);
            connOpts.mcastPort = 10334;
        } else {
            optValue = opt.getOptionValue(MCAST_PORT);
            if (optValue != null) {
                connOpts.mcastPort = Integer.parseInt(optValue);
            } else {
                optValue = opt.getOptionValue(LOCATORS);
                if (optValue != null) {
                    connOpts.locators = optValue;
                    connOpts.properties.append(';').append(LOCATORS).append('=').append(optValue);
                } else {
                    optValue = opt.getOptionValue(BIND_ADDRESS);
                    if (optValue != null) {
                        connOpts.properties.append(';').append(BIND_ADDRESS).append('=').append(optValue);
                    } else {
                        optValue = opt.getOptionValue(AUTH_PROVIDER);
                        if (optValue != null) {
                            connOpts.properties.append(';').append(AUTH_PROVIDER).append('=').append(optValue);
                        } else {
                            optValue = opt.getOptionValue(CLIENT_BIND_ADDRESS);
                            if (optValue != null) {
                                connOpts.clientBindAddress = optValue;
                            } else {
                                optValue = opt.getOptionValue(CONNECTION_URL);
                                if (optValue != null) {
                                    connOpts.connectionUrl = optValue;
                                } else {
                                    optValue = opt.getOptionValue(CLIENT_PORT);
                                    if (optValue != null) {
                                        connOpts.clientPort = Integer.parseInt(optValue);
                                    } else {
                                        optValue = opt.getOptionValue(USERNAME);
                                        if (optValue != null) {
                                            connOpts.user = optValue;
                                        } else {
                                            optValue = opt.getOptionValue(PASSWORD);
                                            if (optValue != null) {
                                                connOpts.password = optValue;
                                            } else {
                                                optValue = opt.getOptionValue(EXTRA_CONN_PROPS);
                                                if (optValue != null) {
                                                    connOpts.extraConnProps = optValue;
                                                } else {
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    protected void handleConnectionOptions(ConnectionOptions connOpts, String cmd, String cmdDescKey) {
        boolean addReadTimeout;
        if (connOpts.mcastPort >= 0 || connOpts.locators != null) {
            if (connOpts.clientPort >= 0 || connOpts.clientBindAddress != null) {
                this.showUsage(LocalizedResource.getMessage((String)"TOOLS_BOTH_EMBEDDED_CLIENT_ERROR"), cmd, cmdDescKey);
                throw new GemFireTerminateError("exiting due to incorect connection options", 1);
            }
            if (connOpts.mcastPort > 0) {
                connOpts.properties.append(';').append(MCAST_PORT).append('=').append(connOpts.mcastPort);
            }
        } else {
            if (connOpts.clientBindAddress == null) {
                connOpts.clientBindAddress = "localhost";
            }
            if (connOpts.clientPort < 0) {
                connOpts.clientPort = 1527;
            }
        }
        if (connOpts.password != null && connOpts.password.length() == 0) {
            Console cons = System.console();
            if (cons == null) {
                throw new IllegalStateException(LocalizedResource.getMessage((String)"TOOLS_NO_CONSOLE_EXCEPTION"));
            }
            char[] pwd = cons.readPassword(LocalizedResource.getMessage((String)"UTIL_password_Prompt"), new Object[0]);
            if (pwd != null) {
                connOpts.password = new String(pwd);
            }
        }
        boolean bl = addReadTimeout = connOpts.clientPort > 0;
        if (connOpts.extraConnProps != null) {
            connOpts.properties.append(';').append(connOpts.extraConnProps);
            if (connOpts.extraConnProps.contains("read-timeout=")) {
                addReadTimeout = false;
            }
        }
        if (addReadTimeout) {
            connOpts.properties.append(";read-timeout=0");
        }
    }

    protected Connection getConnection(ConnectionOptions connOpts, String cmd, String cmdDescKey) throws SQLException {
        this.handleConnectionOptions(connOpts, cmd, cmdDescKey);
        StringBuilder urlBuilder = new StringBuilder();
        if (connOpts.connectionUrl != null) {
            Assert.assertTrue((boolean)connOpts.connectionUrl.startsWith("jdbc:"), (Object)("url must start with jdbc:. passed url=" + connOpts.connectionUrl));
            urlBuilder.append(connOpts.connectionUrl);
        } else if (connOpts.clientPort < 0) {
            String protocol = GfxdUtilLauncher.isSnappyStore() ? "jdbc:snappydata:" : "jdbc:gemfirexd:";
            urlBuilder.append(protocol).append(";host-data=false");
        } else {
            String protocol = GfxdUtilLauncher.isSnappyStore() ? "jdbc:snappydata://" : "jdbc:gemfirexd://";
            String hostName = connOpts.clientBindAddress != null ? connOpts.clientBindAddress : "localhost";
            urlBuilder.append(protocol).append(hostName).append(':').append(connOpts.clientPort).append('/');
        }
        if (connOpts.properties.length() > 0) {
            urlBuilder.append((CharSequence)connOpts.properties);
        }
        if (connOpts.user != null) {
            if (connOpts.connectionUrl != null) {
                System.out.println("Using connection url " + urlBuilder.toString());
            }
            return DriverManager.getConnection(urlBuilder.toString(), connOpts.user, connOpts.password);
        }
        return DriverManager.getConnection(urlBuilder.toString());
    }

    static {
        CONNECTION_URL = LocalizedResource.getMessage((String)"TOOLS_CONNECTION_URL");
        CLIENT_PORT = LocalizedResource.getMessage((String)"TOOLS_CLIENT_PORT");
        CLIENT_BIND_ADDRESS = LocalizedResource.getMessage((String)"TOOLS_CLIENT_ADDRESS");
        MCAST_PORT = LocalizedResource.getMessage((String)"TOOLS_MCAST_PORT");
        MCAST_ADDRESS = LocalizedResource.getMessage((String)"TOOLS_MCAST_ADDRESS");
        LOCATORS = LocalizedResource.getMessage((String)"TOOLS_LOCATORS");
        BIND_ADDRESS = LocalizedResource.getMessage((String)"TOOLS_BIND_ADDRESS");
        AUTH_PROVIDER = LocalizedResource.getMessage((String)"TOOLS_AUTH_PROVIDER");
        USERNAME = LocalizedResource.getMessage((String)"TOOLS_USERNAME");
        PASSWORD = LocalizedResource.getMessage((String)"TOOLS_PASSWORD");
        EXTRA_CONN_PROPS = LocalizedResource.getMessage((String)"TOOLS_EXTRA_CONN_PROPS");
        SYSTEM_PROPERTY = LocalizedResource.getMessage((String)"TOOLS_SYSTEM_PROPERTY");
        HELP = LocalizedResource.getMessage((String)"TOOLS_HELP");
    }

    protected static interface ProcessCommand {
        public void addCommandOptions(Options var1);

        public void executeCommand(CommandLine var1, String var2, String var3) throws ParseException, IOException, SQLException;
    }

    protected static class ConnectionOptions {
        String connectionUrl;
        String clientBindAddress;
        int clientPort = -1;
        int mcastPort = -1;
        String locators;
        String user;
        String password;
        String extraConnProps;
        final StringBuilder properties = new StringBuilder();

        protected ConnectionOptions() {
        }
    }
}

