/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.internal.Assert;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedInput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.tools.ij.Main;
import com.pivotal.gemfirexd.internal.impl.tools.ij.utilMain;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.tools.internal.GfxdOption;
import com.pivotal.gemfirexd.tools.internal.GfxdOptionBuilder;
import com.pivotal.gemfirexd.tools.internal.ToolsBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MiscTools
extends ToolsBase {
    static final String RUN = LocalizedResource.getMessage((String)"MISCTOOLS_RUN");
    private static final String RUN_DESC_KEY = "MISCTOOLS_RUN_DESC";
    private static final Map<String, String> validCommands;
    private static final String SCRIPT_URL;
    private static final String SCRIPT_PATH;
    public static final String PATH_TOKEN;
    private static final String ENCODING;
    private static final String IGNORE_ERRORS;
    private static final String PARAM;
    private static final String NUMTIMESTORUN;
    private String scriptURL;
    private String scriptPath = null;
    private Map<String, String> params = new HashMap<String, String>();
    private String encoding;
    private boolean ignoreErrors;
    private int numTimesToRun = 1;

    public static void main(String[] args) {
        MiscTools instance = new MiscTools();
        instance.invoke(args);
    }

    public static Map<String, String> getValidCommands() {
        return validCommands;
    }

    @Override
    protected Map<String, String> getCommandToDescriptionKeyMap() {
        return validCommands;
    }

    @Override
    protected ToolsBase.ProcessCommand getCommandProcessor(String cmd) {
        if (RUN.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    MiscTools.this.addFileOption(opts);
                    MiscTools.this.addPathOption(opts);
                    MiscTools.this.addEncodingOption(opts);
                    MiscTools.this.addIgnoreErrorsOption(opts);
                    MiscTools.this.addParamOption(opts);
                    MiscTools.this.addNumTimesToRun(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, IOException, SQLException {
                    Connection conn = MiscTools.this.getConnection(cmdLine, cmd, cmdDescKey);
                    if (MiscTools.this.encoding == null) {
                        MiscTools.this.encoding = "UTF-8";
                    }
                    InputStream scriptInput = SharedUtils.openURL((String)MiscTools.this.scriptPath, (String)MiscTools.this.scriptURL);
                    LocalizedResource lr = LocalizedResource.getInstance();
                    PrintStream out = ToolsBase.outputStream != null ? ToolsBase.outputStream : System.out;
                    LocalizedOutput lo = lr.getNewEncodedOutput((OutputStream)out, MiscTools.this.encoding);
                    LocalizedInput li = lr.getNewEncodedInput(scriptInput, MiscTools.this.encoding);
                    Main ijE = new Main(false);
                    utilMain um = MiscTools.this.ignoreErrors ? ijE.getutilMain(1, lo) : new utilMain(1, lo, new Hashtable(), MiscTools.this.scriptPath, MiscTools.this.params, MiscTools.this.numTimesToRun);
                    um.goScript(conn, li, true);
                }
            };
        }
        return null;
    }

    protected void addFileOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_FILE_URL_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_SCRIPT_MESSAGE")).create(SCRIPT_URL);
        opts.addOption((Option)opt);
    }

    protected void addPathOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(false).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_PATH_MESSAGE")).create(SCRIPT_PATH);
        opts.addOption((Option)opt);
    }

    protected void addEncodingOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"MISCTOOLS_CHARSET")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_ENCODING_MESSAGE")).create(ENCODING);
        opts.addOption((Option)opt);
    }

    protected void addIgnoreErrorsOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_RUN_IGNORE_ERRORS_MESSAGE")).create(IGNORE_ERRORS);
        opts.addOption((Option)opt);
    }

    protected void addParamOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PARAM_ARG")).hasArg().isRequired(false).withValueSeparator(':').withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_PARAM_MESSAGE")).create(PARAM);
        opts.addOption((Option)opt);
    }

    protected void addNumTimesToRun(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_NUMTIMESTORUN_ARG")).hasArg().isRequired(false).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"MISCTOOLS_NUMTIMESTORUN_MESSAGE")).create(NUMTIMESTORUN);
        opts.addOption((Option)opt);
    }

    protected Connection getConnection(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        ToolsBase.ConnectionOptions connOpts = new ToolsBase.ConnectionOptions();
        for (GfxdOption opt : cmdLine) {
            if (SCRIPT_URL.equals(opt.getOpt())) {
                this.scriptURL = opt.getValue();
                continue;
            }
            if (SCRIPT_PATH.equals(opt.getOpt())) {
                String path = opt.getValue();
                if (!new File(path).isDirectory()) {
                    Assert.fail((Object)(path + " not a directory"));
                }
                this.scriptPath = path;
                continue;
            }
            if (ENCODING.equals(opt.getOpt())) {
                this.encoding = opt.getValue();
                continue;
            }
            if (IGNORE_ERRORS.equals(opt.getOpt())) {
                this.ignoreErrors = true;
                continue;
            }
            if (PARAM.equals(opt.getOpt())) {
                String[] param = opt.getValue().split("=");
                for (String existingKey : this.params.keySet()) {
                    if (existingKey.indexOf(param[0]) != 0 && param[0].indexOf(existingKey) != 0) continue;
                    Assert.fail((Object)(existingKey + " and " + param[0] + " cannot be subset of each other." + "The parameter names must atleast differ in the first character"));
                }
                if (param.length != 2) {
                    Assert.fail((Object)("Parameter value not found. Passed in => [" + opt.getValue() + "]"));
                }
                this.params.put(param[0], param[1]);
                continue;
            }
            if (NUMTIMESTORUN.equals(opt.getOpt())) {
                this.numTimesToRun = Integer.parseInt(opt.getValue());
                continue;
            }
            if (this.handleCommonOption(opt, cmd, cmdDescKey) || this.handleConnectionOption(opt, connOpts)) continue;
            Assert.fail((Object)opt.toString());
        }
        return this.getConnection(connOpts, cmd, cmdDescKey);
    }

    @Override
    protected String getUsageString(String cmd, String cmdDescKey) {
        return LocalizedResource.getMessage((String)"TOOLS_COMMON_DESC");
    }

    static {
        SCRIPT_URL = LocalizedResource.getMessage((String)"TOOLS_FILE");
        SCRIPT_PATH = LocalizedResource.getMessage((String)"TOOLS_PATH_ARG");
        PATH_TOKEN = "<" + SCRIPT_PATH + ">";
        ENCODING = LocalizedResource.getMessage((String)"MISCTOOLS_ENCODING");
        IGNORE_ERRORS = LocalizedResource.getMessage((String)"MISCTOOLS_RUN_IGNORE_ERRORS");
        PARAM = LocalizedResource.getMessage((String)"TOOLS_PARAM_ARG");
        NUMTIMESTORUN = LocalizedResource.getMessage((String)"TOOLS_NUMTIMESTORUN_ARG");
        validCommands = new LinkedHashMap<String, String>();
        validCommands.put(RUN, RUN_DESC_KEY);
    }
}

