/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.internal.Assert;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.tools.internal.GfxdOption;
import com.pivotal.gemfirexd.tools.internal.GfxdOptionBuilder;
import com.pivotal.gemfirexd.tools.internal.ToolsBase;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class JarTools
extends ToolsBase {
    static final String INSTALL_JAR = LocalizedResource.getMessage((String)"JARTOOLS_INSTALL_JAR");
    static final String REMOVE_JAR = LocalizedResource.getMessage((String)"JARTOOLS_REMOVE_JAR");
    static final String REPLACE_JAR = LocalizedResource.getMessage((String)"JARTOOLS_REPLACE_JAR");
    private static final String INSTALL_JAR_DESC_KEY = "JARTOOLS_INSTALL_JAR_DESC";
    private static final String REMOVE_JAR_DESC_KEY = "JARTOOLS_REMOVE_JAR_DESC";
    private static final String REPLACE_JAR_DESC_KEY = "JARTOOLS_REPLACE_JAR_DESC";
    private static final Map<String, String> validCommands;
    private static final String JAR_NAME;
    private static final String FILE_URL;
    private String jarName;
    private String fileURL;

    public static void main(String[] args) {
        JarTools instance = new JarTools();
        instance.invoke(args);
    }

    public static Map<String, String> getValidCommands() {
        return validCommands;
    }

    @Override
    protected Map<String, String> getCommandToDescriptionKeyMap() {
        return validCommands;
    }

    @Override
    protected ToolsBase.ProcessCommand getCommandProcessor(String cmd) {
        if (INSTALL_JAR.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    JarTools.this.addFileOption(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, IOException, SQLException {
                    Connection conn = JarTools.this.getConnection(cmdLine, cmd, cmdDescKey, true);
                    CallableStatement cstmt = conn.prepareCall("call SQLJ.INSTALL_JAR_BYTES(?, ?)");
                    InputStream is = SharedUtils.openURL((String)JarTools.this.fileURL);
                    cstmt.setBinaryStream(1, is);
                    cstmt.setString(2, JarTools.this.jarName);
                    cstmt.executeUpdate();
                    System.out.println(LocalizedResource.getMessage((String)"JARTOOLS_INSTALL_SUCCESS", (Object)JarTools.this.fileURL, (Object)JarTools.this.jarName));
                }
            };
        }
        if (REMOVE_JAR.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    Connection conn = JarTools.this.getConnection(cmdLine, cmd, cmdDescKey, true);
                    CallableStatement cstmt = conn.prepareCall("call SQLJ.REMOVE_JAR(?, 0)");
                    cstmt.setString(1, JarTools.this.jarName);
                    cstmt.executeUpdate();
                    System.out.println(LocalizedResource.getMessage((String)"JARTOOLS_REMOVE_SUCCESS", (Object)JarTools.this.fileURL, (Object)JarTools.this.jarName));
                }
            };
        }
        if (REPLACE_JAR.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    JarTools.this.addFileOption(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, IOException, SQLException {
                    Connection conn = JarTools.this.getConnection(cmdLine, cmd, cmdDescKey, true);
                    CallableStatement cstmt = conn.prepareCall("call SQLJ.REPLACE_JAR_BYTES(?, ?)");
                    InputStream is = SharedUtils.openURL((String)JarTools.this.fileURL);
                    cstmt.setBinaryStream(1, is);
                    cstmt.setString(2, JarTools.this.jarName);
                    cstmt.executeUpdate();
                    System.out.println(LocalizedResource.getMessage((String)"JARTOOLS_REPLACE_SUCCESS", (Object)JarTools.this.fileURL, (Object)JarTools.this.jarName));
                }
            };
        }
        return null;
    }

    @Override
    protected void addCommonOptions(Options opts) {
        super.addCommonOptions(opts);
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"JARTOOLS_JAR_NAME_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"JARTOOLS_JAR_NAME_MESSAGE")).create(JAR_NAME);
        opts.addOption((Option)opt);
    }

    protected void addFileOption(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_FILE_URL_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"JARTOOLS_JAR_FILE_MESSAGE")).create(FILE_URL);
        opts.addOption((Option)opt);
    }

    protected Connection getConnection(CommandLine cmdLine, String cmd, String cmdDescKey, boolean hasFileName) throws ParseException, SQLException {
        ToolsBase.ConnectionOptions connOpts = new ToolsBase.ConnectionOptions();
        for (GfxdOption opt : cmdLine) {
            if (JAR_NAME.equals(opt.getOpt())) {
                this.jarName = opt.getValue();
                continue;
            }
            if (hasFileName && FILE_URL.equals(opt.getOpt())) {
                this.fileURL = opt.getValue();
                continue;
            }
            if (this.handleCommonOption(opt, cmd, cmdDescKey) || this.handleConnectionOption(opt, connOpts)) continue;
            Assert.fail((Object)opt.toString());
        }
        return this.getConnection(connOpts, cmd, cmdDescKey);
    }

    @Override
    protected String getUsageString(String cmd, String cmdDescKey) {
        return LocalizedResource.getMessage((String)"TOOLS_COMMON_DESC");
    }

    static {
        JAR_NAME = LocalizedResource.getMessage((String)"JARTOOLS_JAR_NAME");
        FILE_URL = LocalizedResource.getMessage((String)"TOOLS_FILE");
        validCommands = new LinkedHashMap<String, String>();
        validCommands.put(INSTALL_JAR, INSTALL_JAR_DESC_KEY);
        validCommands.put(REPLACE_JAR, REPLACE_JAR_DESC_KEY);
        validCommands.put(REMOVE_JAR, REMOVE_JAR_DESC_KEY);
    }
}

