/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.GfxdUtilLauncher;
import java.io.Console;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import jline.console.ConsoleReader;

public class GfxdServerLauncher
extends CacheServerLauncher {
    protected static final String HEAP_SIZE = "heap-size";
    protected static final String OFF_HEAP_SIZE = "off-heap-size";
    protected static final String INITIAL_HEAP = "initial-heap";
    protected static final String MAX_HEAP = "max-heap";
    protected static final long DEFAULT_HEAPSIZE_GB = 4L;
    protected static final long DEFAULT_HEAPSIZE_SMALL_GB = 2L;
    protected static final String RUN_NETSERVER = "run-netserver";
    protected static final String NETWORK_BIND_ADDRESS_ARG = "client-bind-address";
    protected static final String NETWORK_PORT_ARG = "client-port";
    protected static final String WAIT_FOR_SYNC = "sync";
    protected static final String THRIFT_SERVER_ADDRESS = "thrift-server-address";
    protected static final String THRIFT_SERVER_PORT = "thrift-server-port";
    protected static final String DRDA_SERVER_ADDRESS = "drda-server-address";
    protected static final String DRDA_SERVER_PORT = "drda-server-port";
    private static final byte[] ENV_B1 = new byte[]{62, -18, -120, -17};
    private static final byte[] ENV_B2 = new byte[]{28, -20, 55, 74};
    private static final String ENV1 = "env_1";
    private static final byte[] ENV_B3 = new byte[]{-26, 46, -42, -61};
    private static final byte[] ENV_B4 = new byte[]{93, -126, 116, -66};
    private static final String ENV2 = "env_2";
    private static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(GfxdServerLauncher.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");
    protected final String jvmVendor;
    protected Properties bootProps;
    protected boolean waitForData;
    private HashMap<String, String> deprecatedAttributes = new HashMap();
    protected boolean processedDefaultGCParams = false;
    private static final Set<String> gfePropNames = new THashSet(Arrays.asList(AbstractDistributionConfig._getAttNames()));

    public GfxdServerLauncher(String baseName) {
        super(baseName);
        GemFireCacheImpl.setGFXDSystem((boolean)true);
        this.jvmVendor = System.getProperty("java.vendor");
        STATUS_WAIT_TIME = Long.getLong("gemfirexd.launcher.STATUS_WAIT_TIME_MS", 15000L);
        SHUTDOWN_WAIT_TIME = Long.getLong("gemfirexd.launcher.SHUTDOWN_WAIT_TIME_MS", 20000L);
        this.waitForData = false;
        this.populateDeprecatedAttributes();
    }

    private void populateDeprecatedAttributes() {
        this.deprecatedAttributes.put(INITIAL_HEAP, HEAP_SIZE);
        this.deprecatedAttributes.put(MAX_HEAP, HEAP_SIZE);
    }

    protected void usage() throws IOException {
        String script = LocalizedResource.getMessage((String)"FS_SCRIPT");
        String name = LocalizedResource.getMessage((String)"FS_NAME");
        String usageOutput = LocalizedResource.getMessage((String)"SERVER_HELP", (Object)script, (Object)name, (Object)LocalizedResource.getMessage((String)"FS_ADDRESS_ARG"), (Object)LocalizedResource.getMessage((String)"FS_EXTRA_HELP", (Object)LocalizedResource.getMessage((String)"FS_PRODUCT")));
        this.printUsage(usageOutput, 23);
    }

    protected final void printUsage(String usageOutput, int maxLines) throws IOException {
        ConsoleReader reader = GfxdUtilLauncher.getConsoleReader();
        GfxdUtilLauncher.printUsage(usageOutput, maxLines, reader);
    }

    protected InternalDistributedSystem connect(Properties props, Map<String, Object> options) {
        props = GfxdServerLauncher.processProperties(props, options, this.defaultLogFileName);
        try {
            this.startServerVM(props);
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException(ex);
            rte.setStackTrace(new StackTraceElement[0]);
            throw rte;
        }
        return InternalDistributedSystem.getConnectedInstance();
    }

    public static Properties processProperties(Properties props, Map<String, Object> options, String defaultLogFileName) {
        float thresholdOffHeap;
        String statsFile;
        String gfxdLogFile;
        boolean hasMcastPort;
        if (props == null) {
            props = new Properties();
        }
        boolean hasLocators = props.containsKey("locators") || props.containsKey("start-locator");
        boolean bl = hasMcastPort = props.containsKey("mcast-port") || props.containsKey("mcast-address");
        if (hasLocators && !hasMcastPort) {
            props.setProperty("mcast-port", "0");
        }
        if (!props.containsKey("host-data")) {
            props.setProperty("host-data", "true");
        }
        if (!((gfxdLogFile = props.getProperty(GfxdConstants.GFXD_LOG_FILE)) != null && gfxdLogFile.length() != 0 || (gfxdLogFile = props.getProperty("log-file")) != null && gfxdLogFile.length() != 0)) {
            if (defaultLogFileName.length() > 0) {
                props.setProperty("log-file", defaultLogFileName);
                gfxdLogFile = defaultLogFileName;
            } else {
                gfxdLogFile = null;
            }
        }
        if (gfxdLogFile != null) {
            System.setProperty(GfxdConstants.GFXD_LOG_FILE, gfxdLogFile);
        }
        if ((statsFile = props.getProperty("statistic-archive-file")) == null) {
            if (gfxdLogFile != null) {
                statsFile = gfxdLogFile;
            } else {
                statsFile = props.getProperty("statistic-archive-file");
                if (statsFile == null) {
                    statsFile = defaultLogFileName;
                }
            }
            statsFile = statsFile.endsWith(".log") ? statsFile.replaceAll("\\.log$", ".gfs") : statsFile + ".gfs";
            props.setProperty("statistic-archive-file", statsFile);
        } else if (statsFile.length() == 0) {
            props.remove("statistic-archive-file");
        }
        float threshold = GfxdServerLauncher.getCriticalHeapPercent(options);
        if (threshold > 0.0f) {
            props.setProperty("critical-heap-percentage", Float.toString(threshold));
        }
        if ((threshold = GfxdServerLauncher.getEvictionHeapPercent(options)) > 0.0f) {
            props.setProperty("eviction-heap-percentage", Float.toString(threshold));
        }
        if ((thresholdOffHeap = GfxdServerLauncher.getCriticalOffHeapPercent(options)) > 0.0f) {
            props.setProperty("critical-off-heap-percentage", Float.toString(thresholdOffHeap));
        }
        if ((thresholdOffHeap = GfxdServerLauncher.getEvictionOffHeapPercent(options)) > 0.0f) {
            props.setProperty("eviction-off-heap-percentage", Float.toString(thresholdOffHeap));
        }
        return props;
    }

    protected void startServerVM(Properties props) throws Exception {
        ((FabricServer)this.getFabricServiceInstance()).start(props);
        this.bootProps = props;
    }

    protected FabricService getFabricServiceInstance() throws Exception {
        return (FabricService)Class.forName("com.pivotal.gemfirexd.FabricServiceManager").getMethod("getFabricServerInstance", new Class[0]).invoke(null, new Object[0]);
    }

    protected Cache createCache(InternalDistributedSystem system, Map<String, Object> options) {
        Cache cache = CacheFactory.getInstance((DistributedSystem)system);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(Cache cache) {
        Exception severeEx = null;
        try {
            this.getFabricServiceInstance().stop(this.bootProps);
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 50000 && "XJ015".equals(se.getSQLState())) {
            } else {
                severeEx = se;
            }
        }
        catch (Exception ex) {
            severeEx = ex;
        }
        finally {
            if (severeEx != null) {
                String msg = LocalizedResource.getMessage((String)"FS_JDBC_SHUTDOWN_ERROR");
                this.logSevere(msg, severeEx);
            }
            if (!cache.isClosed()) {
                cache.close();
            }
        }
    }

    protected void logSevere(String msg, Throwable t) {
        if (this.logger != null) {
            if (msg != null) {
                this.logger.convertToLogWriter().severe(msg, t);
            } else {
                this.logger.severe(t);
            }
        } else {
            if (msg != null) {
                System.out.println("[severe] " + msg);
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    protected void logWarning(String msg, Throwable t) {
        if (this.logger != null) {
            if (msg != null) {
                this.logger.convertToLogWriter().warning(msg, t);
            } else {
                this.logger.warning(t);
            }
        } else {
            if (msg != null) {
                System.out.println("[warning] " + msg);
            }
            if (t != null) {
                t.printStackTrace();
            }
        }
    }

    protected boolean setDefaultHeapSize() {
        return true;
    }

    protected void processStartArg(String key, String value, Map<String, Object> m, List<String> vmArgs, Properties props) throws Exception {
        throw new IllegalArgumentException(LocalizedStrings.GfxdServerLauncher_UNKNOWN_ARGUMENT.toLocalizedString(new Object[]{key, value}));
    }

    protected void processStartOption(String key, String value, Map<String, Object> m, List<String> vmArgs, Map<String, String> envArgs, Properties props) throws Exception {
        String netBindAddressArg = this.getNetworkAddressArgName();
        String netPortArg = this.getNetworkPortArgName();
        if (this.deprecatedAttributes.keySet().contains(key)) {
            throw new IllegalArgumentException(LocalizedResource.getMessage((String)"TOOLS_DEPRECATED_ATTRIBUTES_MESSAGE", (Object)key, (Object)this.deprecatedAttributes.get(key)));
        }
        if (HEAP_SIZE.equals(key)) {
            if (this.maxHeapSize == null) {
                vmArgs.add("-Xmx" + value);
                this.maxHeapSize = value;
            }
            if (this.initialHeapSize == null) {
                vmArgs.add("-Xms" + value);
                this.initialHeapSize = value;
            }
        } else if (OFF_HEAP_SIZE.equals(key)) {
            props.setProperty("off-heap-memory-size", value);
            this.offHeapSize = value;
        } else if (RUN_NETSERVER.equals(key)) {
            m.put(RUN_NETSERVER, value);
        } else if (netBindAddressArg.equals(key)) {
            m.put(netBindAddressArg, value);
        } else if (netPortArg.equals(key)) {
            try {
                int netPort = Integer.parseInt(value);
                if (netPort < 1 || netPort > 65535) {
                    String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                    throw new IllegalArgumentException(msg);
                }
                m.put(netPortArg, value);
            }
            catch (NumberFormatException nfe) {
                String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                throw new IllegalArgumentException(msg, nfe);
            }
        } else if (THRIFT_SERVER_ADDRESS.equals(key)) {
            m.put(THRIFT_SERVER_ADDRESS, value);
        } else if (THRIFT_SERVER_PORT.equals(key)) {
            try {
                int thriftPort = Integer.parseInt(value);
                if (thriftPort < 1 || thriftPort > 65535) {
                    String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                    throw new IllegalArgumentException(msg);
                }
                m.put(THRIFT_SERVER_PORT, value);
            }
            catch (NumberFormatException nfe) {
                String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                throw new IllegalArgumentException(msg, nfe);
            }
        } else if (DRDA_SERVER_ADDRESS.equals(key)) {
            m.put(DRDA_SERVER_ADDRESS, value);
        } else if (DRDA_SERVER_PORT.equals(key)) {
            try {
                int drdaPort = Integer.parseInt(value);
                if (drdaPort < 1 || drdaPort > 65535) {
                    String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                    throw new IllegalArgumentException(msg);
                }
                m.put(DRDA_SERVER_PORT, value);
            }
            catch (NumberFormatException nfe) {
                String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                throw new IllegalArgumentException(msg, nfe);
            }
        } else if ("auth-provider".equals(key)) {
            props.setProperty("auth-provider", value);
        } else if ("server-auth-provider".equals(key)) {
            props.setProperty("server-auth-provider", value);
        } else if ("password".equalsIgnoreCase(key) && (value == null || value.length() == 0)) {
            this.readPassword(envArgs);
        } else if (WAIT_FOR_SYNC.equals(key)) {
            if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                throw new IllegalArgumentException(LocalizedResource.getMessage((String)"UTIL_GFXD_ExpectedBoolean", (Object)WAIT_FOR_SYNC, (Object)value));
            }
            this.waitForData = "true".equalsIgnoreCase(value);
        } else {
            super.processStartOption(key, value, m, vmArgs, envArgs, props);
        }
    }

    protected void processServerEnv(Properties props) throws Exception {
        NativeCalls nc = NativeCalls.getInstance();
        String encPasswd = nc.getEnvironment(ENV1);
        if (encPasswd != null) {
            nc.setEnvironment(ENV1, null);
            if (encPasswd.length() > 0) {
                byte[] keyBytes = this.getBytesEnv();
                props.setProperty("password", GemFireXDUtils.decrypt((String)encPasswd, null, (byte[])keyBytes));
            }
        }
    }

    protected void readPassword(Map<String, String> envArgs) throws Exception {
        Console cons = System.console();
        if (cons == null) {
            throw new IllegalStateException("No console found for reading the password.");
        }
        char[] pwd = cons.readPassword(LocalizedResource.getMessage((String)"UTIL_password_Prompt"), new Object[0]);
        if (pwd != null) {
            String passwd = new String(pwd);
            byte[] keyBytes = this.getBytesEnv();
            envArgs.put(ENV1, GemFireXDUtils.encrypt((String)passwd, null, (byte[])keyBytes));
        }
    }

    private final byte[] getBytesEnv() throws Exception {
        InetAddress host;
        byte[] bytes = new byte[16];
        int step = 4;
        int pos = 0;
        Assert.assertTrue((4 == ENV_B2.length ? 1 : 0) != 0);
        System.arraycopy(ENV_B2, 0, bytes, pos, 4);
        Assert.assertTrue((4 == ENV_B1.length ? 1 : 0) != 0);
        System.arraycopy(ENV_B1, 0, bytes, pos += 4, 4);
        Assert.assertTrue((4 == ENV_B3.length ? 1 : 0) != 0);
        System.arraycopy(ENV_B3, 0, bytes, pos += 4, 4);
        Assert.assertTrue((4 == ENV_B4.length ? 1 : 0) != 0);
        System.arraycopy(ENV_B4, 0, bytes, pos += 4, 4);
        try {
            host = SocketCreator.getLocalHost();
        }
        catch (Exception ex) {
            host = null;
        }
        if (host != null) {
            GemFireXDUtils.updateCipherKeyBytes((byte[])bytes, (byte[])host.getAddress());
        }
        return bytes;
    }

    protected List<String> postProcessOptions(List<String> incomingVMArgs, Map<String, Object> map) {
        if (this.processedDefaultGCParams) {
            return incomingVMArgs;
        }
        int evictPercent = 0;
        int criticalPercent = 0;
        if (this.offHeapSize != null) {
            if (!map.containsKey("critical-off-heap-percentage")) {
                criticalPercent = 90;
                map.put("critical-off-heap-percentage", "-critical-off-heap-percentage=90");
            }
            if (!map.containsKey("eviction-off-heap-percentage")) {
                evictPercent = criticalPercent * 4 / 5;
                map.put("eviction-off-heap-percentage", "-eviction-off-heap-percentage=" + evictPercent);
            }
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        if (this.maxPermGenSize == null && this.jvmVendor != null && (this.jvmVendor.contains("Sun") || this.jvmVendor.contains("Oracle"))) {
            this.maxPermGenSize = "-XX:MaxPermSize=128m";
            vmArgs.add(this.maxPermGenSize);
        }
        if (this.maxHeapSize == null) {
            if (this.initialHeapSize != null) {
                vmArgs.add("-Xmx" + this.initialHeapSize);
                this.maxHeapSize = this.initialHeapSize;
            } else {
                Properties props = (Properties)map.get("properties");
                if (this.setDefaultHeapSize() && !"false".equalsIgnoreCase(props.getProperty("host-data"))) {
                    OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
                    Object memSize = null;
                    try {
                        Method m = bean.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
                        m.setAccessible(true);
                        memSize = m.invoke((Object)bean, new Object[0]);
                    }
                    catch (Exception m) {
                        // empty catch block
                    }
                    if (memSize != null && memSize instanceof Number) {
                        long totalMemory = ((Number)memSize).longValue();
                        long useDefaultMemoryGB = 4L;
                        long defaultMemory = 0x100000000L;
                        if (totalMemory * 2L < defaultMemory * 3L) {
                            useDefaultMemoryGB = 2L;
                            defaultMemory = 0x80000000L;
                            if (totalMemory * 2L < defaultMemory * 3L) {
                                useDefaultMemoryGB = 0L;
                            }
                        }
                        if (useDefaultMemoryGB > 0L) {
                            this.maxHeapSize = this.initialHeapSize = Long.toString(useDefaultMemoryGB) + 'g';
                            vmArgs.add("-Xmx" + this.maxHeapSize);
                            vmArgs.add("-Xms" + this.initialHeapSize);
                        }
                    }
                }
            }
        } else if (this.initialHeapSize == null) {
            vmArgs.add("-Xms" + this.maxHeapSize);
            this.initialHeapSize = this.maxHeapSize;
        }
        if (this.maxHeapSize != null && this.maxHeapSize.equals(this.initialHeapSize)) {
            if (!map.containsKey("critical-heap-percentage")) {
                criticalPercent = 90;
                map.put("critical-heap-percentage", "-critical-heap-percentage=90");
            } else {
                String criticalHeapStr = (String)map.get("critical-heap-percentage");
                criticalPercent = Integer.parseInt(criticalHeapStr.substring(criticalHeapStr.indexOf(61) + 1).trim());
            }
            if (!map.containsKey("eviction-heap-percentage")) {
                evictPercent = criticalPercent * 9 / 10;
                map.put("eviction-heap-percentage", "-eviction-heap-percentage=" + evictPercent);
            } else {
                String evictHeapStr = (String)map.get("eviction-heap-percentage");
                evictPercent = Integer.parseInt(evictHeapStr.substring(evictHeapStr.indexOf(61) + 1).trim());
            }
            if (this.jvmVendor != null && (this.jvmVendor.contains("Sun") || this.jvmVendor.contains("Oracle"))) {
                vmArgs.add("-XX:+UseParNewGC");
                vmArgs.add("-XX:+UseConcMarkSweepGC");
                vmArgs.add("-XX:CMSInitiatingOccupancyFraction=50");
                vmArgs.add("-XX:+CMSClassUnloadingEnabled");
                vmArgs.add("-XX:NewRatio=2");
            }
        }
        if (evictPercent != 0) {
            float criticalThickness = (float)criticalPercent * 0.05f;
            vmArgs.add("-Dgemfire.thresholdThickness=" + criticalThickness);
            float evictThickness = (float)evictPercent * 0.1f;
            vmArgs.add("-Dgemfire.eviction-thresholdThickness=" + evictThickness);
            float evictBurstPercent = (float)evictPercent * 0.02f;
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictionBurstPercentage=" + evictBurstPercent);
            vmArgs.add("-Dgemfire.heapPollerInterval=50");
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirst=false");
            vmArgs.add("-Dgemfire.HeapLRUCapacityController.evictHighEntryCountBucketsFirstForEvictor=true");
        }
        vmArgs.addAll(incomingVMArgs);
        this.processedDefaultGCParams = true;
        return vmArgs;
    }

    protected String getNetworkAddressArgName() {
        return NETWORK_BIND_ADDRESS_ARG;
    }

    protected String getNetworkPortArgName() {
        return NETWORK_PORT_ARG;
    }

    protected void processUnknownStartOption(String key, String value, Map<String, Object> m, List<String> vmArgs, Properties props) {
        props.setProperty(key, value);
    }

    public static void main(String[] args) {
        GfxdServerLauncher launcher = new GfxdServerLauncher("SnappyData Server");
        launcher.run(args);
    }

    protected String getBaseName(String name) {
        if (!StringUtils.isBlank((String)System.getenv("SNAPPY_HOME"))) {
            return "snappyserver";
        }
        return "gfxdserver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(String[] args) {
        instance = this;
        boolean inServer = false;
        try {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("start")) {
                    if (args.length > 1 && args[1] != null && args[1].equalsIgnoreCase("listcmds")) {
                        this.listOptions("start", args);
                    }
                    this.start(args);
                } else if (args[0].equalsIgnoreCase("server")) {
                    inServer = true;
                    this.server(args);
                } else if (args[0].equalsIgnoreCase("stop")) {
                    this.stop(args);
                    System.clearProperty("gemfirexd.system.home");
                } else if (args[0].equalsIgnoreCase("status")) {
                    this.status(args);
                } else if (args[0].equalsIgnoreCase("listcmds")) {
                    this.listCommands();
                } else if (args[0].equalsIgnoreCase("wait")) {
                    this.waitForData = true;
                    this.waitForRunning(args);
                } else {
                    this.usage();
                    System.exit(1);
                }
            } else {
                this.usage();
                System.exit(1);
            }
            if (DONT_EXIT_AFTER_LAUNCH) {
                return;
            }
            try {
                throw new Exception("internal error.. shouldn't reach here.");
            }
            catch (Throwable t) {
                Error err;
                if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                    SystemFailure.initiateFailure((Error)err);
                    err.printStackTrace();
                    String errorMsg = LocalizedResource.getMessage((String)"FS_START_ERROR");
                    if (inServer) {
                        Throwable lastE = err;
                        Error exception = err;
                        while ((lastE = exception.getCause()) != null) {
                            exception = lastE;
                        }
                        String msg = exception.getMessage() == null ? "" : "\n" + exception.getClass().getSimpleName() + ": " + exception.getMessage();
                        this.setServerError(errorMsg + msg, err);
                    }
                    throw err;
                }
                SystemFailure.checkFailure();
                t.printStackTrace();
                String errorMsg = LocalizedResource.getMessage((String)"FS_START_ERROR");
                if (inServer) {
                    Throwable lastE = t;
                    while ((lastE = t.getCause()) != null) {
                        t = lastE;
                    }
                    String msg = t.getMessage() == null ? "" : "\n" + t.getClass().getSimpleName() + ": " + t.getMessage();
                    this.setServerError(errorMsg + msg, t);
                }
                this.restoreStdOut();
                if (this.logger != null) {
                    this.logger.convertToLogWriter().severe(errorMsg, t);
                } else {
                    System.out.println(errorMsg + t.getMessage());
                }
                System.exit(1);
            }
        }
        finally {
            instance = null;
        }
    }

    private void listCommands() {
        System.out.println("start");
        System.out.println("status");
        System.out.println("stop");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listOptions(String subCmd, String[] args) {
        try {
            String current;
            boolean isPrefixHyphen;
            String prefix;
            switch (args.length) {
                case 3: {
                    prefix = args[2];
                    isPrefixHyphen = prefix.equals("-");
                    if (!isPrefixHyphen) {
                        return;
                    }
                    current = "";
                    break;
                }
                default: {
                    prefix = args[2];
                    isPrefixHyphen = prefix.equals("-");
                    current = args[3] != null ? args[3] : "";
                }
            }
            boolean startsWithGemfire = current.startsWith("gemfire.");
            boolean startsWithGemfirexd = current.startsWith(GfxdConstants.GFXD_PREFIX);
            if (!startsWithGemfire && !startsWithGemfirexd && isPrefixHyphen) {
                System.out.println("-dir");
            }
            if (!subCmd.equals("start")) {
                return;
            }
            this.listAddOnArgs(startsWithGemfire, startsWithGemfirexd, isPrefixHyphen);
            for (String s : FabricServiceUtils.getGFEPropNames()) {
                if (startsWithGemfire) {
                    System.out.print(prefix);
                    System.out.print("gemfire.");
                    System.out.println(s);
                    continue;
                }
                if (!isPrefixHyphen) continue;
                System.out.print(prefix);
                System.out.println(s);
            }
            for (String s : new TreeSet(GfxdConstants.validExtraGFXDProperties)) {
                if (startsWithGemfirexd) {
                    System.out.print(prefix);
                    System.out.print(GfxdConstants.GFXD_PREFIX);
                    System.out.println(s);
                    continue;
                }
                if (!isPrefixHyphen) continue;
                System.out.print(prefix);
                System.out.println(s);
            }
        }
        finally {
            System.exit(0);
        }
    }

    protected void listAddOnArgs(boolean startsWithGemfire, boolean startsWithGemfirexd, boolean isPrefixHyphen) {
        if (!startsWithGemfire && !startsWithGemfirexd && isPrefixHyphen) {
            System.out.println("-classpath");
            System.out.println("-rebalance");
            System.out.println("-lock-memory");
            System.out.println("-server-port");
            System.out.println("-server-bind-address");
            System.out.println("-sync");
            System.out.println("-disable-default-server");
            System.out.println("-critical-heap-percentage");
            System.out.println("-eviction-heap-percentage");
            System.out.println("-heap-size");
            System.out.println("-critical-off-heap-percentage");
            System.out.println("-eviction-off-heap-percentage");
            System.out.println("-off-heap-size");
            System.out.println("-server-groups");
            System.out.println("-init-scripts");
            System.out.println("-run-netserver");
            System.out.println("-" + this.getNetworkAddressArgName());
            System.out.println("-" + this.getNetworkPortArgName());
            System.out.println("-thrift-server-address");
            System.out.println("-thrift-server-port");
            System.out.println("-drda-server-address");
            System.out.println("-drda-server-port");
        }
    }

    protected void addToServerCommand(List<String> cmds, Map<String, Object> options) {
        String drdaPort;
        String thriftPort;
        String netPortArg;
        String port;
        String netAddressArg;
        String bindAddress;
        super.addToServerCommand(cmds, options);
        String runNetServer = (String)options.get(RUN_NETSERVER);
        if (runNetServer != null) {
            cmds.add("-run-netserver=" + runNetServer);
        }
        if ((bindAddress = (String)options.get(netAddressArg = this.getNetworkAddressArgName())) != null) {
            cmds.add("-" + netAddressArg + '=' + bindAddress);
        }
        if ((port = (String)options.get(netPortArg = this.getNetworkPortArgName())) != null) {
            cmds.add("-" + netPortArg + '=' + port);
        }
        if ((bindAddress = (String)options.get(THRIFT_SERVER_ADDRESS)) != null) {
            cmds.add("-thrift-server-address=" + bindAddress);
        }
        if ((thriftPort = (String)options.get(THRIFT_SERVER_PORT)) != null) {
            cmds.add("-thrift-server-port=" + thriftPort);
        }
        if ((bindAddress = (String)options.get(DRDA_SERVER_ADDRESS)) != null) {
            cmds.add("-drda-server-address=" + bindAddress);
        }
        if ((drdaPort = (String)options.get(DRDA_SERVER_PORT)) != null) {
            cmds.add("-drda-server-port=" + drdaPort);
        }
    }

    private String availablePort(String portStr) {
        block5: {
            if (portStr != null) {
                try {
                    int port = Integer.parseInt(portStr);
                    if (port != 1527) break block5;
                    int i = 0;
                    while (i < 10) {
                        if (AvailablePort.isPortAvailable((int)port, (int)0)) {
                            portStr = Integer.toString(port);
                            break;
                        }
                        Thread.sleep(50L);
                        ++i;
                        ++port;
                    }
                }
                catch (InterruptedException | NumberFormatException exception) {
                    // empty catch block
                }
            }
        }
        return portStr;
    }

    protected void printStartMessage(Map<String, Object> options, Properties props, int pid) throws Exception {
        InetAddress listenAddr;
        String thriftDisplay;
        Properties configProps = new Properties();
        Set<String> gfePropNames = GfxdServerLauncher.getGFEPropNames();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!gfePropNames.contains(key)) continue;
            configProps.put(entry.getKey(), entry.getValue());
        }
        DistributionConfig config = this.printDiscoverySettings(options, configProps);
        String runNetServer = (String)options.get(RUN_NETSERVER);
        String bindAddress = (String)options.get(this.getNetworkAddressArgName());
        String port = (String)options.get(this.getNetworkPortArgName());
        String string = thriftDisplay = "true".equalsIgnoreCase(props.getProperty("thrift-ssl")) ? "Secure(SSL) Thrift" : "Thrift";
        if (runNetServer == null || Boolean.valueOf(runNetServer).equals(Boolean.TRUE)) {
            listenAddr = FabricServiceUtils.getListenAddress((String)bindAddress, (DistributionConfig)config);
            port = port != null ? port : String.valueOf(1527);
            System.out.println(LocalizedStrings.GfxdServerLauncher_STARTING_NET_SERVER.toLocalizedString(new Object[]{this.useThriftServerDefault ? thriftDisplay : "DRDA", "SnappyData", listenAddr, this.availablePort(port)}));
        }
        if ((port = (String)options.get(THRIFT_SERVER_PORT)) != null) {
            bindAddress = (String)options.get(THRIFT_SERVER_ADDRESS);
            listenAddr = FabricServiceUtils.getListenAddress((String)bindAddress, (DistributionConfig)config);
            System.out.println(LocalizedStrings.GfxdServerLauncher_STARTING_NET_SERVER.toLocalizedString(new Object[]{thriftDisplay, this.baseName, listenAddr, this.availablePort(port)}));
        }
        if ((port = (String)options.get(DRDA_SERVER_PORT)) != null) {
            bindAddress = (String)options.get(DRDA_SERVER_ADDRESS);
            listenAddr = FabricServiceUtils.getListenAddress((String)bindAddress, (DistributionConfig)config);
            System.out.println(LocalizedStrings.GfxdServerLauncher_STARTING_NET_SERVER.toLocalizedString(new Object[]{"DRDA", this.baseName, listenAddr, this.availablePort(port)}));
        }
    }

    protected DistributionConfig printDiscoverySettings(Map<String, Object> options, Properties props) throws SQLException {
        String startMessage;
        Object homeObj = options.get("dir");
        if (homeObj != null) {
            FabricServiceUtils.defineSystemPropertyIfAbsent(null, (String)"gemfirexd.system.home", (String)homeObj.toString(), null, null);
        }
        props = FabricServiceUtils.preprocessProperties((Properties)props, null, null, (boolean)true);
        props = FabricServiceUtils.filterGemFireProperties((Properties)props, (String)"gemfirexdservertemp.log");
        DistributionConfigImpl config = new DistributionConfigImpl(props);
        String startLocator = props.getProperty("start-locator");
        String locators = props.getProperty("locators");
        String mcastPort = props.getProperty("mcast-port");
        if (startLocator != null && startLocator.length() > 0) {
            startMessage = LocalizedResource.getMessage((String)"FS_START_EMBEDDED_LOCATOR", (Object)this.baseName, (Object)startLocator);
        } else if (locators != null && locators.length() > 0) {
            startMessage = LocalizedResource.getMessage((String)"FS_START_LOCATORS", (Object)this.baseName, (Object)locators);
        } else if ("0".equals(mcastPort)) {
            startMessage = LocalizedResource.getMessage((String)"FS_START_LONER", (Object)this.baseName);
        } else {
            String mcastAddress = config.getMcastAddress().toString();
            if (mcastAddress.charAt(0) == '/') {
                mcastAddress = mcastAddress.substring(1);
            }
            startMessage = LocalizedResource.getMessage((String)"FS_START_MCAST", (Object)this.baseName, (Object)(mcastAddress + '[' + config.getMcastPort() + ']'));
        }
        System.out.println(startMessage);
        return config;
    }

    protected void startAdditionalServices(Cache cache, Map<String, Object> options, Properties props) throws Exception {
        Object drdaArg;
        Object thriftArg;
        String bindAddress;
        String runNetServer = (String)options.get(RUN_NETSERVER);
        if (runNetServer == null || "true".equalsIgnoreCase(runNetServer)) {
            Properties networkProperties = new Properties();
            if (props != null) {
                networkProperties.putAll((Map<?, ?>)props);
            }
            bindAddress = null;
            int port = -1;
            Object netPortObj = options.get(this.getNetworkAddressArgName());
            if (netPortObj != null) {
                bindAddress = (String)netPortObj;
            }
            if ((netPortObj = options.get(this.getNetworkPortArgName())) != null) {
                port = Integer.parseInt((String)netPortObj);
            }
            this.getFabricServiceInstance().startNetworkServer(bindAddress, port, networkProperties);
        }
        if ((thriftArg = options.get(THRIFT_SERVER_PORT)) != null) {
            int port = Integer.parseInt((String)thriftArg);
            bindAddress = null;
            thriftArg = options.get(THRIFT_SERVER_ADDRESS);
            if (thriftArg != null) {
                bindAddress = (String)thriftArg;
            }
            Properties networkProperties = new Properties();
            if (props != null) {
                networkProperties.putAll((Map<?, ?>)props);
            }
            this.getFabricServiceInstance().startThriftServer(bindAddress, port, networkProperties);
        }
        if ((drdaArg = options.get(DRDA_SERVER_PORT)) != null) {
            int port = Integer.parseInt((String)drdaArg);
            String bindAddress2 = null;
            drdaArg = options.get(DRDA_SERVER_ADDRESS);
            if (drdaArg != null) {
                bindAddress2 = (String)drdaArg;
            }
            Properties networkProperties = new Properties();
            if (props != null) {
                networkProperties.putAll((Map<?, ?>)props);
            }
            this.getFabricServiceInstance().startDRDAServer(bindAddress2, port, networkProperties);
        }
    }

    protected void setRunningStatus(CacheServerLauncher.Status stat, InternalDistributedSystem system) {
        Set otherMembers = system.getDistributionManager().getAllOtherMembers();
        int numOtherMembers = otherMembers.size();
        if (numOtherMembers > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Object memberObj : otherMembers) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (++i < 8) {
                    InternalDistributedMember member = (InternalDistributedMember)memberObj;
                    Object vmKind = null;
                    try {
                        vmKind = Class.forName("com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils").getMethod("getVMKind", DistributedMember.class).invoke(null, member);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (vmKind != null) {
                        sb.append(member.toString(":" + vmKind));
                        continue;
                    }
                    sb.append(member.toString());
                    continue;
                }
                sb.append("...");
                break;
            }
            stat.dsMsg = LocalizedResource.getMessage((String)"UTIL_GFXD_DistributedMembers_Message", (Object)(numOtherMembers + 1), (Object)sb.toString());
        }
        super.setRunningStatus(stat, system);
    }

    public void setWaitingStatus(String regionPath, Set<PersistentMemberID> membersToWaitFor, Set<Integer> missingBuckets, PersistentMemberID myId, String message) {
        StringBuilder otherMembers = new StringBuilder();
        String tableName = Misc.getFullTableNameFromRegionPath((String)regionPath);
        tableName = "_DDL_STMTS_META_REGION".equals(tableName) ? "DataDictionary" : "table " + tableName;
        for (PersistentMemberID otherId : membersToWaitFor) {
            otherMembers.append("\n [DiskId: ").append(otherId.diskStoreId.toUUID().toString()).append(", Location: ").append(otherId.directory).append(']');
        }
        message = missingBuckets != null && missingBuckets.size() > 0 ? LocalizedResource.getMessage((String)"FS_WAITING_MESSAGE_BUCKETS", (Object)tableName, (Object)missingBuckets.toString(), (Object)myId.diskStoreId.toUUID().toString(), (Object)myId.directory, (Object)otherMembers.toString()) : LocalizedResource.getMessage((String)"FS_WAITING_MESSAGE", (Object)tableName, (Object)myId.diskStoreId.toUUID().toString(), (Object)myId.directory, (Object)otherMembers.toString());
        super.setWaitingStatus(regionPath, membersToWaitFor, missingBuckets, myId, message);
    }

    protected void stopAdditionalServices() throws Exception {
        this.getFabricServiceInstance().stopAllNetworkServers();
    }

    public static Set<String> getGFEPropNames() {
        return gfePropNames;
    }

    protected boolean checkStatusForWait(CacheServerLauncher.Status status) {
        return status.state == 1 || this.waitForData && status.state == 4;
    }

    protected boolean printLaunchCommand() {
        return PRINT_LAUNCH_COMMAND;
    }

    protected void printCommandLine(String[] commandLine, Map<String, String> env) throws Exception {
        super.printCommandLine(commandLine, env);
        HeapDataOutputStream dos = new HeapDataOutputStream();
        ArrayList<String> cmdArgs = new ArrayList<String>(commandLine.length - 2);
        for (int i = 0; i < commandLine.length; ++i) {
            String command = commandLine[i];
            if (command == null) continue;
            if ("-classpath".equals(command)) {
                ++i;
                continue;
            }
            if (command.startsWith("password=")) {
                cmdArgs.add("password=******");
                continue;
            }
            cmdArgs.add(command);
        }
        DataSerializer.writeArrayList(cmdArgs, (DataOutput)dos);
        byte[] keyBytes = this.getBytesEnv();
        env.put(ENV2, GemFireXDUtils.encryptBytes((byte[])dos.toByteArray(), null, (byte[])keyBytes));
    }

    public void printCommandLine(LogWriterI18n logger) {
        NativeCalls nc = NativeCalls.getInstance();
        String cmdLine = nc.getEnvironment(ENV2);
        if (cmdLine != null) {
            try {
                nc.setEnvironment(ENV2, null);
                byte[] keyBytes = this.getBytesEnv();
                byte[] cmdBytes = GemFireXDUtils.decryptBytes((String)cmdLine, null, (byte[])keyBytes);
                ByteArrayDataInput din = new ByteArrayDataInput();
                din.initialize(cmdBytes, null);
                ArrayList cmdArgs = DataSerializer.readArrayList((DataInput)din);
                logger.config(LocalizedStrings.CacheServerLauncher_CommandLine, new Object[]{this.baseName, cmdArgs.toString()});
            }
            catch (Exception e) {
                logger.warning(LocalizedStrings.CacheServerLauncher_CommandLine, new Object[]{this.baseName, "[ERROR getting command line: " + e.toString() + ']'});
            }
        }
    }
}

