/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.pivotal.gemfirexd.tools.internal.GfxdOption;

public final class GfxdOptionBuilder {
    private String longopt;
    private String description;
    private String argName;
    private boolean required;
    private int numberOfArgs = -1;
    private Object type;
    private boolean optionalArg;
    private char valuesep;

    private void reset() {
        this.description = null;
        this.argName = "arg";
        this.longopt = null;
        this.type = null;
        this.required = false;
        this.numberOfArgs = -1;
        this.optionalArg = false;
        this.valuesep = '\u0000';
    }

    public GfxdOptionBuilder withLongOpt(String newLongopt) {
        this.longopt = newLongopt;
        return this;
    }

    public GfxdOptionBuilder hasArg() {
        this.numberOfArgs = 1;
        return this;
    }

    public GfxdOptionBuilder hasArg(boolean hasArg) {
        this.numberOfArgs = hasArg ? 1 : -1;
        return this;
    }

    public GfxdOptionBuilder withArgName(String name) {
        this.argName = name;
        return this;
    }

    public GfxdOptionBuilder isRequired() {
        this.required = true;
        return this;
    }

    public GfxdOptionBuilder withValueSeparator(char sep) {
        this.valuesep = sep;
        return this;
    }

    public GfxdOptionBuilder withValueSeparator() {
        this.valuesep = (char)61;
        return this;
    }

    public GfxdOptionBuilder isRequired(boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public GfxdOptionBuilder hasArgs() {
        this.numberOfArgs = -2;
        return this;
    }

    public GfxdOptionBuilder hasArgs(int num) {
        this.numberOfArgs = num;
        return this;
    }

    public GfxdOptionBuilder hasOptionalArg() {
        this.numberOfArgs = 1;
        this.optionalArg = true;
        return this;
    }

    public GfxdOptionBuilder hasOptionalArgs() {
        this.numberOfArgs = -2;
        this.optionalArg = true;
        return this;
    }

    public GfxdOptionBuilder hasOptionalArgs(int numArgs) {
        this.numberOfArgs = numArgs;
        this.optionalArg = true;
        return this;
    }

    public GfxdOptionBuilder withType(Object newType) {
        this.type = newType;
        return this;
    }

    public GfxdOptionBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GfxdOption create(char opt) throws IllegalArgumentException {
        return this.create(String.valueOf(opt));
    }

    public GfxdOption create() throws IllegalArgumentException {
        if (this.longopt == null) {
            this.reset();
            throw new IllegalArgumentException("must specify longopt");
        }
        return this.create(null);
    }

    public GfxdOption create(String opt) throws IllegalArgumentException {
        GfxdOption option = null;
        try {
            option = new GfxdOption(opt, this.description);
            option.setLongOpt(this.longopt);
            option.setRequired(this.required);
            option.setOptionalArg(this.optionalArg);
            option.setArgs(this.numberOfArgs);
            option.setType(this.type);
            option.setValueSeparator(this.valuesep);
            option.setArgName(this.argName);
        }
        finally {
            this.reset();
        }
        return option;
    }
}

