/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.internal.GfxdOption;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public final class GfxdHelpFormatter
extends HelpFormatter {
    public GfxdHelpFormatter() {
        this.optionComparator = new Comparator<Option>(){

            @Override
            public int compare(Option o1, Option o2) {
                GfxdOption opt1 = (GfxdOption)o1;
                GfxdOption opt2 = (GfxdOption)o2;
                if (opt1.isRequired()) {
                    if (opt2.isRequired()) {
                        return opt1.getOptKey().compareToIgnoreCase(opt2.getOptKey());
                    }
                    return -1;
                }
                if (opt2.isRequired()) {
                    return 1;
                }
                return opt1.getOptKey().compareToIgnoreCase(opt2.getOptKey());
            }
        };
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        String syntaxPrefix = this.getSyntaxPrefix();
        this.printWrapped(pw, width, syntaxPrefix.length() + argPos, syntaxPrefix + cmdLineSyntax);
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options) {
        StringBuilder buff = new StringBuilder(this.getSyntaxPrefix()).append(app).append(' ');
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        ArrayList optList = new ArrayList(options.getOptions());
        Collections.sort(optList, this.getOptionComparator());
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            OptionGroup group = options.getOptionGroup(option);
            if (group != null) {
                if (!processedGroups.contains(group)) {
                    processedGroups.add(group);
                    this.appendOptionGroup(buff, group);
                }
            } else {
                this.appendOption(buff, option, option.isRequired());
            }
            if (!i.hasNext()) continue;
            buff.append(' ');
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    public String getSyntaxPrefix() {
        return LocalizedResource.getMessage((String)"GFXD_Usage").replace("\n\n", " ");
    }

    protected void appendOptionGroup(StringBuilder buff, OptionGroup group) {
        if (!group.isRequired()) {
            buff.append('[');
        }
        ArrayList optList = new ArrayList(group.getOptions());
        Collections.sort(optList, this.getOptionComparator());
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            this.appendOption(buff, (Option)i.next(), true);
            if (!i.hasNext()) continue;
            buff.append(" | ");
        }
        if (!group.isRequired()) {
            buff.append(']');
        }
    }

    protected void appendOption(StringBuilder buff, Option option, boolean required) {
        if (!required) {
            buff.append('[');
        }
        if (option.getOpt() != null) {
            buff.append(this.getOptPrefix()).append(option.getOpt());
        } else {
            buff.append(this.getLongOptPrefix()).append(option.getLongOpt());
        }
        if (option.hasArg() && option.hasArgName()) {
            if (option.hasOptionalArg()) {
                buff.append('[');
            }
            if (option.hasValueSeparator()) {
                buff.append(option.getValueSeparator());
            } else {
                buff.append(' ');
            }
            buff.append('<').append(option.getArgName()).append('>');
            if (option.hasOptionalArg()) {
                buff.append(']');
            }
        }
        if (!required) {
            buff.append(']');
        }
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuilder optBuf;
        List optList;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuilder> prefixList = new ArrayList<StringBuilder>();
        try {
            Method helpOptions = options.getClass().getDeclaredMethod("helpOptions", new Class[0]);
            helpOptions.setAccessible(true);
            optList = (List)helpOptions.invoke((Object)options, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalGemFireError((Throwable)e);
        }
        Collections.sort(optList, this.getOptionComparator());
        for (Option option : optList) {
            optBuf = new StringBuilder(8);
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                if (option.hasArgName()) {
                    if (option.hasOptionalArg()) {
                        optBuf.append('[');
                    }
                    if (option.hasValueSeparator()) {
                        optBuf.append(option.getValueSeparator());
                    } else {
                        optBuf.append(' ');
                    }
                    optBuf.append('<').append(option.getArgName()).append('>');
                    if (option.hasOptionalArg()) {
                        optBuf.append(']');
                    }
                } else {
                    optBuf.append(' ');
                }
            }
            if (option.isRequired()) {
                optBuf.append('*');
            }
            prefixList.add(optBuf);
            max = optBuf.length() > max ? optBuf.length() : max;
        }
        int x = 0;
        Iterator i = optList.iterator();
        while (i.hasNext()) {
            Option option = (Option)i.next();
            if ((optBuf = new StringBuilder(prefixList.get(x++).toString())).length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max + descPad;
            if (option.isRequired()) {
                optBuf.append("[").append(LocalizedResource.getMessage((String)"TOOLS_OPTION_REQUIRED")).append("] ");
            }
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!i.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }
}

