/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.internal;

import com.gemstone.gemfire.internal.GemFireTerminateError;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.internal.GfxdOption;
import com.pivotal.gemfirexd.tools.internal.GfxdOptionBuilder;
import com.pivotal.gemfirexd.tools.internal.ToolsBase;
import java.io.File;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.task.DatabaseTaskBase;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.DdlToDatabaseTask;
import org.apache.ddlutils.task.ReplayFailedDMLsCommand;
import org.apache.ddlutils.task.ReplayFailedDMLsTask;
import org.apache.ddlutils.task.VerbosityLevel;
import org.apache.ddlutils.task.WriteDataToDatabaseCommand;
import org.apache.ddlutils.task.WriteDataToFileCommand;
import org.apache.ddlutils.task.WriteDtdToFileCommand;
import org.apache.ddlutils.task.WriteSchemaSqlToFileCommand;
import org.apache.ddlutils.task.WriteSchemaToDatabaseCommand;
import org.apache.ddlutils.task.WriteSchemaToFileCommand;
import org.apache.tools.ant.types.FileSet;

public final class GfxdDdlUtils
extends ToolsBase {
    static final String WRITE_SCHEMA_TO_XML = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_SCHEMA_TO_XML");
    static final String WRITE_SCHEMA_TO_SQL = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_SCHEMA_TO_SQL");
    static final String WRITE_DATA_TO_XML = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_DATA_TO_XML");
    static final String WRITE_DATA_DTD_TO_FILE = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_DATA_DTD_TO_FILE");
    static final String WRITE_SCHEMA_TO_DB = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_SCHEMA_TO_DB");
    static final String WRITE_DATA_TO_DB = LocalizedResource.getMessage((String)"DDLUTILS_WRITE_DATA_TO_DB");
    static final String REPLAY_FAILED_DMLS = LocalizedResource.getMessage((String)"DDLUTILS_REPLAY_FAILED_DMLS");
    private static final String WRITE_SCHEMA_TO_XML_DESC_KEY = "DDLUTILS_WRITE_SCHEMA_TO_XML_DESC";
    private static final String WRITE_SCHEMA_TO_SQL_DESC_KEY = "DDLUTILS_WRITE_SCHEMA_TO_SQL_DESC";
    private static final String WRITE_DATA_TO_XML_DESC_KEY = "DDLUTILS_WRITE_DATA_TO_XML_DESC";
    private static final String WRITE_DATA_DTD_TO_FILE_DESC_KEY = "DDLUTILS_WRITE_DATA_DTD_TO_FILE_DESC";
    private static final String WRITE_SCHEMA_TO_DB_DESC_KEY = "DDLUTILS_WRITE_SCHEMA_TO_DB_DESC";
    private static final String WRITE_DATA_TO_DB_DESC_KEY = "DDLUTILS_WRITE_DATA_TO_DB_DESC";
    private static final String REPLAY_FAILED_DMLS_KEY = "DDLUTILS_REPLAY_FAILED_DMLS_DESC";
    private static final Map<String, String> validCommands;
    private static final String DATABASE_TYPE;
    private static final String CATALOG_PATTERN;
    private static final String SCHEMA_PATTERN;
    private static final String DELIMITED_IDENTIFIERS;
    private static final String ISOLATION_LEVEL;
    private static final String ISOLATION_LEVEL_RU;
    private static final String ISOLATION_LEVEL_RC;
    private static final String ISOLATION_LEVEL_RR;
    private static final String ISOLATION_LEVEL_SER;
    private static final String INCLUDE_TABLES;
    private static final String INCLUDE_TABLE_FILTER;
    private static final String EXCLUDE_TABLES;
    private static final String EXCLUDE_TABLE_FILTER;
    private static final String VERBOSITY;
    private static String URL;
    private static String DRIVER_CLASS;
    private String FILE_NAME;
    private String FILE_NAMES;
    private String SCHEMA_FILE_NAMES;
    private String BATCH_SIZE;
    private String DO_DROPS;
    private String ENSURE_FK_ORDER;
    private String ALTER_IDENTITY_COLUMNS;
    private String XML_SCHEMA_FILES;
    private String TO_DATABASE_TYPE;
    private String EXPORT_GENERIC;
    private String EXPORT_ALL;
    private String ERROR_FILE;
    static final int DEFAULT_BATCH_SIZE;

    public static void main(String[] args) {
        GfxdDdlUtils instance = new GfxdDdlUtils();
        instance.invoke(args);
    }

    public static Map<String, String> getValidCommands() {
        return validCommands;
    }

    @Override
    protected Map<String, String> getCommandToDescriptionKeyMap() {
        return validCommands;
    }

    @Override
    protected ToolsBase.ProcessCommand getCommandProcessor(String cmd) {
        if (WRITE_SCHEMA_TO_XML.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteSchemaToXMLOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteSchemaToXML(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (WRITE_SCHEMA_TO_SQL.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteSchemaToSQLOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteSchemaToSQL(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (WRITE_DATA_TO_XML.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteDataToXMLOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteDataToXML(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (WRITE_DATA_DTD_TO_FILE.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteDataDtdToFileOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteDataDtdToFile(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (WRITE_SCHEMA_TO_DB.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteSchemaToDBOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteSchemaToDB(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (WRITE_DATA_TO_DB.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addWriteDataToDBOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeWriteDataToDB(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        if (REPLAY_FAILED_DMLS.equals(cmd)) {
            return new ToolsBase.ProcessCommand(){

                @Override
                public final void addCommandOptions(Options opts) {
                    GfxdDdlUtils.this.addReplayFailedDMLsOptions(opts);
                }

                @Override
                public final void executeCommand(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
                    GfxdDdlUtils.this.executeReplayFailedDMLs(cmdLine, cmd, cmdDescKey);
                }
            };
        }
        return null;
    }

    @Override
    protected String getUsageString(String cmd, String cmdDescKey) {
        return LocalizedResource.getMessage((String)"DDLUTILS_COMMON_DESC");
    }

    protected void addWriteSchemaToXMLOptions(Options opts) {
        this.FILE_NAME = LocalizedResource.getMessage((String)"TOOLS_FILE");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_OUT_FILE_MESSAGE")).create(this.FILE_NAME);
        opts.addOption((Option)opt);
        this.addCommonTaskOptions(opts);
        this.addCommonReadTaskOptions(opts);
    }

    protected void addWriteSchemaToSQLOptions(Options opts) {
        this.FILE_NAME = LocalizedResource.getMessage((String)"TOOLS_FILE");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_SQL_OUT_FILE_MESSAGE")).create(this.FILE_NAME);
        opts.addOption((Option)opt);
        this.XML_SCHEMA_FILES = LocalizedResource.getMessage((String)"DDLUTILS_XML_SCHEMA_FILES");
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATHS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_XML_SCHEMA_FILES_MESSAGE")).create(this.XML_SCHEMA_FILES);
        opts.addOption((Option)opt);
        this.TO_DATABASE_TYPE = LocalizedResource.getMessage((String)"DDLUTILS_TO_DATABASE_TYPE");
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TYPE_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_TO_DATABASE_TYPE_MESSAGE")).create(this.TO_DATABASE_TYPE);
        opts.addOption((Option)opt);
        this.EXPORT_GENERIC = LocalizedResource.getMessage((String)"DDLUTILS_EXPORT_GENERIC");
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_EXPORT_GENERIC_MESSAGE")).create(this.EXPORT_GENERIC);
        opts.addOption((Option)opt);
        this.EXPORT_ALL = LocalizedResource.getMessage((String)"DDLUTILS_EXPORT_ALL");
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_EXPORT_ALL_MESSAGE")).create(this.EXPORT_ALL);
        opts.addOption((Option)opt);
        this.addCommonTaskOptions(opts);
        this.addCommonReadTaskOptions(opts);
    }

    protected void addWriteDataToXMLOptions(Options opts) {
        this.FILE_NAME = LocalizedResource.getMessage((String)"TOOLS_FILE");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DATA_OUT_FILE_MESSAGE")).create(this.FILE_NAME);
        opts.addOption((Option)opt);
        this.addCommonTaskOptions(opts);
        this.addCommonReadTaskOptions(opts);
    }

    protected void addWriteDataDtdToFileOptions(Options opts) {
        this.FILE_NAME = LocalizedResource.getMessage((String)"TOOLS_FILE");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DTD_OUT_FILE_MESSAGE")).create(this.FILE_NAME);
        opts.addOption((Option)opt);
    }

    protected void addWriteSchemaToDBOptions(Options opts) {
        this.FILE_NAMES = LocalizedResource.getMessage((String)"DDLUTILS_FILES");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATHS_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_FILES_ONLY_MESSAGE")).create(this.FILE_NAMES);
        opts.addOption((Option)opt);
        this.DO_DROPS = LocalizedResource.getMessage((String)"DDLUTILS_DO_DROPS");
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DO_DROPS_MESSAGE")).create(this.DO_DROPS);
        opts.addOption((Option)opt);
        this.ALTER_IDENTITY_COLUMNS = LocalizedResource.getMessage((String)"DDLUTILS_ALTER_IDENTITY_COLUMNS");
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_ALTER_IDENTITY_COLUMNS_MESSAGE")).create(this.ALTER_IDENTITY_COLUMNS);
        opts.addOption((Option)opt);
        this.addCommonTaskOptions(opts);
    }

    protected void addWriteDataToDBOptions(Options opts) {
        this.SCHEMA_FILE_NAMES = LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_FILES");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATHS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_FILES_MESSAGE")).create(this.SCHEMA_FILE_NAMES);
        opts.addOption((Option)opt);
        this.FILE_NAMES = LocalizedResource.getMessage((String)"DDLUTILS_FILES");
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATHS_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DATA_FILES_MESSAGE")).create(this.FILE_NAMES);
        opts.addOption((Option)opt);
        this.BATCH_SIZE = LocalizedResource.getMessage((String)"DDLUTILS_BATCH_SIZE");
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_SIZE_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_BATCH_SIZE_MESSAGE")).create(this.BATCH_SIZE);
        opts.addOption((Option)opt);
        this.ENSURE_FK_ORDER = LocalizedResource.getMessage((String)"DDLUTILS_ENSURE_FK_ORDER");
        opt = new GfxdOptionBuilder().hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_ENSURE_FK_ORDER_MESSAGE")).create(this.ENSURE_FK_ORDER);
        opts.addOption((Option)opt);
        this.ALTER_IDENTITY_COLUMNS = LocalizedResource.getMessage((String)"DDLUTILS_ALTER_IDENTITY_COLUMNS");
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_ALTER_IDENTITY_COLUMNS_MESSAGE")).create(this.ALTER_IDENTITY_COLUMNS);
        opts.addOption((Option)opt);
        this.addCommonTaskOptions(opts);
    }

    protected void addReplayFailedDMLsOptions(Options opts) {
        this.ERROR_FILE = LocalizedResource.getMessage((String)"DDLUTILS_ERROR_FILE");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PATH_ARG")).hasArg().isRequired(true).withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_ERROR_FILE_MESSAGE")).create(this.ERROR_FILE);
        opts.addOption((Option)opt);
        this.addBasicConnectionOptions(opts);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_USERNAME_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_USERNAME_MESSAGE")).create(USERNAME);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"TOOLS_PASSWORD_ARG")).hasOptionalArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"TOOLS_PASSWORD_MESSAGE")).create(PASSWORD);
        opts.addOption((Option)opt);
    }

    protected void addCommonTaskOptions(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TYPE_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DATABASE_TYPE_MESSAGE")).create(DATABASE_TYPE);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATTERN")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_CATALOG_PATTERN_MESSAGE")).create(CATALOG_PATTERN);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_PATTERN")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_PATTERN_MESSAGE")).create(SCHEMA_PATTERN);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DELIMITED_IDENTIFIERS_MESSAGE")).create(DELIMITED_IDENTIFIERS);
        opts.addOption((Option)opt);
    }

    protected void addCommonReadTaskOptions(Options opts) {
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TABLE_LIST")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_INCLUDE_TABLES_MESSAGE")).create(INCLUDE_TABLES);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TABLE_FILTER")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_INCLUDE_TABLE_FILTER_MESSAGE")).create(INCLUDE_TABLE_FILTER);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TABLE_LIST")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_EXCLUDE_TABLES_MESSAGE")).create(EXCLUDE_TABLES);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_TABLE_FILTER")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_EXCLUDE_TABLE_FILTER_MESSAGE")).create(EXCLUDE_TABLE_FILTER);
        opts.addOption((Option)opt);
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_LEVEL_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL_MESSAGE")).create(ISOLATION_LEVEL);
        opts.addOption((Option)opt);
    }

    @Override
    protected void addCommonOptions(Options opts) {
        super.addCommonOptions(opts);
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_LEVEL_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_VERBOSITY_MESSAGE")).create(VERBOSITY);
        opts.addOption((Option)opt);
    }

    @Override
    protected void addConnectionOptions(Options opts) {
        super.addConnectionOptions(opts);
        this.addBasicConnectionOptions(opts);
    }

    protected void addBasicConnectionOptions(Options opts) {
        URL = LocalizedResource.getMessage((String)"DDLUTILS_URL");
        GfxdOption opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_URL_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_URL_MESSAGE")).create(URL);
        opts.addOption((Option)opt);
        DRIVER_CLASS = LocalizedResource.getMessage((String)"DDLUTILS_DRIVER_CLASS");
        opt = new GfxdOptionBuilder().withArgName(LocalizedResource.getMessage((String)"DDLUTILS_DRIVER_CLASS_ARG")).hasArg().withValueSeparator('=').withDescription(LocalizedResource.getMessage((String)"DDLUTILS_DRIVER_CLASS_MESSAGE")).create(DRIVER_CLASS);
        opts.addOption((Option)opt);
    }

    protected void executeWriteSchemaToXML(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        String schemaFileName = null;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, true, taskOpts);
            if (resultTaskOpts == null) {
                if (this.FILE_NAME.equals(opt.getOpt())) {
                    schemaFileName = opt.getValue();
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        DatabaseToDdlTask fromDBTask = new DatabaseToDdlTask();
        if (verbosity != null) {
            fromDBTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        fromDBTask.addConfiguredDatabase(dataSource);
        this.setCommonTaskOptions(fromDBTask, taskOpts);
        this.setCommonReadTaskOptions(fromDBTask, taskOpts);
        WriteSchemaToFileCommand writeSchemaToFile = new WriteSchemaToFileCommand();
        File schemaFile = new File(schemaFileName);
        writeSchemaToFile.setFailOnError(true);
        writeSchemaToFile.setOutputFile(schemaFile);
        fromDBTask.addWriteSchemaToFile(writeSchemaToFile);
        fromDBTask.execute();
    }

    protected void executeWriteSchemaToSQL(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        DatabaseTaskBase dbTask;
        String schemaFileName = null;
        String[] xmlSchemaFiles = null;
        String toDbType = null;
        boolean exportDDLs = true;
        boolean exportAll = false;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, true, taskOpts);
            if (resultTaskOpts == null) {
                String optName = opt.getOpt();
                if (this.FILE_NAME.equals(optName)) {
                    schemaFileName = opt.getValue();
                    continue;
                }
                if (this.XML_SCHEMA_FILES.equals(optName)) {
                    xmlSchemaFiles = opt.getValue().split(",");
                    continue;
                }
                if (this.TO_DATABASE_TYPE.equals(optName)) {
                    toDbType = opt.getValue();
                    continue;
                }
                if (this.EXPORT_GENERIC.equals(optName)) {
                    exportDDLs = false;
                    continue;
                }
                if (this.EXPORT_ALL.equals(optName)) {
                    exportAll = true;
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        WriteSchemaSqlToFileCommand writeSchemaToFile = new WriteSchemaSqlToFileCommand();
        File schemaFile = new File(schemaFileName);
        writeSchemaToFile.setFailOnError(true);
        writeSchemaToFile.setDoDrops(true);
        writeSchemaToFile.setAlterDatabase(false);
        writeSchemaToFile.setExportDDLs(exportDDLs);
        writeSchemaToFile.setExportAll(exportAll);
        writeSchemaToFile.setOutputFile(schemaFile);
        if (toDbType != null) {
            writeSchemaToFile.setDatabaseType(toDbType);
        }
        if (xmlSchemaFiles == null) {
            DatabaseToDdlTask fromDBTask = new DatabaseToDdlTask();
            this.setCommonReadTaskOptions(fromDBTask, taskOpts);
            fromDBTask.addWriteSchemaSqlToFile(writeSchemaToFile);
            dbTask = fromDBTask;
        } else {
            DdlToDatabaseTask toDBTask = new DdlToDatabaseTask();
            if (xmlSchemaFiles.length == 1) {
                toDBTask.setSchemaFile(new File(xmlSchemaFiles[0]));
            } else {
                FileSet schemaFileSet = new FileSet();
                schemaFileSet.appendIncludes(xmlSchemaFiles);
                toDBTask.addConfiguredFileset(schemaFileSet);
            }
            toDBTask.addWriteSchemaSqlToFile(writeSchemaToFile);
            dbTask = toDBTask;
        }
        if (verbosity != null) {
            dbTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        dbTask.addConfiguredDatabase(dataSource);
        this.setCommonTaskOptions(dbTask, taskOpts);
        dbTask.execute();
    }

    protected void executeWriteDataToXML(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        String dataFileName = null;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, true, taskOpts);
            if (resultTaskOpts == null) {
                if (this.FILE_NAME.equals(opt.getOpt())) {
                    dataFileName = opt.getValue();
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        DatabaseToDdlTask fromDBTask = new DatabaseToDdlTask();
        if (verbosity != null) {
            fromDBTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        fromDBTask.addConfiguredDatabase(dataSource);
        this.setCommonTaskOptions(fromDBTask, taskOpts);
        this.setCommonReadTaskOptions(fromDBTask, taskOpts);
        WriteDataToFileCommand writeDataToFile = new WriteDataToFileCommand();
        File dataFile = new File(dataFileName);
        writeDataToFile.setFailOnError(true);
        writeDataToFile.setOutputFile(dataFile);
        fromDBTask.addWriteDataToFile(writeDataToFile);
        fromDBTask.execute();
    }

    protected void executeWriteDataDtdToFile(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        String dtdFileName = null;
        DataSourceOptions dsOpts = new DataSourceOptions();
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            if (this.FILE_NAME.equals(opt.getOpt())) {
                dtdFileName = opt.getValue();
                continue;
            }
            verbosity = this.handleVerbosityOption(opt);
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        DatabaseToDdlTask fromDBTask = new DatabaseToDdlTask();
        if (verbosity != null) {
            fromDBTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        fromDBTask.addConfiguredDatabase(dataSource);
        WriteDtdToFileCommand writeDtdToFile = new WriteDtdToFileCommand();
        File dtdFile = new File(dtdFileName);
        writeDtdToFile.setFailOnError(true);
        writeDtdToFile.setOutputFile(dtdFile);
        fromDBTask.addWriteDtdToFile(writeDtdToFile);
        fromDBTask.execute();
    }

    protected void executeWriteSchemaToDB(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        String[] schemaFileNames = null;
        boolean doDrops = false;
        boolean alterIdentityColumns = false;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, false, taskOpts);
            if (resultTaskOpts == null) {
                String optName = opt.getOpt();
                if (this.FILE_NAMES.equals(optName)) {
                    schemaFileNames = opt.getValue().split(",");
                    continue;
                }
                if (this.DO_DROPS.equals(optName)) {
                    doDrops = true;
                    continue;
                }
                if (this.ALTER_IDENTITY_COLUMNS.equals(optName)) {
                    alterIdentityColumns = true;
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        DdlToDatabaseTask toDBTask = new DdlToDatabaseTask();
        if (verbosity != null) {
            toDBTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        toDBTask.addConfiguredDatabase(dataSource);
        if (schemaFileNames.length == 1) {
            File schemaFile = new File((String)schemaFileNames[0]);
            toDBTask.setSchemaFile(schemaFile);
        } else {
            FileSet schemaFileSet = new FileSet();
            schemaFileSet.appendIncludes(schemaFileNames);
            toDBTask.addConfiguredFileset(schemaFileSet);
        }
        this.setCommonTaskOptions(toDBTask, taskOpts);
        WriteSchemaToDatabaseCommand writeSchemaToDB = new WriteSchemaToDatabaseCommand();
        if (doDrops) {
            writeSchemaToDB.setDoDrops(true);
            writeSchemaToDB.setAlterDatabase(false);
        } else {
            writeSchemaToDB.setAlterDatabase(true);
        }
        writeSchemaToDB.setAddIdentityUsingAlterTable(alterIdentityColumns);
        writeSchemaToDB.setFailOnError(true);
        toDBTask.addWriteSchemaToDatabase(writeSchemaToDB);
        toDBTask.execute();
    }

    protected void executeReplayFailedDMLs(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        String dataFileName = null;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, false, taskOpts);
            if (resultTaskOpts == null) {
                String optName = opt.getOpt();
                if (this.ERROR_FILE.equals(optName)) {
                    dataFileName = opt.getValue();
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        ReplayFailedDMLsCommand replayCommand = new ReplayFailedDMLsCommand();
        replayCommand.setErrorFileName(dataFileName);
        ReplayFailedDMLsTask dbTask = new ReplayFailedDMLsTask();
        dbTask.addReplayFailedDMLs(replayCommand);
        if (verbosity != null) {
            dbTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        dbTask.addConfiguredDatabase(dataSource);
        this.setCommonTaskOptions(dbTask, taskOpts);
        dbTask.execute();
    }

    protected void executeWriteDataToDB(CommandLine cmdLine, String cmd, String cmdDescKey) throws ParseException, SQLException {
        DatabaseTaskBase dbTask;
        String[] schemaFileNames = null;
        String[] dataFileNames = null;
        int batchSize = DEFAULT_BATCH_SIZE;
        boolean ensureFKOrder = false;
        boolean alterIdentityColumns = false;
        DataSourceOptions dsOpts = new DataSourceOptions();
        TaskOptions taskOpts = null;
        String verbosity = null;
        for (GfxdOption opt : cmdLine) {
            if (this.handleDataSourceOption(opt, dsOpts) || this.handleCommonOption(opt, cmd, cmdDescKey)) continue;
            TaskOptions resultTaskOpts = this.handleCommonTaskOption(opt, false, taskOpts);
            if (resultTaskOpts == null) {
                String optName = opt.getOpt();
                if (this.FILE_NAMES.equals(optName)) {
                    dataFileNames = opt.getValue().split(",");
                    continue;
                }
                if (this.SCHEMA_FILE_NAMES.equals(optName)) {
                    schemaFileNames = opt.getValue().split(",");
                    continue;
                }
                if (this.BATCH_SIZE.equals(optName)) {
                    batchSize = Integer.parseInt(opt.getValue());
                    continue;
                }
                if (this.ENSURE_FK_ORDER.equals(optName)) {
                    ensureFKOrder = Boolean.parseBoolean(opt.getValue());
                    continue;
                }
                if (this.ALTER_IDENTITY_COLUMNS.equals(optName)) {
                    alterIdentityColumns = true;
                    continue;
                }
                verbosity = this.handleVerbosityOption(opt);
                continue;
            }
            if (taskOpts != null) continue;
            taskOpts = resultTaskOpts;
        }
        BasicDataSource dataSource = this.handleDataSourceOptions(dsOpts, cmd, cmdDescKey);
        WriteDataToDatabaseCommand writeDataToDB = new WriteDataToDatabaseCommand();
        if (batchSize > 1) {
            writeDataToDB.setUseBatchMode(true);
            writeDataToDB.setBatchSize(batchSize);
        }
        if (dataFileNames.length == 1) {
            File dataFile = new File((String)dataFileNames[0]);
            writeDataToDB.setDataFile(dataFile);
        } else {
            FileSet dataFileSet = new FileSet();
            dataFileSet.appendIncludes(dataFileNames);
            writeDataToDB.addConfiguredFileset(dataFileSet);
        }
        writeDataToDB.setEnsureForeignKeyOrder(ensureFKOrder);
        writeDataToDB.setAddIdentityUsingAlterTable(alterIdentityColumns);
        writeDataToDB.setFailOnError(true);
        if (schemaFileNames != null) {
            DdlToDatabaseTask toDBTask = new DdlToDatabaseTask();
            if (schemaFileNames.length == 1) {
                File schemaFile = new File(schemaFileNames[0]);
                toDBTask.setSchemaFile(schemaFile);
            } else {
                FileSet schemaFileSet = new FileSet();
                schemaFileSet.appendIncludes(schemaFileNames);
                toDBTask.addConfiguredFileset(schemaFileSet);
            }
            toDBTask.addWriteDataToDatabase(writeDataToDB);
            dbTask = toDBTask;
        } else {
            DatabaseToDdlTask toDBTask = new DatabaseToDdlTask();
            toDBTask.addWriteDataToDatabase(writeDataToDB);
            dbTask = toDBTask;
        }
        if (verbosity != null) {
            dbTask.setVerbosity(new VerbosityLevel(verbosity));
        }
        dbTask.addConfiguredDatabase(dataSource);
        this.setCommonTaskOptions(dbTask, taskOpts);
        dbTask.execute();
    }

    protected boolean handleDataSourceOption(GfxdOption opt, DataSourceOptions dsOpts) {
        String optValue = opt.getOptionValue(URL);
        if (optValue != null) {
            dsOpts.url = optValue;
        } else {
            optValue = opt.getOptionValue(DRIVER_CLASS);
            if (optValue != null) {
                dsOpts.driverClass = optValue;
            } else {
                return this.handleConnectionOption(opt, dsOpts);
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TaskOptions handleCommonTaskOption(GfxdOption opt, boolean fromDatabase, TaskOptions taskOpts) throws ParseException {
        String optValue = opt.getOptionValue(DATABASE_TYPE);
        if (optValue != null) {
            if (taskOpts == null) {
                taskOpts = new TaskOptions();
            }
            taskOpts.dbType = optValue;
            return taskOpts;
        } else {
            optValue = opt.getOptionValue(CATALOG_PATTERN);
            if (optValue != null) {
                if (taskOpts == null) {
                    taskOpts = new TaskOptions();
                }
                taskOpts.catalogPattern = optValue;
                return taskOpts;
            } else {
                optValue = opt.getOptionValue(SCHEMA_PATTERN);
                if (optValue != null) {
                    if (taskOpts == null) {
                        taskOpts = new TaskOptions();
                    }
                    taskOpts.schemaPattern = optValue;
                    return taskOpts;
                } else if (DELIMITED_IDENTIFIERS.equals(opt.getOpt())) {
                    if (taskOpts == null) {
                        taskOpts = new TaskOptions();
                    }
                    taskOpts.useDelimitedIdentifiers = true;
                    return taskOpts;
                } else {
                    optValue = opt.getOptionValue(ISOLATION_LEVEL);
                    if (optValue != null) {
                        if (taskOpts == null) {
                            taskOpts = new TaskOptions();
                        }
                        if (ISOLATION_LEVEL_RU.equalsIgnoreCase(optValue)) {
                            taskOpts.isolationLevel = 1;
                            return taskOpts;
                        } else if (ISOLATION_LEVEL_RC.equalsIgnoreCase(optValue)) {
                            taskOpts.isolationLevel = 2;
                            return taskOpts;
                        } else if (ISOLATION_LEVEL_RR.equalsIgnoreCase(optValue)) {
                            taskOpts.isolationLevel = 4;
                            return taskOpts;
                        } else {
                            if (!ISOLATION_LEVEL_SER.equalsIgnoreCase(optValue)) throw new ParseException(LocalizedResource.getMessage((String)"DDLUTILS_UNKNOWN_ISOLATION_LEVEL", (Object)optValue));
                            taskOpts.isolationLevel = 8;
                        }
                        return taskOpts;
                    } else {
                        if (!fromDatabase) {
                            return null;
                        }
                        optValue = opt.getOptionValue(INCLUDE_TABLES);
                        if (optValue != null) {
                            if (taskOpts == null) {
                                taskOpts = new TaskOptions();
                            }
                            taskOpts.includeTables = optValue;
                            return taskOpts;
                        } else {
                            optValue = opt.getOptionValue(INCLUDE_TABLE_FILTER);
                            if (optValue != null) {
                                if (taskOpts == null) {
                                    taskOpts = new TaskOptions();
                                }
                                taskOpts.includeTableFilter = optValue;
                                return taskOpts;
                            } else {
                                optValue = opt.getOptionValue(EXCLUDE_TABLES);
                                if (optValue != null) {
                                    if (taskOpts == null) {
                                        taskOpts = new TaskOptions();
                                    }
                                    taskOpts.excludeTables = optValue;
                                    return taskOpts;
                                } else {
                                    optValue = opt.getOptionValue(EXCLUDE_TABLE_FILTER);
                                    if (optValue == null) return null;
                                    if (taskOpts == null) {
                                        taskOpts = new TaskOptions();
                                    }
                                    taskOpts.excludeTableFilter = optValue;
                                }
                            }
                        }
                    }
                }
            }
        }
        return taskOpts;
    }

    protected String handleVerbosityOption(GfxdOption opt) {
        return opt.getOptionValue(VERBOSITY);
    }

    protected BasicDataSource handleDataSourceOptions(DataSourceOptions dsOpts, String cmd, String cmdDescKey) {
        if (dsOpts.url != null) {
            if (dsOpts.clientPort >= 0 || dsOpts.clientBindAddress != null) {
                this.showUsage(LocalizedResource.getMessage((String)"DDLUTILS_BOTH_URL_CLIENT_ERROR"), cmd, cmdDescKey);
                throw new GemFireTerminateError("exiting due to incorrect connection options", 1);
            }
            if (dsOpts.driverClass == null) {
                this.showUsage(LocalizedResource.getMessage((String)"DDLUTILS_MISSING_DRIVER_CLASS_ERROR"), cmd, cmdDescKey);
                throw new GemFireTerminateError("exiting due to missing driverClass option", 1);
            }
        } else {
            this.handleConnectionOptions(dsOpts, cmd, cmdDescKey);
        }
        BasicDataSource dataSource = new BasicDataSource();
        StringBuilder urlBuilder = new StringBuilder();
        if (dsOpts.url != null) {
            dataSource.setDriverClassName(dsOpts.driverClass);
            urlBuilder.append(dsOpts.url);
        } else if (dsOpts.clientPort < 0) {
            dataSource.setDriverClassName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver");
            urlBuilder.append("jdbc:gemfirexd:").append(";host-data=false");
        } else {
            String hostName = dsOpts.clientBindAddress != null ? dsOpts.clientBindAddress : "localhost";
            dataSource.setDriverClassName("com.pivotal.gemfirexd.jdbc.ClientDriver");
            urlBuilder.append("jdbc:gemfirexd://").append(hostName).append(':').append(dsOpts.clientPort).append('/');
        }
        if (dsOpts.properties.length() > 0) {
            urlBuilder.append((CharSequence)dsOpts.properties);
        }
        dataSource.setUrl(urlBuilder.toString());
        if (dsOpts.user != null) {
            dataSource.setUsername(dsOpts.user);
        }
        if (dsOpts.password != null) {
            dataSource.setPassword(dsOpts.password);
        }
        return dataSource;
    }

    protected void setCommonTaskOptions(DatabaseTaskBase task, TaskOptions taskOpts) {
        if (taskOpts != null) {
            if (taskOpts.dbType != null) {
                task.setDatabaseType(taskOpts.dbType);
            }
            if (taskOpts.catalogPattern != null) {
                task.setCatalogPattern(taskOpts.catalogPattern);
            }
            if (taskOpts.schemaPattern != null) {
                task.setSchemaPattern(taskOpts.schemaPattern);
            }
            if (taskOpts.isolationLevel >= 0) {
                task.setIsolationLevel(taskOpts.isolationLevel);
            }
            task.setUseDelimitedSqlIdentifiers(taskOpts.useDelimitedIdentifiers);
        }
    }

    protected void setCommonReadTaskOptions(DatabaseToDdlTask task, TaskOptions taskOpts) {
        if (taskOpts != null) {
            if (taskOpts.includeTables != null) {
                task.setIncludeTables(taskOpts.includeTables);
            }
            if (taskOpts.includeTableFilter != null) {
                task.setIncludeTableFilter(taskOpts.includeTableFilter);
            }
            if (taskOpts.excludeTables != null) {
                task.setExcludeTables(taskOpts.excludeTables);
            }
            if (taskOpts.excludeTableFilter != null) {
                task.setExcludeTableFilter(taskOpts.excludeTableFilter);
            }
        }
    }

    static {
        DATABASE_TYPE = LocalizedResource.getMessage((String)"DDLUTILS_DATABASE_TYPE");
        CATALOG_PATTERN = LocalizedResource.getMessage((String)"DDLUTILS_CATALOG_PATTERN");
        SCHEMA_PATTERN = LocalizedResource.getMessage((String)"DDLUTILS_SCHEMA_PATTERN");
        DELIMITED_IDENTIFIERS = LocalizedResource.getMessage((String)"DDLUTILS_DELIMITED_IDENTIFIERS");
        ISOLATION_LEVEL = LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL");
        ISOLATION_LEVEL_RU = LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL_RU");
        ISOLATION_LEVEL_RC = LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL_RC");
        ISOLATION_LEVEL_RR = LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL_RR");
        ISOLATION_LEVEL_SER = LocalizedResource.getMessage((String)"DDLUTILS_ISOLATION_LEVEL_SER");
        INCLUDE_TABLES = LocalizedResource.getMessage((String)"DDLUTILS_INCLUDE_TABLES");
        INCLUDE_TABLE_FILTER = LocalizedResource.getMessage((String)"DDLUTILS_INCLUDE_TABLE_FILTER");
        EXCLUDE_TABLES = LocalizedResource.getMessage((String)"DDLUTILS_EXCLUDE_TABLES");
        EXCLUDE_TABLE_FILTER = LocalizedResource.getMessage((String)"DDLUTILS_EXCLUDE_TABLE_FILTER");
        VERBOSITY = LocalizedResource.getMessage((String)"DDLUTILS_VERBOSITY");
        DEFAULT_BATCH_SIZE = 1000;
        validCommands = new LinkedHashMap<String, String>();
        validCommands.put(WRITE_SCHEMA_TO_XML, WRITE_SCHEMA_TO_XML_DESC_KEY);
        validCommands.put(WRITE_SCHEMA_TO_SQL, WRITE_SCHEMA_TO_SQL_DESC_KEY);
        validCommands.put(WRITE_DATA_TO_XML, WRITE_DATA_TO_XML_DESC_KEY);
        validCommands.put(WRITE_DATA_DTD_TO_FILE, WRITE_DATA_DTD_TO_FILE_DESC_KEY);
        validCommands.put(WRITE_SCHEMA_TO_DB, WRITE_SCHEMA_TO_DB_DESC_KEY);
        validCommands.put(WRITE_DATA_TO_DB, WRITE_DATA_TO_DB_DESC_KEY);
        validCommands.put(REPLAY_FAILED_DMLS, REPLAY_FAILED_DMLS_KEY);
    }

    private static final class TaskOptions {
        String dbType;
        String catalogPattern;
        String schemaPattern;
        boolean useDelimitedIdentifiers;
        int isolationLevel = -1;
        String includeTables;
        String includeTableFilter;
        String excludeTables;
        String excludeTableFilter;

        private TaskOptions() {
        }
    }

    private static final class DataSourceOptions
    extends ToolsBase.ConnectionOptions {
        String url;
        String driverClass;

        private DataSourceOptions() {
        }
    }
}

