/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.gfxdtop;

import com.pivotal.gemfirexd.tools.gfxdtop.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class StatementTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5313465349050294789L;
    private String[] columnNames = new String[]{"Statement", "numExecution", "numExecutionsInProgress", "executionTime", "totalExecutionTime", "numTimesGlobalIndexLookup"};
    private static final int STATEMENT_INDEX = 0;
    private static final int NnumExecution_INDEX = 1;
    private static final int NumExecutionsInProgress_INDEX = 2;
    private static final int ExecutionTime_INDEX = 3;
    private static final int TotalExecutionTimeT_INDEX = 4;
    private static final int NumTimesGlobalIndexLookupT_INDEX = 5;
    private List<Statement> statementList = Collections.EMPTY_LIST;

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.statementList.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Statement me = this.statementList.get(row);
        switch (col) {
            case 0: {
                return me.getQueryDefinition();
            }
            case 1: {
                return me.getNumExecution();
            }
            case 2: {
                return me.getNumExecutionsInProgress();
            }
            case 3: {
                return me.getExecutionTime();
            }
            case 4: {
                return me.getTotalExecutionTime();
            }
            case 5: {
                return me.getNumTimesGlobalIndexLookup();
            }
        }
        return null;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void setStatementList(List<Statement> statementList) {
        this.statementList = statementList;
    }

    public void setStatementList(Collection<Statement> statementList) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        for (Statement s : statementList) {
            list.add(s);
        }
        Collections.sort(list);
        this.statementList = list;
    }
}

