/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.gfxdtop;

import com.pivotal.gemfirexd.tools.gfxdtop.ClusterStatistics;
import com.pivotal.gemfirexd.tools.gfxdtop.Statement;
import com.pivotal.gemfirexd.tools.gfxdtop.StatementTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class GfxdTop
extends JPanel {
    private MBeanServerConnection server;
    private StatementTableModel tmodel = new StatementTableModel();
    private ClusterStatistics queryStats = new ClusterStatistics();

    public GfxdTop() {
        super(new GridLayout(1, 0));
        JTable table = new JTable(this.tmodel);
        table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        table.setDefaultRenderer(Double.class, new DoubleRenderer());
        table.setIntercellSpacing(new Dimension(6, 3));
        table.setRowHeight(table.getRowHeight() + 4);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
    }

    public void setMBeanServerConnection(MBeanServerConnection mbs) {
        this.server = mbs;
        this.queryStats.setMbs(mbs);
    }

    public SwingWorker<?, ?> newSwingWorker() {
        return new Worker(this.tmodel);
    }

    public static void main(String[] args) throws Exception {
        String[] arg2;
        if (args.length != 1) {
            GfxdTop.usage();
        }
        if ((arg2 = args[0].split(":")).length != 2) {
            GfxdTop.usage();
        }
        String hostname = arg2[0];
        int port = -1;
        try {
            port = Integer.parseInt(arg2[1]);
        }
        catch (NumberFormatException x) {
            GfxdTop.usage();
        }
        if (port < 0) {
            GfxdTop.usage();
        }
        final GfxdTop gfxdTop = new GfxdTop();
        MBeanServerConnection server = GfxdTop.connect(hostname, port);
        gfxdTop.setMBeanServerConnection(server);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                gfxdTop.newSwingWorker().execute();
            }
        };
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                GfxdTop.createAndShowGUI(gfxdTop);
            }
        });
        Timer timer = new Timer("GfxdTop Sampling thread");
        timer.schedule(timerTask, 0L, 2000L);
    }

    private static MBeanServerConnection connect(String hostname, int port) {
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        MBeanServerConnection server = null;
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            server = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
        return server;
    }

    private static void usage() {
        System.out.println("Usage: java GfxdTop <hostname>:<port>");
        System.exit(1);
    }

    private static void createAndShowGUI(JPanel jtop) {
        JFrame frame = new JFrame("GfxdTop");
        frame.setDefaultCloseOperation(3);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.add((Component)jtop, "Center");
        contentPane.setOpaque(true);
        contentPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        frame.setContentPane(contentPane);
        frame.pack();
        frame.setVisible(true);
    }

    class Worker
    extends SwingWorker<Map<String, Statement>, Object> {
        private StatementTableModel tmodel;

        Worker(StatementTableModel tmodel) {
            this.tmodel = tmodel;
        }

        @Override
        public Map<String, Statement> doInBackground() {
            return GfxdTop.this.queryStats.getGfxdStatements();
        }

        @Override
        protected void done() {
            try {
                Map statementMap = (Map)this.get();
                this.tmodel.setStatementList(statementMap.values());
                this.tmodel.fireTableDataChanged();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    static class DoubleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        NumberFormat formatter;

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
                this.formatter.setMinimumFractionDigits(4);
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }
}

