/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.gfxdtop;

import com.pivotal.gemfirexd.tools.gfxdtop.GfxdConstants;
import com.pivotal.gemfirexd.tools.gfxdtop.GfxdLogger;
import com.pivotal.gemfirexd.tools.gfxdtop.JMXHelper;
import com.pivotal.gemfirexd.tools.gfxdtop.Statement;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ClusterStatistics {
    private ObjectName distrStatementON;
    private MBeanServerConnection mbs;
    private GfxdLogger logger = new GfxdLogger();
    private Map<String, Statement> statementMap = new HashMap<String, Statement>();

    public MBeanServerConnection getMbs() {
        return this.mbs;
    }

    public void setMbs(MBeanServerConnection mbs) {
        this.mbs = mbs;
    }

    public ClusterStatistics() {
        try {
            this.distrStatementON = new ObjectName("GemFireXD:service=Statement,type=Aggregate,*");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void queryClusterStatistics() {
        try {
            Set<ObjectName> statementObjectNames = this.mbs.queryNames(this.distrStatementON, null);
            for (ObjectName stmtObjectName : statementObjectNames) {
                this.updateClusterStatement(stmtObjectName);
            }
        }
        catch (IOException e) {
            this.logger.warning(e);
        }
    }

    private void updateClusterStatement(ObjectName mbeanName) throws IOException {
        try {
            Statement statement;
            AttributeList attributeList = this.mbs.getAttributes(mbeanName, GfxdConstants.STATEMENT_MBEAN_ATTRIBUTES);
            String statementDefinition = mbeanName.getKeyProperty("name");
            if (JMXHelper.isQuoted(statementDefinition)) {
                statementDefinition = ObjectName.unquote(statementDefinition);
            }
            if (null == (statement = this.statementMap.get(statementDefinition))) {
                statement = new Statement();
                statement.setQueryDefinition(statementDefinition);
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                this.updateAttribute(statement, attribute);
            }
            this.addClusterStatement(statementDefinition, statement);
        }
        catch (InstanceNotFoundException infe) {
            this.logger.warning(infe);
        }
        catch (ReflectionException re) {
            this.logger.warning(re);
        }
    }

    private void updateAttribute(Statement statement, Attribute attribute) {
        if (attribute.getName().equals("NumTimesCompiled")) {
            statement.setNumTimesCompiled(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("NumExecution")) {
            statement.setNumExecution(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("NumExecutionsInProgress")) {
            statement.setNumExecutionsInProgress(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("NumTimesGlobalIndexLookup")) {
            statement.setNumTimesGlobalIndexLookup(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("NumRowsModified")) {
            statement.setNumRowsModified(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("ParseTime")) {
            statement.setParseTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("BindTime")) {
            statement.setBindTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("OptimizeTime")) {
            statement.setOptimizeTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("RoutingInfoTime")) {
            statement.setRoutingInfoTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("GenerateTime")) {
            statement.setGenerateTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("TotalCompilationTime")) {
            statement.setTotalCompilationTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("ExecutionTime")) {
            statement.setExecutionTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("ProjectionTime")) {
            statement.setProjectionTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("TotalExecutionTime")) {
            statement.setTotalExecutionTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("RowsModificationTime")) {
            statement.setRowsModificationTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("QNNumRowsSeen")) {
            statement.setqNNumRowsSeen(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("QNMsgSendTime")) {
            statement.setqNMsgSendTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        } else if (attribute.getName().equals("QNMsgSerTime")) {
            statement.setqNMsgSerTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        }
        if (attribute.getName().equals("QNRespDeSerTime")) {
            statement.setqNRespDeSerTime(JMXHelper.getLongAttribute(attribute.getValue(), attribute.getName()));
        }
    }

    public Map<String, Statement> getGfxdStatements() {
        this.queryClusterStatistics();
        return this.statementMap;
    }

    public void addClusterStatement(String name, Statement stmt) {
        this.statementMap.put(name, stmt);
    }

    public static void main(String[] args) throws InterruptedException {
        MBeanServerConnection mbs = ClusterStatistics.standAloneConnection(args);
        ClusterStatistics stats = new ClusterStatistics();
        stats.setMbs(mbs);
        while (true) {
            stats.queryClusterStatistics();
            Thread.sleep(5000L);
        }
    }

    private static MBeanServerConnection standAloneConnection(String[] args) {
        return ClusterStatistics.connect(args[0], Integer.valueOf(args[1]));
    }

    private static MBeanServerConnection connect(String hostname, int port) {
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        MBeanServerConnection server = null;
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            server = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
        return server;
    }
}

