/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.GemFireTerminateError;
import com.gemstone.gemfire.internal.GemFireUtilLauncher;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.tools.ij;
import com.pivotal.gemfirexd.tools.GfxdAgentLauncher;
import com.pivotal.gemfirexd.tools.GfxdDistributionLocator;
import com.pivotal.gemfirexd.tools.GfxdSystemAdmin;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import com.pivotal.gemfirexd.tools.internal.JarTools;
import com.pivotal.gemfirexd.tools.internal.MiscTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;

public class GfxdUtilLauncher
extends GemFireUtilLauncher {
    static final String SCRIPT_NAME = "gfxd";
    static final String GET_CANONICAL_PATH_ARG = "--get-canonical-path";
    protected static boolean snappyStore;

    public static boolean isSnappyStore() {
        return snappyStore;
    }

    protected Map<String, GemFireUtilLauncher.CommandEntry> getTypes() {
        Class<?> gfxdDdlUtilsClass;
        String cmdDescKey;
        LinkedHashMap<String, GemFireUtilLauncher.CommandEntry> m = new LinkedHashMap<String, GemFireUtilLauncher.CommandEntry>();
        m.put("server", new GemFireUtilLauncher.CommandEntry(GfxdServerLauncher.class, LocalizedResource.getMessage((String)"UTIL_Server_Usage"), false));
        m.put("locator", new GemFireUtilLauncher.CommandEntry(GfxdDistributionLocator.class, LocalizedResource.getMessage((String)"UTIL_Locator_Usage"), false));
        m.put("agent", new GemFireUtilLauncher.CommandEntry(GfxdAgentLauncher.class, LocalizedStrings.GemFireUtilLauncher_Agent_Usage.toString(new Object[]{LocalizedResource.getMessage((String)"FS_PRODUCT")}), false));
        m.put(SCRIPT_NAME, new GemFireUtilLauncher.CommandEntry(ij.class, LocalizedResource.getMessage((String)"UTIL_GFXD_Usage"), false));
        for (String cmd : GfxdSystemAdmin.getValidCommands()) {
            if ("help".equals(cmd) || cmd.contains("locator")) continue;
            m.put(cmd, new GemFireUtilLauncher.CommandEntry(GfxdSystemAdmin.class, LocalizedResource.getMessage((String)("UTIL_" + cmd.replace('-', '_') + "_ShortDesc")), true));
        }
        for (Map.Entry entry : JarTools.getValidCommands().entrySet()) {
            String cmd = (String)entry.getKey();
            cmdDescKey = (String)entry.getValue();
            m.put(cmd, new GemFireUtilLauncher.CommandEntry(JarTools.class, LocalizedResource.getMessage((String)cmdDescKey), true));
        }
        for (Map.Entry entry : MiscTools.getValidCommands().entrySet()) {
            String cmd = (String)entry.getKey();
            cmdDescKey = (String)entry.getValue();
            m.put(cmd, new GemFireUtilLauncher.CommandEntry(MiscTools.class, LocalizedResource.getMessage((String)cmdDescKey), true));
        }
        try {
            gfxdDdlUtilsClass = Class.forName("com.pivotal.gemfirexd.tools.internal.GfxdDdlUtils");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            gfxdDdlUtilsClass = null;
        }
        catch (Exception exception) {
            throw new InternalGemFireError((Throwable)exception);
        }
        if (gfxdDdlUtilsClass != null) {
            try {
                Iterator iterator = ((Map)gfxdDdlUtilsClass.getMethod("getValidCommands", new Class[0]).invoke(null, new Object[0])).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry;
                    Map.Entry cmdEntry = entry = iterator.next();
                    String cmd = (String)cmdEntry.getKey();
                    String cmdDescKey2 = (String)cmdEntry.getValue();
                    m.put(cmd, new GemFireUtilLauncher.CommandEntry(gfxdDdlUtilsClass, LocalizedResource.getMessage((String)cmdDescKey2), true));
                }
            }
            catch (Exception exception) {
                throw new InternalGemFireError((Throwable)exception);
            }
        }
        return m;
    }

    protected GfxdUtilLauncher() {
        ClientSharedUtils.setThriftDefault((boolean)false);
    }

    protected String scriptName() {
        return SCRIPT_NAME;
    }

    public static void main(String[] args) {
        block8: {
            GfxdUtilLauncher launcher = new GfxdUtilLauncher();
            try {
                if (args.length == 0) {
                    launcher.invoke(new String[]{SCRIPT_NAME});
                    break block8;
                }
                if (args.length == 2 && GET_CANONICAL_PATH_ARG.equals(args[0])) {
                    try {
                        System.out.println(new File(args[1]).getCanonicalPath());
                    }
                    catch (IOException ioe) {
                        System.out.println(args[1]);
                    }
                    return;
                }
                launcher.validateArgs(args);
                launcher.invoke(args);
            }
            catch (GemFireTerminateError term) {
                System.exit(term.getExitCode());
            }
            catch (RuntimeException re) {
                for (Throwable cause = re.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof GemFireTerminateError)) continue;
                    System.exit(((GemFireTerminateError)cause).getExitCode());
                }
                throw re;
            }
        }
    }

    public static ConsoleReader getConsoleReader() {
        if (System.console() != null) {
            try {
                if (!"jline.UnsupportedTerminal".equals(System.getProperty("jline.terminal"))) {
                    final ConsoleReader reader = new ConsoleReader();
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                reader.getTerminal().restore();
                                ((FileHistory)reader.getHistory()).flush();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    return reader;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void printUsage(String usageOutput, int maxLines, ConsoleReader reader) {
        if (reader != null) {
            maxLines = reader.getTerminal().getHeight() - 1;
            reader.setBellEnabled(false);
            SanityManager.printPagedOutput((PrintStream)System.out, (InputStream)System.in, (String)usageOutput, (int)maxLines, (String)LocalizedResource.getMessage((String)"UTIL_GFXD_Continue_Prompt"), (boolean)false);
        } else {
            System.out.println(usageOutput);
        }
    }

    protected void invoke(String[] args) {
        super.invoke(args);
    }

    protected void usage(String context) {
        int len;
        ConsoleReader reader = GfxdUtilLauncher.getConsoleReader();
        int width = reader != null ? reader.getTerminal().getWidth() : 80;
        String lineSep = SanityManager.lineSeparator;
        StringBuilder result = new StringBuilder();
        GfxdUtilLauncher.splitLine(context, width, 0, result);
        result.append(lineSep);
        String indent = "   ";
        Map<String, GemFireUtilLauncher.CommandEntry> types = this.getTypes();
        String[] selfHelp = types.remove((Object)this.scriptName()).usage.split("\\r?\\n");
        types.remove(SCRIPT_NAME);
        for (String helpLine : selfHelp) {
            GfxdUtilLauncher.splitLine(helpLine, width, 0, result);
        }
        result.append(lineSep);
        GfxdUtilLauncher.splitLine(LocalizedResource.getMessage((String)"UTIL_GFXD_Tools_Message"), width, 0, result);
        int maxLength = 0;
        for (String cmd : types.keySet()) {
            len = cmd.length();
            if (len <= maxLength) continue;
            maxLength = len;
        }
        StringBuilder sb = new StringBuilder();
        int toolsIndent = (maxLength += 4) + "   ".length() + 1;
        if (toolsIndent >= width - 6) {
            for (Map.Entry<String, GemFireUtilLauncher.CommandEntry> entry : types.entrySet()) {
                len = entry.getKey().length();
                sb.append("   ").append(entry.getKey()).append("   ");
                sb.append(entry.getValue().usage).append(lineSep);
            }
        } else {
            for (Map.Entry<String, GemFireUtilLauncher.CommandEntry> entry : types.entrySet()) {
                StringBuilder line = new StringBuilder();
                len = entry.getKey().length();
                line.append("   ").append(entry.getKey());
                for (int cnt = len; cnt <= maxLength; ++cnt) {
                    line.append(' ');
                }
                line.append(entry.getValue().usage);
                GfxdUtilLauncher.splitLine(line, width, toolsIndent, sb);
            }
        }
        result.append("   ");
        result.append(LocalizedResource.getMessage((String)"UTIL_GFXD_Tools_Usage", (Object)this.scriptName(), (Object)sb.toString()));
        result.append(lineSep);
        GfxdUtilLauncher.printUsage(result.toString(), 23, reader);
        throw new GemFireTerminateError("exiting after usage", 1);
    }

    protected void listCommands() {
        Map<String, GemFireUtilLauncher.CommandEntry> types = this.getTypes();
        TreeSet<String> sorted = new TreeSet<String>();
        sorted.addAll(types.keySet());
        sorted.add("help");
        for (String key : sorted) {
            System.out.println(key);
        }
        throw new GemFireTerminateError(null, 0);
    }

    public static void splitLine(CharSequence line, int width, int indent, StringBuilder result) {
        String lineSep = SanityManager.lineSeparator;
        int len = line.length();
        if (len <= width) {
            result.append(line);
            result.append(lineSep);
            return;
        }
        char[] indentStr = null;
        if (indent > 0) {
            indentStr = new char[indent];
            for (int index = 0; index < indent; ++index) {
                indentStr[index] = 32;
            }
        }
        int offset = 0;
        int end = width;
        int lineIndent = 0;
        while (true) {
            if (lineIndent > 0) {
                result.append(indentStr);
            }
            if (end != len) {
                int origEnd = end;
                while (!Character.isWhitespace(line.charAt(end - 1))) {
                    if (--end > offset) continue;
                    end = origEnd;
                    break;
                }
            }
            result.append(line.subSequence(offset, end));
            result.append(lineSep);
            if (end == len) break;
            offset = end;
            if ((end += width - indent) > len) {
                end = len;
            }
            lineIndent = indent;
        }
    }
}

