/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireTerminateError;
import com.gemstone.gemfire.internal.SystemAdmin;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.FabricServer;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.GemFireXDVersion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.distributed.message.GfxdShutdownAllRequest;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.AuthenticationServiceBase;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import java.io.Console;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GfxdSystemAdmin
extends SystemAdmin {
    static final File DEFAULT_LICENSE_FILE = new File("gemfirexdLicense.zip");
    protected static final HashSet<String> removedCommands = new HashSet();
    protected static final HashMap<String, String> modifiedUsageInfo = new HashMap();
    protected static final HashMap<String, String> modifiedHelpInfo = new HashMap();
    static final String[] commandsWithDSProps = new String[]{"backup", "compact-all-disk-stores", "encrypt-password", "list-missing-disk-stores", "print-stacks", "revoke-missing-disk-store", "shut-down-all"};
    private static final String INCLUDE_ADMINS = "-include-admins";
    private static final String SKIP_ACCESSORS = "-skip-accessors";
    private static final String PASSWORD_FOR_EXTERNAL = "external";
    private static final String PASSWORD_TRANSFORM = "-transformation";
    private static final String PASSWORD_KEYSIZE = "-keysize";
    private static final List<String> noValArgs = Arrays.asList("-password", "-skip-accessors");
    protected String defaultLogFileName;
    private boolean shutDownAllIncludeAdmins;
    private boolean shutDownAllSkipAccessors;
    private String encryptPasswordTransformation;
    private int encryptPasswordKeySize;

    protected void initMapsForGFXD() {
        this.usageMap.put("encrypt-password", "encrypt-password [external]");
        this.helpMap.put("encrypt-password", LocalizedResource.getMessage((String)"UTIL_encrypt_password_Help"));
        ArrayList<String> allCommands = new ArrayList<String>();
        ArrayList<String> aliases = new ArrayList<String>();
        for (String cmd : validCommands) {
            if (!cmd.contains("locator")) {
                allCommands.add(cmd);
                continue;
            }
            removedCommands.add(cmd);
        }
        for (String cmd : aliasCommands) {
            if (cmd.contains("locator")) continue;
            aliases.add(cmd);
        }
        String dsPropsArgs = LocalizedResource.getMessage((String)"UTIL_GFXD_Tools_DSProps");
        String dsPropsHelpPre = LocalizedResource.getMessage((String)"UTIL_GFXD_Tools_DSProps_HelpPre");
        String dsPropsHelpPost = LocalizedResource.getMessage((String)"UTIL_GFXD_Tools_DSProps_HelpPost");
        for (String cmd : commandsWithDSProps) {
            String usage = ((String)this.usageMap.get(cmd)).toString();
            String help = ((String)this.helpMap.get(cmd)).toString();
            String cmdKeyPrefix = "UTIL_" + cmd.replace('-', '_');
            String extraUsage = LocalizedResource.getInstance().getTextMessageOrNull(cmdKeyPrefix + "_ExtraArgs", null);
            String extraHelp = LocalizedResource.getInstance().getTextMessageOrNull(cmdKeyPrefix + "_ExtraArgsHelp", null);
            modifiedUsageInfo.put(cmd, usage + (extraUsage == null ? dsPropsArgs : extraUsage + dsPropsArgs));
            modifiedHelpInfo.put(cmd, help + (extraHelp == null ? dsPropsHelpPre + dsPropsHelpPost : dsPropsHelpPre + extraHelp + dsPropsHelpPost));
        }
        validCommands = allCommands.toArray(new String[allCommands.size()]);
        aliasCommands = aliases.toArray(new String[aliases.size()]);
    }

    public GfxdSystemAdmin() {
        GemFireCacheImpl.setGFXDSystem((boolean)true);
    }

    public static void main(String[] args) {
        try {
            GemFireXDVersion.loadProperties();
            GfxdSystemAdmin admin = new GfxdSystemAdmin();
            admin.initHelpMap();
            admin.initUsageMap();
            admin.initMapsForGFXD();
            for (String string : removedCommands) {
                admin.usageMap.remove(string);
                admin.helpMap.remove(string);
            }
            for (Map.Entry entry : modifiedUsageInfo.entrySet()) {
                admin.usageMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : modifiedHelpInfo.entrySet()) {
                admin.helpMap.put(entry.getKey(), entry.getValue());
            }
            admin.invoke(args);
        }
        catch (GemFireTerminateError term) {
            System.exit(term.getExitCode());
        }
    }

    public void invoke(String[] args) {
        this.defaultLogFileName = null;
        try {
            super.invoke(args);
        }
        finally {
            if (this.defaultLogFileName != null) {
                try {
                    File logFile = new File(this.defaultLogFileName);
                    if (logFile.exists() && logFile.isFile() && logFile.length() == 0L) {
                        logFile.delete();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected String getDistributionLocatorPath() {
        return "com.pivotal.gemfirexd.tools.GfxdDistributionLocator";
    }

    protected String getUsageString(String cmd) {
        StringBuilder result = new StringBuilder(80);
        result.append("gfxd").append(' ');
        result.append((String)this.usageMap.get(cmd.toLowerCase()));
        return result.toString();
    }

    protected void printHelp(String cmd) {
        System.err.println(LocalizedStrings.SystemAdmin_USAGE.toLocalizedString() + ": " + this.getUsageString(cmd));
        System.err.println();
        List lines = GfxdSystemAdmin.format((String)((String)this.helpMap.get(cmd.toLowerCase())).toString(), (int)80);
        for (String line : lines) {
            System.err.println(line);
        }
        throw new GemFireTerminateError("exiting after printing help", 1);
    }

    public void printStacks(String cmd, List<String> cmdLine, boolean allStacks) {
        super.printStacks(cmd, cmdLine, true);
    }

    protected void checkDashArg(String cmd, String arg, Iterator it) {
        if (Arrays.binarySearch(commandsWithDSProps, cmd) >= 0) {
            if (cmd != null && this.matchCmdArg(cmd, arg) || this.matchCmdArg("gemfire", arg)) {
                it.remove();
            }
        } else {
            super.checkDashArg(cmd, arg, it);
        }
    }

    public static String[] getValidCommands() {
        return SystemAdmin.getValidCommands();
    }

    protected String upperCaseDiskStoreNameIfNeeded(String diskStoreName) {
        return diskStoreName.toUpperCase();
    }

    protected void printProductDirectory() {
        System.out.println(LocalizedResource.getMessage((String)"UTIL_version_ProductDirectory", (Object)GfxdSystemAdmin.getProductDir()));
    }

    public void upgradeDiskStore(List<String> args) {
        super.upgradeDiskStore(args);
        String diskStoreName = args.get(0);
        if (diskStoreName.startsWith("SQLF-DD-")) {
            GemFireXDUtils.renameFiles((List)GemFireXDUtils.listFiles((String)diskStoreName, args.subList(1, args.size())));
        } else if (diskStoreName.startsWith("SQLF-DEFAULT-")) {
            GemFireXDUtils.renameFiles((List)GemFireXDUtils.listFiles((String)diskStoreName, args.subList(1, args.size())));
        }
    }

    protected String encryptPassword(String cmd, List<?> cmdLine) throws Exception {
        String pwd2;
        boolean forExternal = false;
        if (cmdLine.size() > 0 && PASSWORD_FOR_EXTERNAL.equals(cmdLine.get(0))) {
            cmdLine.remove(0);
            forExternal = true;
        } else if (cmdLine.size() > 0) {
            this.usage(cmd);
        }
        Console cons = System.console();
        if (cons == null) {
            throw new IllegalStateException("No console found for reading the password.");
        }
        String user = cons.readLine(LocalizedResource.getMessage((String)"UTIL_user_Prompt"), new Object[0]);
        String pwd = new String(cons.readPassword(LocalizedResource.getMessage((String)"UTIL_password_Prompt"), new Object[0]));
        if (!pwd.equals(pwd2 = new String(cons.readPassword(LocalizedResource.getMessage((String)"UTIL_reenter_password_Prompt"), new Object[0])))) {
            throw new IllegalStateException("Re-entered password mismatched");
        }
        String encryptedString = forExternal ? this.encryptForExternal(cmd, cmdLine, user, pwd) : AuthenticationServiceBase.encryptUserPassword((String)user, (String)pwd, (boolean)true, (boolean)false, (boolean)true);
        System.out.println(LocalizedResource.getMessage((String)"UTIL_encrypt_password_Output", (Object)encryptedString));
        return encryptedString;
    }

    public String encryptForExternal(String cmd, List<?> cmdLine, String user, String pwd) throws Exception {
        this.getAdminCnx(cmd, cmdLine);
        if (Misc.getMemStoreBooting().getDDLQueueNoThrow().getRegion().getCacheDistributionAdvisor().adviseInitializedPersistentMembers().size() == 0) {
            throw new IllegalStateException("No member with persistent datadictionary found!");
        }
        String algo = this.encryptPasswordTransformation == null ? "AES" : GemFireXDUtils.getPrivateKeyAlgorithm((String)this.encryptPasswordTransformation);
        GemFireXDUtils.initializePrivateKey((String)algo, (int)this.encryptPasswordKeySize, null);
        return GemFireXDUtils.encrypt((String)pwd, (String)this.encryptPasswordTransformation, (byte[])GemFireXDUtils.getUserPasswordCipherKeyBytes((String)user, (String)this.encryptPasswordTransformation, (int)this.encryptPasswordKeySize));
    }

    protected void checkNoArgs(String cmd, List cmdLine) {
    }

    protected void checkRevokeMissingDiskStoresArgs(String cmd, List cmdLine) {
        if (cmdLine.size() < 1) {
            System.err.println("Expected a disk store id.");
            this.usage(cmd);
        }
    }

    protected void checkShutDownAllArgs(String cmd, List<String> cmdLine) {
    }

    protected void checkBackupArgs(String cmd, List cmdLine) {
        if (cmdLine.size() < 1) {
            this.usage(cmd);
        }
    }

    protected Set<?> invokeShutDownAllMembers(InternalDistributedSystem ads, long timeout) throws SQLException {
        if (this.shutDownAllIncludeAdmins) {
            DM dm = ads.getDistributionManager();
            HashSet recipients = new HashSet(dm.getDistributionManagerIdsIncludingAdmin());
            recipients.remove(dm.getDistributionManagerId());
            return new GfxdShutdownAllRequest().send(dm, recipients, timeout);
        }
        if (this.shutDownAllSkipAccessors) {
            GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
            Set members = advisor.adviseDataStores(null);
            members.remove(ads.getDistributedMember());
            return new GfxdShutdownAllRequest().send(ads.getDistributionManager(), members, timeout);
        }
        GfxdDistributionAdvisor advisor = GemFireXDUtils.getGfxdAdvisor();
        Set members = advisor.adviseOperationNodes(null);
        members.remove(ads.getDistributedMember());
        return new GfxdShutdownAllRequest().send(ads.getDistributionManager(), members, timeout);
    }

    protected InternalDistributedSystem getAdminCnx(String cmd, List cmdLine) {
        String passwd;
        Properties dsProps;
        this.shutDownAllIncludeAdmins = false;
        this.shutDownAllSkipAccessors = false;
        Properties props = new Properties();
        props.setProperty("log-level", "warning");
        for (int index = 0; index < cmdLine.size(); ++index) {
            String argValue;
            int eqIndex;
            String arg = (String)cmdLine.get(index);
            if (arg.length() == 0 || arg.charAt(0) != '-' || (eqIndex = arg.indexOf(61)) <= 0 && !noValArgs.contains(arg)) {
                this.usage(cmd);
                return null;
            }
            if (eqIndex >= 0) {
                argValue = arg.substring(eqIndex + 1);
            } else {
                argValue = "";
                eqIndex = arg.length();
            }
            if (arg.startsWith("-J-D")) {
                System.setProperty(arg.substring(4, eqIndex), argValue);
                continue;
            }
            if ("shut-down-all".equals(cmd)) {
                if (INCLUDE_ADMINS.equals(arg)) {
                    this.shutDownAllIncludeAdmins = true;
                    continue;
                }
                if (SKIP_ACCESSORS.equals(arg)) {
                    this.shutDownAllSkipAccessors = true;
                    continue;
                }
                props.setProperty(arg.substring(1, eqIndex), argValue);
                continue;
            }
            if ("encrypt-password".equals(cmd)) {
                if (arg.startsWith(PASSWORD_TRANSFORM)) {
                    this.encryptPasswordTransformation = argValue;
                    continue;
                }
                if (arg.startsWith(PASSWORD_KEYSIZE)) {
                    this.encryptPasswordKeySize = Integer.parseInt(argValue);
                    continue;
                }
                props.setProperty(arg.substring(1, eqIndex), argValue);
                continue;
            }
            props.setProperty(arg.substring(1, eqIndex), argValue);
        }
        this.defaultLogFileName = "gemfirexd.log";
        if (cmd != null) {
            this.defaultLogFileName = cmd.replace('-', '_') + ".log";
        }
        try {
            props = FabricServiceUtils.preprocessProperties((Properties)props, null, null, (boolean)false);
            dsProps = FabricServiceUtils.filterGemFireProperties((Properties)props, (String)this.defaultLogFileName);
        }
        catch (SQLException e) {
            throw GemFireXDRuntimeException.newRuntimeException((String)"Exception in admin connection", (Throwable)e);
        }
        if (props.containsKey("password") && ((passwd = props.getProperty("password")) == null || passwd.length() == 0)) {
            Console cons = System.console();
            if (cons == null) {
                throw new IllegalStateException("No console found for reading the password.");
            }
            char[] pwd = cons.readPassword(LocalizedResource.getMessage((String)"UTIL_password_Prompt"), new Object[0]);
            if (pwd != null) {
                passwd = new String(pwd);
                props.setProperty("password", passwd);
            } else {
                props.remove("password");
            }
        }
        DistributionConfigImpl dsc = new DistributionConfigImpl(dsProps);
        System.out.print("Connecting to distributed system:");
        if (!"".equals(dsc.getLocators())) {
            System.out.println(" locators=" + dsc.getLocators());
        } else {
            System.out.println(" mcast=" + dsc.getMcastAddress() + ":" + dsc.getMcastPort());
        }
        props.setProperty("host-data", "false");
        props = GfxdServerLauncher.processProperties(props, null, this.defaultLogFileName);
        props.put("gemfirexd.__rt.admin", "true");
        try {
            FabricServer server = (FabricServer)Class.forName("com.pivotal.gemfirexd.FabricServiceManager").getMethod("getFabricServerInstance", new Class[0]).invoke(null, new Object[0]);
            if (server.status() != FabricService.State.RUNNING) {
                server.start(props);
            }
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException(ex);
            rte.setStackTrace(new StackTraceElement[0]);
            throw rte;
        }
        InternalDistributedSystem ds = InternalDistributedSystem.getConnectedInstance();
        Set existingMembers = ds.getDistributionManager().getDistributionManagerIds();
        if (existingMembers.isEmpty()) {
            throw new RuntimeException("There are no members in the distributed system");
        }
        return ds;
    }

    static {
        GemFireCacheImpl.setGFXDSystem((boolean)true);
    }
}

