/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.pivotal.gemfirexd.FabricLocator;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.internal.engine.fabricservice.FabricServiceUtils;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class GfxdDistributionLocator
extends GfxdServerLauncher {
    private static final String LOC_ADDRESS_ARG = "peer-discovery-address";
    private static final String LOC_PORT_ARG = "peer-discovery-port";
    private static final String LWC_PORT_ARG = "client-port";
    private static final String JMX_MANAGER_ARG = "jmx-manager";
    private String bindAddress = "0.0.0.0";
    private int port = 10334;
    private static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(GfxdDistributionLocator.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");

    public GfxdDistributionLocator(String baseName) {
        super(baseName);
        this.waitForData = false;
    }

    @Override
    protected void usage() throws IOException {
        String script = LocalizedResource.getMessage((String)"LOC_SCRIPT");
        String name = LocalizedResource.getMessage((String)"LOC_NAME");
        this.printUsage(LocalizedResource.getMessage((String)"SERVER_HELP", (Object)script, (Object)name, (Object)LocalizedResource.getMessage((String)"LOC_ADDRESS_ARG"), (Object)LocalizedResource.getMessage((String)"LOC_EXTRA_HELP")), 23);
    }

    @Override
    protected FabricService getFabricServiceInstance() throws Exception {
        return (FabricService)Class.forName("com.pivotal.gemfirexd.FabricServiceManager").getMethod("getFabricLocatorInstance", new Class[0]).invoke(null, new Object[0]);
    }

    @Override
    protected void startServerVM(Properties props) throws Exception {
        ((FabricLocator)this.getFabricServiceInstance()).start(this.bindAddress, this.port, props);
        this.bootProps = props;
    }

    @Override
    protected boolean setDefaultHeapSize() {
        return false;
    }

    @Override
    protected void processStartOption(String key, String value, Map<String, Object> m, List<String> vmArgs, Map<String, String> envArgs, Properties props) throws Exception {
        if (LOC_ADDRESS_ARG.equals(key)) {
            m.put(LOC_ADDRESS_ARG, value);
        } else if (JMX_MANAGER_ARG.equals(key)) {
            m.put(JMX_MANAGER_ARG, value);
        } else if (LOC_PORT_ARG.equals(key)) {
            try {
                int locPort = Integer.parseInt(value);
                if (locPort < 1 || locPort > 65535) {
                    String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                    throw new IllegalArgumentException(msg);
                }
                m.put(LOC_PORT_ARG, value);
            }
            catch (NumberFormatException nfe) {
                String msg = LocalizedResource.getMessage((String)"SERVER_INVALID_PORT", (Object)value);
                throw new IllegalArgumentException(msg, nfe);
            }
        } else {
            super.processStartOption(key, value, m, vmArgs, envArgs, props);
        }
    }

    @Override
    protected DistributionConfig printDiscoverySettings(Map<String, Object> options, Properties props) throws SQLException {
        String locPort;
        String locAddress;
        Object locAddressObj = options.get(LOC_ADDRESS_ARG);
        Object locPortObj = options.get(LOC_PORT_ARG);
        String locators = props.getProperty("locators");
        if (locAddressObj == null || (locAddress = (String)locAddressObj).length() == 0) {
            locAddress = "0.0.0.0";
        }
        if (locPortObj == null || (locPort = (String)locPortObj).length() == 0) {
            locPort = String.valueOf(10334);
        }
        props.setProperty("start-locator", locAddress + '[' + locPort + ']');
        props = FabricServiceUtils.preprocessProperties((Properties)props, null, null, (boolean)true);
        props = FabricServiceUtils.filterGemFireProperties((Properties)props, (String)"gemfirexdlocatortemp.log");
        if (locators != null && locators.length() > 0) {
            System.out.println(LocalizedResource.getMessage((String)"LOC_START_MESSAGE_WITH_LOCATORS", (Object)this.baseName, (Object)(locAddress + '[' + locPort + ']'), (Object)locators));
        } else {
            System.out.println(LocalizedResource.getMessage((String)"LOC_START_MESSAGE", (Object)this.baseName, (Object)(locAddress + '[' + locPort + ']')));
        }
        return new DistributionConfigImpl(props);
    }

    @Override
    protected String getNetworkPortArgName() {
        return LWC_PORT_ARG;
    }

    public static void main(String[] args) {
        GfxdDistributionLocator launcher = new GfxdDistributionLocator("SnappyData Locator");
        launcher.run(args);
    }

    @Override
    protected String getBaseName(String name) {
        if (!StringUtils.isBlank((String)System.getenv("SNAPPY_HOME"))) {
            return "snappylocator";
        }
        return "gfxdlocator";
    }

    @Override
    protected void addToServerCommand(List<String> cmds, Map<String, Object> options) {
        String manager;
        String locPort;
        super.addToServerCommand(cmds, options);
        StringBuilder locOption = new StringBuilder();
        String locAddress = (String)options.get(LOC_ADDRESS_ARG);
        if (locAddress != null) {
            locOption.append('-').append(LOC_ADDRESS_ARG).append('=').append(locAddress);
            cmds.add(locOption.toString());
        }
        if ((locPort = (String)options.get(LOC_PORT_ARG)) != null) {
            locOption.setLength(0);
            locOption.append('-').append(LOC_PORT_ARG).append('=').append(Integer.parseInt(locPort));
            cmds.add(locOption.toString());
        }
        if (null == (manager = (String)options.get(JMX_MANAGER_ARG))) {
            locOption.setLength(0);
            locOption.append(JMX_MANAGER_ARG).append('=').append("true");
            cmds.add(locOption.toString());
        }
    }

    protected Map<String, Object> getServerOptions(String[] args) throws Exception {
        String locPort;
        Map options = super.getServerOptions(args);
        this.bindAddress = (String)options.get(LOC_ADDRESS_ARG);
        if (this.bindAddress == null) {
            this.bindAddress = "0.0.0.0";
        }
        this.port = (locPort = (String)options.get(LOC_PORT_ARG)) != null ? Integer.parseInt(locPort) : 10334;
        return options;
    }

    protected void startRebalanceFactory(Cache cache, Map<String, Object> options) {
    }

    @Override
    protected boolean printLaunchCommand() {
        return PRINT_LAUNCH_COMMAND;
    }

    @Override
    protected void listAddOnArgs(boolean startsWithGemfire, boolean startsWithGemfirexd, boolean isPrefixHyphen) {
        super.listAddOnArgs(startsWithGemfire, startsWithGemfirexd, isPrefixHyphen);
        if (!startsWithGemfire && !startsWithGemfirexd && isPrefixHyphen) {
            System.out.println("-peer-discovery-address");
            System.out.println("-peer-discovery-port");
            System.out.println("-client-port");
        }
    }
}

