/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.jmx.AgentConfig;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.FabricAgent;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.tools.internal.GfxdServerLauncher;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class GfxdAgentLauncher
extends GfxdServerLauncher {
    private static final boolean PRINT_LAUNCH_COMMAND = Boolean.getBoolean(GfxdAgentLauncher.class.getSimpleName() + ".PRINT_LAUNCH_COMMAND");

    public GfxdAgentLauncher(String baseName) {
        super(baseName);
    }

    @Override
    protected void usage() throws IOException {
        String script = LocalizedResource.getMessage((String)"AGENT_SCRIPT");
        String name = LocalizedResource.getMessage((String)"AGENT_NAME");
        this.printUsage(LocalizedResource.getMessage((String)"SERVER_HELP", (Object)script, (Object)name, (Object)LocalizedResource.getMessage((String)"AGENT_ADDRESS_ARG"), (Object)LocalizedResource.getMessage((String)"AGENT_EXTRA_HELP")), 23);
    }

    protected final FabricAgent getFabricServiceInstance() throws Exception {
        return (FabricAgent)Class.forName("com.pivotal.gemfirexd.FabricServiceManager").getMethod("getFabricAgentInstance", new Class[0]).invoke(null, new Object[0]);
    }

    @Override
    protected void startServerVM(Properties props) throws Exception {
        this.getFabricServiceInstance().start(props);
        this.bootProps = props;
    }

    @Override
    protected boolean setDefaultHeapSize() {
        return false;
    }

    @Override
    protected void processStartOption(String key, String value, Map<String, Object> m, List<String> vmArgs, Map<String, String> envArgs, Properties props) throws Exception {
        if ("auth-provider".equals(key)) {
            props.setProperty("auth-provider", value);
        } else if ("server-auth-provider".equals(key)) {
            props.setProperty("server-auth-provider", value);
        } else if ("password".equalsIgnoreCase(key) && (value == null || value.length() == 0)) {
            this.readPassword(envArgs);
        } else if ("sync".equals(key)) {
            if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
                throw new IllegalArgumentException(LocalizedResource.getMessage((String)"UTIL_GFXD_ExpectedBoolean", (Object)"sync", (Object)value));
            }
            this.waitForData = "true".equalsIgnoreCase(value);
        } else {
            this.processUnknownStartOption(key, value, m, vmArgs, props);
        }
    }

    @Override
    protected List<String> postProcessOptions(List<String> incomingVMArgs, Map<String, Object> map) {
        if (this.processedDefaultGCParams) {
            return incomingVMArgs;
        }
        if (this.maxHeapSize == null) {
            return incomingVMArgs;
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        if (this.jvmVendor != null && (this.jvmVendor.contains("Sun") || this.jvmVendor.contains("Oracle"))) {
            vmArgs.add("-XX:+UseParNewGC");
            vmArgs.add("-XX:+UseConcMarkSweepGC");
            vmArgs.add("-XX:CMSInitiatingOccupancyFraction=50");
        }
        vmArgs.addAll(incomingVMArgs);
        this.processedDefaultGCParams = true;
        return vmArgs;
    }

    @Override
    protected String getNetworkAddressArgName() {
        return null;
    }

    @Override
    protected String getNetworkPortArgName() {
        return null;
    }

    @Override
    protected void startAdditionalServices(Cache cache, Map<String, Object> options, Properties props) throws Exception {
    }

    protected void redirectOutputToLogFile(InternalDistributedSystem system) throws Exception {
        AgentConfig config = this.getFabricServiceInstance().getConfig();
        if (config.getLogFile() == null || "".equals(config.getLogFile().trim())) {
            config.setLogFile(this.getBaseName(null) + ".log");
        }
        OSProcess.redirectOutput((File)new File(config.getLogFile()));
    }

    public static void main(String[] args) {
        SystemFailure.loadEmergencyClasses();
        GfxdAgentLauncher launcher = new GfxdAgentLauncher("GemFireXD JMX Agent");
        launcher.run(args);
    }

    @Override
    protected String getBaseName(String name) {
        return "gfxdagent";
    }

    @Override
    protected void addToServerCommand(List<String> cmds, Map<String, Object> options) {
        CacheServerLauncher.ListWrapper commandLineWrapper = new CacheServerLauncher.ListWrapper(cmds);
        Properties props = (Properties)options.get("properties");
        for (Object key : props.keySet()) {
            commandLineWrapper.add((Object)(key + "=" + props.getProperty(key.toString())));
        }
        if (props.getProperty("log-file") == null && GfxdAgentLauncher.isLoggingToStdOut()) {
            commandLineWrapper.add((Object)("log-file=" + this.defaultLogFileName));
        }
    }

    @Override
    protected void printStartMessage(Map<String, Object> options, Properties props, int pid) throws Exception {
        Properties configProps = new Properties();
        Set<String> gfePropNames = GfxdAgentLauncher.getGFEPropNames();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            if (!gfePropNames.contains(key)) continue;
            configProps.put(entry.getKey(), entry.getValue());
        }
        this.printDiscoverySettings(options, configProps);
    }

    protected Map<String, Object> getServerOptions(String[] args) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("dir", new File("."));
        this.workingDir = (File)options.get("dir");
        Properties props = new Properties();
        options.put("properties", props);
        for (String arg : args) {
            if (arg.equals("server")) continue;
            if (arg.startsWith("-dir=")) {
                this.workingDir = this.processDirOption(options, arg.substring(arg.indexOf("=") + 1));
                continue;
            }
            if (arg.indexOf("=") > 1) {
                int assignmentIndex = arg.indexOf("=");
                String key = arg.substring(0, assignmentIndex);
                String value = arg.substring(assignmentIndex + 1);
                if (key.startsWith("-")) {
                    options.put(key.substring(1), value);
                    continue;
                }
                props.setProperty(key, value);
                continue;
            }
            throw new IllegalArgumentException(LocalizedStrings.CacheServerLauncher_UNKNOWN_ARGUMENT_0.toLocalizedString(new Object[]{arg}));
        }
        this.processServerEnv(props);
        return options;
    }

    protected void startRebalanceFactory(Cache cache, Map<String, Object> options) {
    }

    @Override
    protected boolean printLaunchCommand() {
        return PRINT_LAUNCH_COMMAND;
    }

    @Override
    protected void listAddOnArgs(boolean startsWithGemfire, boolean startsWithGemfirexd, boolean isPrefixHyphen) {
        if (!startsWithGemfire && !startsWithGemfirexd && isPrefixHyphen) {
            System.out.println("-classpath");
            System.out.println("-sync");
        }
    }
}

