/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools;

import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.PagedLocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.RedirectedLocalizedOutput;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijException;
import com.pivotal.gemfirexd.internal.shared.common.StopWatch;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jline.console.ConsoleReader;

public class JDBCDisplayUtil {
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    public static boolean showSelectCount = false;
    public static boolean showSelectRows = true;
    private static final int MAX_RETRIES = 0;
    private static int maxLineWidth;
    private static int maxLineWidthImplicit;
    private static boolean maxWidthIsExplicit;
    private static boolean maxLineWidthIsExplicit;
    private static boolean pageResults;
    private static final HashMap<String, Integer> columnWidths;
    private static ArrayDeque<String[]> currentResults;

    public static void ShowException(PrintWriter out, Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(out, (SQLException)e);
        } else {
            e.printStackTrace(out);
        }
    }

    public static void ShowSQLException(PrintWriter out, SQLException e) {
        String errorCode = JDBCDisplayUtil.getSystemBoolean("gfxd.showErrorCode") ? LocalizedResource.getMessage((String)"UT_Error0", (Object)LocalizedResource.getNumber((int)e.getErrorCode())) : "";
        while (e != null) {
            String p1 = JDBCDisplayUtil.mapNull(e.getSQLState(), LocalizedResource.getMessage((String)"UT_NoSqlst"));
            String p2 = JDBCDisplayUtil.mapNull(e.getMessage(), LocalizedResource.getMessage((String)"UT_NoMessa"));
            out.println(LocalizedResource.getMessage((String)"UT_Error012", (Object)p1, (Object)p2, (Object)errorCode));
            JDBCDisplayUtil.doTrace(out, (Exception)e);
            e = e.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter out, Connection theConnection) {
        try {
            Object warning = null;
            if (theConnection != null) {
                JDBCDisplayUtil.ShowWarnings(out, theConnection.getWarnings());
            }
            if (theConnection != null) {
                theConnection.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static int ShowWarnings(PrintWriter out, SQLWarning warning) {
        int numWarnings = 0;
        while (warning != null) {
            ++numWarnings;
            String p1 = JDBCDisplayUtil.mapNull(warning.getSQLState(), LocalizedResource.getMessage((String)"UT_NoSqlst_7"));
            String p2 = JDBCDisplayUtil.mapNull(warning.getMessage(), LocalizedResource.getMessage((String)"UT_NoMessa_8"));
            out.println(LocalizedResource.getMessage((String)"UT_Warni01", (Object)p1, (Object)p2));
            warning = warning.getNextWarning();
        }
        return numWarnings;
    }

    public static int ShowWarnings(PrintWriter out, ResultSet rs) {
        try {
            Object warning = null;
            if (rs != null) {
                return JDBCDisplayUtil.ShowWarnings(out, rs.getWarnings());
            }
            if (rs != null) {
                rs.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
        return 0;
    }

    public static void ShowWarnings(PrintWriter out, Statement s) {
        try {
            Object warning = null;
            if (s != null) {
                JDBCDisplayUtil.ShowWarnings(out, s.getWarnings());
            }
            if (s != null) {
                s.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void DisplayResults(PrintWriter out, Statement stmt, Connection conn, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, stmt, conn, 0, null, null, reader, timer);
    }

    private static void indent_DisplayResults(PrintWriter out, Statement stmt, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.checkNotNull(stmt, "Statement");
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, indentLevel, displayColumns, displayColumnWidths, reader, timer);
            rs.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(out, stmt.getUpdateCount(), indentLevel);
        }
        JDBCDisplayUtil.ShowWarnings(out, stmt);
    }

    static void DisplayUpdateCount(PrintWriter out, int count, int indentLevel) {
        if (count == 1) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_1RowInserUpdatDelet"));
        } else if (count >= 0) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_0RowsInserUpdatDelet", (Object)LocalizedResource.getNumber((int)count)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_StateExecu"));
        }
    }

    private static int[] getColumnDisplayWidths(ResultSetMetaData rsmd, int[] dispColumns, boolean localizedOutput) throws SQLException {
        int count = dispColumns == null ? rsmd.getColumnCount() : dispColumns.length;
        int[] widths = new int[count];
        for (int i = 0; i < count; ++i) {
            int colnum = dispColumns == null ? i + 1 : dispColumns[i];
            int dispsize = localizedOutput ? LocalizedResource.getInstance().getColumnDisplaySize(rsmd, colnum) : rsmd.getColumnDisplaySize(colnum);
            int maxWidth = JDBCDisplayUtil.getMaxColumnWidth(rsmd.getColumnLabel(colnum));
            widths[i] = Math.min(maxWidth, Math.max(rsmd.isNullable(colnum) == 0 ? 0 : 4, dispsize));
        }
        return widths;
    }

    public static void DisplayMultipleResults(PrintWriter out, List resultSets, Connection conn, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, resultSets, conn, 0, displayColumns, displayColumnWidths, reader, timer);
    }

    public static void DisplayResults(PrintWriter out, ResultSet rs, Connection conn, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, 0, displayColumns, displayColumnWidths, reader, timer);
    }

    private static void indent_DisplayResults(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
        resultSets.add(rs);
        JDBCDisplayUtil.indent_DisplayResults(out, resultSets, conn, 0, displayColumns, displayColumnWidths, reader, timer);
    }

    private static void indent_DisplayResults(PrintWriter out, List resultSets, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        int termWidth;
        ResultSetMetaData rsmd = null;
        if (resultSets != null && resultSets.size() > 0) {
            rsmd = ((ResultSet)resultSets.get(0)).getMetaData();
        }
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int numberOfRowsSelected = 0;
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        if (displayColumnWidths == null) {
            displayColumnWidths = JDBCDisplayUtil.getColumnDisplayWidths(rsmd, displayColumns, true);
        }
        if (rsmd != null) {
            JDBCDisplayUtil.adjustColumnWidths(displayColumns, displayColumnWidths, resultSets, rsmd, nestedResults, false, reader);
        }
        if (reader != null && (termWidth = reader.getTerminal().getWidth()) > 4 && pageResults && !(out instanceof RedirectedLocalizedOutput)) {
            String continuePrompt = LocalizedResource.getMessage((String)"UTIL_GFXD_Continue_Prompt");
            out = new PagedLocalizedOutput((Writer)out, reader.getInput(), termWidth, reader.getTerminal().getHeight(), continuePrompt, timer);
        }
        try {
            int len = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
            int retry = 0;
            ResultSet rs = null;
            boolean doNext = true;
            for (int i = 0; i < resultSets.size(); ++i) {
                rs = (ResultSet)resultSets.get(i);
                doNext = true;
                while (doNext) {
                    try {
                        doNext = currentResults != null ? true : rs.next();
                        if (!doNext) continue;
                        JDBCDisplayUtil.DisplayRow(out, rs, rsmd, len, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
                        JDBCDisplayUtil.ShowWarnings(out, rs);
                        ++numberOfRowsSelected;
                    }
                    catch (SQLException e) {
                        if (++retry > 0) {
                            throw e;
                        }
                        JDBCDisplayUtil.ShowSQLException(out, e);
                    }
                }
            }
            if (showSelectCount) {
                if (numberOfRowsSelected == 1) {
                    out.println();
                    JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_1RowSelec"));
                } else if (numberOfRowsSelected >= 0) {
                    out.println();
                    JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_0RowsSelec", (Object)LocalizedResource.getNumber((int)numberOfRowsSelected)));
                }
            }
            JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel, reader, timer);
            nestedResults = null;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void DisplayNestedResults(PrintWriter out, Vector nr, Connection conn, int indentLevel, ConsoleReader reader, StopWatch timer) throws SQLException {
        if (nr == null) {
            return;
        }
        String b = LocalizedResource.getMessage((String)"UT_JDBCDisplayUtil_16");
        String oldString = "0";
        for (int i = 0; i < nr.size(); ++i) {
            LocalizedResource.OutputWriter().println();
            String t = Integer.toString(i);
            if (t.length() > oldString.length()) {
                oldString = t;
                b = b + LocalizedResource.getMessage((String)"UT_JDBCDisplayUtil_17");
            }
            LocalizedResource.OutputWriter().println(b);
            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage((String)"UT_Resul0", (Object)LocalizedResource.getNumber((int)i)));
            LocalizedResource.OutputWriter().println(b);
            JDBCDisplayUtil.indent_DisplayResults(out, (ResultSet)nr.elementAt(i), conn, indentLevel, null, null, reader, timer);
        }
    }

    public static void DisplayNextRow(PrintWriter out, ResultSet rs, Connection conn, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, true), reader, timer);
    }

    private static void indent_DisplayNextRow(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(rs, "ResultSet");
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        if (rs.next()) {
            int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
            JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, null, null);
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel, reader, timer);
        nestedResults = null;
    }

    public static void DisplayCurrentRow(PrintWriter out, ResultSet rs, Connection conn, ConsoleReader reader, StopWatch timer) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, true), reader, timer);
    }

    private static void indent_DisplayCurrentRow(PrintWriter out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths, ConsoleReader reader, StopWatch timer) throws SQLException {
        if (rs == null) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_NoCurreRow_19"));
            return;
        }
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(1);
        results.add(rs);
        JDBCDisplayUtil.adjustColumnWidths(displayColumns, displayColumnWidths, results, rsmd, nestedResults, true, reader);
        int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel, reader, timer);
        nestedResults = null;
    }

    public static int DisplayBanner(PrintWriter out, ResultSetMetaData rsmd) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(rsmd, null, true));
    }

    private static int indent_DisplayBanner(PrintWriter out, ResultSetMetaData rsmd, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int numCols = displayColumnWidths.length;
        int rowLen = numCols - 1;
        if (rowLen < 0) {
            return 0;
        }
        for (i = 1; i <= numCols; ++i) {
            rowLen += displayColumnWidths[i - 1];
        }
        buf.ensureCapacity(rowLen);
        for (i = 1; i <= numCols; ++i) {
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            String s = rsmd.getColumnLabel(colnum);
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                int k;
                buf.append(s);
                for (k = w - s.length(); k >= 64; k -= 64) {
                    buf.append("                                                                ");
                }
                while (k >= 16) {
                    buf.append("                ");
                    k -= 16;
                }
                while (k >= 4) {
                    buf.append("    ");
                    k -= 4;
                }
                while (k > 0) {
                    buf.append(' ');
                    --k;
                }
                continue;
            }
            if (s.length() > w) {
                if (w > 1) {
                    buf.append(s.substring(0, w - 1));
                }
                if (w <= 0) continue;
                buf.append('&');
                continue;
            }
            buf.append(s);
        }
        buf.setLength(Math.min(rowLen, 1024));
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        for (i = 0; i < Math.min(rowLen, 1024); ++i) {
            buf.setCharAt(i, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        buf = null;
        return rowLen;
    }

    private static int DisplayRow(PrintWriter out, ResultSet rs, ResultSetMetaData rsmd, int rowLen, Vector nestedResults, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        if (!showSelectRows) {
            return 0;
        }
        StringBuilder buf = new StringBuilder();
        buf.ensureCapacity(rowLen);
        int numCols = displayColumnWidths.length;
        String[] row = null;
        if (currentResults != null) {
            row = currentResults.removeFirst();
            if (currentResults.size() == 0) {
                currentResults = null;
            }
        }
        for (int i = 1; i <= numCols; ++i) {
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            String s = row != null ? row[i - 1] : JDBCDisplayUtil.getColumnDisplayString(rs, rsmd, colnum, nestedResults);
            int w = displayColumnWidths[i - 1];
            if (out instanceof RedirectedLocalizedOutput) {
                w = s.length() + 1;
            }
            if (s.length() < w) {
                StringBuilder fullS = new StringBuilder(s);
                fullS.ensureCapacity(w);
                for (int k = s.length(); k < w; ++k) {
                    fullS.append(' ');
                }
                s = fullS.toString();
            } else if (s.length() > w) {
                switch (rsmd.getColumnType(i)) {
                    case -15: 
                    case 1: {
                        boolean truncate = false;
                        for (int j = s.length() - 1; j >= w; --j) {
                            if (s.charAt(j) == ' ') continue;
                            truncate = true;
                            break;
                        }
                        if (truncate) {
                            s = s.substring(0, w - 1) + '&';
                            break;
                        }
                        s = s.substring(0, w);
                        break;
                    }
                    default: {
                        s = s.substring(0, w - 1) + '&';
                    }
                }
            }
            buf.append(s);
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        return buf.length() + indentLevel * 2;
    }

    public static void checkNotNull(Object o, String what) {
        if (o == null) {
            throw ijException.objectWasNull(what);
        }
    }

    public static String mapNull(String s, String nullValue) {
        if (s == null) {
            return nullValue;
        }
        return s;
    }

    public static void doTrace(PrintWriter out, Exception e) {
        if (JDBCDisplayUtil.getSystemBoolean("gfxd.exceptionTrace")) {
            e.printStackTrace(out);
            out.flush();
        }
    }

    public static void setMaxDisplayWidth(int maxDisplayWidth) {
        maxWidth = maxDisplayWidth;
        maxWidthIsExplicit = true;
    }

    private static void indentedPrintLine(PrintWriter out, int indentLevel, String text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indentedPrintLine(PrintWriter out, int indentLevel, StringBuilder text) {
        if (!showSelectRows) {
            return;
        }
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indent(PrintWriter out, int indentLevel) {
        for (int ictr = 0; ictr < indentLevel; ++ictr) {
            out.print("  ");
        }
    }

    public static void ShowException(PrintStream out, Throwable e) {
        if (e == null) {
            return;
        }
        if (e instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(out, (SQLException)e);
        } else {
            e.printStackTrace(out);
        }
    }

    public static void ShowSQLException(PrintStream out, SQLException e) {
        String errorCode = JDBCDisplayUtil.getSystemBoolean("gfxd.showErrorCode") ? " (errorCode = " + e.getErrorCode() + ")" : "";
        while (e != null) {
            out.println("ERROR " + JDBCDisplayUtil.mapNull(e.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(e.getMessage(), "(no message)") + errorCode);
            JDBCDisplayUtil.doTrace(out, (Exception)e);
            e = e.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream out, Connection theConnection) {
        try {
            Object warning = null;
            if (theConnection != null) {
                JDBCDisplayUtil.ShowWarnings(out, theConnection.getWarnings());
            }
            if (theConnection != null) {
                theConnection.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintStream out, SQLWarning warning) {
        while (warning != null) {
            out.println("WARNING " + JDBCDisplayUtil.mapNull(warning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(warning.getMessage(), "(no message)"));
            warning = warning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream out, ResultSet rs) {
        try {
            Object warning = null;
            if (rs != null) {
                JDBCDisplayUtil.ShowWarnings(out, rs.getWarnings());
            }
            if (rs != null) {
                rs.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void ShowWarnings(PrintStream out, Statement s) {
        try {
            Object warning = null;
            if (s != null) {
                JDBCDisplayUtil.ShowWarnings(out, s.getWarnings());
            }
            if (s != null) {
                s.clearWarnings();
            }
        }
        catch (SQLException e) {
            JDBCDisplayUtil.ShowSQLException(out, e);
        }
    }

    public static void DisplayResults(PrintStream out, Statement stmt, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, stmt, conn, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream out, Statement stmt, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        JDBCDisplayUtil.checkNotNull(stmt, "Statement");
        ResultSet rs = stmt.getResultSet();
        if (rs != null) {
            JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, indentLevel, displayColumns, displayColumnWidths);
            rs.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(out, stmt.getUpdateCount(), indentLevel);
        }
        JDBCDisplayUtil.ShowWarnings(out, stmt);
    }

    static void DisplayUpdateCount(PrintStream out, int count, int indentLevel) {
        if (count == 1) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "1 row inserted/updated/deleted");
        } else if (count >= 0) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, count + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(out, rs, conn, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int numberOfRowsSelected = 0;
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        if (displayColumnWidths == null) {
            displayColumnWidths = JDBCDisplayUtil.getColumnDisplayWidths(rsmd, displayColumns, false);
        }
        int len = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        boolean doNext = true;
        int retry = 0;
        while (doNext) {
            try {
                doNext = rs.next();
                if (!doNext) continue;
                JDBCDisplayUtil.DisplayRow(out, rs, rsmd, len, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
                JDBCDisplayUtil.ShowWarnings(out, rs);
                ++numberOfRowsSelected;
            }
            catch (SQLException e) {
                if (++retry > 0) {
                    throw e;
                }
                JDBCDisplayUtil.ShowSQLException(out, e);
            }
        }
        if (showSelectCount) {
            if (numberOfRowsSelected == 1) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, "1 row selected");
            } else if (numberOfRowsSelected >= 0) {
                out.println();
                JDBCDisplayUtil.indentedPrintLine(out, indentLevel, numberOfRowsSelected + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    private static void DisplayNestedResults(PrintStream out, Vector nr, Connection conn, int indentLevel) throws SQLException {
        if (nr == null) {
            return;
        }
        String s = "+ ResultSet #";
        String b = "++++++++++++++++";
        String oldString = "0";
        for (int i = 0; i < nr.size(); ++i) {
            System.out.println();
            String t = Integer.toString(i);
            if (t.length() > oldString.length()) {
                oldString = t;
                b = b + "+";
            }
            System.out.println(b);
            System.out.println(s + i + " +");
            System.out.println(b);
            JDBCDisplayUtil.indent_DisplayResults(out, (ResultSet)nr.elementAt(i), conn, indentLevel, null, null);
        }
    }

    public static void DisplayNextRow(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, false));
    }

    private static void indent_DisplayNextRow(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        JDBCDisplayUtil.checkNotNull(rs, "ResultSet");
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        if (rs.next()) {
            int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, null, null);
            JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        } else {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_NoCurreRow"));
        }
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static void DisplayCurrentRow(PrintStream out, ResultSet rs, Connection conn) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(out, rs, conn, 0, null, rs == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(rs.getMetaData(), null, false));
    }

    private static void indent_DisplayCurrentRow(PrintStream out, ResultSet rs, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        if (rs == null) {
            JDBCDisplayUtil.indentedPrintLine(out, indentLevel, LocalizedResource.getMessage((String)"UT_NoCurreRow_19"));
            return;
        }
        Vector nestedResults = !conn.getAutoCommit() ? new Vector() : null;
        ResultSetMetaData rsmd = rs.getMetaData();
        JDBCDisplayUtil.checkNotNull(rsmd, "ResultSetMetaData");
        int rowLen = JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.DisplayRow(out, rs, rsmd, rowLen, nestedResults, conn, indentLevel, displayColumns, displayColumnWidths);
        JDBCDisplayUtil.ShowWarnings(out, rs);
        JDBCDisplayUtil.DisplayNestedResults(out, nestedResults, conn, indentLevel);
        nestedResults = null;
    }

    public static int DisplayBanner(PrintStream out, ResultSetMetaData rsmd) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(out, rsmd, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(rsmd, null, false));
    }

    private static int indent_DisplayBanner(PrintStream out, ResultSetMetaData rsmd, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int numCols = displayColumnWidths.length;
        int rowLen = numCols - 1;
        for (i = 1; i <= numCols; ++i) {
            rowLen += displayColumnWidths[i - 1];
        }
        buf.ensureCapacity(rowLen);
        for (i = 1; i <= numCols; ++i) {
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            String s = rsmd.getColumnLabel(colnum);
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                int k;
                StringBuilder blanks = new StringBuilder(s);
                blanks.ensureCapacity(w);
                for (k = blanks.length() + 64; k <= w; k += 64) {
                    blanks.append("                                                                ");
                }
                for (k = blanks.length() + 16; k <= w; k += 16) {
                    blanks.append("                ");
                }
                for (k = blanks.length() + 4; k <= w; k += 4) {
                    blanks.append("    ");
                }
                for (k = blanks.length(); k < w; ++k) {
                    blanks.append(' ');
                }
                buf.append((CharSequence)blanks);
                continue;
            }
            if (s.length() > w) {
                if (w > 1) {
                    buf.append(s.substring(0, w - 1));
                }
                if (w <= 0) continue;
                buf.append('&');
                continue;
            }
            buf.append(s);
        }
        buf.setLength(Math.min(rowLen, 1024));
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        for (i = 0; i < Math.min(rowLen, 1024); ++i) {
            buf.setCharAt(i, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
        buf = null;
        return rowLen;
    }

    private static void DisplayRow(PrintStream out, ResultSet rs, ResultSetMetaData rsmd, int rowLen, Vector nestedResults, Connection conn, int indentLevel, int[] displayColumns, int[] displayColumnWidths) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.ensureCapacity(rowLen);
        int numCols = displayColumnWidths.length;
        for (int i = 1; i <= numCols; ++i) {
            String s;
            int colnum;
            int n = colnum = displayColumns == null ? i : displayColumns[i - 1];
            if (i > 1) {
                buf.append('|');
            }
            switch (rsmd.getColumnType(colnum)) {
                default: {
                    s = rs.getString(colnum);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object o = rs.getObject(colnum);
                    if (o == null) {
                        s = "NULL";
                        break;
                    }
                    if (o instanceof ResultSet && nestedResults != null) {
                        s = "ResultSet #" + nestedResults.size();
                        nestedResults.addElement(o);
                        break;
                    }
                    try {
                        s = rs.getString(colnum);
                        break;
                    }
                    catch (SQLException se) {
                        s = o.toString();
                    }
                }
            }
            if (s == null) {
                s = "NULL";
            }
            int w = displayColumnWidths[i - 1];
            if (s.length() < w) {
                StringBuilder fullS = new StringBuilder(s);
                fullS.ensureCapacity(w);
                for (int k = s.length(); k < w; ++k) {
                    fullS.append(' ');
                }
                s = fullS.toString();
            } else if (s.length() > w) {
                s = s.substring(0, w - 1) + "&";
            }
            buf.append(s);
        }
        JDBCDisplayUtil.indentedPrintLine(out, indentLevel, buf);
    }

    public static void doTrace(PrintStream out, Exception e) {
        if (JDBCDisplayUtil.getSystemBoolean("gfxd.exceptionTrace")) {
            e.printStackTrace(out);
            out.flush();
        }
    }

    private static void indentedPrintLine(PrintStream out, int indentLevel, String text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indentedPrintLine(PrintStream out, int indentLevel, StringBuilder text) {
        JDBCDisplayUtil.indent(out, indentLevel);
        out.println(text);
    }

    private static void indent(PrintStream out, int indentLevel) {
        for (int ictr = 0; ictr < indentLevel; ++ictr) {
            out.print("  ");
        }
    }

    private static boolean getSystemBoolean(final String name) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Boolean.getBoolean(name) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public static void setMaxLineWidth(int width, boolean explicit) {
        if (!explicit) {
            maxLineWidth = width - 1;
            maxLineWidthImplicit = width - 1;
            maxLineWidthIsExplicit = false;
        } else if (width == 0) {
            maxLineWidth = maxLineWidthImplicit;
            maxLineWidthIsExplicit = false;
        } else {
            maxLineWidth = width - 1;
            maxLineWidthIsExplicit = true;
        }
    }

    public static int getMaxDisplayWidth() {
        return maxWidth;
    }

    public static int getMaxColumnWidth(String columnName) {
        Integer width = columnName != null ? columnWidths.get(columnName) : null;
        return width == null ? maxWidth : width;
    }

    public static int getMaxColumnWidthExplicit(String columnName) {
        Integer width;
        Integer n = width = columnName != null ? columnWidths.get(columnName) : null;
        if (width != null) {
            return width;
        }
        if (maxWidthIsExplicit) {
            return maxWidth;
        }
        return -1;
    }

    public static int getMaxLineWidth() {
        if (maxLineWidthIsExplicit) {
            return maxLineWidth + 1;
        }
        return 0;
    }

    public static void setMaxDisplayWidth(String columnName, int maxDisplayWidth) {
        if (maxDisplayWidth < 0) {
            columnWidths.remove(columnName);
        } else {
            columnWidths.put(columnName, maxDisplayWidth);
        }
    }

    public static void setPaging(boolean on) {
        pageResults = on;
    }

    private static String getColumnDisplayString(ResultSet rs, ResultSetMetaData rsmd, int colNum, Vector nestedResults) throws SQLException {
        String s;
        switch (rsmd.getColumnType(colNum)) {
            case 1111: 
            case 2000: {
                Object o = rs.getObject(colNum);
                if (o == null) {
                    s = "NULL";
                    break;
                }
                if (o instanceof ResultSet && nestedResults != null) {
                    s = LocalizedResource.getMessage((String)"UT_Resul0_20", (Object)LocalizedResource.getNumber((int)nestedResults.size()));
                    nestedResults.addElement(o);
                    break;
                }
                try {
                    s = rs.getString(colNum);
                }
                catch (SQLException se) {
                    s = o.toString();
                }
                break;
            }
            default: {
                s = LocalizedResource.getInstance().getLocalizedString(rs, rsmd, colNum);
            }
        }
        if (s == null) {
            s = "NULL";
        }
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private static void adjustColumnWidths(int[] columns, int[] columnWidths, List results, ResultSetMetaData rsmd, Vector<?> nestedResults, boolean singleRow, ConsoleReader reader) throws SQLException {
        block53: {
            if (JDBCDisplayUtil.maxLineWidth == 0) {
                return;
            }
            numColumns = columnWidths.length;
            adjustForLabels = true;
            JDBCDisplayUtil.currentResults = null;
            totalWidth = numColumns - 1;
            for (int w : columnWidths) {
                totalWidth += w;
            }
            if (reader == null) break block53;
            if (singleRow) {
                numRows = 1;
            } else {
                numRows = reader.getTerminal().getHeight() - 1;
                if (numRows <= 1) {
                    numRows = 2;
                }
            }
            JDBCDisplayUtil.currentResults = new ArrayDeque<E>(numRows);
            newColumnWidths = new int[numColumns];
            newColumnAndLabelWidths = new int[numColumns];
            hasAdjustedColumns = false;
            resultIndex = 0;
            rs = (ResultSet)results.get(resultIndex++);
            block5: while (numRows-- > 0) {
                if (singleRow || rs.next()) ** GOTO lbl28
                ++resultIndex;
                while (resultIndex < results.size()) {
                    if (!(rs = (ResultSet)results.get(resultIndex++)).next()) continue;
lbl28:
                    // 2 sources

                    row = new String[numColumns];
                    for (i = 0; i < numColumns; ++i) {
                        colNum = columns == null ? i + 1 : columns[i];
                        s = JDBCDisplayUtil.getColumnDisplayString(rs, rsmd, colNum, nestedResults);
                        isCharType = false;
                        switch (rsmd.getColumnType(colNum)) {
                            case -16: 
                            case -15: 
                            case -9: 
                            case -1: 
                            case 1: 
                            case 12: 
                            case 2005: {
                                isCharType = true;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2: 
                            case 3: 
                            case 91: 
                            case 92: 
                            case 93: 
                            case 1111: 
                            case 2000: 
                            case 2004: {
                                v0 = len = s != null && s.length() > 4 ? s.length() : 4;
                                if (len > newColumnWidths[i]) {
                                    if (len > 4) {
                                        if (isCharType) {
                                            for (index = s.length() - 1; index >= 0 && s.charAt(index) == ' '; --index) {
                                            }
                                            if (index >= newColumnWidths[i]) {
                                                newColumnWidths[i] = index + 1;
                                            }
                                        } else {
                                            newColumnWidths[i] = s.length();
                                        }
                                        maxWidth = JDBCDisplayUtil.getMaxColumnWidthExplicit(rsmd.getColumnLabel(colNum));
                                        if (maxWidth > 0 && newColumnWidths[i] > maxWidth) {
                                            newColumnWidths[i] = maxWidth;
                                        }
                                    } else {
                                        newColumnWidths[i] = 4;
                                    }
                                    newColumnAndLabelWidths[i] = newColumnWidths[i];
                                }
                                hasAdjustedColumns = true;
                            }
                        }
                        colLabel = rsmd.getColumnLabel(colNum);
                        if (colLabel != null) {
                            labelLen = colLabel.trim().length();
                            maxWidth = JDBCDisplayUtil.getMaxColumnWidthExplicit(colLabel);
                            if (maxWidth > 0 && labelLen > maxWidth) {
                                labelLen = maxWidth;
                            }
                            if ((labelLen > columnWidths[i] || newColumnWidths[i] > 0) && newColumnAndLabelWidths[i] < labelLen) {
                                newColumnAndLabelWidths[i] = labelLen;
                            }
                        }
                        row[i] = s;
                    }
                    JDBCDisplayUtil.currentResults.addLast(row);
                    if (hasAdjustedColumns) continue block5;
                    break block5;
                }
                break block5;
            }
            totalWidth = numColumns - 1;
            totalReduction = 0;
            totalAdjustableWidth = 0;
            for (i = 0; i < columnWidths.length; ++i) {
                newWidth = newColumnAndLabelWidths[i];
                if (newWidth > 0) {
                    totalWidth += newWidth;
                    if (columnWidths[i] > newWidth) {
                        if (newColumnWidths[i] == newColumnAndLabelWidths[i]) {
                            totalReduction += columnWidths[i] - newWidth;
                        } else {
                            c_l = columnWidths[i] - newWidth;
                            totalReduction += c_l * c_l / (columnWidths[i] - newColumnAndLabelWidths[i]);
                        }
                    }
                    totalAdjustableWidth += newWidth;
                    continue;
                }
                totalWidth += columnWidths[i];
            }
            computeWidths = true;
            if (totalWidth > JDBCDisplayUtil.maxLineWidth) {
                if (JDBCDisplayUtil.maxLineWidthIsExplicit) {
                    toReduce = totalWidth - JDBCDisplayUtil.maxLineWidth;
                    totalWidth = numColumns - 1;
                    for (i = 0; i < columnWidths.length; ++i) {
                        newWidth = newColumnAndLabelWidths[i];
                        if (newWidth > 0) {
                            v1 = i;
                            newColumnAndLabelWidths[v1] = newColumnAndLabelWidths[v1] - newWidth * toReduce / totalAdjustableWidth;
                            if (newColumnAndLabelWidths[i] < 4) {
                                newColumnAndLabelWidths[i] = 4;
                            }
                            columnWidths[i] = newColumnAndLabelWidths[i];
                        }
                        totalWidth += columnWidths[i];
                    }
                    initTotalWidth = totalWidth;
                    if (initTotalWidth > JDBCDisplayUtil.maxLineWidth) {
                        toReduce = initTotalWidth - JDBCDisplayUtil.maxLineWidth;
                        totalWidth = numColumns - 1;
                        for (i = 0; i < columnWidths.length; ++i) {
                            if (columnWidths[i] > 4) {
                                v2 = i;
                                columnWidths[v2] = columnWidths[v2] - columnWidths[i] * toReduce / initTotalWidth;
                                if (columnWidths[i] < 4) {
                                    columnWidths[i] = 4;
                                }
                            }
                            totalWidth += columnWidths[i];
                        }
                    }
                    adjustForLabels = false;
                } else {
                    totalWidth = numColumns - 1;
                    for (i = 0; i < columnWidths.length; ++i) {
                        if (newColumnWidths[i] > 0 && columnWidths[i] > newColumnWidths[i]) {
                            columnWidths[i] = newColumnWidths[i];
                        }
                        totalWidth += columnWidths[i];
                    }
                }
                computeWidths = false;
            } else if (totalWidth < JDBCDisplayUtil.maxLineWidth && totalReduction > 0) {
                adjustForLabels = false;
                availableWidth = JDBCDisplayUtil.maxLineWidth - totalWidth;
                for (i = 0; i < columnWidths.length; ++i) {
                    newWidth = newColumnAndLabelWidths[i];
                    if (newWidth <= 0) continue;
                    if (columnWidths[i] > newWidth) {
                        if (newColumnWidths[i] == newColumnAndLabelWidths[i]) {
                            myReduction = columnWidths[i] - newWidth;
                        } else {
                            c_l = columnWidths[i] - newWidth;
                            myReduction = c_l * c_l / (columnWidths[i] - newColumnWidths[i]);
                            newColumnWidths[i] = newColumnAndLabelWidths[i];
                        }
                        v3 = i;
                        newColumnWidths[v3] = newColumnWidths[v3] + myReduction * availableWidth / totalReduction;
                        if (newColumnWidths[i] <= columnWidths[i]) continue;
                        newColumnWidths[i] = columnWidths[i];
                        continue;
                    }
                    if (newColumnAndLabelWidths[i] <= newColumnWidths[i]) continue;
                    newColumnWidths[i] = newColumnAndLabelWidths[i];
                }
            }
            if (computeWidths) {
                totalWidth = numColumns - 1;
                for (i = 0; i < columnWidths.length; ++i) {
                    if (newColumnWidths[i] > 0) {
                        columnWidths[i] = newColumnWidths[i];
                    }
                    totalWidth += columnWidths[i];
                }
            }
            if (JDBCDisplayUtil.currentResults.size() == 0) {
                JDBCDisplayUtil.currentResults = null;
            }
        }
        if (adjustForLabels && (!JDBCDisplayUtil.maxLineWidthIsExplicit || totalWidth < JDBCDisplayUtil.maxLineWidth)) {
            for (i = 0; i < numColumns; ++i) {
                colNum = columns == null ? i + 1 : columns[i];
                colLabel = rsmd.getColumnLabel(colNum);
                if (colLabel == null) continue;
                labelLen = colLabel.trim().length();
                maxWidth = JDBCDisplayUtil.getMaxColumnWidthExplicit(colLabel);
                if (maxWidth > 0 && labelLen > maxWidth) {
                    labelLen = maxWidth;
                }
                if (columnWidths[i] >= labelLen) continue;
                if (JDBCDisplayUtil.maxLineWidthIsExplicit && (totalWidth += labelLen - columnWidths[i]) > JDBCDisplayUtil.maxLineWidth) break;
                columnWidths[i] = labelLen;
            }
        }
    }

    static {
        LocalizedResource.getInstance();
        maxLineWidth = 0;
        maxLineWidthImplicit = 0;
        maxWidthIsExplicit = false;
        maxLineWidthIsExplicit = false;
        pageResults = true;
        columnWidths = new HashMap();
    }
}

