/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.ij;

import com.gemstone.gemfire.internal.GemFireVersion;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedInput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.RedirectedLocalizedOutput;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ConnectionEnv;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ParseException;
import com.pivotal.gemfirexd.internal.impl.tools.ij.StatementFinder;
import com.pivotal.gemfirexd.internal.impl.tools.ij.TokenMgrError;
import com.pivotal.gemfirexd.internal.impl.tools.ij.UCode_CharStream;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ij;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijException;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijFatalException;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijResult;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijRowResult;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijTokenException;
import com.pivotal.gemfirexd.internal.impl.tools.ij.ijTokenManager;
import com.pivotal.gemfirexd.internal.impl.tools.ij.util;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.StopWatch;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;

public class utilMain
implements PrivilegedAction {
    private StatementFinder[] commandGrabber;
    UCode_CharStream charStream;
    ijTokenManager ijTokMgr;
    ij ijParser;
    ConnectionEnv[] connEnv;
    private int currCE;
    private final int numConnections;
    private boolean fileInput;
    private boolean initialFileInput;
    private boolean mtUse;
    private boolean firstRun = true;
    private LocalizedOutput out = null;
    private Properties connAttributeDefaults;
    private Hashtable ignoreErrors;
    private static final Pattern pattern = Pattern.compile("gemfirexd|gfxd", 2);
    private final boolean showErrorCode;
    private final String ijExceptionTrace;
    public static final int BUFFEREDFILESIZE = 2048;
    Stack oldGrabbers = new Stack();
    LocalizedResource langUtil = LocalizedResource.getInstance();
    private final String basePath;
    private final Map<String, String> params;
    private final int numTimesToRun;
    private static String basePrompt = "gfxd";

    public static void setBasePrompt(String prompt) {
        if (prompt != null && prompt.trim().length() >= 3 && prompt.trim().length() <= 10) {
            basePrompt = prompt.trim();
        }
    }

    utilMain(int numConnections, LocalizedOutput out) throws ijFatalException {
        this(numConnections, out, null, null, null, 1);
    }

    public utilMain(int numConnections, LocalizedOutput out, Hashtable ignoreErrors, String basePath, Map<String, String> params, int numTimesToRun) throws ijFatalException {
        this.charStream = new UCode_CharStream(new StringReader(" "), 1, 1);
        this.ijTokMgr = new ijTokenManager(this.charStream);
        this.ijParser = new ij(this.ijTokMgr, this);
        this.out = out;
        this.ignoreErrors = ignoreErrors;
        this.basePath = basePath;
        this.params = params;
        this.numTimesToRun = numTimesToRun;
        this.showErrorCode = Boolean.valueOf(util.getSystemProperty("gfxd.showErrorCode"));
        this.ijExceptionTrace = util.getSystemProperty("gfxd.exceptionTrace");
        this.numConnections = numConnections;
        this.commandGrabber = new StatementFinder[numConnections];
        this.connEnv = new ConnectionEnv[numConnections];
        for (int ictr = 0; ictr < numConnections; ++ictr) {
            this.commandGrabber[ictr] = new StatementFinder(this.langUtil.getNewInput(System.in), out, basePath, params);
            this.connEnv[ictr] = new ConnectionEnv(ictr, numConnections > 1, numConnections == 1);
        }
        this.currCE = 0;
        this.fileInput = false;
        this.initialFileInput = false;
        this.firstRun = true;
    }

    public void initFromEnvironment() {
        this.ijParser.initFromEnvironment();
        for (int ictr = 0; ictr < this.numConnections; ++ictr) {
            try {
                this.connEnv[ictr].init(this.out);
                continue;
            }
            catch (SQLException s) {
                JDBCDisplayUtil.ShowException((PrintWriter)this.out, (Throwable)s);
                continue;
            }
            catch (ClassNotFoundException c) {
                JDBCDisplayUtil.ShowException((PrintWriter)this.out, (Throwable)c);
                continue;
            }
            catch (InstantiationException i) {
                JDBCDisplayUtil.ShowException((PrintWriter)this.out, (Throwable)i);
                continue;
            }
            catch (IllegalAccessException ia) {
                JDBCDisplayUtil.ShowException((PrintWriter)this.out, (Throwable)ia);
            }
        }
    }

    public void go(LocalizedInput[] in, LocalizedOutput out, Properties connAttributeDefaults) throws ijFatalException {
        this.out = out;
        this.connAttributeDefaults = connAttributeDefaults;
        this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
        this.initialFileInput = !in[this.currCE].isStandardInput();
        this.fileInput = this.initialFileInput;
        for (int ictr = 0; ictr < this.commandGrabber.length; ++ictr) {
            this.commandGrabber[ictr].ReInit(in[ictr]);
        }
        if (this.firstRun) {
            out.println(utilMain.convertGfxdMessageToSnappy(this.langUtil.getTextMessage("IJ_IjVers30C199", (Object)(GemFireVersion.getProductVersion() + " " + GemFireVersion.getProductReleaseStage()))));
            for (int i = this.connEnv.length - 1; i >= 0; --i) {
                Connection c = this.connEnv[i].getConnection();
                if (c == null) continue;
                JDBCDisplayUtil.ShowWarnings((PrintWriter)out, c);
            }
            this.firstRun = false;
            boolean showNoCountForSelect = Boolean.valueOf(util.getSystemProperty("gfxd.showNoCountForSelect"));
            JDBCDisplayUtil.showSelectCount = !showNoCountForSelect;
            boolean showNoRowsForSelect = Boolean.valueOf(util.getSystemProperty("gfxd.showNoRowsForSelect"));
            JDBCDisplayUtil.showSelectRows = !showNoRowsForSelect;
            boolean showNoConnectionsAtStart = Boolean.valueOf(util.getSystemProperty("gfxd.showNoConnectionsAtStart"));
            if (!showNoConnectionsAtStart) {
                try {
                    ijResult result = this.ijParser.showConnectionsMethod(true);
                    this.displayResult(out, result, this.connEnv[this.currCE].getConnection(), -1L);
                }
                catch (SQLException ex) {
                    this.handleSQLException(out, ex);
                }
            }
        }
        this.out = out;
        this.runScriptGuts();
        this.cleanupGo(in);
    }

    public int goScript(Connection conn, LocalizedInput in, boolean checkShowSelectCount) {
        boolean showNoCountForSelect;
        JDBCDisplayUtil.showSelectCount = checkShowSelectCount ? !(showNoCountForSelect = Boolean.valueOf(util.getSystemProperty("gfxd.showNoCountForSelect")).booleanValue()) : false;
        boolean showNoRowsForSelect = Boolean.valueOf(util.getSystemProperty("gfxd.showNoRowsForSelect"));
        JDBCDisplayUtil.showSelectRows = !showNoRowsForSelect;
        this.connEnv[0].addSession(conn, null);
        this.initialFileInput = !in.isStandardInput();
        this.fileInput = this.initialFileInput;
        this.commandGrabber[0].ReInit(in);
        return this.runScriptGuts();
    }

    private int runScriptGuts() {
        File initFile;
        int scriptErrorCount = 0;
        boolean done = false;
        String command = null;
        String initScript = System.getProperty("gfxd.initScript");
        if (initScript == null) {
            String homeDir = System.getProperty("user.home");
            initFile = new File(homeDir, ".gfxd.init");
        } else {
            initFile = new File(initScript);
        }
        if (initFile.exists()) {
            this.newInput(initFile.getAbsolutePath());
        }
        while (!this.ijParser.exit && !done) {
            try {
                this.ijParser.setConnection(this.connEnv[this.currCE], this.numConnections > 1);
            }
            catch (Throwable homeDir) {
                // empty catch block
            }
            try {
                command = null;
                command = this.commandGrabber[this.currCE].nextStatement(this.connEnv[this.currCE], this.out);
                while (command == null && !this.oldGrabbers.empty()) {
                    if (this.fileInput) {
                        this.commandGrabber[this.currCE].close();
                    }
                    this.commandGrabber[this.currCE] = (StatementFinder)this.oldGrabbers.pop();
                    if (this.oldGrabbers.empty()) {
                        this.fileInput = this.initialFileInput;
                    }
                    command = this.commandGrabber[this.currCE].nextStatement(null, this.out);
                }
                if (command == null && this.oldGrabbers.empty()) {
                    done = true;
                } else {
                    boolean elapsedTimeOn = this.ijParser.getElapsedTimeState();
                    long beginTime = 0L;
                    if (this.fileInput) {
                        this.out.println(command + ";");
                        this.out.flush();
                    }
                    if (this.ijParser.getExplainMode()) {
                        this.charStream.ReInit(new StringReader(command), 1, 1);
                    } else {
                        this.charStream.ReInit(new StringReader(command), 1, 1);
                    }
                    this.ijTokMgr.ReInit(this.charStream);
                    this.ijParser.ReInit(this.ijTokMgr);
                    if (elapsedTimeOn) {
                        beginTime = System.currentTimeMillis();
                    }
                    ijResult result = this.ijParser.ijStatement();
                    long endTime = this.displayResult(this.out, result, this.connEnv[this.currCE].getConnection(), beginTime);
                    if (elapsedTimeOn) {
                        this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil", (Object)this.langUtil.getNumberAsString(endTime)));
                    }
                }
            }
            catch (ParseException e) {
                if (!this.printConnectUsage(command, (PrintWriter)this.out) && command != null) {
                    scriptErrorCount += this.doCatch(command) ? 0 : 1;
                }
            }
            catch (TokenMgrError e) {
                if (!this.printConnectUsage(command, (PrintWriter)this.out) && command != null) {
                    scriptErrorCount += this.doCatch(command) ? 0 : 1;
                }
            }
            catch (SQLException e) {
                ++scriptErrorCount;
                this.handleSQLException(this.out, e);
                if (!"08001".equals(e.getSQLState()) && !"08004".equals(e.getSQLState())) {
                    this.printConnectUsage(command, (PrintWriter)this.out);
                }
            }
            catch (ijException e) {
                ++scriptErrorCount;
                this.out.println(this.langUtil.getTextMessage("IJ_IjErro0", (Object)this.getExceptionMessageForDisplay(e)));
                this.doTrace(e);
            }
            catch (Throwable e) {
                ++scriptErrorCount;
                this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0", (Object)this.getExceptionMessageForDisplay(e)));
                this.doTrace(e);
            }
            ++this.currCE;
            this.currCE %= this.connEnv.length;
        }
        ConsoleReader reader = this.commandGrabber != null && this.commandGrabber.length > 0 ? this.commandGrabber[0].getConsoleReader() : null;
        if (reader == null) {
            this.out.println();
        }
        return scriptErrorCount;
    }

    private void cleanupGo(LocalizedInput[] in) {
        int i;
        try {
            for (i = 0; i < this.connEnv.length; ++i) {
                this.connEnv[i].removeAllSessions();
            }
        }
        catch (SQLException se) {
            this.handleSQLException(this.out, se);
        }
        for (i = 0; i < this.numConnections; ++i) {
            try {
                in[i].close();
                continue;
            }
            catch (Exception e) {
                this.out.println(this.langUtil.getTextMessage("IJ_CannotCloseInFile", (Object)e.toString()));
            }
        }
        if (this.ijParser.exit || this.initialFileInput && !this.mtUse) {
            Driver d = null;
            try {
                d = DriverManager.getDriver("jdbc:gemfirexd:");
            }
            catch (Throwable e) {
                d = null;
            }
            if (d != null) {
                try {
                    boolean isBooting = false;
                    try {
                        Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.store.GemFireStore");
                        if (c != null) {
                            isBooting = c.getMethod("getBootingInstance", new Class[0]).invoke(null, new Object[0]) != null;
                        }
                    }
                    catch (Exception e) {
                        isBooting = false;
                    }
                    if (isBooting) {
                        DriverManager.getConnection("jdbc:gemfirexd:;shutdown=true");
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private long displayResult(LocalizedOutput out, ijResult result, Connection conn, long beginTime) throws SQLException {
        StopWatch timer = SharedUtils.newTimer((long)beginTime);
        if (result != null) {
            ConsoleReader reader = this.commandGrabber != null && this.commandGrabber.length > 0 ? this.commandGrabber[0].getConsoleReader() : null;
            if (result.isConnection()) {
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                } else {
                    out.println(LocalizedResource.getMessage((String)"IJ_UsingConn", (Object)this.connEnv[this.currCE].getSession().getName()));
                }
            } else if (result.isStatement()) {
                Statement s = result.getStatement();
                try {
                    JDBCDisplayUtil.DisplayResults((PrintWriter)out, s, this.connEnv[this.currCE].getConnection(), reader, timer);
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
            } else if (result.isNextRowOfResultSet()) {
                ResultSet r = result.getNextRowOfResultSet();
                JDBCDisplayUtil.DisplayCurrentRow((PrintWriter)out, r, this.connEnv[this.currCE].getConnection(), reader, timer);
            } else if (result.isHelp()) {
                if (result.pageResult() && reader != null) {
                    SanityManager.printPagedOutput((PrintStream)System.out, (InputStream)reader.getInput(), (String)result.getHelpMessage(), (int)(reader.getTerminal().getHeight() - 1), (String)LocalizedResource.getMessage((String)"UTIL_GFXD_Continue_Prompt"), (boolean)false);
                } else {
                    out.println(result.getHelpMessage());
                }
            } else if (result.isVector()) {
                util.DisplayVector(out, result.getVector());
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                }
            } else if (result.isMulti()) {
                try {
                    util.DisplayMulti(out, (PreparedStatement)result.getStatement(), result.getResultSet(), this.connEnv[this.currCE].getConnection(), reader, timer);
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
                if (result.hasWarnings()) {
                    JDBCDisplayUtil.ShowWarnings((PrintWriter)out, result.getSQLWarnings());
                    result.clearSQLWarnings();
                }
            } else if (result.isResultSet()) {
                ResultSet rs = result.getResultSet();
                try {
                    JDBCDisplayUtil.DisplayResults((PrintWriter)out, rs, this.connEnv[this.currCE].getConnection(), result.getColumnDisplayList(), result.getColumnWidthList(), reader, timer);
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
                result.closeStatement();
            } else if (result.isMultipleResultSetResult()) {
                List resultSets = result.getMultipleResultSets();
                try {
                    JDBCDisplayUtil.DisplayMultipleResults((PrintWriter)out, resultSets, this.connEnv[this.currCE].getConnection(), result.getColumnDisplayList(), result.getColumnWidthList(), reader, timer);
                }
                catch (SQLException se) {
                    result.closeStatement();
                    throw se;
                }
            } else if (result.isException()) {
                JDBCDisplayUtil.ShowException((PrintWriter)out, (Throwable)result.getException());
            }
        }
        if (timer != null) {
            timer.stop();
            return timer.getElapsedMillis();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCatch(String command) {
        RedirectedLocalizedOutput redirected = null;
        try {
            int repeatCommand = this.numTimesToRun;
            boolean reportRunNum = false;
            String c = command.trim().toLowerCase();
            if (c.startsWith("set") || c.startsWith("elapsed")) {
                repeatCommand = 1;
            } else if (repeatCommand > 1) {
                reportRunNum = true;
            }
            int runNumber = 0;
            do {
                boolean elapsedTimeOn = this.ijParser.getElapsedTimeState();
                long beginTime = 0L;
                if (elapsedTimeOn) {
                    beginTime = System.currentTimeMillis();
                }
                ijResult result = this.ijParser.executeImmediate(command);
                redirected = this.ijParser.getExplainMode() && command.startsWith("explain ") ? RedirectedLocalizedOutput.getNewInstance() : null;
                long endTime = this.displayResult((LocalizedOutput)(redirected == null ? this.out : redirected), result, this.connEnv[this.currCE].getConnection(), beginTime);
                if (elapsedTimeOn) {
                    if (reportRunNum) {
                        this.out.println("Run - " + runNumber + " " + this.langUtil.getTextMessage("IJ_ElapTime0Mil_4", (Object)this.langUtil.getNumberAsString(endTime)));
                        continue;
                    }
                    this.out.println(this.langUtil.getTextMessage("IJ_ElapTime0Mil_4", (Object)this.langUtil.getNumberAsString(endTime)));
                    continue;
                }
                if (!reportRunNum) continue;
                this.out.println("Run - " + runNumber + " completed ");
            } while (++runNumber < repeatCommand);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.handleSQLException(this.out, e);
        }
        catch (ijException i) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_5", (Object)this.getExceptionMessageForDisplay(i)));
            this.doTrace(i);
        }
        catch (ijTokenException ie) {
            this.out.println(this.langUtil.getTextMessage("IJ_IjErro0_6", (Object)this.getExceptionMessageForDisplay(ie)));
            this.doTrace(ie);
        }
        catch (Throwable t) {
            this.out.println(this.langUtil.getTextMessage("IJ_JavaErro0_7", (Object)this.getExceptionMessageForDisplay(t)));
            this.doTrace(t);
        }
        finally {
            if (redirected != null) {
                redirected.waitForCompletion();
            }
        }
        return false;
    }

    private void handleSQLException(LocalizedOutput out, SQLException e) throws ijFatalException {
        String sqlState = null;
        SQLException fatalException = null;
        String errorCode = this.showErrorCode ? this.langUtil.getTextMessage("IJ_Erro0", (Object)this.langUtil.getNumberAsString(e.getErrorCode())) : "";
        boolean syntaxErrorOccurred = false;
        while (e != null) {
            block9: {
                block8: {
                    sqlState = e.getSQLState();
                    if ("42X01".equals(sqlState)) {
                        syntaxErrorOccurred = true;
                    }
                    if (this.ignoreErrors == null) break block8;
                    if (sqlState != null && this.ignoreErrors.get(sqlState) != null) break block9;
                    fatalException = e;
                }
                String st1 = JDBCDisplayUtil.mapNull(e.getSQLState(), this.langUtil.getTextMessage("IJ_NoSqls"));
                String st2 = JDBCDisplayUtil.mapNull(e.getMessage(), this.langUtil.getTextMessage("IJ_NoMess"));
                StringBuilder sb = new StringBuilder(this.langUtil.getTextMessage("IJ_Erro012", (Object)st1, (Object)st2, (Object)errorCode));
                if (this.ijExceptionTrace == null) {
                    this.getExceptionCauseForDisplay(e, sb);
                }
                out.println(sb.toString());
                this.doTrace(e);
            }
            e = e.getNextException();
        }
        if (fatalException != null) {
            throw new ijFatalException(fatalException);
        }
        if (syntaxErrorOccurred) {
            out.println(utilMain.convertGfxdMessageToSnappy(this.langUtil.getTextMessage("IJ_SuggestHelp")));
        }
    }

    private void doTrace(Throwable t) {
        if (this.ijExceptionTrace != null) {
            t.printStackTrace((PrintWriter)this.out);
        }
        this.out.flush();
    }

    void newInput(String fileName) {
        FileInputStream newFile = null;
        try {
            newFile = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            if (this.basePath == null) {
                throw ijException.fileNotFound();
            }
            try {
                newFile = new FileInputStream(new File(this.basePath, fileName));
            }
            catch (FileNotFoundException e1) {
                throw ijException.fileNotFound();
            }
        }
        if (newFile == null) {
            return;
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewInput((InputStream)new BufferedInputStream(newFile, 2048)), null, this.basePath, this.params);
        this.fileInput = true;
    }

    void newResourceInput(String resourceName) {
        InputStream is = util.getResourceAsStream(resourceName);
        if (is == null) {
            throw ijException.resourceNotFound();
        }
        this.oldGrabbers.push(this.commandGrabber[this.currCE]);
        this.commandGrabber[this.currCE] = new StatementFinder(this.langUtil.getNewEncodedInput((InputStream)new BufferedInputStream(is, 2048), "UTF8"), null, this.basePath, this.params);
        this.fileInput = true;
    }

    static void doPrompt(boolean newStatement, LocalizedOutput out, String tag) {
        if (newStatement) {
            out.print(basePrompt + (tag == null ? "" : tag) + "> ");
        } else {
            out.print("> ");
        }
        out.flush();
    }

    static String getPrompt(boolean newStatement, String tag) {
        if (newStatement) {
            return basePrompt + tag + "> ";
        }
        return "> ";
    }

    String getExceptionMessageForDisplay(Throwable t) {
        if (this.ijExceptionTrace != null) {
            return t.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        if (!(t instanceof ijException)) {
            sb.append(t.getClass().getSimpleName()).append(": ");
        }
        sb.append(t.getMessage());
        return this.getExceptionCauseForDisplay(t, sb);
    }

    String getExceptionCauseForDisplay(Throwable t, StringBuilder sb) {
        String causeClass;
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause != t && !"SqlException".equals(causeClass = cause.getClass().getSimpleName())) {
            sb.append(SanityManager.lineSeparator);
            sb.append("Caused by: ").append(causeClass);
            sb.append(": ").append(cause.getMessage());
            sb.append(SanityManager.lineSeparator);
            sb.append("\tat ").append(cause.getStackTrace()[0]);
        }
        return sb.toString();
    }

    boolean printConnectUsage(String command, PrintWriter out) {
        String trimCommand;
        String connect = "connect";
        String clientConnect = "client";
        String peerConnect = "peer";
        String hostsConnect = "hosts";
        if (command != null && (trimCommand = command.trim()).length() >= "connect".length() && trimCommand.substring(0, "connect".length()).equalsIgnoreCase("connect")) {
            if (trimCommand.length() > "connect".length()) {
                String remaining = trimCommand.substring("connect".length()).trim();
                if (remaining.length() >= "client".length() && remaining.substring(0, "client".length()).equalsIgnoreCase("client")) {
                    out.println(LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Client", (Object)LocalizedResource.getMessage((String)"GFXD_Usage")));
                    return true;
                }
                if (remaining.length() >= "peer".length() && remaining.substring(0, "peer".length()).equalsIgnoreCase("peer")) {
                    out.println(utilMain.convertGfxdMessageToSnappy(LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Peer", (Object)LocalizedResource.getMessage((String)"GFXD_Usage"))));
                    return true;
                }
                if (remaining.length() >= "hosts".length() && remaining.substring(0, "hosts".length()).equalsIgnoreCase("hosts")) {
                    out.println(LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Hosts", (Object)LocalizedResource.getMessage((String)"GFXD_Usage")));
                    return true;
                }
            }
            out.println(LocalizedResource.getMessage((String)"GFXD_ConnectHelpText", (Object)LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Client", (Object)LocalizedResource.getMessage((String)"GFXD_Usage")), (Object)LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Peer", (Object)""), (Object)LocalizedResource.getMessage((String)"GFXD_ConnectHelpText_Hosts", (Object)"")));
            return true;
        }
        if (command != null) {
            String cmd;
            String string = cmd = command.trim().length() > 3 ? command.trim().substring(0, 4) : command;
            if (cmd.equalsIgnoreCase("run ")) {
                out.println(LocalizedResource.getMessage((String)"IJ_ExceRunnComm", (Object)(command + "\n" + LocalizedResource.getMessage((String)"IJ_RunUsage"))));
                return true;
            }
        }
        return false;
    }

    public static String convertGfxdMessageToSnappy(String message) {
        if (utilMain.getPrompt(true, "").contains("snappy")) {
            return pattern.matcher(message).replaceAll("SnappyData");
        }
        return message;
    }

    void setMtUse(boolean b) {
        this.mtUse = b;
    }

    private void checkScrollableCursor(ResultSet rs, String operation) throws ijException, SQLException {
        if (rs.getType() == 1003) {
            throw ijException.forwardOnlyCursor(operation);
        }
    }

    ijResult absolute(ResultSet rs, int row) throws SQLException {
        this.checkScrollableCursor(rs, "ABSOLUTE");
        return new ijRowResult(rs, rs.absolute(row));
    }

    ijResult relative(ResultSet rs, int row) throws SQLException {
        this.checkScrollableCursor(rs, "RELATIVE");
        return new ijRowResult(rs, rs.relative(row));
    }

    ijResult beforeFirst(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "BEFORE FIRST");
        rs.beforeFirst();
        return new ijRowResult(rs, false);
    }

    ijResult first(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "FIRST");
        return new ijRowResult(rs, rs.first());
    }

    ijResult afterLast(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "AFTER LAST");
        rs.afterLast();
        return new ijRowResult(rs, false);
    }

    ijResult last(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "LAST");
        return new ijRowResult(rs, rs.last());
    }

    ijResult previous(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "PREVIOUS");
        return new ijRowResult(rs, rs.previous());
    }

    int getCurrentRowNumber(ResultSet rs) throws SQLException {
        this.checkScrollableCursor(rs, "GETCURRENTROWNUMBER");
        return rs.getRow();
    }

    Properties getConnAttributeDefaults() {
        return this.connAttributeDefaults;
    }

    public final Object run() {
        return this.getClass().getResourceAsStream("/com/pivotal/gemfirexd/internal/info/tools.properties");
    }
}

