/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.ij;

import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedInput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.tools.ij.utilMain;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;

public class mtTestCase {
    public String name = null;
    public String file = null;
    public String propFile = null;
    public float weight = 0.5f;
    public Hashtable ignoreErrors = null;
    public String description = null;
    private int iterations;
    private int attempts;

    public void mtTestCase() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setFile(String name) {
        this.file = name;
    }

    public void setInputDir(String dir) {
        this.file = dir + "/" + this.file;
    }

    public String getFile() {
        return this.file;
    }

    public void setPropFile(String name) {
        this.propFile = name;
    }

    public String getPropFile() {
        return this.propFile;
    }

    public void setWeight(int weight) {
        this.weight = (float)((double)weight / 100.0);
    }

    public void setIgnoreErrors(Hashtable t) {
        this.ignoreErrors = t;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public synchronized BufferedInputStream initialize() throws FileNotFoundException, IOException {
        return this.initialize(null);
    }

    public synchronized BufferedInputStream initialize(String inputDir) throws FileNotFoundException, IOException {
        BufferedInputStream inStream = null;
        if (this.propFile != null) {
            BufferedInputStream propStream;
            String propPath = inputDir == null ? this.propFile : inputDir + "/" + this.propFile;
            try {
                propStream = new BufferedInputStream(new FileInputStream(propPath));
            }
            catch (FileNotFoundException e) {
                System.out.println(this.name + ": unable to find properties file " + propPath);
                throw e;
            }
            Properties p = System.getProperties();
            p.load(propStream);
            String framework = p.getProperty("framework");
            if (framework != null) {
                String newURLPrefix = null;
                if ((framework = framework.toUpperCase(Locale.ENGLISH)).equals("DB2JNET") || framework.equals("DERBYNET")) {
                    newURLPrefix = "jdbc:derby:net://localhost:1527/";
                } else if (framework.equals("DERBYNETCLIENT")) {
                    newURLPrefix = "jdbc:gemfirexd://localhost:1527/";
                }
                if (newURLPrefix != null) {
                    this.updateURLProperties(p, newURLPrefix);
                    p.setProperty("ij.user", "APP");
                    p.setProperty("ij.password", "PWD");
                }
            }
            if ("true".equalsIgnoreCase(p.getProperty("encryption"))) {
                String encryptUrl = "dataEncryption=true;bootPassword=Thursday";
                String dbUrl = p.getProperty("ij.database");
                String encryptionAlgorithm = p.getProperty("encryptionAlgorithm");
                if (encryptionAlgorithm != null) {
                    p.setProperty("ij.database", dbUrl + ";" + encryptUrl + ";" + encryptionAlgorithm);
                } else {
                    p.setProperty("ij.database", dbUrl + ";" + encryptUrl);
                }
            }
            if (System.getProperty("ij.dataSource") != null) {
                p.remove("ij.database");
                p.remove("ij.protocol");
            }
            System.setProperties(p);
        }
        String filePath = inputDir == null ? this.file : inputDir + "/" + this.file;
        try {
            inStream = new BufferedInputStream(new FileInputStream(filePath), 2048);
        }
        catch (FileNotFoundException e) {
            System.out.println("unable to find properties file " + filePath);
            throw e;
        }
        return inStream;
    }

    public synchronized boolean grab() {
        ++this.attempts;
        if (Math.random() < (double)this.weight) {
            ++this.iterations;
            return true;
        }
        return false;
    }

    public void runMe(LocalizedOutput log, LocalizedOutput out, BufferedInputStream infile) {
        LocalizedInput is = LocalizedResource.getInstance().getNewInput((InputStream)infile);
        LocalizedInput[] in = new LocalizedInput[]{is};
        out.println("--------------" + this.file + "-----------------");
        utilMain utilInstance = new utilMain(1, out, this.ignoreErrors, null, null, 1);
        utilInstance.initFromEnvironment();
        utilInstance.setMtUse(true);
        utilInstance.go(in, out, null);
        log.flush();
        out.flush();
    }

    public void updateURLProperties(Properties p, String newURLPrefix) {
        String[] propsToUpdate = new String[]{"ij.database", "ij.protocol", "database"};
        for (int i = 0; i < propsToUpdate.length; ++i) {
            String key = propsToUpdate[i];
            String val = p.getProperty(key);
            if (val == null) continue;
            p.setProperty(key, this.alterURL(val, newURLPrefix));
        }
    }

    public String alterURL(String url, String newURLPrefix) {
        String urlPrefix = "jdbc:derby:";
        if (url.startsWith(newURLPrefix)) {
            return url;
        }
        if (newURLPrefix == null) {
            return url;
        }
        if (url.equals(urlPrefix)) {
            return newURLPrefix;
        }
        if (url.startsWith(urlPrefix)) {
            url = newURLPrefix + url.substring(urlPrefix.length());
        } else if (!url.startsWith("jdbc:")) {
            url = newURLPrefix + url;
        }
        return url;
    }

    public String toString() {
        return "name: " + this.name + "\n\tfile: " + this.file + "\n\tproperties: " + this.propFile + "\n\tweight: " + this.weight + "\n\tignoreErrors: " + this.ignoreErrors + "\n\tdescription: " + this.description;
    }
}

