/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.ij;

import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.impl.tools.ij.AsyncStatement;
import com.pivotal.gemfirexd.internal.impl.tools.ij.utilMain;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

class Session {
    static final String DEFAULT_NAME = "CONNECTION";
    boolean singleSession = true;
    Connection conn = null;
    String tag;
    String name;
    Hashtable prepStmts = new Hashtable();
    Hashtable cursorStmts = new Hashtable();
    Hashtable cursors = new Hashtable();
    Hashtable asyncStmts = new Hashtable();
    boolean isJCC = false;
    boolean isDNC = false;

    Session(Connection newConn, String newTag, String newName) {
        this.conn = newConn;
        this.tag = newTag;
        this.name = newName;
        try {
            this.isJCC = this.conn.getMetaData().getDriverName().startsWith("IBM DB2 JDBC Universal Driver");
            this.isDNC = this.conn.getMetaData().getDriverName().startsWith("GemFireXD Network Client");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    Connection getConnection() {
        return this.conn;
    }

    boolean getIsJCC() {
        return this.isJCC;
    }

    boolean getIsDNC() {
        return this.isDNC;
    }

    String getName() {
        return this.name;
    }

    Object addPreparedStatement(String name, PreparedStatement ps) {
        return this.prepStmts.put(name, ps);
    }

    Object addCursorStatement(String name, Statement s) {
        return this.cursorStmts.put(name, s);
    }

    Object addCursor(String name, ResultSet rs) {
        return this.cursors.put(name, rs);
    }

    Object addAsyncStatement(String name, AsyncStatement s) {
        return this.asyncStmts.put(name, s);
    }

    PreparedStatement getPreparedStatement(String name) {
        return (PreparedStatement)this.prepStmts.get(name);
    }

    Statement getCursorStatement(String name) {
        return (Statement)this.cursorStmts.get(name);
    }

    ResultSet getCursor(String name) {
        return (ResultSet)this.cursors.get(name);
    }

    AsyncStatement getAsyncStatement(String name) {
        return (AsyncStatement)this.asyncStmts.get(name);
    }

    boolean removePreparedStatement(String name) {
        return this.prepStmts.remove(name) != null;
    }

    boolean removeCursorStatement(String name) {
        return this.cursorStmts.remove(name) != null;
    }

    boolean removeCursor(String name) {
        return this.cursors.remove(name) != null;
    }

    void doPrompt(boolean newStatement, LocalizedOutput out, boolean multiSessions) {
        utilMain.doPrompt(newStatement, out, this.getTag(multiSessions));
    }

    String getTag(boolean multiSessions) {
        if (multiSessions && this.singleSession) {
            this.singleSession = false;
            this.tag = this.tag == null ? "(" + this.name + ")" : this.tag.substring(0, this.tag.length() - 1) + ":" + this.name + ")";
        }
        if (!multiSessions && !this.singleSession) {
            this.singleSession = true;
            if (this.tag != null) {
                this.tag = this.tag.length() == this.name.length() + 2 ? null : this.tag.substring(0, this.tag.length() - 2 - this.name.length()) + ")";
            }
        }
        return this.tag != null ? this.tag : "";
    }

    void close() throws SQLException {
        if (!this.conn.isClosed()) {
            if (!this.conn.getAutoCommit() && this.name != null && !this.name.startsWith("XA")) {
                this.conn.rollback();
            }
            this.conn.close();
        }
        this.prepStmts.clear();
        this.cursorStmts.clear();
        this.cursors.clear();
        this.asyncStmts.clear();
        this.conn = null;
    }
}

