/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.ij;

import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedInput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedOutput;
import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.tools.ij.util;
import com.pivotal.gemfirexd.internal.impl.tools.ij.utilMain;
import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import jline.console.history.FileHistory;
import jline.console.history.History;

public class Main {
    private utilMain utilInstance;

    public static void main(String[] args) throws IOException {
        Main.mainCore(args, new Main(true));
    }

    public static void mainCore(String[] args, Main main) throws IOException {
        String maxDisplayWidth;
        String outFile;
        LocalizedOutput out;
        LocalizedResource langUtil;
        Properties connAttributeDefaults;
        LocalizedInput in;
        block20: {
            in = null;
            InputStream in1 = null;
            connAttributeDefaults = null;
            langUtil = LocalizedResource.getInstance();
            out = langUtil.getNewOutput((OutputStream)System.out);
            if (util.invalidArgs(args)) {
                util.Usage(out);
                return;
            }
            boolean gotProp = util.getPropertyArg(args);
            connAttributeDefaults = util.getConnAttributeArg(args);
            langUtil.init();
            out = langUtil.getNewOutput((OutputStream)System.out);
            main.initAppUI();
            String file = util.getFileArg(args);
            String inputResourceName = util.getInputResourceNameArg(args);
            if (inputResourceName != null) {
                in = langUtil.getNewInput(util.getResourceAsStream(inputResourceName));
                if (in == null) {
                    out.println(utilMain.convertGfxdMessageToSnappy(langUtil.getTextMessage("IJ_IjErroResoNo", (Object)inputResourceName)));
                    return;
                }
            } else if (file == null) {
                in = langUtil.getNewInput(System.in);
                out.flush();
            } else {
                try {
                    in1 = new FileInputStream(file);
                    if (in1 != null) {
                        in1 = new BufferedInputStream(in1, 2048);
                        in = langUtil.getNewInput(in1);
                    }
                }
                catch (FileNotFoundException e) {
                    if (Boolean.getBoolean("ij.searchClassPath")) {
                        in = langUtil.getNewInput(util.getResourceAsStream(file));
                    }
                    if (in != null) break block20;
                    out.println(utilMain.convertGfxdMessageToSnappy(langUtil.getTextMessage("IJ_IjErroFileNo", (Object)file)));
                    return;
                }
            }
        }
        if ((outFile = util.getSystemProperty("ij.outfile")) != null && outFile.length() > 0) {
            LocalizedOutput oldOut = out;
            FileOutputStream fos = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(outFile);
                    }
                    catch (FileNotFoundException e) {
                        out = null;
                    }
                    return out;
                }
            });
            out = langUtil.getNewOutput((OutputStream)fos);
            if (out == null) {
                oldOut.println(utilMain.convertGfxdMessageToSnappy(langUtil.getTextMessage("IJ_IjErroUnabTo", (Object)outFile)));
            }
        }
        if ((maxDisplayWidth = util.getSystemProperty("maximumDisplayWidth")) == null) {
            maxDisplayWidth = util.getSystemProperty("ij.maximumDisplayWidth");
        }
        if (maxDisplayWidth != null && maxDisplayWidth.length() > 0) {
            try {
                int maxWidth = Integer.parseInt(maxDisplayWidth);
                JDBCDisplayUtil.setMaxDisplayWidth(maxWidth);
            }
            catch (NumberFormatException nfe) {
                out.println(utilMain.convertGfxdMessageToSnappy(langUtil.getTextMessage("IJ_IjErroMaxiVa", (Object)maxDisplayWidth)));
            }
        }
        Main me = main.getMain(out);
        if (in != null && in.isStandardInput() && System.console() != null && !"jline.UnsupportedTerminal".equals(System.getProperty("jline.terminal"))) {
            int termWidth;
            String encode = in.getEncoding();
            if (encode != null) {
                System.setProperty("input.encoding", encode);
                System.setProperty("jline.WindowsTerminal.input.encoding", encode);
            }
            String historyFileName = System.getProperty("gfxd.history", ".gfxd.history");
            final ConsoleReader reader = new ConsoleReader();
            reader.setBellEnabled(false);
            File histFile = new File(historyFileName);
            if (historyFileName.length() > 0) {
                FileHistory hist = histFile.isAbsolute() ? new FileHistory(new File(historyFileName)) : new FileHistory(new File(System.getProperty("user.home"), historyFileName));
                reader.setHistory((History)hist);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        reader.getTerminal().restore();
                        ((FileHistory)reader.getHistory()).flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            reader.addCompleter((Completer)new StringsCompleter(new String[]{"PROTOCOL", "protocol", "DRIVER", "driver", "CONNECT CLIENT", "connect client", "CONNECT PEER", "connect peer", "SET CONNECTION", "set connection", "SHOW CONNECTIONS", "show connections", "AUTOCOMMIT ON;", "AUTOCOMMIT OFF;", "autocommit on;", "autocommit off;", "DISCONNECT", "DISCONNECT CURRENT;", "DISCONNECT ALL;", "disconnect", "disconnect current;", "disconnect all;", "SHOW SCHEMAS;", "show schemas;", "SHOW TABLES IN", "show tables in", "SHOW VIEWS IN", "show views in", "SHOW PROCEDURES IN", "show procedures in", "SHOW SYNONYMS IN", "show synonyms in", "SHOW INDEXES IN", "SHOW INDEXES FROM", "show indexes in", "show indexes from", "SHOW IMPORTEDKEYS IN", "SHOW IMPORTEDKEYS FROM", "show importedkeys in", "show importedkeys from", "SHOW MEMBERS", "show members", "DESCRIBE", "describe", "COMMIT;", "commit;", "ROLLBACK;", "rollback;", "PREPARE", "prepare", "EXECUTE", "execute", "REMOVE", "remove", "RUN", "run", "ELAPSEDTIME ON;", "ELAPSEDTIME OFF;", "elapsedtime on;", "elapsedtime off;", "MAXIMUMDISPLAYWIDTH", "maximumdisplaywidth", "MAXIMUMLINEWIDTH", "maximumlinewidth", "PAGING ON;", "paging on;", "PAGING OFF;", "paging off;", "ASYNC", "async", "WAIT FOR", "wait for", "GET", "GET CURSOR", "GET SCROLL INSENSITIVE CURSOR", "get", "get cursor", "get scroll insensitive cursor", "NEXT", "next", "FIRST", "first", "LAST", "last", "PREVIOUS", "previous", "ABSOLUTE", "absolute", "RELATIVE", "relative", "AFTER LAST", "after last", "BEFORE FIRST", "before first", "CLOSE", "close", "GETCURRENTROWNUMBER", "getcurrentrownumber", "LOCALIZEDDISPLAY ON;", "LOCALIZEDDISPLAY OFF;", "localizeddisplay on;", "localizeddisplay off;", "EXIT;", "exit;", "QUIT;", "quit;", "HELP;", "help;", "EXPLAIN ", "explain ", "EXPLAINMODE ON;", "explainmode on;", "EXPLAINMODE OFF;", "explainmode off;"}));
            if ((maxDisplayWidth == null || maxDisplayWidth.length() == 0) && (termWidth = reader.getTerminal().getWidth()) > 4) {
                JDBCDisplayUtil.setMaxLineWidth(termWidth, false);
            }
            in.setConsoleReader((Object)reader);
        }
        me.go(in, out, connAttributeDefaults);
        in.close();
        out.close();
    }

    public Main getMain(LocalizedOutput out) {
        return new Main(out);
    }

    public utilMain getutilMain(int numConnections, LocalizedOutput out) {
        return new utilMain(numConnections, out);
    }

    private void go(LocalizedInput in, LocalizedOutput out, Properties connAttributeDefaults) {
        LocalizedInput[] inA = new LocalizedInput[]{in};
        this.utilInstance.go(inA, out, connAttributeDefaults);
    }

    public Main() {
        this(null);
    }

    public Main(LocalizedOutput out) {
        if (out == null) {
            out = LocalizedResource.getInstance().getNewOutput((OutputStream)System.out);
        }
        this.utilInstance = this.getutilMain(1, out);
        this.utilInstance.initFromEnvironment();
    }

    public Main(boolean trash) {
    }

    private void initAppUI() {
        LocalizedResource.getInstance();
    }
}

