/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.ij;

import com.pivotal.gemfirexd.internal.iapi.tools.i18n.LocalizedResource;
import com.pivotal.gemfirexd.internal.impl.tools.ij.URLCheck;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class AttributeHolder {
    String name;
    String value;
    String token;
    Vector errors = new Vector();

    public String getName() {
        return this.name;
    }

    public void setName(String aString) {
        this.name = aString;
    }

    String getValue() {
        return this.value;
    }

    public void setValue(String aString) {
        this.value = aString;
    }

    String getToken() {
        return this.token;
    }

    public void setToken(String aString) {
        this.token = aString;
    }

    public void addError(String aString) {
        if (!this.errors.contains(aString)) {
            this.errors.addElement(aString);
        }
    }

    public void check(Vector validProps) {
        this.checkName(validProps);
        this.displayErrors();
    }

    void displayErrors() {
        Enumeration e = this.errors.elements();
        if (e.hasMoreElements()) {
            this.display(LocalizedResource.getMessage((String)"TL_urlLabel1", (Object)"[", (Object)this.getToken(), (Object)"]"));
        }
        while (e.hasMoreElements()) {
            String aString = (String)e.nextElement();
            this.displayIndented(aString);
        }
    }

    void checkName(Vector validProps) {
        if (validProps == null) {
            return;
        }
        String anAtt = this.getName();
        try {
            if (!validProps.contains(anAtt)) {
                if (validProps.contains(anAtt.toLowerCase(Locale.ENGLISH))) {
                    this.errors.addElement(LocalizedResource.getMessage((String)"TL_incorCase"));
                } else {
                    this.errors.addElement(LocalizedResource.getMessage((String)"TL_unknownAtt"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void checkValue() {
        String anAtt = this.getName();
        String aValue = this.getValue();
        try {
            if (URLCheck.getBooleanAttributes().contains(anAtt) && !this.checkBoolean(aValue)) {
                this.errors.addElement(LocalizedResource.getMessage((String)"TL_trueFalse"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    boolean checkBoolean(String aValue) {
        if (aValue == null) {
            return false;
        }
        return aValue.toLowerCase(Locale.ENGLISH).equals("true") || aValue.toLowerCase(Locale.ENGLISH).equals("false");
    }

    void display(String aString) {
        LocalizedResource.OutputWriter().println(aString);
    }

    void displayIndented(String aString) {
        LocalizedResource.OutputWriter().println("   " + aString);
    }
}

