/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_View {
    public static void doViews(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT V.VIEWDEFINITION, T.TABLENAME, T.SCHEMAID, V.COMPILATIONSCHEMAID FROM SYS.SYSVIEWS V, SYS.SYSTABLES T WHERE T.TABLEID = V.TABLEID");
        boolean firstTime = true;
        while (rs.next()) {
            String viewSchema = dblook.lookupSchemaId(rs.getString(3));
            if (dblook.isIgnorableSchema(viewSchema) || !dblook.stringContainsTargetTable(rs.getString(1))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_ViewsHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL("SET SCHEMA ");
            Logs.writeToNewDDL(dblook.lookupSchemaId(rs.getString(4)));
            Logs.writeStmtEndToNewDDL();
            Logs.writeToNewDDL(dblook.removeNewlines(rs.getString(1)));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        if (!firstTime) {
            Logs.reportMessage("DBLOOK_DefaultSchema");
            Logs.writeToNewDDL("SET SCHEMA \"APP\"");
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
        }
        rs.close();
        stmt.close();
    }
}

