/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_Trigger {
    public static void doTriggers(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT TRIGGERNAME, SCHEMAID, EVENT, FIRINGTIME, TYPE, TABLEID, REFERENCEDCOLUMNS, TRIGGERDEFINITION, REFERENCINGOLD, REFERENCINGNEW, OLDREFERENCINGNAME, NEWREFERENCINGNAME FROM SYS.SYSTRIGGERS WHERE STATE != 'D'");
        boolean firstTime = true;
        while (rs.next()) {
            String trigName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String trigSchema = dblook.lookupSchemaId(rs.getString(2));
            if (dblook.isIgnorableSchema(trigSchema)) continue;
            trigName = trigSchema + "." + trigName;
            String tableName = dblook.lookupTableId(rs.getString(6));
            if (!dblook.stringContainsTargetTable(rs.getString(8)) && dblook.isExcludedTable(tableName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TriggersHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String createTrigString = DB_Trigger.createTrigger(trigName, tableName, rs);
            Logs.writeToNewDDL(createTrigString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }

    private static String createTrigger(String trigName, String tableName, ResultSet aTrig) throws SQLException {
        StringBuilder sb = new StringBuilder("CREATE TRIGGER ");
        sb.append(trigName);
        if (aTrig.getString(4).charAt(0) == 'A') {
            sb.append(" AFTER ");
        } else {
            sb.append(" NO CASCADE BEFORE ");
        }
        switch (aTrig.getString(3).charAt(0)) {
            case 'I': {
                sb.append("INSERT");
                break;
            }
            case 'D': {
                sb.append("DELETE");
                break;
            }
            case 'U': {
                sb.append("UPDATE");
                String updateCols = aTrig.getString(7);
                if (aTrig.wasNull()) break;
                sb.append(" OF ");
                sb.append(dblook.getColumnListFromDescription(aTrig.getString(6), updateCols));
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected trigger event: " + aTrig.getString(3), (String)null);
            }
        }
        sb.append(" ON ");
        sb.append(tableName);
        char trigType = aTrig.getString(5).charAt(0);
        String oldReferencing = aTrig.getString(11);
        String newReferencing = aTrig.getString(12);
        if (oldReferencing != null || newReferencing != null) {
            sb.append(" REFERENCING");
            if (aTrig.getBoolean(9)) {
                sb.append(" OLD");
                if (trigType == 'S') {
                    sb.append("_TABLE AS ");
                } else {
                    sb.append(" AS ");
                }
                sb.append(oldReferencing);
            }
            if (aTrig.getBoolean(10)) {
                sb.append(" NEW");
                if (trigType == 'S') {
                    sb.append("_TABLE AS ");
                } else {
                    sb.append(" AS ");
                }
                sb.append(newReferencing);
            }
        }
        sb.append(" FOR EACH ");
        if (trigType == 'S') {
            sb.append("STATEMENT ");
        } else {
            sb.append("ROW ");
        }
        sb.append(dblook.removeNewlines(aTrig.getString(8)));
        return sb.toString();
    }
}

