/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;

public class DB_Table {
    private static PreparedStatement getColumnInfoStmt;
    private static PreparedStatement getColumnTypeStmt;
    private static PreparedStatement getAutoIncStmt;

    public static void doTables(Connection conn, HashMap tableIdToNameMap) throws SQLException {
        getColumnInfoStmt = conn.prepareStatement("SELECT C.COLUMNNAME, C.REFERENCEID, C.COLUMNNUMBER FROM SYS.SYSCOLUMNS C, SYS.SYSTABLES T WHERE T.TABLEID = ? AND T.TABLEID = C.REFERENCEID ORDER BY C.COLUMNNUMBER");
        getColumnTypeStmt = conn.prepareStatement("SELECT COLUMNDATATYPE, COLUMNDEFAULT FROM SYS.SYSCOLUMNS WHERE REFERENCEID = ? AND COLUMNNAME = ?");
        getAutoIncStmt = conn.prepareStatement("SELECT AUTOINCREMENTSTART, AUTOINCREMENTINC, COLUMNNAME, REFERENCEID, COLUMNDEFAULT FROM SYS.SYSCOLUMNS WHERE COLUMNNAME = ? AND REFERENCEID = ?");
        boolean firstTime = true;
        Set tableIds = tableIdToNameMap.keySet();
        for (String tableId : tableIds) {
            String tableName = (String)tableIdToNameMap.get(tableId);
            if (dblook.isExcludedTable(tableName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TablesHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            Logs.writeToNewDDL("CREATE TABLE " + tableName + " (");
            boolean firstCol = true;
            getColumnInfoStmt.setString(1, tableId);
            ResultSet columnRS = getColumnInfoStmt.executeQuery();
            while (columnRS.next()) {
                String colName = dblook.addQuotes(columnRS.getString(1));
                String createColString = DB_Table.createColumn(colName, columnRS.getString(2), columnRS.getInt(3));
                if (!firstCol) {
                    createColString = ", " + createColString;
                }
                Logs.writeToNewDDL(createColString);
                firstCol = false;
            }
            columnRS.close();
            Logs.writeToNewDDL(")");
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        getColumnInfoStmt.close();
        getColumnTypeStmt.close();
        getAutoIncStmt.close();
    }

    private static String createColumn(String colName, String tableId, int colNum) throws SQLException {
        getColumnTypeStmt.setString(1, tableId);
        getColumnTypeStmt.setString(2, dblook.stripQuotes(colName));
        ResultSet rs = getColumnTypeStmt.executeQuery();
        StringBuilder colDef = new StringBuilder();
        if (rs.next()) {
            colDef.append(dblook.addQuotes(dblook.expandDoubleQuotes(dblook.stripQuotes(colName))));
            colDef.append(" ");
            colDef.append(rs.getString(1));
            if (!DB_Table.reinstateAutoIncrement(colName, tableId, colDef) && rs.getString(2) != null) {
                colDef.append(" DEFAULT ");
                colDef.append(rs.getString(2));
            }
        }
        rs.close();
        return colDef.toString();
    }

    public static boolean reinstateAutoIncrement(String colName, String tableId, StringBuilder colDef) throws SQLException {
        getAutoIncStmt.setString(1, dblook.stripQuotes(colName));
        getAutoIncStmt.setString(2, tableId);
        ResultSet autoIncCols = getAutoIncStmt.executeQuery();
        if (autoIncCols.next()) {
            long start = autoIncCols.getLong(1);
            if (!autoIncCols.wasNull()) {
                colDef.append(" GENERATED ");
                colDef.append(autoIncCols.getObject(5) == null ? "ALWAYS " : "BY DEFAULT ");
                colDef.append("AS IDENTITY (START WITH ");
                colDef.append(autoIncCols.getLong(1));
                colDef.append(", INCREMENT BY ");
                colDef.append(autoIncCols.getLong(2));
                colDef.append(")");
                return true;
            }
        }
        return false;
    }
}

