/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_Key {
    private static PreparedStatement getReferenceCols;
    private static boolean printedHeader;

    public static void doKeys(Connection conn) throws SQLException {
        printedHeader = false;
        getReferenceCols = conn.prepareStatement("SELECT CG.TABLEID, CG.DESCRIPTOR FROM SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE K.CONSTRAINTID = ? AND K.CONGLOMERATEID = CG.CONGLOMERATEID");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CG.DESCRIPTOR, CG.ISCONSTRAINT FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(rs);
        rs = stmt.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TYPE, CS.TABLEID, CS.CONSTRAINTID, CS.SCHEMAID, CG.DESCRIPTOR, CG.ISCONSTRAINT, K.DELETERULE, K.UPDATERULE, K.KEYCONSTRAINTID FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCONGLOMERATES CG, SYS.SYSFOREIGNKEYS K WHERE CS.STATE != 'D' AND CS.CONSTRAINTID = K.CONSTRAINTID AND CG.CONGLOMERATEID = K.CONGLOMERATEID ORDER BY CS.TABLEID");
        DB_Key.createKeysFrom(rs);
        getReferenceCols.close();
        stmt.close();
        rs.close();
    }

    private static void createKeysFrom(ResultSet rs) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String tableId;
            String tableName;
            if (!rs.getBoolean(7) || dblook.isExcludedTable(tableName = dblook.lookupTableId(tableId = rs.getString(3)))) continue;
            if (firstTime) {
                DB_Key.printHeader();
                if (rs.getString(2).equals("F")) {
                    Logs.reportMessage("DBLOOK_ForeignHeader");
                } else {
                    Logs.reportMessage("DBLOOK_PrimUniqueHeader");
                }
            }
            StringBuilder kString = DB_Key.createKeyString(tableId, tableName, rs);
            if (rs.getString(2).equals("F")) {
                kString.append(DB_Key.makeFKReferenceClause(rs.getString(10), rs.getString(8).charAt(0), rs.getString(9).charAt(0)));
            }
            Logs.writeToNewDDL(kString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static StringBuilder createKeyString(String tableId, String tableName, ResultSet aKey) throws SQLException {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        sb.append(tableName);
        sb.append(" ADD");
        String constraintName = dblook.addQuotes(dblook.expandDoubleQuotes(aKey.getString(1)));
        sb.append(" CONSTRAINT ");
        sb.append(constraintName);
        sb.append(DB_Key.expandKeyType(aKey.getString(2).charAt(0)));
        sb.append("(");
        sb.append(dblook.getColumnListFromDescription(tableId, aKey.getString(6)));
        sb.append(")");
        return sb;
    }

    private static String expandKeyType(char keyType) {
        switch (keyType) {
            case 'P': {
                return " PRIMARY KEY ";
            }
            case 'U': {
                return " UNIQUE ";
            }
            case 'F': {
                return " FOREIGN KEY ";
            }
        }
        Logs.debug("INTERNAL ERROR: unexpected key type" + keyType, (String)null);
        return "";
    }

    private static String makeFKReferenceClause(String constraintId, char deleteChar, char updateChar) throws SQLException {
        StringBuilder refClause = new StringBuilder();
        getReferenceCols.setString(1, constraintId);
        ResultSet colsRS = getReferenceCols.executeQuery();
        colsRS.next();
        refClause.append(" REFERENCES ");
        refClause.append(dblook.lookupTableId(colsRS.getString(1)));
        refClause.append(" (");
        refClause.append(dblook.getColumnListFromDescription(colsRS.getString(1), colsRS.getString(2)));
        refClause.append(")");
        refClause.append(" ON DELETE ");
        switch (deleteChar) {
            case 'R': {
                refClause.append("NO ACTION");
                break;
            }
            case 'S': {
                refClause.append("RESTRICT");
                break;
            }
            case 'C': {
                refClause.append("CASCADE");
                break;
            }
            case 'U': {
                refClause.append("SET NULL");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-delete' action: " + deleteChar, (String)null);
            }
        }
        refClause.append(" ON UPDATE ");
        switch (updateChar) {
            case 'R': {
                refClause.append("NO ACTION");
                break;
            }
            case 'S': {
                refClause.append("RESTRICT");
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected 'on-update' action: " + updateChar, (String)null);
            }
        }
        colsRS.close();
        return refClause.toString();
    }

    private static void printHeader() {
        if (printedHeader) {
            return;
        }
        Logs.reportString("----------------------------------------------");
        Logs.reportMessage("DBLOOK_KeysHeader");
        Logs.reportString("----------------------------------------------\n");
        printedHeader = true;
    }
}

