/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_Index {
    public static void doIndexes(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT TABLEID, CONGLOMERATENAME, DESCRIPTOR, SCHEMAID, ISINDEX, ISCONSTRAINT FROM SYS.SYSCONGLOMERATES ORDER BY TABLEID");
        boolean firstTime = true;
        while (rs.next()) {
            String iSchema;
            String tableId;
            String tableName;
            if (!rs.getBoolean(5) || rs.getBoolean(6) || (tableName = dblook.lookupTableId(tableId = rs.getString(1))) == null || dblook.isExcludedTable(tableName) || dblook.isIgnorableSchema(iSchema = dblook.lookupSchemaId(rs.getString(4)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_IndexesHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String iName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(2)));
            iName = iSchema + "." + iName;
            StringBuilder createIndexString = DB_Index.createIndex(iName, tableName, tableId, rs.getString(3));
            Logs.writeToNewDDL(createIndexString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }

    private static StringBuilder createIndex(String ixName, String tableName, String tableId, String ixDescribe) throws SQLException {
        StringBuilder sb = new StringBuilder("CREATE ");
        if (ixDescribe.indexOf("UNIQUE") != -1) {
            sb.append("UNIQUE ");
        }
        sb.append("INDEX ");
        sb.append(ixName);
        sb.append(" ON ");
        sb.append(tableName);
        sb.append(" (");
        sb.append(dblook.getColumnListFromDescription(tableId, ixDescribe));
        sb.append(")");
        return sb;
    }
}

