/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_Check {
    public static void doChecks(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CS.CONSTRAINTNAME, CS.TABLEID, CS.SCHEMAID, CK.CHECKDEFINITION FROM SYS.SYSCONSTRAINTS CS, SYS.SYSCHECKS CK WHERE CS.CONSTRAINTID = CK.CONSTRAINTID AND CS.STATE != 'D' ORDER BY CS.TABLEID");
        boolean firstTime = true;
        while (rs.next()) {
            String tableId = rs.getString(2);
            String tableName = dblook.lookupTableId(tableId);
            if (dblook.isExcludedTable(tableName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_ChecksHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            StringBuilder chkString = DB_Check.createCheckString(tableName, rs);
            Logs.writeToNewDDL(chkString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        stmt.close();
        rs.close();
    }

    private static StringBuilder createCheckString(String tableName, ResultSet aCheck) throws SQLException {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        sb.append(tableName);
        sb.append(" ADD");
        String constraintName = dblook.addQuotes(dblook.expandDoubleQuotes(aCheck.getString(1)));
        sb.append(" CONSTRAINT ");
        sb.append(constraintName);
        sb.append(" CHECK ");
        sb.append(dblook.removeNewlines(aCheck.getString(4)));
        return sb;
    }
}

