/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.tools.dblook;

import com.pivotal.gemfirexd.internal.impl.tools.dblook.Logs;
import com.pivotal.gemfirexd.internal.tools.dblook;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DB_Alias {
    private static final char UDT_TYPE = 'A';
    private static final char PROCEDURE_TYPE = 'P';
    private static final char FUNCTION_TYPE = 'F';

    public static void doProceduresFunctionsAndUDTs(Connection conn) throws SQLException {
        PreparedStatement ps = conn.prepareStatement("SELECT ALIAS, ALIASINFO, ALIASID, SCHEMAID, JAVACLASSNAME, SYSTEMALIAS FROM SYS.SYSALIASES WHERE ALIASTYPE=?");
        DB_Alias.generateDDL(ps, 'A');
        DB_Alias.generateDDL(ps, 'P');
        DB_Alias.generateDDL(ps, 'F');
        ps.close();
    }

    private static void generateDDL(PreparedStatement ps, char aliasType) throws SQLException {
        ps.setString(1, new String(new char[]{aliasType}));
        ResultSet rs = ps.executeQuery();
        DB_Alias.generateDDL(rs, aliasType);
        rs.close();
    }

    private static void generateDDL(ResultSet rs, char aliasType) throws SQLException {
        boolean firstTime = true;
        while (rs.next()) {
            String procSchema;
            if (rs.getBoolean(6) || dblook.isIgnorableSchema(procSchema = dblook.lookupSchemaId(rs.getString(4)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                switch (aliasType) {
                    case 'A': {
                        Logs.reportMessage("DBLOOK_UDTHeader");
                        break;
                    }
                    case 'P': {
                        Logs.reportMessage("DBLOOK_StoredProcHeader");
                        break;
                    }
                    case 'F': {
                        Logs.reportMessage("DBLOOK_FunctionHeader");
                    }
                }
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String fullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            fullName = procSchema + "." + fullName;
            String creationString = DB_Alias.createProcFuncOrUDTString(fullName, rs, aliasType);
            Logs.writeToNewDDL(creationString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
    }

    private static String createProcFuncOrUDTString(String aliasName, ResultSet aliasInfo, char aliasType) throws SQLException {
        StringBuilder alias = new StringBuilder("CREATE ");
        switch (aliasType) {
            case 'A': {
                alias.append("TYPE ");
                break;
            }
            case 'P': {
                alias.append("PROCEDURE ");
                break;
            }
            case 'F': {
                alias.append("FUNCTION ");
            }
        }
        alias.append(aliasName);
        alias.append(" ");
        String params = aliasInfo.getString(2);
        if (aliasType != 'A') {
            alias.append(params.substring(params.indexOf("("), params.length()));
            alias.append(" ");
        }
        alias.append("EXTERNAL NAME '");
        alias.append(aliasInfo.getString(5));
        if (aliasType == 'A') {
            alias.append("' ");
            alias.append(params);
        } else {
            alias.append(".");
            alias.append(params.substring(0, params.indexOf("(")));
            alias.append("' ");
        }
        return alias.toString();
    }

    public static void doSynonyms(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ALIAS, SCHEMAID, ALIASINFO, SYSTEMALIAS FROM SYS.SYSALIASES A WHERE ALIASTYPE='S'");
        boolean firstTime = true;
        while (rs.next()) {
            String aliasSchema;
            if (rs.getBoolean(4) || dblook.isIgnorableSchema(aliasSchema = dblook.lookupSchemaId(rs.getString(2)))) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_SynonymHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String aliasName = rs.getString(1);
            String aliasFullName = dblook.addQuotes(dblook.expandDoubleQuotes(aliasName));
            aliasFullName = aliasSchema + "." + aliasFullName;
            Logs.writeToNewDDL("CREATE SYNONYM " + aliasFullName + " FOR " + rs.getString(3));
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }
}

