/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TransactionXid
implements TBase<TransactionXid, _Fields>,
Serializable,
Cloneable,
Comparable<TransactionXid> {
    private static final TStruct STRUCT_DESC = new TStruct("TransactionXid");
    private static final TField FORMAT_ID_FIELD_DESC = new TField("formatId", 8, 1);
    private static final TField GLOBAL_ID_FIELD_DESC = new TField("globalId", 11, 2);
    private static final TField BRANCH_QUALIFIER_FIELD_DESC = new TField("branchQualifier", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public int formatId;
    public ByteBuffer globalId;
    public ByteBuffer branchQualifier;
    private static final int __FORMATID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TransactionXid() {
    }

    public TransactionXid(int formatId, ByteBuffer globalId, ByteBuffer branchQualifier) {
        this();
        this.formatId = formatId;
        this.setFormatIdIsSet(true);
        this.globalId = TBaseHelper.copyBinary((ByteBuffer)globalId);
        this.branchQualifier = TBaseHelper.copyBinary((ByteBuffer)branchQualifier);
    }

    public TransactionXid(TransactionXid other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.formatId = other.formatId;
        if (other.isSetGlobalId()) {
            this.globalId = TBaseHelper.copyBinary((ByteBuffer)other.globalId);
        }
        if (other.isSetBranchQualifier()) {
            this.branchQualifier = TBaseHelper.copyBinary((ByteBuffer)other.branchQualifier);
        }
    }

    public TransactionXid deepCopy() {
        return new TransactionXid(this);
    }

    public void clear() {
        this.setFormatIdIsSet(false);
        this.formatId = 0;
        this.globalId = null;
        this.branchQualifier = null;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public TransactionXid setFormatId(int formatId) {
        this.formatId = formatId;
        this.setFormatIdIsSet(true);
        return this;
    }

    public void unsetFormatId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetFormatId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setFormatIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte[] getGlobalId() {
        this.setGlobalId(TBaseHelper.rightSize((ByteBuffer)this.globalId));
        return this.globalId == null ? null : this.globalId.array();
    }

    public ByteBuffer bufferForGlobalId() {
        return TBaseHelper.copyBinary((ByteBuffer)this.globalId);
    }

    public TransactionXid setGlobalId(byte[] globalId) {
        this.globalId = globalId == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(globalId, globalId.length));
        return this;
    }

    public TransactionXid setGlobalId(ByteBuffer globalId) {
        this.globalId = TBaseHelper.copyBinary((ByteBuffer)globalId);
        return this;
    }

    public void unsetGlobalId() {
        this.globalId = null;
    }

    public boolean isSetGlobalId() {
        return this.globalId != null;
    }

    public void setGlobalIdIsSet(boolean value) {
        if (!value) {
            this.globalId = null;
        }
    }

    public byte[] getBranchQualifier() {
        this.setBranchQualifier(TBaseHelper.rightSize((ByteBuffer)this.branchQualifier));
        return this.branchQualifier == null ? null : this.branchQualifier.array();
    }

    public ByteBuffer bufferForBranchQualifier() {
        return TBaseHelper.copyBinary((ByteBuffer)this.branchQualifier);
    }

    public TransactionXid setBranchQualifier(byte[] branchQualifier) {
        this.branchQualifier = branchQualifier == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(branchQualifier, branchQualifier.length));
        return this;
    }

    public TransactionXid setBranchQualifier(ByteBuffer branchQualifier) {
        this.branchQualifier = TBaseHelper.copyBinary((ByteBuffer)branchQualifier);
        return this;
    }

    public void unsetBranchQualifier() {
        this.branchQualifier = null;
    }

    public boolean isSetBranchQualifier() {
        return this.branchQualifier != null;
    }

    public void setBranchQualifierIsSet(boolean value) {
        if (!value) {
            this.branchQualifier = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case FORMAT_ID: {
                if (value == null) {
                    this.unsetFormatId();
                    break;
                }
                this.setFormatId((Integer)value);
                break;
            }
            case GLOBAL_ID: {
                if (value == null) {
                    this.unsetGlobalId();
                    break;
                }
                this.setGlobalId((ByteBuffer)value);
                break;
            }
            case BRANCH_QUALIFIER: {
                if (value == null) {
                    this.unsetBranchQualifier();
                    break;
                }
                this.setBranchQualifier((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FORMAT_ID: {
                return this.getFormatId();
            }
            case GLOBAL_ID: {
                return this.getGlobalId();
            }
            case BRANCH_QUALIFIER: {
                return this.getBranchQualifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FORMAT_ID: {
                return this.isSetFormatId();
            }
            case GLOBAL_ID: {
                return this.isSetGlobalId();
            }
            case BRANCH_QUALIFIER: {
                return this.isSetBranchQualifier();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TransactionXid) {
            return this.equals((TransactionXid)that);
        }
        return false;
    }

    public boolean equals(TransactionXid that) {
        if (that == null) {
            return false;
        }
        boolean this_present_formatId = true;
        boolean that_present_formatId = true;
        if (this_present_formatId || that_present_formatId) {
            if (!this_present_formatId || !that_present_formatId) {
                return false;
            }
            if (this.formatId != that.formatId) {
                return false;
            }
        }
        boolean this_present_globalId = this.isSetGlobalId();
        boolean that_present_globalId = that.isSetGlobalId();
        if (this_present_globalId || that_present_globalId) {
            if (!this_present_globalId || !that_present_globalId) {
                return false;
            }
            if (!this.globalId.equals(that.globalId)) {
                return false;
            }
        }
        boolean this_present_branchQualifier = this.isSetBranchQualifier();
        boolean that_present_branchQualifier = that.isSetBranchQualifier();
        if (this_present_branchQualifier || that_present_branchQualifier) {
            if (!this_present_branchQualifier || !that_present_branchQualifier) {
                return false;
            }
            if (!this.branchQualifier.equals(that.branchQualifier)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_formatId = true;
        list.add(Boolean.valueOf(present_formatId));
        if (present_formatId) {
            list.add(Integer.valueOf(this.formatId));
        }
        boolean present_globalId = this.isSetGlobalId();
        list.add(Boolean.valueOf(present_globalId));
        if (present_globalId) {
            list.add(this.globalId);
        }
        boolean present_branchQualifier = this.isSetBranchQualifier();
        list.add(Boolean.valueOf(present_branchQualifier));
        if (present_branchQualifier) {
            list.add(this.branchQualifier);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TransactionXid other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetFormatId()).compareTo(other.isSetFormatId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFormatId() && (lastComparison = TBaseHelper.compareTo((int)this.formatId, (int)other.formatId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGlobalId()).compareTo(other.isSetGlobalId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGlobalId() && (lastComparison = TBaseHelper.compareTo((Comparable)this.globalId, (Comparable)other.globalId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBranchQualifier()).compareTo(other.isSetBranchQualifier());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBranchQualifier() && (lastComparison = TBaseHelper.compareTo((Comparable)this.branchQualifier, (Comparable)other.branchQualifier)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionXid(");
        boolean first = true;
        sb.append("formatId:");
        sb.append(this.formatId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("globalId:");
        if (this.globalId == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.globalId, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("branchQualifier:");
        if (this.branchQualifier == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.branchQualifier, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.globalId == null) {
            throw new TProtocolException("Required field 'globalId' was not present! Struct: " + this.toString());
        }
        if (this.branchQualifier == null) {
            throw new TProtocolException("Required field 'branchQualifier' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TransactionXidStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TransactionXidTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FORMAT_ID, new FieldMetaData("formatId", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.GLOBAL_ID, new FieldMetaData("globalId", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.BRANCH_QUALIFIER, new FieldMetaData("branchQualifier", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TransactionXid.class, metaDataMap);
    }

    private static class TransactionXidTupleScheme
    extends TupleScheme<TransactionXid> {
        private TransactionXidTupleScheme() {
        }

        public void write(TProtocol prot, TransactionXid struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.formatId);
            oprot.writeBinary(struct.globalId);
            oprot.writeBinary(struct.branchQualifier);
        }

        public void read(TProtocol prot, TransactionXid struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.formatId = iprot.readI32();
            struct.setFormatIdIsSet(true);
            struct.globalId = iprot.readBinary();
            struct.setGlobalIdIsSet(true);
            struct.branchQualifier = iprot.readBinary();
            struct.setBranchQualifierIsSet(true);
        }
    }

    private static class TransactionXidTupleSchemeFactory
    implements SchemeFactory {
        private TransactionXidTupleSchemeFactory() {
        }

        public TransactionXidTupleScheme getScheme() {
            return new TransactionXidTupleScheme();
        }
    }

    private static class TransactionXidStandardScheme
    extends StandardScheme<TransactionXid> {
        private TransactionXidStandardScheme() {
        }

        public void read(TProtocol iprot, TransactionXid struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.formatId = iprot.readI32();
                            struct.setFormatIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.globalId = iprot.readBinary();
                            struct.setGlobalIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.branchQualifier = iprot.readBinary();
                            struct.setBranchQualifierIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetFormatId()) {
                throw new TProtocolException("Required field 'formatId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TransactionXid struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(FORMAT_ID_FIELD_DESC);
            oprot.writeI32(struct.formatId);
            oprot.writeFieldEnd();
            if (struct.globalId != null) {
                oprot.writeFieldBegin(GLOBAL_ID_FIELD_DESC);
                oprot.writeBinary(struct.globalId);
                oprot.writeFieldEnd();
            }
            if (struct.branchQualifier != null) {
                oprot.writeFieldBegin(BRANCH_QUALIFIER_FIELD_DESC);
                oprot.writeBinary(struct.branchQualifier);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TransactionXidStandardSchemeFactory
    implements SchemeFactory {
        private TransactionXidStandardSchemeFactory() {
        }

        public TransactionXidStandardScheme getScheme() {
            return new TransactionXidStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FORMAT_ID(1, "formatId"),
        GLOBAL_ID(2, "globalId"),
        BRANCH_QUALIFIER(3, "branchQualifier");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FORMAT_ID;
                }
                case 2: {
                    return GLOBAL_ID;
                }
                case 3: {
                    return BRANCH_QUALIFIER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

