/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import io.snappydata.thrift.ColumnDescriptor;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.Row;
import io.snappydata.thrift.SnappyExceptionData;
import io.snappydata.thrift.common.ThriftRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class RowSet
implements TBase<RowSet, _Fields>,
Serializable,
Cloneable,
Comparable<RowSet> {
    private static final TStruct STRUCT_DESC = new TStruct("RowSet");
    private static final TField ROWS_FIELD_DESC = new TField("rows", 15, 1);
    private static final TField FLAGS_FIELD_DESC = new TField("flags", 3, 2);
    private static final TField CURSOR_ID_FIELD_DESC = new TField("cursorId", 10, 3);
    private static final TField STATEMENT_ID_FIELD_DESC = new TField("statementId", 10, 4);
    private static final TField CONN_ID_FIELD_DESC = new TField("connId", 10, 5);
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 6);
    private static final TField SOURCE_FIELD_DESC = new TField("source", 12, 7);
    private static final TField OFFSET_FIELD_DESC = new TField("offset", 8, 8);
    private static final TField METADATA_FIELD_DESC = new TField("metadata", 15, 9);
    private static final TField CURSOR_NAME_FIELD_DESC = new TField("cursorName", 11, 10);
    private static final TField WARNINGS_FIELD_DESC = new TField("warnings", 12, 11);
    private static final TField ROW_IDS_FOR_UPDATE_OR_DELETE_FIELD_DESC = new TField("rowIdsForUpdateOrDelete", 15, 12);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public List<Row> rows;
    public byte flags;
    public long cursorId;
    public long statementId;
    public long connId;
    public ByteBuffer token;
    public HostAddress source;
    public int offset;
    public List<ColumnDescriptor> metadata;
    public String cursorName;
    public SnappyExceptionData warnings;
    public List<Long> rowIdsForUpdateOrDelete;
    private static final int __FLAGS_ISSET_ID = 0;
    private static final int __CURSORID_ISSET_ID = 1;
    private static final int __STATEMENTID_ISSET_ID = 2;
    private static final int __CONNID_ISSET_ID = 3;
    private static final int __OFFSET_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public RowSet() {
    }

    public RowSet(List<Row> rows, byte flags, long cursorId, long statementId, long connId) {
        this();
        this.rows = rows;
        this.flags = flags;
        this.setFlagsIsSet(true);
        this.cursorId = cursorId;
        this.setCursorIdIsSet(true);
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        this.connId = connId;
        this.setConnIdIsSet(true);
    }

    public RowSet(RowSet other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetRows()) {
            ArrayList<Row> __this__rows = new ArrayList<Row>(other.rows.size());
            for (Row row : other.rows) {
                __this__rows.add(new Row(row));
            }
            this.rows = __this__rows;
        }
        this.flags = other.flags;
        this.cursorId = other.cursorId;
        this.statementId = other.statementId;
        this.connId = other.connId;
        if (other.isSetToken()) {
            this.token = TBaseHelper.copyBinary((ByteBuffer)other.token);
        }
        if (other.isSetSource()) {
            this.source = new HostAddress(other.source);
        }
        this.offset = other.offset;
        if (other.isSetMetadata()) {
            ArrayList<ColumnDescriptor> __this__metadata = new ArrayList<ColumnDescriptor>(other.metadata.size());
            for (ColumnDescriptor columnDescriptor : other.metadata) {
                __this__metadata.add(new ColumnDescriptor(columnDescriptor));
            }
            this.metadata = __this__metadata;
        }
        if (other.isSetCursorName()) {
            this.cursorName = other.cursorName;
        }
        if (other.isSetWarnings()) {
            this.warnings = new SnappyExceptionData(other.warnings);
        }
        if (other.isSetRowIdsForUpdateOrDelete()) {
            ArrayList<Long> __this__rowIdsForUpdateOrDelete = new ArrayList<Long>(other.rowIdsForUpdateOrDelete);
            this.rowIdsForUpdateOrDelete = __this__rowIdsForUpdateOrDelete;
        }
    }

    public RowSet deepCopy() {
        return new RowSet(this);
    }

    public void clear() {
        this.rows = null;
        this.setFlagsIsSet(false);
        this.flags = 0;
        this.setCursorIdIsSet(false);
        this.cursorId = 0L;
        this.setStatementIdIsSet(false);
        this.statementId = 0L;
        this.setConnIdIsSet(false);
        this.connId = 0L;
        this.token = null;
        this.source = null;
        this.setOffsetIsSet(false);
        this.offset = 0;
        this.metadata = null;
        this.cursorName = null;
        this.warnings = null;
        this.rowIdsForUpdateOrDelete = null;
    }

    public int getRowsSize() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public Iterator<Row> getRowsIterator() {
        return this.rows == null ? null : this.rows.iterator();
    }

    public void addToRows(Row elem) {
        if (this.rows == null) {
            this.rows = new ArrayList<Row>();
        }
        this.rows.add(elem);
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public RowSet setRows(List<Row> rows) {
        this.rows = rows;
        return this;
    }

    public void unsetRows() {
        this.rows = null;
    }

    public boolean isSetRows() {
        return this.rows != null;
    }

    public void setRowsIsSet(boolean value) {
        if (!value) {
            this.rows = null;
        }
    }

    public byte getFlags() {
        return this.flags;
    }

    public RowSet setFlags(byte flags) {
        this.flags = flags;
        this.setFlagsIsSet(true);
        return this;
    }

    public void unsetFlags() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetFlags() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setFlagsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getCursorId() {
        return this.cursorId;
    }

    public RowSet setCursorId(long cursorId) {
        this.cursorId = cursorId;
        this.setCursorIdIsSet(true);
        return this;
    }

    public void unsetCursorId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetCursorId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setCursorIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getStatementId() {
        return this.statementId;
    }

    public RowSet setStatementId(long statementId) {
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        return this;
    }

    public void unsetStatementId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetStatementId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setStatementIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getConnId() {
        return this.connId;
    }

    public RowSet setConnId(long connId) {
        this.connId = connId;
        this.setConnIdIsSet(true);
        return this;
    }

    public void unsetConnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetConnId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setConnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public byte[] getToken() {
        this.setToken(TBaseHelper.rightSize((ByteBuffer)this.token));
        return this.token == null ? null : this.token.array();
    }

    public ByteBuffer bufferForToken() {
        return TBaseHelper.copyBinary((ByteBuffer)this.token);
    }

    public RowSet setToken(byte[] token) {
        this.token = token == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(token, token.length));
        return this;
    }

    public RowSet setToken(ByteBuffer token) {
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    public HostAddress getSource() {
        return this.source;
    }

    public RowSet setSource(HostAddress source) {
        this.source = source;
        return this;
    }

    public void unsetSource() {
        this.source = null;
    }

    public boolean isSetSource() {
        return this.source != null;
    }

    public void setSourceIsSet(boolean value) {
        if (!value) {
            this.source = null;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public RowSet setOffset(int offset) {
        this.offset = offset;
        this.setOffsetIsSet(true);
        return this;
    }

    public void unsetOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getMetadataSize() {
        return this.metadata == null ? 0 : this.metadata.size();
    }

    public Iterator<ColumnDescriptor> getMetadataIterator() {
        return this.metadata == null ? null : this.metadata.iterator();
    }

    public void addToMetadata(ColumnDescriptor elem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<ColumnDescriptor>();
        }
        this.metadata.add(elem);
    }

    public List<ColumnDescriptor> getMetadata() {
        return this.metadata;
    }

    public RowSet setMetadata(List<ColumnDescriptor> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void unsetMetadata() {
        this.metadata = null;
    }

    public boolean isSetMetadata() {
        return this.metadata != null;
    }

    public void setMetadataIsSet(boolean value) {
        if (!value) {
            this.metadata = null;
        }
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public RowSet setCursorName(String cursorName) {
        this.cursorName = cursorName;
        return this;
    }

    public void unsetCursorName() {
        this.cursorName = null;
    }

    public boolean isSetCursorName() {
        return this.cursorName != null;
    }

    public void setCursorNameIsSet(boolean value) {
        if (!value) {
            this.cursorName = null;
        }
    }

    public SnappyExceptionData getWarnings() {
        return this.warnings;
    }

    public RowSet setWarnings(SnappyExceptionData warnings) {
        this.warnings = warnings;
        return this;
    }

    public void unsetWarnings() {
        this.warnings = null;
    }

    public boolean isSetWarnings() {
        return this.warnings != null;
    }

    public void setWarningsIsSet(boolean value) {
        if (!value) {
            this.warnings = null;
        }
    }

    public int getRowIdsForUpdateOrDeleteSize() {
        return this.rowIdsForUpdateOrDelete == null ? 0 : this.rowIdsForUpdateOrDelete.size();
    }

    public Iterator<Long> getRowIdsForUpdateOrDeleteIterator() {
        return this.rowIdsForUpdateOrDelete == null ? null : this.rowIdsForUpdateOrDelete.iterator();
    }

    public void addToRowIdsForUpdateOrDelete(long elem) {
        if (this.rowIdsForUpdateOrDelete == null) {
            this.rowIdsForUpdateOrDelete = new ArrayList<Long>();
        }
        this.rowIdsForUpdateOrDelete.add(elem);
    }

    public List<Long> getRowIdsForUpdateOrDelete() {
        return this.rowIdsForUpdateOrDelete;
    }

    public RowSet setRowIdsForUpdateOrDelete(List<Long> rowIdsForUpdateOrDelete) {
        this.rowIdsForUpdateOrDelete = rowIdsForUpdateOrDelete;
        return this;
    }

    public void unsetRowIdsForUpdateOrDelete() {
        this.rowIdsForUpdateOrDelete = null;
    }

    public boolean isSetRowIdsForUpdateOrDelete() {
        return this.rowIdsForUpdateOrDelete != null;
    }

    public void setRowIdsForUpdateOrDeleteIsSet(boolean value) {
        if (!value) {
            this.rowIdsForUpdateOrDelete = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ROWS: {
                if (value == null) {
                    this.unsetRows();
                    break;
                }
                this.setRows((List)value);
                break;
            }
            case FLAGS: {
                if (value == null) {
                    this.unsetFlags();
                    break;
                }
                this.setFlags((Byte)value);
                break;
            }
            case CURSOR_ID: {
                if (value == null) {
                    this.unsetCursorId();
                    break;
                }
                this.setCursorId((Long)value);
                break;
            }
            case STATEMENT_ID: {
                if (value == null) {
                    this.unsetStatementId();
                    break;
                }
                this.setStatementId((Long)value);
                break;
            }
            case CONN_ID: {
                if (value == null) {
                    this.unsetConnId();
                    break;
                }
                this.setConnId((Long)value);
                break;
            }
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((ByteBuffer)value);
                break;
            }
            case SOURCE: {
                if (value == null) {
                    this.unsetSource();
                    break;
                }
                this.setSource((HostAddress)value);
                break;
            }
            case OFFSET: {
                if (value == null) {
                    this.unsetOffset();
                    break;
                }
                this.setOffset((Integer)value);
                break;
            }
            case METADATA: {
                if (value == null) {
                    this.unsetMetadata();
                    break;
                }
                this.setMetadata((List)value);
                break;
            }
            case CURSOR_NAME: {
                if (value == null) {
                    this.unsetCursorName();
                    break;
                }
                this.setCursorName((String)value);
                break;
            }
            case WARNINGS: {
                if (value == null) {
                    this.unsetWarnings();
                    break;
                }
                this.setWarnings((SnappyExceptionData)value);
                break;
            }
            case ROW_IDS_FOR_UPDATE_OR_DELETE: {
                if (value == null) {
                    this.unsetRowIdsForUpdateOrDelete();
                    break;
                }
                this.setRowIdsForUpdateOrDelete((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ROWS: {
                return this.getRows();
            }
            case FLAGS: {
                return this.getFlags();
            }
            case CURSOR_ID: {
                return this.getCursorId();
            }
            case STATEMENT_ID: {
                return this.getStatementId();
            }
            case CONN_ID: {
                return this.getConnId();
            }
            case TOKEN: {
                return this.getToken();
            }
            case SOURCE: {
                return this.getSource();
            }
            case OFFSET: {
                return this.getOffset();
            }
            case METADATA: {
                return this.getMetadata();
            }
            case CURSOR_NAME: {
                return this.getCursorName();
            }
            case WARNINGS: {
                return this.getWarnings();
            }
            case ROW_IDS_FOR_UPDATE_OR_DELETE: {
                return this.getRowIdsForUpdateOrDelete();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ROWS: {
                return this.isSetRows();
            }
            case FLAGS: {
                return this.isSetFlags();
            }
            case CURSOR_ID: {
                return this.isSetCursorId();
            }
            case STATEMENT_ID: {
                return this.isSetStatementId();
            }
            case CONN_ID: {
                return this.isSetConnId();
            }
            case TOKEN: {
                return this.isSetToken();
            }
            case SOURCE: {
                return this.isSetSource();
            }
            case OFFSET: {
                return this.isSetOffset();
            }
            case METADATA: {
                return this.isSetMetadata();
            }
            case CURSOR_NAME: {
                return this.isSetCursorName();
            }
            case WARNINGS: {
                return this.isSetWarnings();
            }
            case ROW_IDS_FOR_UPDATE_OR_DELETE: {
                return this.isSetRowIdsForUpdateOrDelete();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof RowSet) {
            return this.equals((RowSet)that);
        }
        return false;
    }

    public boolean equals(RowSet that) {
        if (that == null) {
            return false;
        }
        boolean this_present_rows = this.isSetRows();
        boolean that_present_rows = that.isSetRows();
        if (this_present_rows || that_present_rows) {
            if (!this_present_rows || !that_present_rows) {
                return false;
            }
            if (!this.rows.equals(that.rows)) {
                return false;
            }
        }
        boolean this_present_flags = true;
        boolean that_present_flags = true;
        if (this_present_flags || that_present_flags) {
            if (!this_present_flags || !that_present_flags) {
                return false;
            }
            if (this.flags != that.flags) {
                return false;
            }
        }
        boolean this_present_cursorId = true;
        boolean that_present_cursorId = true;
        if (this_present_cursorId || that_present_cursorId) {
            if (!this_present_cursorId || !that_present_cursorId) {
                return false;
            }
            if (this.cursorId != that.cursorId) {
                return false;
            }
        }
        boolean this_present_statementId = true;
        boolean that_present_statementId = true;
        if (this_present_statementId || that_present_statementId) {
            if (!this_present_statementId || !that_present_statementId) {
                return false;
            }
            if (this.statementId != that.statementId) {
                return false;
            }
        }
        boolean this_present_connId = true;
        boolean that_present_connId = true;
        if (this_present_connId || that_present_connId) {
            if (!this_present_connId || !that_present_connId) {
                return false;
            }
            if (this.connId != that.connId) {
                return false;
            }
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_source = this.isSetSource();
        boolean that_present_source = that.isSetSource();
        if (this_present_source || that_present_source) {
            if (!this_present_source || !that_present_source) {
                return false;
            }
            if (!this.source.equals(that.source)) {
                return false;
            }
        }
        boolean this_present_offset = this.isSetOffset();
        boolean that_present_offset = that.isSetOffset();
        if (this_present_offset || that_present_offset) {
            if (!this_present_offset || !that_present_offset) {
                return false;
            }
            if (this.offset != that.offset) {
                return false;
            }
        }
        boolean this_present_metadata = this.isSetMetadata();
        boolean that_present_metadata = that.isSetMetadata();
        if (this_present_metadata || that_present_metadata) {
            if (!this_present_metadata || !that_present_metadata) {
                return false;
            }
            if (!this.metadata.equals(that.metadata)) {
                return false;
            }
        }
        boolean this_present_cursorName = this.isSetCursorName();
        boolean that_present_cursorName = that.isSetCursorName();
        if (this_present_cursorName || that_present_cursorName) {
            if (!this_present_cursorName || !that_present_cursorName) {
                return false;
            }
            if (!this.cursorName.equals(that.cursorName)) {
                return false;
            }
        }
        boolean this_present_warnings = this.isSetWarnings();
        boolean that_present_warnings = that.isSetWarnings();
        if (this_present_warnings || that_present_warnings) {
            if (!this_present_warnings || !that_present_warnings) {
                return false;
            }
            if (!this.warnings.equals(that.warnings)) {
                return false;
            }
        }
        boolean this_present_rowIdsForUpdateOrDelete = this.isSetRowIdsForUpdateOrDelete();
        boolean that_present_rowIdsForUpdateOrDelete = that.isSetRowIdsForUpdateOrDelete();
        if (this_present_rowIdsForUpdateOrDelete || that_present_rowIdsForUpdateOrDelete) {
            if (!this_present_rowIdsForUpdateOrDelete || !that_present_rowIdsForUpdateOrDelete) {
                return false;
            }
            if (!this.rowIdsForUpdateOrDelete.equals(that.rowIdsForUpdateOrDelete)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_rows = this.isSetRows();
        list.add(present_rows);
        if (present_rows) {
            list.add(this.rows);
        }
        boolean present_flags = true;
        list.add(present_flags);
        if (present_flags) {
            list.add(this.flags);
        }
        boolean present_cursorId = true;
        list.add(present_cursorId);
        if (present_cursorId) {
            list.add(this.cursorId);
        }
        boolean present_statementId = true;
        list.add(present_statementId);
        if (present_statementId) {
            list.add(this.statementId);
        }
        boolean present_connId = true;
        list.add(present_connId);
        if (present_connId) {
            list.add(this.connId);
        }
        boolean present_token = this.isSetToken();
        list.add(present_token);
        if (present_token) {
            list.add(this.token);
        }
        boolean present_source = this.isSetSource();
        list.add(present_source);
        if (present_source) {
            list.add(this.source);
        }
        boolean present_offset = this.isSetOffset();
        list.add(present_offset);
        if (present_offset) {
            list.add(this.offset);
        }
        boolean present_metadata = this.isSetMetadata();
        list.add(present_metadata);
        if (present_metadata) {
            list.add(this.metadata);
        }
        boolean present_cursorName = this.isSetCursorName();
        list.add(present_cursorName);
        if (present_cursorName) {
            list.add(this.cursorName);
        }
        boolean present_warnings = this.isSetWarnings();
        list.add(present_warnings);
        if (present_warnings) {
            list.add(this.warnings);
        }
        boolean present_rowIdsForUpdateOrDelete = this.isSetRowIdsForUpdateOrDelete();
        list.add(present_rowIdsForUpdateOrDelete);
        if (present_rowIdsForUpdateOrDelete) {
            list.add(this.rowIdsForUpdateOrDelete);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(RowSet other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRows()).compareTo(other.isSetRows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRows() && (lastComparison = TBaseHelper.compareTo(this.rows, other.rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFlags()).compareTo(other.isSetFlags());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFlags() && (lastComparison = TBaseHelper.compareTo((byte)this.flags, (byte)other.flags)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCursorId()).compareTo(other.isSetCursorId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCursorId() && (lastComparison = TBaseHelper.compareTo((long)this.cursorId, (long)other.cursorId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatementId()).compareTo(other.isSetStatementId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatementId() && (lastComparison = TBaseHelper.compareTo((long)this.statementId, (long)other.statementId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetConnId()).compareTo(other.isSetConnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConnId() && (lastComparison = TBaseHelper.compareTo((long)this.connId, (long)other.connId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetToken()).compareTo(other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((Comparable)this.token, (Comparable)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSource()).compareTo(other.isSetSource());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSource() && (lastComparison = TBaseHelper.compareTo((Comparable)this.source, (Comparable)other.source)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOffset()).compareTo(other.isSetOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffset() && (lastComparison = TBaseHelper.compareTo((int)this.offset, (int)other.offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMetadata()).compareTo(other.isSetMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMetadata() && (lastComparison = TBaseHelper.compareTo(this.metadata, other.metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCursorName()).compareTo(other.isSetCursorName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCursorName() && (lastComparison = TBaseHelper.compareTo((String)this.cursorName, (String)other.cursorName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetWarnings()).compareTo(other.isSetWarnings());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWarnings() && (lastComparison = TBaseHelper.compareTo((Comparable)this.warnings, (Comparable)other.warnings)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRowIdsForUpdateOrDelete()).compareTo(other.isSetRowIdsForUpdateOrDelete());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRowIdsForUpdateOrDelete() && (lastComparison = TBaseHelper.compareTo(this.rowIdsForUpdateOrDelete, other.rowIdsForUpdateOrDelete)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowSet(");
        boolean first = true;
        sb.append("rows:");
        if (this.rows == null) {
            sb.append("null");
        } else {
            sb.append(this.rows);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("flags:");
        sb.append(this.flags);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("cursorId:");
        sb.append(this.cursorId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("statementId:");
        sb.append(this.statementId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("connId:");
        sb.append(this.connId);
        first = false;
        if (this.isSetToken()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("token:");
            if (this.token == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.token, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetSource()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("source:");
            if (this.source == null) {
                sb.append("null");
            } else {
                sb.append(this.source);
            }
            first = false;
        }
        if (this.isSetOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offset:");
            sb.append(this.offset);
            first = false;
        }
        if (this.isSetMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("metadata:");
            if (this.metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.metadata);
            }
            first = false;
        }
        if (this.isSetCursorName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("cursorName:");
            if (this.cursorName == null) {
                sb.append("null");
            } else {
                sb.append(this.cursorName);
            }
            first = false;
        }
        if (this.isSetWarnings()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("warnings:");
            if (this.warnings == null) {
                sb.append("null");
            } else {
                sb.append(this.warnings);
            }
            first = false;
        }
        if (this.isSetRowIdsForUpdateOrDelete()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("rowIdsForUpdateOrDelete:");
            if (this.rowIdsForUpdateOrDelete == null) {
                sb.append("null");
            } else {
                sb.append(this.rowIdsForUpdateOrDelete);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.rows == null) {
            throw new TProtocolException("Required field 'rows' was not present! Struct: " + this.toString());
        }
        if (this.source != null) {
            this.source.validate();
        }
        if (this.warnings != null) {
            this.warnings.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new RowSetStandardSchemeFactory());
        schemes.put(TupleScheme.class, new RowSetTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.TOKEN, _Fields.SOURCE, _Fields.OFFSET, _Fields.METADATA, _Fields.CURSOR_NAME, _Fields.WARNINGS, _Fields.ROW_IDS_FOR_UPDATE_OR_DELETE};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ROWS, new FieldMetaData("rows", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Row.class))));
        tmpMap.put(_Fields.FLAGS, new FieldMetaData("flags", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.CURSOR_ID, new FieldMetaData("cursorId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STATEMENT_ID, new FieldMetaData("statementId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.CONN_ID, new FieldMetaData("connId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.SOURCE, new FieldMetaData("source", 2, (FieldValueMetaData)new StructMetaData(12, HostAddress.class)));
        tmpMap.put(_Fields.OFFSET, new FieldMetaData("offset", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.METADATA, new FieldMetaData("metadata", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnDescriptor.class))));
        tmpMap.put(_Fields.CURSOR_NAME, new FieldMetaData("cursorName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.WARNINGS, new FieldMetaData("warnings", 2, (FieldValueMetaData)new StructMetaData(12, SnappyExceptionData.class)));
        tmpMap.put(_Fields.ROW_IDS_FOR_UPDATE_OR_DELETE, new FieldMetaData("rowIdsForUpdateOrDelete", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(10))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(RowSet.class, metaDataMap);
    }

    private static class RowSetTupleScheme
    extends TupleScheme<RowSet> {
        private RowSetTupleScheme() {
        }

        public void write(TProtocol prot, RowSet struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.rows.size());
            for (Row _iter216 : struct.rows) {
                _iter216.write((TProtocol)oprot);
            }
            oprot.writeByte(struct.flags);
            oprot.writeI64(struct.cursorId);
            oprot.writeI64(struct.statementId);
            oprot.writeI64(struct.connId);
            BitSet optionals = new BitSet();
            if (struct.isSetToken()) {
                optionals.set(0);
            }
            if (struct.isSetSource()) {
                optionals.set(1);
            }
            if (struct.isSetOffset()) {
                optionals.set(2);
            }
            if (struct.isSetMetadata()) {
                optionals.set(3);
            }
            if (struct.isSetCursorName()) {
                optionals.set(4);
            }
            if (struct.isSetWarnings()) {
                optionals.set(5);
            }
            if (struct.isSetRowIdsForUpdateOrDelete()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetToken()) {
                oprot.writeBinary(struct.token);
            }
            if (struct.isSetSource()) {
                struct.source.write((TProtocol)oprot);
            }
            if (struct.isSetOffset()) {
                oprot.writeI32(struct.offset);
            }
            if (struct.isSetMetadata()) {
                oprot.writeI32(struct.metadata.size());
                for (ColumnDescriptor _iter217 : struct.metadata) {
                    _iter217.write((TProtocol)oprot);
                }
            }
            if (struct.isSetCursorName()) {
                oprot.writeString(struct.cursorName);
            }
            if (struct.isSetWarnings()) {
                struct.warnings.write((TProtocol)oprot);
            }
            if (struct.isSetRowIdsForUpdateOrDelete()) {
                oprot.writeI32(struct.rowIdsForUpdateOrDelete.size());
                Iterator<Comparable<ColumnDescriptor>> iterator = struct.rowIdsForUpdateOrDelete.iterator();
                while (iterator.hasNext()) {
                    long _iter218 = (Long)iterator.next();
                    oprot.writeI64(_iter218);
                }
            }
        }

        public void read(TProtocol prot, RowSet struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list219 = new TList(12, iprot.readI32());
            struct.rows = new ArrayList<Row>(_list219.size);
            for (int _i221 = 0; _i221 < _list219.size; ++_i221) {
                Row _elem220 = new Row();
                _elem220.read((TProtocol)iprot);
                struct.rows.add(_elem220);
            }
            struct.setRowsIsSet(true);
            struct.flags = iprot.readByte();
            struct.setFlagsIsSet(true);
            struct.cursorId = iprot.readI64();
            struct.setCursorIdIsSet(true);
            struct.statementId = iprot.readI64();
            struct.setStatementIdIsSet(true);
            struct.connId = iprot.readI64();
            struct.setConnIdIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.token = iprot.readBinary();
                struct.setTokenIsSet(true);
            }
            if (incoming.get(1)) {
                struct.source = new HostAddress();
                struct.source.read((TProtocol)iprot);
                struct.setSourceIsSet(true);
            }
            if (incoming.get(2)) {
                struct.offset = iprot.readI32();
                struct.setOffsetIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list222 = new TList(12, iprot.readI32());
                struct.metadata = new ArrayList<ColumnDescriptor>(_list222.size);
                for (int _i224 = 0; _i224 < _list222.size; ++_i224) {
                    ColumnDescriptor _elem223 = new ColumnDescriptor();
                    _elem223.read((TProtocol)iprot);
                    struct.metadata.add(_elem223);
                }
                struct.setMetadataIsSet(true);
            }
            if (incoming.get(4)) {
                struct.cursorName = iprot.readString();
                struct.setCursorNameIsSet(true);
            }
            if (incoming.get(5)) {
                struct.warnings = new SnappyExceptionData();
                struct.warnings.read((TProtocol)iprot);
                struct.setWarningsIsSet(true);
            }
            if (incoming.get(6)) {
                TList _list225 = new TList(10, iprot.readI32());
                struct.rowIdsForUpdateOrDelete = new ArrayList<Long>(_list225.size);
                for (int _i227 = 0; _i227 < _list225.size; ++_i227) {
                    long _elem226 = iprot.readI64();
                    struct.rowIdsForUpdateOrDelete.add(_elem226);
                }
                struct.setRowIdsForUpdateOrDeleteIsSet(true);
            }
        }
    }

    private static class RowSetTupleSchemeFactory
    implements SchemeFactory {
        private RowSetTupleSchemeFactory() {
        }

        public RowSetTupleScheme getScheme() {
            return new RowSetTupleScheme();
        }
    }

    private static class RowSetStandardScheme
    extends StandardScheme<RowSet> {
        private RowSetStandardScheme() {
        }

        public void read(TProtocol iprot, RowSet struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list204 = iprot.readListBegin();
                            struct.rows = new ArrayList<Row>(_list204.size);
                            for (int _i206 = 0; _i206 < _list204.size; ++_i206) {
                                Row _elem205 = new Row();
                                _elem205.read(iprot);
                                struct.rows.add(_elem205);
                            }
                            iprot.readListEnd();
                            struct.setRowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 3) {
                            struct.flags = iprot.readByte();
                            struct.setFlagsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.cursorId = iprot.readI64();
                            struct.setCursorIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.statementId = iprot.readI64();
                            struct.setStatementIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.connId = iprot.readI64();
                            struct.setConnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readBinary();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.source = new HostAddress();
                            struct.source.read(iprot);
                            struct.setSourceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.offset = iprot.readI32();
                            struct.setOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list207 = iprot.readListBegin();
                            struct.metadata = new ArrayList<ColumnDescriptor>(_list207.size);
                            for (int _i209 = 0; _i209 < _list207.size; ++_i209) {
                                ColumnDescriptor _elem208 = new ColumnDescriptor();
                                _elem208.read(iprot);
                                struct.metadata.add(_elem208);
                            }
                            iprot.readListEnd();
                            struct.setMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.cursorName = iprot.readString();
                            struct.setCursorNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 12) {
                            struct.warnings = new SnappyExceptionData();
                            struct.warnings.read(iprot);
                            struct.setWarningsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 15) {
                            TList _list210 = iprot.readListBegin();
                            struct.rowIdsForUpdateOrDelete = new ArrayList<Long>(_list210.size);
                            for (int _i212 = 0; _i212 < _list210.size; ++_i212) {
                                long _elem211 = iprot.readI64();
                                struct.rowIdsForUpdateOrDelete.add(_elem211);
                            }
                            iprot.readListEnd();
                            struct.setRowIdsForUpdateOrDeleteIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetFlags()) {
                throw new TProtocolException("Required field 'flags' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetCursorId()) {
                throw new TProtocolException("Required field 'cursorId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetStatementId()) {
                throw new TProtocolException("Required field 'statementId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetConnId()) {
                throw new TProtocolException("Required field 'connId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, RowSet struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.rows != null) {
                oprot.writeFieldBegin(ROWS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.rows.size()));
                for (Row _iter213 : struct.rows) {
                    _iter213.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(FLAGS_FIELD_DESC);
            oprot.writeByte(struct.flags);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(CURSOR_ID_FIELD_DESC);
            oprot.writeI64(struct.cursorId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(STATEMENT_ID_FIELD_DESC);
            oprot.writeI64(struct.statementId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(CONN_ID_FIELD_DESC);
            oprot.writeI64(struct.connId);
            oprot.writeFieldEnd();
            if (struct.token != null && struct.isSetToken()) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeBinary(struct.token);
                oprot.writeFieldEnd();
            }
            if (struct.source != null && struct.isSetSource()) {
                oprot.writeFieldBegin(SOURCE_FIELD_DESC);
                struct.source.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOffset()) {
                oprot.writeFieldBegin(OFFSET_FIELD_DESC);
                oprot.writeI32(struct.offset);
                oprot.writeFieldEnd();
            }
            if (struct.metadata != null && struct.isSetMetadata()) {
                oprot.writeFieldBegin(METADATA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.metadata.size()));
                for (ColumnDescriptor _iter214 : struct.metadata) {
                    _iter214.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.cursorName != null && struct.isSetCursorName()) {
                oprot.writeFieldBegin(CURSOR_NAME_FIELD_DESC);
                oprot.writeString(struct.cursorName);
                oprot.writeFieldEnd();
            }
            if (struct.warnings != null && struct.isSetWarnings()) {
                oprot.writeFieldBegin(WARNINGS_FIELD_DESC);
                struct.warnings.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.rowIdsForUpdateOrDelete != null && struct.isSetRowIdsForUpdateOrDelete()) {
                oprot.writeFieldBegin(ROW_IDS_FOR_UPDATE_OR_DELETE_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.rowIdsForUpdateOrDelete.size()));
                Iterator<Comparable<ThriftRow>> iterator = struct.rowIdsForUpdateOrDelete.iterator();
                while (iterator.hasNext()) {
                    long _iter215 = (Long)iterator.next();
                    oprot.writeI64(_iter215);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class RowSetStandardSchemeFactory
    implements SchemeFactory {
        private RowSetStandardSchemeFactory() {
        }

        public RowSetStandardScheme getScheme() {
            return new RowSetStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ROWS(1, "rows"),
        FLAGS(2, "flags"),
        CURSOR_ID(3, "cursorId"),
        STATEMENT_ID(4, "statementId"),
        CONN_ID(5, "connId"),
        TOKEN(6, "token"),
        SOURCE(7, "source"),
        OFFSET(8, "offset"),
        METADATA(9, "metadata"),
        CURSOR_NAME(10, "cursorName"),
        WARNINGS(11, "warnings"),
        ROW_IDS_FOR_UPDATE_OR_DELETE(12, "rowIdsForUpdateOrDelete");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ROWS;
                }
                case 2: {
                    return FLAGS;
                }
                case 3: {
                    return CURSOR_ID;
                }
                case 4: {
                    return STATEMENT_ID;
                }
                case 5: {
                    return CONN_ID;
                }
                case 6: {
                    return TOKEN;
                }
                case 7: {
                    return SOURCE;
                }
                case 8: {
                    return OFFSET;
                }
                case 9: {
                    return METADATA;
                }
                case 10: {
                    return CURSOR_NAME;
                }
                case 11: {
                    return WARNINGS;
                }
                case 12: {
                    return ROW_IDS_FOR_UPDATE_OR_DELETE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

