/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class SingleHopInformation
implements Externalizable {
    public static final int NO_SINGLE_HOP_CASE = 0;
    public static final int REPLICATE_FLAG = 1;
    public static final int LIST_RESOLVER_FLAG = 2;
    public static final int RANGE_RESOLVER_FLAG = 3;
    public static final int COLUMN_RESOLVER_FLAG = 4;
    public static final int NO_SINGLE_HOP_AS_PRIMARY_NOT_DETERMINED = 10;
    public static final int SINGLE_HOP_BUT_SERVER_FOR_SECONDARIES_NOT_DETERMINED = 11;
    public static final int NO_SINGLE_HOP_AS_COULD_NOT_DETERMINE_SERVER_LOCATION_LOGIC = 12;
    private String fullQualifiedTableName;
    private byte resolverFlag = 0;
    private Map mapOfListValuesToRoutingObjects;
    private int[] typeFormatIdArray;
    private ArrayList rangeValuesHolderList;
    private ArrayList bucketAndNetServerInfoList;
    private Set routingObjectInfoSet;
    private int totalNumberOfBuckets;
    private boolean requiredSerializedHash;
    private byte useOnlyPrimariesFlag = 0;
    private static final byte NO_CASE_FOR_ONLY_PRIMARIES = 0;
    private static final byte SECONDARY_SERVERS_NOT_DETERMINED_CASE = 1;
    private static final byte HDFS_REGION_CASE = 2;
    private boolean hasAggregate;

    public SingleHopInformation(String regionname) {
        this.fullQualifiedTableName = regionname;
    }

    public SingleHopInformation() {
    }

    public String getRegionName() {
        return this.fullQualifiedTableName;
    }

    public byte getResolverByte() {
        return this.resolverFlag;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.resolverFlag != 10 && (this.routingObjectInfoSet == null || this.routingObjectInfoSet.contains(ResolverUtils.TOK_ALL_NODES))) {
            this.resolverFlag = 0;
        }
        out.writeBoolean(this.hasAggregate);
        out.writeByte(this.resolverFlag);
        if (this.resolverFlag == 0 || this.resolverFlag == 10) {
            return;
        }
        out.writeUTF(this.fullQualifiedTableName);
        out.writeInt(this.totalNumberOfBuckets);
        assert (this.typeFormatIdArray != null && this.typeFormatIdArray.length != 0);
        out.writeByte(this.typeFormatIdArray.length);
        for (int i = 0; i < this.typeFormatIdArray.length; ++i) {
            out.writeShort(this.typeFormatIdArray[i]);
        }
        if (this.resolverFlag == 2) {
            this.writeListResolverData(out);
        }
        if (this.resolverFlag == 3) {
            this.writeRangeResolverData(out);
        }
        if (this.resolverFlag == 4) {
            out.writeBoolean(this.requiredSerializedHash);
            this.writeColumnResolverData(out);
        }
        out.writeObject(this.bucketAndNetServerInfoList);
        out.writeObject(this.routingObjectInfoSet);
        out.writeByte(this.useOnlyPrimariesFlag);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.hasAggregate = in.readBoolean();
        this.resolverFlag = in.readByte();
        if (this.resolverFlag == 0 || this.resolverFlag == 10) {
            return;
        }
        this.fullQualifiedTableName = in.readUTF();
        this.totalNumberOfBuckets = in.readInt();
        int len = in.readByte();
        this.typeFormatIdArray = new int[len];
        for (int i = 0; i < len; ++i) {
            this.typeFormatIdArray[i] = in.readShort();
        }
        if (this.resolverFlag == 2) {
            this.readListResolverData(in);
        }
        if (this.resolverFlag == 3) {
            this.readRangeResolverData(in);
        }
        if (this.resolverFlag == 4) {
            this.requiredSerializedHash = in.readBoolean();
            this.readColumnResolverData(in);
        }
        this.bucketAndNetServerInfoList = (ArrayList)in.readObject();
        this.routingObjectInfoSet = (Set)in.readObject();
        this.useOnlyPrimariesFlag = in.readByte();
    }

    private void writeColumnResolverData(ObjectOutput out) {
    }

    private void writeRangeResolverData(ObjectOutput out) throws IOException {
        assert (this.rangeValuesHolderList != null);
        out.writeObject(this.rangeValuesHolderList);
    }

    private void writeListResolverData(ObjectOutput out) throws IOException {
        assert (this.mapOfListValuesToRoutingObjects != null);
        out.writeObject(this.mapOfListValuesToRoutingObjects);
    }

    private void readColumnResolverData(ObjectInput in) {
    }

    private void readRangeResolverData(ObjectInput in) throws ClassNotFoundException, IOException {
        this.rangeValuesHolderList = (ArrayList)in.readObject();
    }

    private void readListResolverData(ObjectInput in) throws ClassNotFoundException, IOException {
        this.mapOfListValuesToRoutingObjects = (Map)in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table name: ");
        sb.append(this.fullQualifiedTableName);
        sb.append(", resolver type: ");
        sb.append(this.getResolverType(this.resolverFlag));
        if (this.typeFormatIdArray != null) {
            sb.append(", type array length: ");
            sb.append(this.typeFormatIdArray.length);
            for (int i = 0; i < this.typeFormatIdArray.length; ++i) {
                sb.append(", type array[" + i + "]: ");
                sb.append(this.typeFormatIdArray[i]);
            }
        } else {
            sb.append(", type array: " + null);
        }
        sb.append(", bucketAndNetServer list: ");
        sb.append(this.bucketAndNetServerInfoList);
        sb.append(", routing object info set: ");
        sb.append(this.routingObjectInfoSet);
        sb.append(", isHoppable: ");
        sb.append(this.isHoppable());
        sb.append(", someSecondariesNotDetermined: ");
        sb.append(this.useOnlyPrimariesFlag);
        return sb.toString();
    }

    private String getResolverType(byte flag) {
        if (flag == 0) {
            return "NO_SINGLE_HOP_CASE";
        }
        if (flag == 1) {
            return "REPLICATE";
        }
        if (flag == 2) {
            return "LIST_RESOLVER";
        }
        if (flag == 3) {
            return "RANGE_RESOLVER";
        }
        if (flag == 4) {
            return "COLUMN_RESOLVER";
        }
        return null;
    }

    public void setResolverType(int resolverFlag) {
        this.resolverFlag = (byte)resolverFlag;
    }

    public void setMapOfListValues(Map map) {
        this.mapOfListValuesToRoutingObjects = map;
    }

    public Map getMapOfListValues() {
        return this.mapOfListValuesToRoutingObjects;
    }

    public void setTypeFormatIdArray(int[] typeFormatIdArray) {
        this.typeFormatIdArray = typeFormatIdArray;
    }

    public int[] getTypeFormatIdArray() {
        return this.typeFormatIdArray;
    }

    public void setRangeValueHolderList(ArrayList list) {
        this.rangeValuesHolderList = list;
    }

    public ArrayList getRangeValueHolderList() {
        return this.rangeValuesHolderList;
    }

    public void setBucketAndNetworkServerInfoList(ArrayList list) {
        this.bucketAndNetServerInfoList = list;
    }

    public ArrayList getBucketAndNetServerInfoList() {
        return this.bucketAndNetServerInfoList;
    }

    public static boolean isSupportedTypeForSingleHop(int typeFormatId) {
        switch (typeFormatId) {
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 200: {
                return true;
            }
        }
        return false;
    }

    public void setRoutingObjectInfoSet(Set routingInfoObjects) {
        this.routingObjectInfoSet = routingInfoObjects;
    }

    public Set getRoutingObjectInfoSet() {
        return this.routingObjectInfoSet;
    }

    public boolean isHoppable() {
        if (this.resolverFlag == 0) {
            if (SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT("TraceSingleHop", "SingleHopInformation::isHoppable no single hop for table: " + this.fullQualifiedTableName);
            }
            return false;
        }
        if (this.resolverFlag == 10) {
            if (SanityManager.TraceSingleHop) {
                SanityManager.DEBUG_PRINT("TraceSingleHop", "SingleHopInformation::isHoppable no single hop for table: " + this.fullQualifiedTableName + " as servers corresponding to primaries could not be determined");
            }
            return false;
        }
        return true;
    }

    public void setTotalNumberOfBuckets(int totalNumberOfBuckets) {
        this.totalNumberOfBuckets = totalNumberOfBuckets;
    }

    public int getTotalNumberOfBuckets() {
        return this.totalNumberOfBuckets;
    }

    public void setRequiredSerializedHash(boolean requiresSerializedHash) {
        this.requiredSerializedHash = requiresSerializedHash;
    }

    public boolean getRequiresSerializedHash() {
        return this.requiredSerializedHash;
    }

    public void setSecondaryServerNotDeterminedForSomeBuckets() {
        this.useOnlyPrimariesFlag = SingleHopInformation.set(this.useOnlyPrimariesFlag, (byte)1);
    }

    public boolean getAllSecondaryServersDetermined() {
        return !SingleHopInformation.isSet(this.useOnlyPrimariesFlag, (byte)1);
    }

    public void setHdfsRegionCase() {
        this.useOnlyPrimariesFlag = SingleHopInformation.set(this.useOnlyPrimariesFlag, (byte)2);
    }

    public boolean getHdfsRegionCase() {
        return SingleHopInformation.isSet(this.useOnlyPrimariesFlag, (byte)2);
    }

    public void setHasAggregate() {
        this.hasAggregate = true;
    }

    public boolean getHasAggregate() {
        return this.hasAggregate;
    }

    public static final byte set(byte flags, byte mask) {
        return (byte)(flags | mask);
    }

    public static final boolean isSet(byte flags, byte mask) {
        return (flags & mask) != 0;
    }

    public static class BucketAndNetServerInfo
    implements Externalizable {
        private Integer bucketId;
        private String primaryBucketServersStr;
        private String[] secondaryBucketServersStr;

        public BucketAndNetServerInfo() {
        }

        public BucketAndNetServerInfo(Integer bucketId, String primaryBucketServers, String[] secondaryBucketServers) {
            this.bucketId = bucketId;
            this.primaryBucketServersStr = primaryBucketServers;
            this.secondaryBucketServersStr = secondaryBucketServers;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.bucketId);
            out.writeUTF(this.primaryBucketServersStr);
            if (this.secondaryBucketServersStr == null) {
                out.writeShort(-1);
            } else {
                out.writeShort(this.secondaryBucketServersStr.length);
                for (int i = 0; i < this.secondaryBucketServersStr.length; ++i) {
                    out.writeUTF(this.secondaryBucketServersStr[i]);
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.bucketId = in.readInt();
            this.primaryBucketServersStr = in.readUTF();
            int secServerArrayLen = in.readShort();
            if (secServerArrayLen != -1) {
                this.secondaryBucketServersStr = new String[secServerArrayLen];
                for (int i = 0; i < secServerArrayLen; ++i) {
                    this.secondaryBucketServersStr[i] = in.readUTF();
                }
            }
        }

        public String getPrimaryBucketServerString() {
            return this.primaryBucketServersStr;
        }

        public String[] getSecondaryServerBucketStrings() {
            return this.secondaryBucketServersStr;
        }

        public int getBucketId() {
            return this.bucketId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("bucket id: ");
            sb.append(this.bucketId);
            sb.append("\n");
            sb.append(", primary server string: " + this.primaryBucketServersStr);
            sb.append(", no of secondary server string: ");
            if (this.secondaryBucketServersStr != null) {
                sb.append(this.secondaryBucketServersStr.length);
                for (int i = 0; i < this.secondaryBucketServersStr.length; ++i) {
                    sb.append(", secondary server string [" + i + "] = ");
                    sb.append(this.secondaryBucketServersStr[i]);
                }
            } else {
                sb.append("0");
            }
            sb.append("\n");
            return sb.toString();
        }
    }

    public static class PlainRangeValueHolder
    implements Externalizable {
        private Object lowerBound;
        private Object upperBound;
        private Integer routingValue;

        public PlainRangeValueHolder() {
        }

        public PlainRangeValueHolder(Object lowerBound, Object upperBound, Integer routingValue) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.routingValue = routingValue;
        }

        public Object getLowerBound() {
            return this.lowerBound;
        }

        public Object getUpperBound() {
            return this.upperBound;
        }

        public int getRoutingVal() {
            return this.routingValue;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.lowerBound);
            out.writeObject(this.upperBound);
            out.writeObject(this.routingValue);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.lowerBound = in.readObject();
            this.upperBound = in.readObject();
            this.routingValue = (Integer)in.readObject();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PlainRangeValueHolder: lower bound= ");
            sb.append(this.lowerBound);
            sb.append(", upper bound= " + this.upperBound);
            sb.append(", routing value= ");
            sb.append(this.routingValue);
            return sb.toString();
        }
    }
}

