/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.gemstone.gemfire.internal.shared.ClientResolverUtils;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import org.slf4j.Logger;

public abstract class ResolverUtils
extends ClientResolverUtils {
    public static Integer TOKEN_FOR_DB_SYNC;
    public static Object TOK_ALL_NODES;
    private static final Constructor<?> bigIntCons;
    private static final long stringCharsOffset;
    private static final Integer MINUS_ONE;
    private static final Integer ZERO;
    private static final Integer PLUS_ONE;
    public static final String GFXD_USE_PRE1302_HASHCODE = "gemfirexd.use-pre1302-hashing";
    private static boolean GEMFIREXD_USING_GFXD1302_HASHING;
    private static Boolean GEMFIREXD_GFXD1302_HASHING_STATE;
    private static final int PRIME_FACTOR_FOR_CHUNKED_INT_HASH = 19845871;
    private static final int PRIME_FACTOR_FOR_CHUNKED_BYTE_HASH = 197;
    private static final int OLD_PRIME_FACTOR_FOR_CHUNKED_HASH = 31;
    public static final long MAG_MASK = 0xFFFFFFFFL;

    protected ResolverUtils() {
    }

    public static BigInteger newBigInteger(int[] mag, int signum) {
        if (bigIntCons != null) {
            try {
                Integer sig;
                switch (signum) {
                    case 0: {
                        sig = ZERO;
                        break;
                    }
                    case 1: {
                        sig = PLUS_ONE;
                        break;
                    }
                    case -1: {
                        sig = MINUS_ONE;
                        break;
                    }
                    default: {
                        sig = signum;
                    }
                }
                return (BigInteger)bigIntCons.newInstance(mag, sig);
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException((String)"unexpected exception", (Throwable)ex);
            }
        }
        byte[] magnitude = new byte[mag.length << 2];
        int index = 0;
        for (int i = 0; i < mag.length; ++i) {
            int v = mag[i];
            magnitude[index++] = (byte)(v >>> 24);
            magnitude[index++] = (byte)(v >>> 16);
            magnitude[index++] = (byte)(v >>> 8);
            magnitude[index++] = (byte)v;
        }
        return new BigInteger(signum, magnitude);
    }

    public static final boolean hasBigIntegerWrapperConstructor() {
        return bigIntCons != null;
    }

    public static int addLongToBucketHash(long val, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ResolverUtils.addLongToChunkedHash(val, hash);
            }
        }
        return ResolverUtils.addLongToHash((long)val, (int)hash);
    }

    public static int addIntToBucketHash(int val, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ResolverUtils.addIntToChunkedHash(val, hash);
            }
        }
        return ResolverUtils.addIntToHash((int)val, (int)hash);
    }

    public static int addByteToBucketHash(byte val, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ResolverUtils.addByteToChunkedHash(val, hash);
            }
        }
        return ResolverUtils.addByteToHash((byte)val, (int)hash);
    }

    public static int addBytesToBucketHash(byte[] bytes, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ResolverUtils.addBytesToChunkedHash(bytes, hash);
            }
        }
        return ResolverUtils.addBytesToHash((byte[])bytes, (int)hash);
    }

    public static int addBytesToBucketHash(byte[] bytes, int offset, int length, int hash, int typeId) {
        switch (typeId) {
            case 7: 
            case 10: 
            case 11: 
            case 80: 
            case 83: 
            case 84: 
            case 195: 
            case 199: {
                return ResolverUtils.addBytesToChunkedHash(bytes, offset, length, hash);
            }
        }
        return ResolverUtils.addBytesToHash((byte[])bytes, (int)offset, (int)length, (int)hash);
    }

    public static final int addBytesToHash(ByteBuffer bytes, int hash) {
        long v;
        int pos;
        int endRound8Pos;
        int endPos = bytes.limit();
        int n = endRound8Pos = (endPos - pos) % 8 != 0 ? endPos - 8 : endPos;
        if (bytes.order() == ByteOrder.BIG_ENDIAN) {
            for (pos = bytes.position(); pos < endRound8Pos; pos += 8) {
                v = bytes.getLong(pos);
                hash ^= sbox[(int)(v >>> 56 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 48 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 40 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 32 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 24 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 16 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 8 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v & 0xFFL)];
                hash *= 3;
            }
        } else {
            while (pos < endRound8Pos) {
                v = bytes.getLong(pos);
                hash ^= sbox[(int)(v & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 8 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 16 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 24 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 32 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 40 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 48 & 0xFFL)];
                hash *= 3;
                hash ^= sbox[(int)(v >>> 56 & 0xFFL)];
                hash *= 3;
                pos += 8;
            }
        }
        while (pos < endPos) {
            hash ^= sbox[bytes.get(pos) & 0xFF];
            hash *= 3;
            ++pos;
        }
        return hash;
    }

    public static final boolean isUsingGFXD1302Hashing() {
        return GEMFIREXD_USING_GFXD1302_HASHING;
    }

    public static synchronized boolean isGFXD1302HashingStateSet() {
        return GEMFIREXD_GFXD1302_HASHING_STATE != null;
    }

    public static synchronized void setUseGFXD1302Hashing(boolean checkState) {
        if (GEMFIREXD_GFXD1302_HASHING_STATE == null) {
            GEMFIREXD_GFXD1302_HASHING_STATE = Boolean.TRUE;
            GEMFIREXD_USING_GFXD1302_HASHING = true;
        } else if (checkState && !GEMFIREXD_GFXD1302_HASHING_STATE.booleanValue()) {
            throw new IllegalStateException("GemFireXD: already setup to use pre GemFireXD 1.3.0.2 hashing scheme for tables but found a new GemFireXD >= 1.3.0.2 table source. Use gemfirexd.use-pre1302-hashing system property to force using pre 1.3.0.2 hashing but consult documentation on upgrade path to use new hashing scheme consistently for optimal performance.");
        }
    }

    public static synchronized void setUsePre1302Hashing(boolean checkState) {
        if (!GEMFIREXD_USING_GFXD1302_HASHING) {
            return;
        }
        if (checkState && GEMFIREXD_GFXD1302_HASHING_STATE != null && GEMFIREXD_GFXD1302_HASHING_STATE.booleanValue()) {
            throw new IllegalStateException("GemFireXD: already setup to use new GemFireXD 1.3.0.2 hashing scheme for tables but found a pre 1.3.0.2 table source. Use gemfirexd.use-pre1302-hashing system property to force using pre 1.3.0.2 hashing but consult documentation on upgrade path to use new hashing scheme consistently for optimal performance.");
        }
        Logger logger = ClientSharedUtils.getLogger(ResolverUtils.class);
        if (logger != null) {
            logger.warn("Using non-optimal pre 1.3.0.2 hashing scheme due to old members or data files in the distributed system (#51381). Consult documentation on upgrade path for optimal performance.");
        }
        GEMFIREXD_GFXD1302_HASHING_STATE = Boolean.FALSE;
        GEMFIREXD_USING_GFXD1302_HASHING = false;
    }

    public static void reset() {
        GEMFIREXD_USING_GFXD1302_HASHING = true;
        GEMFIREXD_GFXD1302_HASHING_STATE = null;
    }

    public static int addIntToChunkedHash(int val, int hash) {
        return GEMFIREXD_USING_GFXD1302_HASHING ? 19845871 * hash + val : 31 * hash + val;
    }

    public static int addLongToChunkedHash(long val, int hash) {
        hash = ResolverUtils.addIntToChunkedHash((int)(val >>> 32), hash);
        return ResolverUtils.addIntToChunkedHash((int)val, hash);
    }

    private static final int addByteToChunkedHash(byte b, int hash) {
        return GEMFIREXD_USING_GFXD1302_HASHING ? 197 * hash + (b & 0xFF) : 31 * hash + (b & 0xFF);
    }

    private static int addBytesToChunkedHash(byte[] bytes, int hash) {
        return ResolverUtils.addBytesToChunkedHash(bytes, 0, bytes.length, hash);
    }

    private static int addBytesToChunkedHashPre1302(byte[] bytes, int offset, int length, int hash) {
        if (bytes != null) {
            int endPos = offset + length;
            while (offset < endPos) {
                int nextInt = 0;
                for (int i = 0; i < 4 && offset < endPos; ++offset, ++i) {
                    nextInt <<= 8;
                    nextInt += bytes[offset] & 0xFF;
                }
                hash = 31 * hash + nextInt;
            }
        }
        return hash;
    }

    private static int addBytesToChunkedHash(byte[] bytes, int offset, int length, int hash) {
        if (GEMFIREXD_USING_GFXD1302_HASHING) {
            if (bytes != null) {
                int endPos = offset + length;
                while (offset < endPos) {
                    int nextInt = 0;
                    for (int i = 0; i < 4 && offset < endPos; ++offset, ++i) {
                        nextInt <<= 8;
                        nextInt += bytes[offset] & 0xFF;
                    }
                    hash = 19845871 * hash + nextInt;
                }
            }
            return hash;
        }
        return ResolverUtils.addBytesToChunkedHashPre1302(bytes, offset, length, hash);
    }

    public static int computeHashCode(int[] magnitude, int hash, int formatId) {
        int size_1 = magnitude.length - 1;
        if (size_1 >= 0) {
            long firstInt = (long)magnitude[0] & 0xFFFFFFFFL;
            int numBytesInFirstInt = ResolverUtils.numBytesWithoutZeros(firstInt);
            while (numBytesInFirstInt-- > 0) {
                hash = ResolverUtils.addByteToBucketHash((byte)(firstInt >>> 8 * numBytesInFirstInt), hash, formatId);
            }
            for (int index = 1; index <= size_1; ++index) {
                hash = ResolverUtils.addIntToBucketHash(magnitude[index], hash, formatId);
            }
        }
        return hash;
    }

    public static final int numBytesWithoutZeros(long value) {
        if (value <= 255L) {
            return 1;
        }
        if (value <= 65535L) {
            return 2;
        }
        if (value <= 0xFFFFFFL) {
            return 3;
        }
        return 4;
    }

    public static char[] getInternalChars(String s, int slen) {
        if (stringCharsOffset != -1L) {
            try {
                char[] chars = (char[])UnsafeHolder.getUnsafe().getObject(s, stringCharsOffset);
                if (chars != null && chars.length == slen) {
                    return chars;
                }
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException((String)"unexpected exception", (Throwable)ex);
            }
        }
        return ResolverUtils.getChars(s, slen);
    }

    public static char[] getInternalCharsOnly(String s, int slen) {
        if (stringCharsOffset != -1L) {
            try {
                char[] chars = (char[])UnsafeHolder.getUnsafe().getObject(s, stringCharsOffset);
                if (chars != null && chars.length == slen) {
                    return chars;
                }
            }
            catch (Exception ex) {
                throw ClientSharedUtils.newRuntimeException((String)"unexpected exception", (Throwable)ex);
            }
        }
        return null;
    }

    public static char[] getChars(String s, int slen) {
        char[] result = new char[slen];
        s.getChars(0, slen, result, 0);
        return result;
    }

    public static int getComputeHashOfCharArrayData(int hash, int strlen, char[] data, int typeId) {
        for (int index = 0; index < strlen; ++index) {
            char c = data[index];
            if (c >= '\u0001' && c <= '\u007f') {
                hash = ResolverUtils.addByteToBucketHash((byte)(c & 0xFF), hash, typeId);
                continue;
            }
            if (c > '\u07ff') {
                hash = ResolverUtils.addByteToBucketHash((byte)(0xE0 | c >> 12 & 0xF), hash, typeId);
                hash = ResolverUtils.addByteToBucketHash((byte)(0x80 | c >> 6 & 0x3F), hash, typeId);
                hash = ResolverUtils.addByteToBucketHash((byte)(0x80 | c >> 0 & 0x3F), hash, typeId);
                continue;
            }
            hash = ResolverUtils.addByteToBucketHash((byte)(0xC0 | c >> 6 & 0x1F), hash, typeId);
            hash = ResolverUtils.addByteToBucketHash((byte)(0x80 | c >> 0 & 0x3F), hash, typeId);
        }
        return hash;
    }

    public static int getHashCodeOfCharArrayData(char[] data, String value, int rawLength) {
        if (data != null && rawLength > 0) {
            int index = rawLength - 1;
            if (data[index] == ' ') {
                while (index > 0 && data[--index] == ' ') {
                }
            } else if (value != null) {
                return value.hashCode();
            }
            int h = 0;
            for (int i = 0; i <= index; ++i) {
                h = 31 * h + data[i];
            }
            return h;
        }
        return 0;
    }

    static {
        Field strChars;
        Constructor cons;
        TOKEN_FOR_DB_SYNC = Short.MAX_VALUE;
        TOK_ALL_NODES = new Object(){

            public boolean equals(Object obj) {
                return obj == this;
            }

            public String toString() {
                return "TOK_ALL_ROUTING_KEYS";
            }
        };
        try {
            cons = BigInteger.class.getDeclaredConstructor(int[].class, Integer.TYPE);
            cons.setAccessible(true);
        }
        catch (Exception e) {
            cons = null;
        }
        try {
            strChars = String.class.getDeclaredField("value");
            strChars.setAccessible(true);
            if (!char[].class.equals(strChars.getType())) {
                strChars = null;
            }
        }
        catch (Exception e) {
            strChars = null;
        }
        bigIntCons = cons;
        stringCharsOffset = strChars != null ? UnsafeHolder.getUnsafe().objectFieldOffset(strChars) : -1L;
        MINUS_ONE = -1;
        ZERO = 0;
        PLUS_ONE = 1;
        GEMFIREXD_USING_GFXD1302_HASHING = true;
        GEMFIREXD_GFXD1302_HASHING_STATE = null;
    }

    public static class GfxdRange
    implements Comparable,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 4157382512604052723L;
        private GfxdComparableFuzzy start;
        protected GfxdComparableFuzzy end;
        private Class rangeType;
        protected String command;

        public GfxdRange(String command, Object start, Object end) {
            if (start != null) {
                if (!(start instanceof Comparable)) {
                    // empty if block
                }
                this.rangeType = start.getClass();
                if (end != null && !this.rangeType.equals(end.getClass())) {
                    // empty if block
                }
            } else if (end != null) {
                if (!(end instanceof Comparable)) {
                    // empty if block
                }
                this.rangeType = end.getClass();
            }
            this.command = command;
            Comparable startComp = (Comparable)start;
            Comparable endComp = (Comparable)end;
            this.start = start == null ? new GfxdComparableFuzzy(startComp, 1) : new GfxdComparableFuzzy(startComp, 0);
            this.end = end == null ? new GfxdComparableFuzzy(endComp, -1) : new GfxdComparableFuzzy(endComp, -1);
        }

        public GfxdRange(String command, GfxdComparableFuzzy start, GfxdComparableFuzzy end) {
            this.command = command;
            this.start = start;
            this.end = end;
            this.rangeType = start != null ? start.getObjectType() : (end != null ? end.getObjectType() : null);
        }

        public String getCommand() {
            return this.command;
        }

        public String setCommand(String cmd) {
            this.command = cmd;
            return this.command;
        }

        public Comparable rangeStart() {
            return this.start;
        }

        public Comparable rangeEnd() {
            return this.end;
        }

        public void invalidate() {
            this.rangeType = null;
        }

        public boolean isInvalid() {
            return this.rangeType == null;
        }

        public int inRange(GfxdComparableFuzzy obj) throws ClassCastException {
            if (this.rangeType == null) {
                throw new ClassCastException(this.command + ": range object invalidated");
            }
            if (this.start.compareTo(obj) > 0) {
                return 1;
            }
            if (this.end.compareTo(obj) < 0) {
                return -1;
            }
            return 0;
        }

        public int compareTo(Object other) throws ClassCastException {
            if (this == other) {
                return 0;
            }
            if (other instanceof GfxdRange) {
                GfxdRange otherRange = (GfxdRange)other;
                if (this.start.compareTo(otherRange.end) > 0) {
                    return 1;
                }
                if (otherRange.start.compareTo(this.end) > 0) {
                    return -1;
                }
                throw new ClassCastException(this.command + ": Cannot have overlapping ranges: [" + this.toString() + "], [" + otherRange.toString() + ']');
            }
            throw new ClassCastException(this.command + "Cannot compare range [" + this.toString() + "] against object of " + other.getClass());
        }

        public String toString() {
            return (this.start != null ? this.start.toString() : "-infinity") + " - " + (this.end != null ? this.end.toString() : "+infinity");
        }

        public final void getDDLString(StringBuilder sb) {
            if (this.start.obj != null) {
                sb.append(this.start.boundaryType == 1 ? (char)'(' : '[');
                sb.append(this.start.obj);
            } else {
                sb.append("(-infinity");
            }
            sb.append(',');
            if (this.end.obj != null) {
                sb.append(this.end.obj);
                sb.append(this.end.boundaryType == -1 ? (char)')' : ']');
            } else {
                sb.append("+infinity)");
            }
        }

        public Object clone() {
            return new GfxdRange(this.command, this.start, this.end);
        }

        public GfxdComparableFuzzy getStart() {
            return this.start;
        }

        public GfxdComparableFuzzy getEnd() {
            return this.end;
        }
    }

    public static class GfxdComparableFuzzy
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -1475537216488457161L;
        protected Comparable obj;
        protected int boundaryType;
        public static final int GT = 1;
        public static final int GE = 0;
        public static final int LE = 0;
        public static final int LT = -1;

        public GfxdComparableFuzzy(Comparable obj, int boundaryType) {
            this.obj = obj;
            this.boundaryType = boundaryType;
        }

        public GfxdComparableFuzzy(Object obj) {
            this.obj = (Comparable)obj;
            this.boundaryType = 0;
        }

        public int compareTo(Object other) throws ClassCastException {
            if (other instanceof GfxdComparableFuzzy) {
                GfxdComparableFuzzy otherObj = (GfxdComparableFuzzy)other;
                if (otherObj.obj == null) {
                    if (this.obj == null) {
                        return otherObj.boundaryType - this.boundaryType;
                    }
                    return otherObj.boundaryType;
                }
                if (this.obj == null) {
                    return -this.boundaryType;
                }
                int cmp = 0;
                cmp = this.obj.getClass() == Integer.class && otherObj.obj.getClass() == Short.class ? this.obj.compareTo(Integer.valueOf(((Short)otherObj.obj).shortValue())) : this.obj.compareTo(otherObj.obj);
                if (cmp == 0) {
                    return this.boundaryType - otherObj.boundaryType;
                }
                return cmp;
            }
            throw new ClassCastException("Cannot compare GfxdComparableFuzzy against object of " + this.obj.getClass());
        }

        public Class getObjectType() {
            return this.obj.getClass();
        }

        public String toString() {
            return "GfxdComparableFuzzy: val = " + this.obj + ", boundaryType = " + this.boundaryType;
        }

        public Object getWrappedObject() {
            return this.obj;
        }
    }

    public static class GfxdRangeComparator
    implements Comparator {
        private final String command;

        public GfxdRangeComparator(String command) {
            this.command = command;
        }

        public int compare(Object objOrRange1, Object rangeOrObj2) throws ClassCastException {
            if (rangeOrObj2 instanceof GfxdRange) {
                if (objOrRange1 instanceof GfxdRange) {
                    return ((GfxdRange)objOrRange1).compareTo(rangeOrObj2);
                }
                return -1 * ((GfxdRange)rangeOrObj2).inRange((GfxdComparableFuzzy)objOrRange1);
            }
            if (objOrRange1 instanceof GfxdRange) {
                return ((GfxdRange)objOrRange1).inRange((GfxdComparableFuzzy)rangeOrObj2);
            }
            if (objOrRange1 instanceof GfxdComparableFuzzy) {
                return ((GfxdComparableFuzzy)objOrRange1).compareTo(rangeOrObj2);
            }
            throw new ClassCastException(this.command + ": Cannot compare object of " + objOrRange1.getClass() + " against object of " + rangeOrObj2.getClass());
        }
    }
}

