/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.AbstractRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ClientResolver;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ListRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractClientResolver
implements ClientResolver {
    protected int numberOfBuckets;
    private Set testSet;

    @Override
    public void setNumBuckets(int noOfBuckets) {
        this.numberOfBuckets = noOfBuckets;
    }

    @Override
    public void setTestSet(Set routingObjectSet) {
        this.testSet = routingObjectSet;
    }

    @Override
    public HashSet getListOfRoutingObjects(AbstractRoutingObjectInfo rInfo, SingleHopInformation singleHopInformation) {
        assert (rInfo instanceof ListRoutingObjectInfo);
        ColumnRoutingObjectInfo[] cinfos = ((ListRoutingObjectInfo)rInfo).getListOfInfos();
        HashSet<Integer> routingObjects = new HashSet<Integer>();
        int len = cinfos.length;
        for (int i = 0; i < len; ++i) {
            Integer robj = (Integer)this.getRoutingObject(cinfos[i], singleHopInformation, false);
            if (robj == null) {
                return null;
            }
            if (this.testSet != null) {
                this.testSet.add(robj);
            }
            int bid = Math.abs(robj % this.numberOfBuckets);
            routingObjects.add(bid);
        }
        return routingObjects;
    }
}

