/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.common.TProtocolDirectBinary;
import io.snappydata.thrift.common.ThriftUtils;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.Helper;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;

public final class TCompactProtocolDirect
extends TCompactProtocol
implements TProtocolDirectBinary {
    private final TNonblockingTransport nonBlockingTransport;
    private final boolean useDirectBuffers;

    public TCompactProtocolDirect(TTransport transport, boolean useDirectBuffers) {
        super(transport, -1L, -1L);
        this.nonBlockingTransport = transport instanceof TNonblockingTransport ? (TNonblockingTransport)transport : null;
        this.useDirectBuffers = useDirectBuffers;
    }

    @Override
    public ByteBuffer readDirectBinary() throws TException {
        if (this.useDirectBuffers && this.nonBlockingTransport != null) {
            int length = this.readVarInt32();
            if (length < 0) {
                throw new TProtocolException(2, "Negative length: " + length);
            }
            return ThriftUtils.readByteBuffer(this.nonBlockingTransport, length);
        }
        return super.readBinary();
    }

    public void writeBinary(ByteBuffer buffer) throws TException {
        int length = buffer.remaining();
        this.writeVarInt32(length);
        ThriftUtils.writeByteBuffer(buffer, this.trans_, this.nonBlockingTransport, length);
    }

    private int readVarInt32() throws TException {
        int result = 0;
        int shift = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 5) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b = buf[pos + off];
                result |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b = this.readByte();
                result |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result;
    }

    private void writeVarInt32(int n) throws TException {
        int idx = 0;
        byte[] i32buf = Helper.getI32Buffer(this);
        while (true) {
            if ((n & 0xFFFFFF80) == 0) break;
            i32buf[idx++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        i32buf[idx++] = (byte)n;
        this.trans_.write(i32buf, 0, idx);
    }

    public static class Factory
    implements TProtocolFactory {
        protected final boolean useDirectBuffers;

        public Factory(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        public TProtocol getProtocol(TTransport trans) {
            return new TCompactProtocolDirect(trans, this.useDirectBuffers);
        }
    }
}

