/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.ClobChunk;
import io.snappydata.thrift.ColumnDescriptor;
import io.snappydata.thrift.ColumnValue;
import io.snappydata.thrift.Decimal;
import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.common.Converters;
import io.snappydata.thrift.common.LobService;
import io.snappydata.thrift.common.ThriftUtils;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.unsafe.Platform;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;

public class OptimizedElementArray {
    protected long[] primitives;
    protected Object[] nonPrimitives;
    protected int nonPrimSize;
    protected int headerSize;
    protected transient int hash;
    protected boolean hasLobs;
    protected static final long[] EMPTY = new long[0];

    protected OptimizedElementArray() {
        this.primitives = EMPTY;
    }

    protected OptimizedElementArray(OptimizedElementArray other) {
        this(other, false, true);
    }

    protected OptimizedElementArray(OptimizedElementArray other, boolean otherIsEmpty, boolean copyValues) {
        long[] prims = other.primitives;
        Object[] nonPrims = other.nonPrimitives;
        this.headerSize = other.headerSize;
        this.primitives = prims.length > 0 ? (long[])prims.clone() : EMPTY;
        if (nonPrims != null) {
            this.nonPrimitives = copyValues && !otherIsEmpty ? (Object[])nonPrims.clone() : new Object[nonPrims.length];
        }
        this.nonPrimSize = other.nonPrimSize;
        this.hasLobs = other.hasLobs;
        if (copyValues) {
            this.hash = other.hash;
        } else {
            this.setDefaultNullability();
        }
    }

    public OptimizedElementArray(List<ColumnDescriptor> metadata, boolean checkOutputParameters) {
        int nonPrimitiveIndex = 0;
        int numFields = metadata.size();
        if (checkOutputParameters) {
            for (int rIndex = numFields - 1; rIndex >= 0; --rIndex) {
                if (metadata.get(rIndex).isParameterOut()) continue;
                numFields = rIndex + 1;
                break;
            }
        }
        int headerSize = numFields + 7 >>> 3;
        this.primitives = new long[headerSize + numFields];
        block5: for (int index = 0; index < numFields; ++index) {
            ColumnDescriptor cd = metadata.get(index);
            SnappyType type = cd.type;
            switch (type) {
                case INTEGER: 
                case BIGINT: 
                case DOUBLE: 
                case FLOAT: 
                case DATE: 
                case TIMESTAMP: 
                case TIME: 
                case SMALLINT: 
                case BOOLEAN: 
                case TINYINT: 
                case NULLTYPE: {
                    this.setType(index, type.getValue());
                    continue block5;
                }
                case BLOB: 
                case CLOB: {
                    this.primitives[headerSize + index] = nonPrimitiveIndex++;
                    this.setType(index, -type.getValue());
                    this.hasLobs = true;
                    continue block5;
                }
                default: {
                    this.primitives[headerSize + index] = nonPrimitiveIndex++;
                    this.setType(index, -type.getValue());
                }
            }
        }
        if (nonPrimitiveIndex > 0) {
            this.nonPrimitives = new Object[nonPrimitiveIndex];
            this.nonPrimSize = nonPrimitiveIndex;
        }
        this.headerSize = headerSize;
    }

    private void setDefaultNullability() {
        long[] primitives = this.primitives;
        int end = Platform.LONG_ARRAY_OFFSET + this.size();
        block3: for (int offset = Platform.LONG_ARRAY_OFFSET; offset < end; ++offset) {
            byte snappyType = Platform.getByte((Object)primitives, (long)offset);
            switch (Math.abs(snappyType)) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 12: 
                case 13: 
                case 14: 
                case 24: {
                    if (snappyType >= 0) continue block3;
                    Platform.putByte((Object)primitives, (long)offset, (byte)(-snappyType));
                    continue block3;
                }
                default: {
                    if (snappyType <= 0) continue block3;
                    Platform.putByte((Object)primitives, (long)offset, (byte)(-snappyType));
                }
            }
        }
    }

    public final void setType(int index, int snappyType) {
        Platform.putByte((Object)this.primitives, (long)(Platform.LONG_ARRAY_OFFSET + index), (byte)((byte)snappyType));
    }

    public final int getType(int index) {
        return Platform.getByte((Object)this.primitives, (long)(Platform.LONG_ARRAY_OFFSET + index));
    }

    public final boolean isNull(int index) {
        return this.getType(index) < 0;
    }

    public final boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    public final byte getByte(int index) {
        return (byte)this.primitives[this.headerSize + index];
    }

    public final short getShort(int index) {
        return (short)this.primitives[this.headerSize + index];
    }

    public final int getInt(int index) {
        return (int)this.primitives[this.headerSize + index];
    }

    public final long getLong(int index) {
        return this.primitives[this.headerSize + index];
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final Date getDate(int index) {
        return Converters.getDate(this.getLong(index));
    }

    public final Time getTime(int index) {
        return Converters.getTime(this.getLong(index));
    }

    public final long getDateTimeMillis(int index) {
        return this.getLong(index) * 1000L;
    }

    public final Timestamp getTimestamp(int index) {
        return Converters.getTimestamp(this.getLong(index));
    }

    public final Object getObject(int index) {
        return this.nonPrimitives[(int)this.primitives[this.headerSize + index]];
    }

    public final void initializeLobs(LobService lobService) throws SQLException {
        if (!this.hasLobs || this.nonPrimitives == null) {
            return;
        }
        Object[] nonPrimitives = this.nonPrimitives;
        long[] primitives = this.primitives;
        int headerSize = this.headerSize;
        int size = primitives.length - headerSize;
        for (int index = 0; index < size; ++index) {
            Comparable<BlobChunk> chunk;
            int lobIndex;
            int type = this.getType(index);
            if (type == SnappyType.BLOB.getValue()) {
                lobIndex = (int)primitives[headerSize + index];
                if (!(nonPrimitives[lobIndex] instanceof BlobChunk)) continue;
                chunk = (BlobChunk)nonPrimitives[lobIndex];
                nonPrimitives[lobIndex] = lobService.createBlob((BlobChunk)chunk, false);
                continue;
            }
            if (type != SnappyType.CLOB.getValue() || !(nonPrimitives[lobIndex = (int)primitives[headerSize + index]] instanceof ClobChunk)) continue;
            chunk = (ClobChunk)nonPrimitives[lobIndex];
            nonPrimitives[lobIndex] = lobService.createClob((ClobChunk)chunk, false);
        }
    }

    public final void setNull(int index) {
        int snappyType = this.getType(index);
        if (snappyType > 0) {
            this.setType(index, -snappyType);
        }
    }

    public final void setNull(int index, int snappyType) {
        this.setType(index, -snappyType);
    }

    public final int setNotNull(int index) {
        int snappyType = this.getType(index);
        if (snappyType < 0) {
            snappyType = -snappyType;
            this.setType(index, snappyType);
        }
        return snappyType;
    }

    protected final void setPrimLong(int primIndex, long value) {
        this.primitives[primIndex] = value;
    }

    public final void setBoolean(int index, boolean value) {
        this.setPrimLong(this.headerSize + index, value ? 1L : 0L);
    }

    public final void setByte(int index, byte value) {
        this.setPrimLong(this.headerSize + index, value);
    }

    public final void setShort(int index, short value) {
        this.setPrimLong(this.headerSize + index, value);
    }

    public final void setInt(int index, int value) {
        this.setPrimLong(this.headerSize + index, value);
    }

    public final void setLong(int index, long value) {
        this.setPrimLong(this.headerSize + index, value);
    }

    public final void setFloat(int index, float value) {
        this.setPrimLong(this.headerSize + index, Float.floatToIntBits(value));
    }

    public final void setDouble(int index, double value) {
        this.setPrimLong(this.headerSize + index, Double.doubleToLongBits(value));
    }

    public final void setDateTime(int index, java.util.Date date) {
        this.setPrimLong(this.headerSize + index, Converters.getDateTime(date));
    }

    public final void setTimestamp(int index, Timestamp ts) {
        this.setPrimLong(this.headerSize + index, Converters.getTimestampNanos(ts));
    }

    public final void setTimestamp(int index, java.util.Date ts) {
        this.setPrimLong(this.headerSize + index, Converters.getTimestampNanos(ts));
    }

    public final void setObject(int index, Object value, SnappyType type) {
        if (value != null) {
            this.nonPrimitives[(int)this.primitives[this.headerSize + index]] = value;
            if (this.getType(index) != type.getValue()) {
                this.setType(index, type.getValue());
            }
        } else {
            this.setNull(index, type.getValue());
        }
    }

    public final void writeStandardScheme(BitSet changedColumns, TProtocol oprot) throws TException {
        int size;
        int index;
        long[] primitives = this.primitives;
        Object[] nonPrimitives = this.nonPrimitives;
        int offset = this.headerSize;
        if (changedColumns == null) {
            index = 0;
            size = this.size();
            if (size == 0) {
                return;
            }
        } else {
            index = changedColumns.nextSetBit(0);
            size = 0;
            offset += index;
            if (index < 0) {
                return;
            }
        }
        while (true) {
            oprot.writeStructBegin(ColumnValue.STRUCT_DESC);
            int snappyType = this.getType(index);
            switch (snappyType) {
                case 9: 
                case 10: 
                case 11: {
                    oprot.writeFieldBegin(ColumnValue.STRING_VAL_FIELD_DESC);
                    oprot.writeString((String)nonPrimitives[(int)primitives[offset]]);
                    break;
                }
                case 4: {
                    oprot.writeFieldBegin(ColumnValue.I32_VAL_FIELD_DESC);
                    oprot.writeI32((int)primitives[offset]);
                    break;
                }
                case 5: {
                    oprot.writeFieldBegin(ColumnValue.I64_VAL_FIELD_DESC);
                    oprot.writeI64(primitives[offset]);
                    break;
                }
                case 12: {
                    oprot.writeFieldBegin(ColumnValue.DATE_VAL_FIELD_DESC);
                    oprot.writeI64(primitives[offset]);
                    break;
                }
                case 14: {
                    oprot.writeFieldBegin(ColumnValue.TIMESTAMP_VAL_FIELD_DESC);
                    oprot.writeI64(primitives[offset]);
                    break;
                }
                case 7: {
                    oprot.writeFieldBegin(ColumnValue.DOUBLE_VAL_FIELD_DESC);
                    oprot.writeDouble(Double.longBitsToDouble(primitives[offset]));
                    break;
                }
                case 8: {
                    oprot.writeFieldBegin(ColumnValue.DECIMAL_VAL_FIELD_DESC);
                    BigDecimal decimal = (BigDecimal)nonPrimitives[(int)primitives[offset]];
                    Converters.getDecimal(decimal).write(oprot);
                    break;
                }
                case 6: {
                    oprot.writeFieldBegin(ColumnValue.FLOAT_VAL_FIELD_DESC);
                    oprot.writeI32((int)primitives[offset]);
                    break;
                }
                case 3: {
                    oprot.writeFieldBegin(ColumnValue.I16_VAL_FIELD_DESC);
                    oprot.writeI16((short)primitives[offset]);
                    break;
                }
                case 1: {
                    oprot.writeFieldBegin(ColumnValue.BOOL_VAL_FIELD_DESC);
                    oprot.writeBool(primitives[offset] != 0L);
                    break;
                }
                case 2: {
                    oprot.writeFieldBegin(ColumnValue.BYTE_VAL_FIELD_DESC);
                    oprot.writeByte((byte)primitives[offset]);
                    break;
                }
                case 13: {
                    oprot.writeFieldBegin(ColumnValue.TIME_VAL_FIELD_DESC);
                    oprot.writeI64(primitives[offset]);
                    break;
                }
                case 19: 
                case 20: 
                case 25: {
                    oprot.writeFieldBegin(ColumnValue.CLOB_VAL_FIELD_DESC);
                    ClobChunk clob = (ClobChunk)nonPrimitives[(int)primitives[offset]];
                    clob.write(oprot);
                    break;
                }
                case 18: {
                    oprot.writeFieldBegin(ColumnValue.BLOB_VAL_FIELD_DESC);
                    BlobChunk blob = (BlobChunk)nonPrimitives[(int)primitives[offset]];
                    blob.write(oprot);
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    oprot.writeFieldBegin(ColumnValue.BINARY_VAL_FIELD_DESC);
                    byte[] bytes = (byte[])nonPrimitives[(int)primitives[offset]];
                    oprot.writeBinary(ByteBuffer.wrap(bytes));
                    break;
                }
                case 21: {
                    oprot.writeFieldBegin(ColumnValue.ARRAY_VAL_FIELD_DESC);
                    List list = (List)nonPrimitives[(int)primitives[offset]];
                    oprot.writeListBegin(new TList(12, list.size()));
                    for (Object cv : list) {
                        ((ColumnValue)((Object)cv)).write(oprot);
                    }
                    oprot.writeListEnd();
                    break;
                }
                case 22: {
                    Object cv;
                    oprot.writeFieldBegin(ColumnValue.MAP_VAL_FIELD_DESC);
                    Map map = (Map)nonPrimitives[(int)primitives[offset]];
                    oprot.writeMapBegin(new TMap(12, 12, map.size()));
                    cv = map.entrySet().iterator();
                    while (cv.hasNext()) {
                        Map.Entry entry = cv.next();
                        ((ColumnValue)((Object)entry.getKey())).write(oprot);
                        ((ColumnValue)((Object)entry.getValue())).write(oprot);
                    }
                    oprot.writeMapEnd();
                    break;
                }
                case 23: {
                    oprot.writeFieldBegin(ColumnValue.STRUCT_VAL_FIELD_DESC);
                    List struct = (List)nonPrimitives[(int)primitives[offset]];
                    oprot.writeListBegin(new TList(12, struct.size()));
                    for (ColumnValue cv : struct) {
                        cv.write(oprot);
                    }
                    oprot.writeListEnd();
                    break;
                }
                case 24: {
                    oprot.writeFieldBegin(ColumnValue.NULL_VAL_FIELD_DESC);
                    oprot.writeBool(false);
                    break;
                }
                case 26: {
                    oprot.writeFieldBegin(ColumnValue.JAVA_VAL_FIELD_DESC);
                    byte[] objBytes = ((Converters.JavaObjectWrapper)nonPrimitives[(int)primitives[offset]]).getSerialized();
                    oprot.writeBinary(ByteBuffer.wrap(objBytes));
                    break;
                }
                default: {
                    if (snappyType < 0) {
                        oprot.writeFieldBegin(ColumnValue.NULL_VAL_FIELD_DESC);
                        oprot.writeBool(true);
                        break;
                    }
                    throw new TProtocolException("write: unhandled typeId=" + snappyType + " at index=" + index + " with size=" + size + "(changedCols=" + changedColumns + ")");
                }
            }
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
            if (changedColumns == null) {
                ++offset;
                if (++index < size) continue;
                return;
            }
            index = changedColumns.nextSetBit(index);
            offset = this.headerSize + index;
            if (index < 0) break;
        }
    }

    public final void readStandardScheme(int numFields, TProtocol iprot) throws TException {
        this.initialize(numFields);
        long[] primitives = this.primitives;
        int nonPrimSize = 0;
        int offset = this.headerSize;
        int index = 0;
        while (index < numFields) {
            iprot.readStructBegin();
            TField field = iprot.readFieldBegin();
            ColumnValue._Fields setField = ColumnValue._Fields.findByThriftId(field.id);
            SnappyType nullType = null;
            if (setField != null) {
                switch (setField) {
                    case STRING_VAL: {
                        if (field.type == ColumnValue.STRING_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            String str = iprot.readString();
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = str;
                            this.setType(index, SnappyType.VARCHAR.getValue());
                            break;
                        }
                        nullType = SnappyType.VARCHAR;
                        break;
                    }
                    case I32_VAL: {
                        if (field.type == ColumnValue.I32_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI32());
                            this.setType(index, SnappyType.INTEGER.getValue());
                            break;
                        }
                        nullType = SnappyType.INTEGER;
                        break;
                    }
                    case I64_VAL: {
                        if (field.type == ColumnValue.I64_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI64());
                            this.setType(index, SnappyType.BIGINT.getValue());
                            break;
                        }
                        nullType = SnappyType.BIGINT;
                        break;
                    }
                    case DATE_VAL: {
                        if (field.type == ColumnValue.DATE_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI64());
                            this.setType(index, SnappyType.DATE.getValue());
                            break;
                        }
                        nullType = SnappyType.DATE;
                        break;
                    }
                    case TIMESTAMP_VAL: {
                        if (field.type == ColumnValue.TIMESTAMP_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI64());
                            this.setType(index, SnappyType.TIMESTAMP.getValue());
                            break;
                        }
                        nullType = SnappyType.TIMESTAMP;
                        break;
                    }
                    case DOUBLE_VAL: {
                        if (field.type == ColumnValue.DOUBLE_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, Double.doubleToLongBits(iprot.readDouble()));
                            this.setType(index, SnappyType.DOUBLE.getValue());
                            break;
                        }
                        nullType = SnappyType.DOUBLE;
                        break;
                    }
                    case DECIMAL_VAL: {
                        if (field.type == ColumnValue.DECIMAL_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            Decimal decimal = new Decimal();
                            decimal.read(iprot);
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = Converters.getBigDecimal(decimal);
                            this.setType(index, SnappyType.DECIMAL.getValue());
                            break;
                        }
                        nullType = SnappyType.DECIMAL;
                        break;
                    }
                    case FLOAT_VAL: {
                        if (field.type == ColumnValue.FLOAT_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI32());
                            this.setType(index, SnappyType.FLOAT.getValue());
                            break;
                        }
                        nullType = SnappyType.FLOAT;
                        break;
                    }
                    case I16_VAL: {
                        if (field.type == ColumnValue.I16_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI16());
                            this.setType(index, SnappyType.SMALLINT.getValue());
                            break;
                        }
                        nullType = SnappyType.SMALLINT;
                        break;
                    }
                    case BOOL_VAL: {
                        if (field.type == ColumnValue.BOOL_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readBool() ? 1L : 0L);
                            this.setType(index, SnappyType.BOOLEAN.getValue());
                            break;
                        }
                        nullType = SnappyType.BOOLEAN;
                        break;
                    }
                    case BYTE_VAL: {
                        if (field.type == ColumnValue.BYTE_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readByte());
                            this.setType(index, SnappyType.TINYINT.getValue());
                            break;
                        }
                        nullType = SnappyType.TINYINT;
                        break;
                    }
                    case TIME_VAL: {
                        if (field.type == ColumnValue.TIME_VAL_FIELD_DESC.type) {
                            this.setPrimLong(offset, iprot.readI64());
                            this.setType(index, SnappyType.TIME.getValue());
                            break;
                        }
                        nullType = SnappyType.TIME;
                        break;
                    }
                    case CLOB_VAL: {
                        if (field.type == ColumnValue.CLOB_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            ClobChunk clob = new ClobChunk();
                            clob.read(iprot);
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = clob;
                            this.setType(index, SnappyType.CLOB.getValue());
                            this.hasLobs = true;
                            break;
                        }
                        nullType = SnappyType.CLOB;
                        break;
                    }
                    case BLOB_VAL: {
                        if (field.type == ColumnValue.BLOB_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            BlobChunk blob = new BlobChunk();
                            blob.read(iprot);
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = blob;
                            this.setType(index, SnappyType.BLOB.getValue());
                            this.hasLobs = true;
                            break;
                        }
                        nullType = SnappyType.BLOB;
                        break;
                    }
                    case BINARY_VAL: {
                        if (field.type == ColumnValue.BINARY_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            byte[] bytes = ThriftUtils.toBytes(iprot.readBinary());
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = bytes;
                            this.setType(index, SnappyType.VARBINARY.getValue());
                            break;
                        }
                        nullType = SnappyType.VARBINARY;
                        break;
                    }
                    case NULL_VAL: {
                        this.setType(index, iprot.readBool() ? -SnappyType.NULLTYPE.getValue() : SnappyType.NULLTYPE.getValue());
                        break;
                    }
                    case ARRAY_VAL: 
                    case STRUCT_VAL: {
                        int i;
                        byte fieldType;
                        SnappyType fieldSQLType;
                        if (setField == ColumnValue._Fields.ARRAY_VAL) {
                            fieldSQLType = SnappyType.ARRAY;
                            fieldType = ColumnValue.ARRAY_VAL_FIELD_DESC.type;
                        } else {
                            fieldSQLType = SnappyType.STRUCT;
                            fieldType = ColumnValue.STRUCT_VAL_FIELD_DESC.type;
                        }
                        if (field.type == fieldType) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            TList alist = iprot.readListBegin();
                            int listSize = alist.size;
                            ArrayList<ColumnValue> values = new ArrayList<ColumnValue>(listSize);
                            for (i = 0; i < listSize; ++i) {
                                ColumnValue cv = new ColumnValue();
                                cv.read(iprot);
                                values.add(cv);
                            }
                            iprot.readListEnd();
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = values;
                            this.setType(index, fieldSQLType.getValue());
                            break;
                        }
                        nullType = fieldSQLType;
                        break;
                    }
                    case MAP_VAL: {
                        int i;
                        if (field.type == ColumnValue.MAP_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            TMap m = iprot.readMapBegin();
                            int mapSize = m.size;
                            HashMap<ColumnValue, ColumnValue> map = new HashMap<ColumnValue, ColumnValue>(mapSize << 1);
                            for (i = 0; i < mapSize; ++i) {
                                ColumnValue k = new ColumnValue();
                                ColumnValue v = new ColumnValue();
                                k.read(iprot);
                                v.read(iprot);
                                map.put(k, v);
                            }
                            iprot.readMapEnd();
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = map;
                            this.setType(index, SnappyType.MAP.getValue());
                            break;
                        }
                        nullType = SnappyType.MAP;
                        break;
                    }
                    case JAVA_VAL: {
                        if (field.type == ColumnValue.JAVA_VAL_FIELD_DESC.type) {
                            this.ensureNonPrimCapacity(nonPrimSize);
                            byte[] serializedBytes = ThriftUtils.toBytes(iprot.readBinary());
                            primitives[offset] = nonPrimSize;
                            this.nonPrimitives[nonPrimSize++] = new Converters.JavaObjectWrapper(serializedBytes);
                            this.setType(index, SnappyType.JAVA_OBJECT.getValue());
                            break;
                        }
                        nullType = SnappyType.JAVA_OBJECT;
                        break;
                    }
                    default: {
                        throw ClientSharedUtils.newRuntimeException((String)("unknown column type = " + (Object)((Object)setField)), null);
                    }
                }
                if (nullType != null) {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    this.setType(index, -nullType.getValue());
                }
            } else {
                TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                this.setType(index, -SnappyType.NULLTYPE.getValue());
            }
            iprot.readFieldEnd();
            iprot.readFieldBegin();
            iprot.readStructEnd();
            ++index;
            ++offset;
        }
        this.nonPrimSize = nonPrimSize;
    }

    public final void initialize(int numFields) {
        int headerSize = numFields + 7 >>> 3;
        this.primitives = new long[headerSize + numFields];
        this.nonPrimitives = null;
        this.nonPrimSize = 0;
        this.headerSize = headerSize;
        this.hash = 0;
        this.hasLobs = false;
    }

    public final void setColumnValue(int index, ColumnValue cv) throws SQLException {
        ColumnValue._Fields setField = (ColumnValue._Fields)cv.getSetField();
        if (setField != null) {
            int sqlTypeId;
            Object fieldVal = Boolean.FALSE;
            switch (setField) {
                case STRING_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.VARCHAR.getValue();
                    break;
                }
                case I32_VAL: {
                    sqlTypeId = SnappyType.INTEGER.getValue();
                    break;
                }
                case I64_VAL: {
                    sqlTypeId = SnappyType.BIGINT.getValue();
                    break;
                }
                case DATE_VAL: {
                    sqlTypeId = SnappyType.DATE.getValue();
                    break;
                }
                case TIMESTAMP_VAL: {
                    sqlTypeId = SnappyType.TIMESTAMP.getValue();
                    break;
                }
                case DOUBLE_VAL: {
                    sqlTypeId = SnappyType.DOUBLE.getValue();
                    break;
                }
                case DECIMAL_VAL: {
                    Decimal decimal = (Decimal)cv.getFieldValue();
                    fieldVal = decimal != null ? Converters.getBigDecimal(decimal) : null;
                    sqlTypeId = SnappyType.DECIMAL.getValue();
                    break;
                }
                case FLOAT_VAL: {
                    sqlTypeId = SnappyType.FLOAT.getValue();
                    break;
                }
                case I16_VAL: {
                    sqlTypeId = SnappyType.SMALLINT.getValue();
                    break;
                }
                case BOOL_VAL: {
                    sqlTypeId = SnappyType.BOOLEAN.getValue();
                    break;
                }
                case BYTE_VAL: {
                    sqlTypeId = SnappyType.TINYINT.getValue();
                    break;
                }
                case TIME_VAL: {
                    sqlTypeId = SnappyType.TIME.getValue();
                    break;
                }
                case CLOB_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.CLOB.getValue();
                    this.hasLobs = true;
                    break;
                }
                case BLOB_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.BLOB.getValue();
                    this.hasLobs = true;
                    break;
                }
                case BINARY_VAL: {
                    fieldVal = cv.getBinary_val();
                    sqlTypeId = SnappyType.VARBINARY.getValue();
                    break;
                }
                case NULL_VAL: {
                    this.setType(index, cv.getNull_val() ? -SnappyType.NULLTYPE.getValue() : SnappyType.NULLTYPE.getValue());
                    return;
                }
                case ARRAY_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.ARRAY.getValue();
                    break;
                }
                case MAP_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.MAP.getValue();
                    break;
                }
                case STRUCT_VAL: {
                    fieldVal = cv.getFieldValue();
                    sqlTypeId = SnappyType.STRUCT.getValue();
                    break;
                }
                case JAVA_VAL: {
                    byte[] serializedBytes = cv.getJava_val();
                    fieldVal = serializedBytes != null ? new Converters.JavaObjectWrapper(serializedBytes) : null;
                    sqlTypeId = SnappyType.JAVA_OBJECT.getValue();
                    break;
                }
                default: {
                    throw ClientSharedUtils.newRuntimeException((String)("unknown column value: " + (cv.getFieldValue() != null ? cv : "null")), null);
                }
            }
            if (fieldVal == Boolean.FALSE) {
                this.setPrimLong(this.headerSize + index, cv.getPrimitiveLong());
                this.setType(index, sqlTypeId);
            } else if (fieldVal != null) {
                this.ensureNonPrimCapacity(this.nonPrimSize);
                this.primitives[this.headerSize + index] = this.nonPrimSize;
                this.nonPrimitives[this.nonPrimSize++] = fieldVal;
                this.setType(index, sqlTypeId);
            } else {
                this.setType(index, -sqlTypeId);
            }
        } else {
            this.setType(index, -SnappyType.NULLTYPE.getValue());
        }
    }

    protected final void ensureNonPrimCapacity(int nonPrimSize) {
        if (this.nonPrimitives != null) {
            int capacity = this.nonPrimitives.length;
            if (nonPrimSize >= capacity) {
                int newCapacity = Math.min(capacity + (capacity >>> 1), this.size());
                Object[] newNonPrims = new Object[newCapacity];
                System.arraycopy(this.nonPrimitives, 0, newNonPrims, 0, capacity);
                this.nonPrimitives = newNonPrims;
            }
        } else {
            this.nonPrimitives = new Object[4];
        }
    }

    public final int size() {
        return this.primitives.length - this.headerSize;
    }

    public void clear() {
        this.setDefaultNullability();
        Arrays.fill(this.nonPrimitives, null);
        this.hash = 0;
    }

    public int hashCode() {
        Object[] nps;
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        long[] prims = this.primitives;
        if (prims != null && prims.length > 0) {
            for (long l : prims) {
                h = ResolverUtils.addLongToHashOpt((long)l, (int)h);
            }
        }
        if ((nps = this.nonPrimitives) != null && nps.length > 0) {
            for (Object o : nps) {
                h = ResolverUtils.addIntToHashOpt((int)(o != null ? o.hashCode() : -1), (int)h);
            }
        }
        this.hash = h;
        return this.hash;
    }

    public boolean equals(Object other) {
        return other instanceof OptimizedElementArray && this.equals((OptimizedElementArray)other);
    }

    public boolean equals(OptimizedElementArray other) {
        return this.nonPrimSize == other.nonPrimSize && this.hasLobs == other.hasLobs && Arrays.equals(this.primitives, other.primitives) && Arrays.equals(this.nonPrimitives, other.nonPrimitives);
    }

    public String toString() {
        long[] primitives = this.primitives;
        Object[] nonPrimitives = this.nonPrimitives;
        int offset = this.headerSize;
        int size = this.size();
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (index < size) {
            if (index != 0) {
                sb.append(',');
            }
            int snappyType = this.getType(index);
            sb.append("TYPE=").append((Object)SnappyType.findByValue(Math.abs(snappyType))).append(" VALUE=");
            switch (snappyType) {
                case 1: {
                    sb.append(primitives[offset] != 0L);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    sb.append(primitives[offset]);
                    break;
                }
                case 6: {
                    sb.append(Float.intBitsToFloat((int)primitives[offset]));
                    break;
                }
                case 7: {
                    sb.append(Double.longBitsToDouble(primitives[offset]));
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: {
                    Object o = nonPrimitives[(int)primitives[offset]];
                    if (o != null) {
                        sb.append("(type=").append(o.getClass().getName()).append(')');
                    }
                    sb.append(nonPrimitives[(int)primitives[offset]]);
                    break;
                }
                case 12: {
                    sb.append(primitives[offset]).append(',');
                    break;
                }
                case 13: {
                    sb.append(primitives[offset]).append(',');
                    break;
                }
                case 14: {
                    sb.append(primitives[offset]).append(',');
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    byte[] bytes = (byte[])nonPrimitives[(int)primitives[offset]];
                    TBaseHelper.toString((ByteBuffer)ByteBuffer.wrap(bytes), (StringBuilder)sb);
                    break;
                }
                case 24: {
                    sb.append("NullType=false");
                    break;
                }
                default: {
                    if (snappyType < 0) {
                        sb.append("NULL");
                        break;
                    }
                    sb.append("UNKNOWN");
                }
            }
            ++index;
            ++offset;
        }
        return sb.toString();
    }

    static {
        if (SnappyType.BOOLEAN.getValue() != 1) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.TINYINT.getValue() != 2) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.SMALLINT.getValue() != 3) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.INTEGER.getValue() != 4) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.BIGINT.getValue() != 5) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.FLOAT.getValue() != 6) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.DOUBLE.getValue() != 7) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.DECIMAL.getValue() != 8) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.CHAR.getValue() != 9) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.VARCHAR.getValue() != 10) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.LONGVARCHAR.getValue() != 11) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.DATE.getValue() != 12) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.TIME.getValue() != 13) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.TIMESTAMP.getValue() != 14) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.BINARY.getValue() != 15) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.VARBINARY.getValue() != 16) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.LONGVARBINARY.getValue() != 17) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.BLOB.getValue() != 18) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.CLOB.getValue() != 19) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.SQLXML.getValue() != 20) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.ARRAY.getValue() != 21) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.MAP.getValue() != 22) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.STRUCT.getValue() != 23) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.NULLTYPE.getValue() != 24) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.JSON.getValue() != 25) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.JAVA_OBJECT.getValue() != 26) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.OTHER.getValue() != 27) {
            throw new AssertionError((Object)"typeId mismatch");
        }
        if (SnappyType.findByValue(28) != null) {
            throw new AssertionError((Object)"unhandled typeId 29");
        }
    }
}

