/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.Converter;
import com.pivotal.gemfirexd.internal.shared.common.RoutingObjectInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;

public abstract class AbstractRoutingObjectInfo
implements RoutingObjectInfo {
    private int valueType;
    protected Object value;
    private transient Object resolver;

    public AbstractRoutingObjectInfo() {
    }

    public AbstractRoutingObjectInfo(int isParameter, Object val, Object resolver) {
        this.valueType = isParameter;
        this.value = val;
        this.resolver = resolver;
    }

    @Override
    public boolean isValueAConstant() {
        return this.valueType != 2;
    }

    @Override
    public Object getConstantObjectValue() {
        if (this.valueType == 1) {
            return this.value;
        }
        return null;
    }

    @Override
    public int getParameterNumber() {
        if (this.valueType == 2) {
            return (Integer)this.value;
        }
        return -1;
    }

    @Override
    public Object getResolver() {
        return this.resolver;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(this.valueType);
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.valueType = in.readByte();
        this.value = in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("value type: ");
        sb.append(this.getValueType());
        sb.append(", value: ");
        sb.append(this.value);
        return sb.toString();
    }

    private String getValueType() {
        if (this.valueType == 2) {
            return "PARAMETER";
        }
        if (this.valueType == 1) {
            return "CONSTANT";
        }
        return "INVALID";
    }

    public abstract int computeHashCode(int var1, int var2, boolean var3);

    public abstract void setActualValue(Object[] var1, Converter var2) throws SQLException;

    public abstract int getTypeFormatId();

    public abstract Object getActualValue();

    public abstract int dvdEquivalenthashCode();

    public boolean isListRoutingObjectInfo() {
        return false;
    }
}

