/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.common.SocketParameters;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.thrift.transport.TTransportException;

public abstract class SSLFactory {
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"TLSv1.2", "Default", "TLSv1", "TLS"};

    private SSLFactory() {
    }

    public static SSLSocket getClientSocket(InetAddress hostAddress, int port, int timeout, SocketParameters params) throws TTransportException {
        SSLContext ctx = SSLFactory.createSSLContext(params);
        return SSLFactory.createClient(ctx.getSocketFactory(), hostAddress, port, timeout, params);
    }

    private static SSLSocket createClient(SSLSocketFactory factory, InetAddress hostAddress, int port, int timeout, SocketParameters params) throws TTransportException {
        try {
            SSLSocket socket = (SSLSocket)factory.createSocket(hostAddress, port);
            socket.setSoTimeout(timeout);
            if (params != null) {
                if (params.getSSLEnabledProtocols() != null) {
                    socket.setEnabledProtocols(params.getSSLEnabledProtocols());
                }
                if (params.getSSLCipherSuites() != null) {
                    socket.setEnabledCipherSuites(params.getSSLCipherSuites());
                }
            }
            return socket;
        }
        catch (IOException ioe) {
            throw new TTransportException(1, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new TTransportException(1, "Could not connect to " + hostAddress + " on port " + port, (Throwable)e);
        }
    }

    public static SSLEngine createEngine(String peerHostName, int peerPort, SocketParameters params, boolean forClient) throws TTransportException {
        SSLContext ctx = SSLFactory.createSSLContext(params);
        SSLEngine engine = ctx.createSSLEngine(peerHostName, peerPort);
        if (params != null) {
            if (params.getSSLEnabledProtocols() != null) {
                engine.setEnabledProtocols(params.getSSLEnabledProtocols());
            }
            if (params.getSSLCipherSuites() != null) {
                engine.setEnabledCipherSuites(params.getSSLCipherSuites());
            }
            if (forClient) {
                engine.setUseClientMode(true);
            } else {
                engine.setUseClientMode(false);
                engine.setNeedClientAuth(params.getSSLClientAuth());
            }
        }
        return engine;
    }

    public static SSLContext createSSLContext(SocketParameters params) throws TTransportException {
        SSLContext ctx;
        FileInputStream tsInput = null;
        FileInputStream ksInput = null;
        try {
            if (params == null || !params.hasSSLParams()) {
                SSLContext sSLContext = SSLContext.getDefault();
                return sSLContext;
            }
            if (!params.isSSLKeyStoreSet() && !params.isSSLTrustStoreSet()) {
                throw new TTransportException("Either one of the KeyStore or TrustStore must be set in SSLSocketParameters having explicit SSL parameters");
            }
            if (params.getSSLProtocol() != null) {
                ctx = SSLContext.getInstance(params.getSSLProtocol());
            } else {
                ctx = null;
                NoSuchAlgorithmException failure = null;
                for (String protocol : DEFAULT_PROTOCOLS) {
                    try {
                        ctx = SSLContext.getInstance(protocol);
                        break;
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        failure = nsae;
                    }
                }
                if (failure != null) {
                    throw failure;
                }
                if (ctx == null) {
                    throw new NoSuchAlgorithmException(Arrays.toString(DEFAULT_PROTOCOLS));
                }
            }
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (params.isSSLTrustStoreSet()) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(params.getSSLTrustManagerType());
                KeyStore ts = KeyStore.getInstance(params.getSSLTrustStoreType());
                tsInput = new FileInputStream(params.getSSLTrustStore());
                ts.load(tsInput, params.getSSLTrustPass().toCharArray());
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            }
            if (params.isSSLKeyStoreSet()) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(params.getSSLKeyManagerType());
                KeyStore ks = KeyStore.getInstance(params.getSSLKeyStoreType());
                char[] keyPass = params.getSSLKeyPass() != null ? params.getSSLKeyPass().toCharArray() : null;
                ksInput = new FileInputStream(params.getSSLKeyStore());
                ks.load(ksInput, keyPass);
                kmf.init(ks, keyPass);
                keyManagers = kmf.getKeyManagers();
            }
            ctx.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            throw new TTransportException("Error creating the transport", (Throwable)e);
        }
        finally {
            if (tsInput != null) {
                try {
                    tsInput.close();
                }
                catch (Exception exception) {}
            }
            if (ksInput != null) {
                try {
                    ksInput.close();
                }
                catch (Exception exception) {}
            }
        }
        return ctx;
    }
}

