/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ConnectionProperties
implements TBase<ConnectionProperties, _Fields>,
Serializable,
Cloneable,
Comparable<ConnectionProperties> {
    private static final TStruct STRUCT_DESC = new TStruct("ConnectionProperties");
    private static final TField CONN_ID_FIELD_DESC = new TField("connId", 10, 1);
    private static final TField CLIENT_HOST_NAME_FIELD_DESC = new TField("clientHostName", 11, 2);
    private static final TField CLIENT_ID_FIELD_DESC = new TField("clientID", 11, 3);
    private static final TField USER_NAME_FIELD_DESC = new TField("userName", 11, 4);
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 5);
    private static final TField DEFAULT_SCHEMA_FIELD_DESC = new TField("defaultSchema", 11, 6);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long connId;
    public String clientHostName;
    public String clientID;
    public String userName;
    public ByteBuffer token;
    public String defaultSchema;
    private static final int __CONNID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ConnectionProperties() {
    }

    public ConnectionProperties(long connId, String clientHostName, String clientID) {
        this();
        this.connId = connId;
        this.setConnIdIsSet(true);
        this.clientHostName = clientHostName;
        this.clientID = clientID;
    }

    public ConnectionProperties(ConnectionProperties other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.connId = other.connId;
        if (other.isSetClientHostName()) {
            this.clientHostName = other.clientHostName;
        }
        if (other.isSetClientID()) {
            this.clientID = other.clientID;
        }
        if (other.isSetUserName()) {
            this.userName = other.userName;
        }
        if (other.isSetToken()) {
            this.token = TBaseHelper.copyBinary((ByteBuffer)other.token);
        }
        if (other.isSetDefaultSchema()) {
            this.defaultSchema = other.defaultSchema;
        }
    }

    public ConnectionProperties deepCopy() {
        return new ConnectionProperties(this);
    }

    public void clear() {
        this.setConnIdIsSet(false);
        this.connId = 0L;
        this.clientHostName = null;
        this.clientID = null;
        this.userName = null;
        this.token = null;
        this.defaultSchema = null;
    }

    public long getConnId() {
        return this.connId;
    }

    public ConnectionProperties setConnId(long connId) {
        this.connId = connId;
        this.setConnIdIsSet(true);
        return this;
    }

    public void unsetConnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetConnId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setConnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public ConnectionProperties setClientHostName(String clientHostName) {
        this.clientHostName = clientHostName;
        return this;
    }

    public void unsetClientHostName() {
        this.clientHostName = null;
    }

    public boolean isSetClientHostName() {
        return this.clientHostName != null;
    }

    public void setClientHostNameIsSet(boolean value) {
        if (!value) {
            this.clientHostName = null;
        }
    }

    public String getClientID() {
        return this.clientID;
    }

    public ConnectionProperties setClientID(String clientID) {
        this.clientID = clientID;
        return this;
    }

    public void unsetClientID() {
        this.clientID = null;
    }

    public boolean isSetClientID() {
        return this.clientID != null;
    }

    public void setClientIDIsSet(boolean value) {
        if (!value) {
            this.clientID = null;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public ConnectionProperties setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public void unsetUserName() {
        this.userName = null;
    }

    public boolean isSetUserName() {
        return this.userName != null;
    }

    public void setUserNameIsSet(boolean value) {
        if (!value) {
            this.userName = null;
        }
    }

    public byte[] getToken() {
        this.setToken(TBaseHelper.rightSize((ByteBuffer)this.token));
        return this.token == null ? null : this.token.array();
    }

    public ByteBuffer bufferForToken() {
        return TBaseHelper.copyBinary((ByteBuffer)this.token);
    }

    public ConnectionProperties setToken(byte[] token) {
        this.token = token == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(token, token.length));
        return this;
    }

    public ConnectionProperties setToken(ByteBuffer token) {
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public ConnectionProperties setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    public void unsetDefaultSchema() {
        this.defaultSchema = null;
    }

    public boolean isSetDefaultSchema() {
        return this.defaultSchema != null;
    }

    public void setDefaultSchemaIsSet(boolean value) {
        if (!value) {
            this.defaultSchema = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CONN_ID: {
                if (value == null) {
                    this.unsetConnId();
                    break;
                }
                this.setConnId((Long)value);
                break;
            }
            case CLIENT_HOST_NAME: {
                if (value == null) {
                    this.unsetClientHostName();
                    break;
                }
                this.setClientHostName((String)value);
                break;
            }
            case CLIENT_ID: {
                if (value == null) {
                    this.unsetClientID();
                    break;
                }
                this.setClientID((String)value);
                break;
            }
            case USER_NAME: {
                if (value == null) {
                    this.unsetUserName();
                    break;
                }
                this.setUserName((String)value);
                break;
            }
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((ByteBuffer)value);
                break;
            }
            case DEFAULT_SCHEMA: {
                if (value == null) {
                    this.unsetDefaultSchema();
                    break;
                }
                this.setDefaultSchema((String)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CONN_ID: {
                return this.getConnId();
            }
            case CLIENT_HOST_NAME: {
                return this.getClientHostName();
            }
            case CLIENT_ID: {
                return this.getClientID();
            }
            case USER_NAME: {
                return this.getUserName();
            }
            case TOKEN: {
                return this.getToken();
            }
            case DEFAULT_SCHEMA: {
                return this.getDefaultSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CONN_ID: {
                return this.isSetConnId();
            }
            case CLIENT_HOST_NAME: {
                return this.isSetClientHostName();
            }
            case CLIENT_ID: {
                return this.isSetClientID();
            }
            case USER_NAME: {
                return this.isSetUserName();
            }
            case TOKEN: {
                return this.isSetToken();
            }
            case DEFAULT_SCHEMA: {
                return this.isSetDefaultSchema();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ConnectionProperties) {
            return this.equals((ConnectionProperties)that);
        }
        return false;
    }

    public boolean equals(ConnectionProperties that) {
        if (that == null) {
            return false;
        }
        boolean this_present_connId = true;
        boolean that_present_connId = true;
        if (this_present_connId || that_present_connId) {
            if (!this_present_connId || !that_present_connId) {
                return false;
            }
            if (this.connId != that.connId) {
                return false;
            }
        }
        boolean this_present_clientHostName = this.isSetClientHostName();
        boolean that_present_clientHostName = that.isSetClientHostName();
        if (this_present_clientHostName || that_present_clientHostName) {
            if (!this_present_clientHostName || !that_present_clientHostName) {
                return false;
            }
            if (!this.clientHostName.equals(that.clientHostName)) {
                return false;
            }
        }
        boolean this_present_clientID = this.isSetClientID();
        boolean that_present_clientID = that.isSetClientID();
        if (this_present_clientID || that_present_clientID) {
            if (!this_present_clientID || !that_present_clientID) {
                return false;
            }
            if (!this.clientID.equals(that.clientID)) {
                return false;
            }
        }
        boolean this_present_userName = this.isSetUserName();
        boolean that_present_userName = that.isSetUserName();
        if (this_present_userName || that_present_userName) {
            if (!this_present_userName || !that_present_userName) {
                return false;
            }
            if (!this.userName.equals(that.userName)) {
                return false;
            }
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_defaultSchema = this.isSetDefaultSchema();
        boolean that_present_defaultSchema = that.isSetDefaultSchema();
        if (this_present_defaultSchema || that_present_defaultSchema) {
            if (!this_present_defaultSchema || !that_present_defaultSchema) {
                return false;
            }
            if (!this.defaultSchema.equals(that.defaultSchema)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_connId = true;
        list.add(present_connId);
        if (present_connId) {
            list.add(this.connId);
        }
        boolean present_clientHostName = this.isSetClientHostName();
        list.add(present_clientHostName);
        if (present_clientHostName) {
            list.add(this.clientHostName);
        }
        boolean present_clientID = this.isSetClientID();
        list.add(present_clientID);
        if (present_clientID) {
            list.add(this.clientID);
        }
        boolean present_userName = this.isSetUserName();
        list.add(present_userName);
        if (present_userName) {
            list.add(this.userName);
        }
        boolean present_token = this.isSetToken();
        list.add(present_token);
        if (present_token) {
            list.add(this.token);
        }
        boolean present_defaultSchema = this.isSetDefaultSchema();
        list.add(present_defaultSchema);
        if (present_defaultSchema) {
            list.add(this.defaultSchema);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ConnectionProperties other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetConnId()).compareTo(other.isSetConnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConnId() && (lastComparison = TBaseHelper.compareTo((long)this.connId, (long)other.connId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetClientHostName()).compareTo(other.isSetClientHostName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetClientHostName() && (lastComparison = TBaseHelper.compareTo((String)this.clientHostName, (String)other.clientHostName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetClientID()).compareTo(other.isSetClientID());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetClientID() && (lastComparison = TBaseHelper.compareTo((String)this.clientID, (String)other.clientID)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUserName()).compareTo(other.isSetUserName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUserName() && (lastComparison = TBaseHelper.compareTo((String)this.userName, (String)other.userName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetToken()).compareTo(other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((Comparable)this.token, (Comparable)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefaultSchema()).compareTo(other.isSetDefaultSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefaultSchema() && (lastComparison = TBaseHelper.compareTo((String)this.defaultSchema, (String)other.defaultSchema)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectionProperties(");
        boolean first = true;
        sb.append("connId:");
        sb.append(this.connId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("clientHostName:");
        if (this.clientHostName == null) {
            sb.append("null");
        } else {
            sb.append(this.clientHostName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("clientID:");
        if (this.clientID == null) {
            sb.append("null");
        } else {
            sb.append(this.clientID);
        }
        first = false;
        if (this.isSetUserName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("userName:");
            if (this.userName == null) {
                sb.append("null");
            } else {
                sb.append(this.userName);
            }
            first = false;
        }
        if (this.isSetToken()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("token:");
            if (this.token == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.token, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetDefaultSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("defaultSchema:");
            if (this.defaultSchema == null) {
                sb.append("null");
            } else {
                sb.append(this.defaultSchema);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.clientHostName == null) {
            throw new TProtocolException("Required field 'clientHostName' was not present! Struct: " + this.toString());
        }
        if (this.clientID == null) {
            throw new TProtocolException("Required field 'clientID' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ConnectionPropertiesStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ConnectionPropertiesTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.USER_NAME, _Fields.TOKEN, _Fields.DEFAULT_SCHEMA};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CONN_ID, new FieldMetaData("connId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.CLIENT_HOST_NAME, new FieldMetaData("clientHostName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CLIENT_ID, new FieldMetaData("clientID", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER_NAME, new FieldMetaData("userName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DEFAULT_SCHEMA, new FieldMetaData("defaultSchema", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ConnectionProperties.class, metaDataMap);
    }

    private static class ConnectionPropertiesTupleScheme
    extends TupleScheme<ConnectionProperties> {
        private ConnectionPropertiesTupleScheme() {
        }

        public void write(TProtocol prot, ConnectionProperties struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.connId);
            oprot.writeString(struct.clientHostName);
            oprot.writeString(struct.clientID);
            BitSet optionals = new BitSet();
            if (struct.isSetUserName()) {
                optionals.set(0);
            }
            if (struct.isSetToken()) {
                optionals.set(1);
            }
            if (struct.isSetDefaultSchema()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetUserName()) {
                oprot.writeString(struct.userName);
            }
            if (struct.isSetToken()) {
                oprot.writeBinary(struct.token);
            }
            if (struct.isSetDefaultSchema()) {
                oprot.writeString(struct.defaultSchema);
            }
        }

        public void read(TProtocol prot, ConnectionProperties struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.connId = iprot.readI64();
            struct.setConnIdIsSet(true);
            struct.clientHostName = iprot.readString();
            struct.setClientHostNameIsSet(true);
            struct.clientID = iprot.readString();
            struct.setClientIDIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                struct.userName = iprot.readString();
                struct.setUserNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.token = iprot.readBinary();
                struct.setTokenIsSet(true);
            }
            if (incoming.get(2)) {
                struct.defaultSchema = iprot.readString();
                struct.setDefaultSchemaIsSet(true);
            }
        }
    }

    private static class ConnectionPropertiesTupleSchemeFactory
    implements SchemeFactory {
        private ConnectionPropertiesTupleSchemeFactory() {
        }

        public ConnectionPropertiesTupleScheme getScheme() {
            return new ConnectionPropertiesTupleScheme();
        }
    }

    private static class ConnectionPropertiesStandardScheme
    extends StandardScheme<ConnectionProperties> {
        private ConnectionPropertiesStandardScheme() {
        }

        public void read(TProtocol iprot, ConnectionProperties struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.connId = iprot.readI64();
                            struct.setConnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.clientHostName = iprot.readString();
                            struct.setClientHostNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.clientID = iprot.readString();
                            struct.setClientIDIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.userName = iprot.readString();
                            struct.setUserNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readBinary();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.defaultSchema = iprot.readString();
                            struct.setDefaultSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetConnId()) {
                throw new TProtocolException("Required field 'connId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, ConnectionProperties struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(CONN_ID_FIELD_DESC);
            oprot.writeI64(struct.connId);
            oprot.writeFieldEnd();
            if (struct.clientHostName != null) {
                oprot.writeFieldBegin(CLIENT_HOST_NAME_FIELD_DESC);
                oprot.writeString(struct.clientHostName);
                oprot.writeFieldEnd();
            }
            if (struct.clientID != null) {
                oprot.writeFieldBegin(CLIENT_ID_FIELD_DESC);
                oprot.writeString(struct.clientID);
                oprot.writeFieldEnd();
            }
            if (struct.userName != null && struct.isSetUserName()) {
                oprot.writeFieldBegin(USER_NAME_FIELD_DESC);
                oprot.writeString(struct.userName);
                oprot.writeFieldEnd();
            }
            if (struct.token != null && struct.isSetToken()) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeBinary(struct.token);
                oprot.writeFieldEnd();
            }
            if (struct.defaultSchema != null && struct.isSetDefaultSchema()) {
                oprot.writeFieldBegin(DEFAULT_SCHEMA_FIELD_DESC);
                oprot.writeString(struct.defaultSchema);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ConnectionPropertiesStandardSchemeFactory
    implements SchemeFactory {
        private ConnectionPropertiesStandardSchemeFactory() {
        }

        public ConnectionPropertiesStandardScheme getScheme() {
            return new ConnectionPropertiesStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CONN_ID(1, "connId"),
        CLIENT_HOST_NAME(2, "clientHostName"),
        CLIENT_ID(3, "clientID"),
        USER_NAME(4, "userName"),
        TOKEN(5, "token"),
        DEFAULT_SCHEMA(6, "defaultSchema");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CONN_ID;
                }
                case 2: {
                    return CLIENT_HOST_NAME;
                }
                case 3: {
                    return CLIENT_ID;
                }
                case 4: {
                    return USER_NAME;
                }
                case 5: {
                    return TOKEN;
                }
                case 6: {
                    return DEFAULT_SCHEMA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

