/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.Converter;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.sql.SQLException;

public class DoubleColumnRoutingObjectInfo
extends ColumnRoutingObjectInfo {
    private Double actualValue;

    public DoubleColumnRoutingObjectInfo(int isParameter, Object val, Object resolver) {
        super(isParameter, val, resolver);
    }

    public DoubleColumnRoutingObjectInfo() {
    }

    @Override
    public int computeHashCode(int hash, int resolverType, boolean requiresSerializedHash) {
        Double val = null;
        if (this.isValueAConstant()) {
            this.actualValue = val = (Double)this.value;
        } else {
            val = this.actualValue;
        }
        if (requiresSerializedHash && resolverType == 4 || resolverType == 2) {
            int typeId = this.getTypeFormatId();
            if (this.actualValue != null) {
                long bits = Double.doubleToLongBits(this.actualValue);
                return ResolverUtils.addLongToBucketHash(bits, hash, typeId);
            }
            return ResolverUtils.addByteToBucketHash((byte)0, hash, typeId);
        }
        return this.dvdEquivalenthashCode();
    }

    @Override
    public void setActualValue(Object[] parameters, Converter crossConverter) throws SQLException {
        if (!this.isValueAConstant()) {
            this.actualValue = (Double)crossConverter.getJavaObjectOfType(8, parameters[(Integer)this.value]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 79;
    }

    @Override
    public Object getActualValue() {
        if (this.actualValue != null) {
            return this.actualValue;
        }
        if (this.isValueAConstant()) {
            this.actualValue = (Double)this.value;
            return this.actualValue;
        }
        return null;
    }

    @Override
    public int dvdEquivalenthashCode() {
        double localdoublevalue = this.actualValue != null ? this.actualValue : 0.0;
        long longVal = (long)localdoublevalue;
        double doubleLongVal = longVal;
        if (doubleLongVal != localdoublevalue) {
            longVal = Double.doubleToLongBits(localdoublevalue);
        }
        return (int)(longVal ^ longVal >> 32);
    }

    public static void dummy() {
    }
}

