/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.shared.unsafe.DirectBufferAllocator;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.TransactionAttribute;
import io.snappydata.thrift.common.SocketParameters;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public abstract class ThriftUtils {
    private static final SharedUtils.CSVVisitor<SocketParameters, Void> parseSSLParams = new SharedUtils.CSVVisitor<SocketParameters, Void>(){

        @Override
        public void visit(String str, SocketParameters sslParams, Void ignore) {
            int eqIndex = str.indexOf(61);
            if (eqIndex > 0) {
                String key = str.substring(0, eqIndex).trim();
                String value = str.substring(eqIndex + 1).trim();
                try {
                    SocketParameters.findSSLParameterByPropertyName(key).setParameter(sslParams, value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Expected numeric format for SSL property '" + key + "' but got: " + value, nfe);
                }
            } else {
                throw new IllegalArgumentException("Missing equality: expected comma-separated <property>=<value> pairs");
            }
        }
    };

    private ThriftUtils() {
    }

    public static boolean isThriftSelectorServer() {
        return SystemProperties.getServerInstance().getBoolean("thrift-selector", false);
    }

    public static HostAddress getHostAddress(String hostNameAndAddress, int port) {
        int slashIndex = hostNameAndAddress.indexOf(47);
        if (slashIndex > 0) {
            String hostName = hostNameAndAddress.substring(0, slashIndex);
            String ipAddress = hostNameAndAddress.substring(slashIndex + 1);
            if (ipAddress.length() > 0 && !hostName.equals(ipAddress)) {
                return new HostAddress(hostName, port).setIpAddress(ipAddress);
            }
            return new HostAddress(hostName, port);
        }
        if (slashIndex == 0) {
            return new HostAddress(hostNameAndAddress.substring(1), port);
        }
        return new HostAddress(hostNameAndAddress, port);
    }

    public static void getSSLParameters(SocketParameters socketParams, String sslProperties) {
        if (sslProperties != null && sslProperties.length() > 0) {
            socketParams.setHasSSLParams();
            SharedUtils.splitCSV(sslProperties, parseSSLParams, socketParams, null);
        }
    }

    public static EnumMap<TransactionAttribute, Boolean> newTransactionFlags() {
        return new EnumMap<TransactionAttribute, Boolean>(TransactionAttribute.class);
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        return ClientSharedUtils.toBytes((ByteBuffer)buffer);
    }

    public static ByteBuffer readByteBuffer(TNonblockingTransport transport, int length) throws TTransportException {
        ByteBuffer buffer;
        if (length == 0) {
            return ClientSharedData.NULL_BUFFER;
        }
        if (transport.getBytesRemainingInBuffer() >= length) {
            ByteBuffer buffer2 = ByteBuffer.wrap(transport.getBuffer(), transport.getBufferPosition(), length);
            transport.consumeBuffer(length);
            return buffer2;
        }
        if (length <= 8192) {
            byte[] buffer3 = new byte[length];
            transport.readAll(buffer3, 0, length);
            return ByteBuffer.wrap(buffer3);
        }
        try {
            buffer = DirectBufferAllocator.instance().allocateWithFallback(length, "THRIFT");
        }
        catch (OutOfMemoryError | RuntimeException ignored) {
            buffer = ByteBuffer.allocate(length);
        }
        buffer.limit(length);
        try {
            long parkedNanos = 0L;
            int numTries = 0;
            while (length > 0) {
                int numReadBytes = transport.read(buffer);
                if (numReadBytes > 0) {
                    length -= numReadBytes;
                    continue;
                }
                if (numReadBytes == 0) {
                    parkedNanos = ClientSharedUtils.parkThreadForAsyncOperationIfRequired(null, (long)parkedNanos, (int)(++numTries));
                    continue;
                }
                throw new EOFException("Socket channel closed in read.");
            }
        }
        catch (IOException e) {
            throw new TTransportException(e instanceof EOFException ? 4 : 0);
        }
        buffer.flip();
        return buffer;
    }

    public static void writeByteBuffer(ByteBuffer buffer, TTransport transport, TNonblockingTransport nonBlockingTransport, int length) throws TTransportException {
        if (buffer.hasArray()) {
            transport.write(buffer.array(), buffer.position() + buffer.arrayOffset(), length);
        } else if (nonBlockingTransport != null) {
            try {
                long parkedNanos = 0L;
                int numTries = 0;
                int position = buffer.position();
                boolean flushed = false;
                while (length > 0) {
                    int numWrittenBytes = nonBlockingTransport.write(buffer);
                    if (numWrittenBytes > 0) {
                        length -= numWrittenBytes;
                        continue;
                    }
                    if (numWrittenBytes == 0) {
                        if (!flushed) {
                            nonBlockingTransport.flush();
                            flushed = true;
                            continue;
                        }
                        flushed = false;
                        parkedNanos = ClientSharedUtils.parkThreadForAsyncOperationIfRequired(null, (long)parkedNanos, (int)(++numTries));
                        continue;
                    }
                    throw new EOFException("Socket channel closed in write.");
                }
                buffer.position(position);
            }
            catch (IOException e) {
                throw new TTransportException(e instanceof EOFException ? 4 : 0);
            }
        } else {
            byte[] bytes = ClientSharedUtils.toBytes((ByteBuffer)buffer, (int)buffer.remaining(), (int)length);
            transport.write(bytes, 0, length);
        }
    }
}

