/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.ClobChunk;
import io.snappydata.thrift.Decimal;
import io.snappydata.thrift.common.ThriftUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public final class ColumnValue
extends TUnion<ColumnValue, _Fields> {
    public static final TStruct STRUCT_DESC = new TStruct("ColumnValue");
    public static final TField BOOL_VAL_FIELD_DESC = new TField("bool_val", 2, 1);
    public static final TField BYTE_VAL_FIELD_DESC = new TField("byte_val", 3, 2);
    public static final TField I16_VAL_FIELD_DESC = new TField("i16_val", 6, 3);
    public static final TField I32_VAL_FIELD_DESC = new TField("i32_val", 8, 4);
    public static final TField I64_VAL_FIELD_DESC = new TField("i64_val", 10, 5);
    public static final TField FLOAT_VAL_FIELD_DESC = new TField("float_val", 8, 6);
    public static final TField DOUBLE_VAL_FIELD_DESC = new TField("double_val", 4, 7);
    public static final TField STRING_VAL_FIELD_DESC = new TField("string_val", 11, 8);
    public static final TField DECIMAL_VAL_FIELD_DESC = new TField("decimal_val", 12, 9);
    public static final TField DATE_VAL_FIELD_DESC = new TField("date_val", 10, 10);
    public static final TField TIME_VAL_FIELD_DESC = new TField("time_val", 10, 11);
    public static final TField TIMESTAMP_VAL_FIELD_DESC = new TField("timestamp_val", 10, 12);
    public static final TField BINARY_VAL_FIELD_DESC = new TField("binary_val", 11, 13);
    public static final TField BLOB_VAL_FIELD_DESC = new TField("blob_val", 12, 14);
    public static final TField CLOB_VAL_FIELD_DESC = new TField("clob_val", 12, 15);
    public static final TField ARRAY_VAL_FIELD_DESC = new TField("array_val", 15, 16);
    public static final TField MAP_VAL_FIELD_DESC = new TField("map_val", 13, 17);
    public static final TField STRUCT_VAL_FIELD_DESC = new TField("struct_val", 15, 18);
    public static final TField NULL_VAL_FIELD_DESC = new TField("null_val", 2, 19);
    public static final TField JAVA_VAL_FIELD_DESC = new TField("java_val", 11, 20);
    public static final Map<_Fields, FieldMetaData> metaDataMap;
    private long primitiveValue;

    public ColumnValue() {
    }

    public ColumnValue(ColumnValue other) {
        super((TUnion)other);
        this.primitiveValue = other.primitiveValue;
    }

    public ColumnValue deepCopy() {
        return new ColumnValue(this);
    }

    public static ColumnValue bool_val(boolean value) {
        ColumnValue x = new ColumnValue();
        x.setBool_val(value);
        return x;
    }

    public static ColumnValue byte_val(byte value) {
        ColumnValue x = new ColumnValue();
        x.setByte_val(value);
        return x;
    }

    public static ColumnValue i16_val(short value) {
        ColumnValue x = new ColumnValue();
        x.setI16_val(value);
        return x;
    }

    public static ColumnValue i32_val(int value) {
        ColumnValue x = new ColumnValue();
        x.setI32_val(value);
        return x;
    }

    public static ColumnValue i64_val(long value) {
        ColumnValue x = new ColumnValue();
        x.setI64_val(value);
        return x;
    }

    public static ColumnValue float_val(int value) {
        ColumnValue x = new ColumnValue();
        x.setFloat_val(value);
        return x;
    }

    public static ColumnValue double_val(double value) {
        ColumnValue x = new ColumnValue();
        x.setDouble_val(value);
        return x;
    }

    public static ColumnValue string_val(String value) {
        ColumnValue x = new ColumnValue();
        x.setString_val(value);
        return x;
    }

    public static ColumnValue decimal_val(Decimal value) {
        ColumnValue x = new ColumnValue();
        x.setDecimal_val(value);
        return x;
    }

    public static ColumnValue date_val(long value) {
        ColumnValue x = new ColumnValue();
        x.setDate_val(value);
        return x;
    }

    public static ColumnValue time_val(long value) {
        ColumnValue x = new ColumnValue();
        x.setTime_val(value);
        return x;
    }

    public static ColumnValue timestamp_val(long value) {
        ColumnValue x = new ColumnValue();
        x.setTimestamp_val(value);
        return x;
    }

    public static ColumnValue binary_val(ByteBuffer value) {
        ColumnValue x = new ColumnValue();
        x.setBinary_val(value);
        return x;
    }

    public static ColumnValue binary_val(byte[] value) {
        ColumnValue x = new ColumnValue();
        x.setBinary_val(ByteBuffer.wrap(Arrays.copyOf(value, value.length)));
        return x;
    }

    public static ColumnValue blob_val(BlobChunk value) {
        ColumnValue x = new ColumnValue();
        x.setBlob_val(value);
        return x;
    }

    public static ColumnValue clob_val(ClobChunk value) {
        ColumnValue x = new ColumnValue();
        x.setClob_val(value);
        return x;
    }

    public static ColumnValue array_val(List<ColumnValue> value) {
        ColumnValue x = new ColumnValue();
        x.setArray_val(value);
        return x;
    }

    public static ColumnValue map_val(Map<ColumnValue, ColumnValue> value) {
        ColumnValue x = new ColumnValue();
        x.setMap_val(value);
        return x;
    }

    public static ColumnValue struct_val(List<ColumnValue> value) {
        ColumnValue x = new ColumnValue();
        x.setStruct_val(value);
        return x;
    }

    public static ColumnValue null_val(boolean value) {
        ColumnValue x = new ColumnValue();
        x.setNull_val(value);
        return x;
    }

    public static ColumnValue java_val(ByteBuffer value) {
        ColumnValue x = new ColumnValue();
        x.setJava_val(value);
        return x;
    }

    public static ColumnValue java_val(byte[] value) {
        ColumnValue x = new ColumnValue();
        x.setJava_val(ByteBuffer.wrap(Arrays.copyOf(value, value.length)));
        return x;
    }

    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case BOOL_VAL: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type Boolean for field 'bool_val', but got " + value.getClass().getSimpleName());
            }
            case BYTE_VAL: {
                if (value instanceof Byte) break;
                throw new ClassCastException("Was expecting value of type Byte for field 'byte_val', but got " + value.getClass().getSimpleName());
            }
            case I16_VAL: {
                if (value instanceof Short) break;
                throw new ClassCastException("Was expecting value of type Short for field 'i16_val', but got " + value.getClass().getSimpleName());
            }
            case I32_VAL: {
                if (value instanceof Integer) break;
                throw new ClassCastException("Was expecting value of type Integer for field 'i32_val', but got " + value.getClass().getSimpleName());
            }
            case I64_VAL: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'i64_val', but got " + value.getClass().getSimpleName());
            }
            case FLOAT_VAL: {
                if (value instanceof Integer) break;
                throw new ClassCastException("Was expecting value of type Integer for field 'float_val', but got " + value.getClass().getSimpleName());
            }
            case DOUBLE_VAL: {
                if (value instanceof Double) break;
                throw new ClassCastException("Was expecting value of type Double for field 'double_val', but got " + value.getClass().getSimpleName());
            }
            case STRING_VAL: {
                if (value instanceof String) break;
                throw new ClassCastException("Was expecting value of type String for field 'string_val', but got " + value.getClass().getSimpleName());
            }
            case DECIMAL_VAL: {
                if (value instanceof Decimal) break;
                throw new ClassCastException("Was expecting value of type Decimal for field 'decimal_val', but got " + value.getClass().getSimpleName());
            }
            case DATE_VAL: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'date_val', but got " + value.getClass().getSimpleName());
            }
            case TIME_VAL: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'time_val', but got " + value.getClass().getSimpleName());
            }
            case TIMESTAMP_VAL: {
                if (value instanceof Long) break;
                throw new ClassCastException("Was expecting value of type Long for field 'timestamp_val', but got " + value.getClass().getSimpleName());
            }
            case BINARY_VAL: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type ByteBuffer for field 'binary_val', but got " + value.getClass().getSimpleName());
            }
            case BLOB_VAL: {
                if (value instanceof BlobChunk) break;
                throw new ClassCastException("Was expecting value of type BlobChunk for field 'blob_val', but got " + value.getClass().getSimpleName());
            }
            case CLOB_VAL: {
                if (value instanceof ClobChunk) break;
                throw new ClassCastException("Was expecting value of type ClobChunk for field 'clob_val', but got " + value.getClass().getSimpleName());
            }
            case ARRAY_VAL: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type List<ColumnValue> for field 'array_val', but got " + value.getClass().getSimpleName());
            }
            case MAP_VAL: {
                if (value instanceof Map) break;
                throw new ClassCastException("Was expecting value of type Map<ColumnValue,ColumnValue> for field 'map_val', but got " + value.getClass().getSimpleName());
            }
            case STRUCT_VAL: {
                if (value instanceof List) break;
                throw new ClassCastException("Was expecting value of type List<ColumnValue> for field 'struct_val', but got " + value.getClass().getSimpleName());
            }
            case NULL_VAL: {
                if (value instanceof Boolean) break;
                throw new ClassCastException("Was expecting value of type Boolean for field 'null_val', but got " + value.getClass().getSimpleName());
            }
            case JAVA_VAL: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type ByteBuffer for field 'java_val', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
            }
        }
    }

    protected Object standardSchemeReadValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case BOOL_VAL: {
                    if (field.type == ColumnValue.BOOL_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readBool() ? 1L : 0L;
                        this.setField_ = _Fields.BOOL_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BYTE_VAL: {
                    if (field.type == ColumnValue.BYTE_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readByte();
                        this.setField_ = _Fields.BYTE_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case I16_VAL: {
                    if (field.type == ColumnValue.I16_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI16();
                        this.setField_ = _Fields.I16_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case I32_VAL: {
                    if (field.type == ColumnValue.I32_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI32();
                        this.setField_ = _Fields.I32_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case I64_VAL: {
                    if (field.type == ColumnValue.I64_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI64();
                        this.setField_ = _Fields.I64_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case FLOAT_VAL: {
                    if (field.type == ColumnValue.FLOAT_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI32();
                        this.setField_ = _Fields.FLOAT_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DOUBLE_VAL: {
                    if (field.type == ColumnValue.DOUBLE_VAL_FIELD_DESC.type) {
                        this.primitiveValue = Double.doubleToLongBits(iprot.readDouble());
                        this.setField_ = _Fields.DOUBLE_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case STRING_VAL: {
                    if (field.type == ColumnValue.STRING_VAL_FIELD_DESC.type) {
                        String string_val = iprot.readString();
                        return string_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DECIMAL_VAL: {
                    if (field.type == ColumnValue.DECIMAL_VAL_FIELD_DESC.type) {
                        Decimal decimal_val = new Decimal();
                        decimal_val.read(iprot);
                        return decimal_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case DATE_VAL: {
                    if (field.type == ColumnValue.DATE_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI64();
                        this.setField_ = _Fields.DATE_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case TIME_VAL: {
                    if (field.type == ColumnValue.TIME_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI64();
                        this.setField_ = _Fields.TIME_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case TIMESTAMP_VAL: {
                    if (field.type == ColumnValue.TIMESTAMP_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readI64();
                        this.setField_ = _Fields.TIMESTAMP_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BINARY_VAL: {
                    if (field.type == ColumnValue.BINARY_VAL_FIELD_DESC.type) {
                        ByteBuffer binary_val = iprot.readBinary();
                        return binary_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BLOB_VAL: {
                    if (field.type == ColumnValue.BLOB_VAL_FIELD_DESC.type) {
                        BlobChunk blob_val = new BlobChunk();
                        blob_val.read(iprot);
                        return blob_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case CLOB_VAL: {
                    if (field.type == ColumnValue.CLOB_VAL_FIELD_DESC.type) {
                        ClobChunk clob_val = new ClobChunk();
                        clob_val.read(iprot);
                        return clob_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case ARRAY_VAL: {
                    if (field.type == ColumnValue.ARRAY_VAL_FIELD_DESC.type) {
                        TList _list146 = iprot.readListBegin();
                        ArrayList<ColumnValue> array_val = new ArrayList<ColumnValue>(_list146.size);
                        for (int _i148 = 0; _i148 < _list146.size; ++_i148) {
                            ColumnValue _elem147 = new ColumnValue();
                            _elem147.read(iprot);
                            array_val.add(_elem147);
                        }
                        iprot.readListEnd();
                        return array_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case MAP_VAL: {
                    if (field.type == ColumnValue.MAP_VAL_FIELD_DESC.type) {
                        TMap _map149 = iprot.readMapBegin();
                        HashMap<ColumnValue, ColumnValue> map_val = new HashMap<ColumnValue, ColumnValue>(2 * _map149.size);
                        for (int _i152 = 0; _i152 < _map149.size; ++_i152) {
                            ColumnValue _key150 = new ColumnValue();
                            _key150.read(iprot);
                            ColumnValue _val151 = new ColumnValue();
                            _val151.read(iprot);
                            map_val.put(_key150, _val151);
                        }
                        iprot.readMapEnd();
                        return map_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case STRUCT_VAL: {
                    if (field.type == ColumnValue.STRUCT_VAL_FIELD_DESC.type) {
                        TList _list153 = iprot.readListBegin();
                        ArrayList<ColumnValue> struct_val = new ArrayList<ColumnValue>(_list153.size);
                        for (int _i155 = 0; _i155 < _list153.size; ++_i155) {
                            ColumnValue _elem154 = new ColumnValue();
                            _elem154.read(iprot);
                            struct_val.add(_elem154);
                        }
                        iprot.readListEnd();
                        return struct_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case NULL_VAL: {
                    if (field.type == ColumnValue.NULL_VAL_FIELD_DESC.type) {
                        this.primitiveValue = iprot.readBool() ? 1L : 0L;
                        this.setField_ = _Fields.NULL_VAL;
                        return null;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case JAVA_VAL: {
                    if (field.type == ColumnValue.JAVA_VAL_FIELD_DESC.type) {
                        ByteBuffer java_val = iprot.readBinary();
                        return java_val;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
        return null;
    }

    public void write(TProtocol oprot) throws TException {
        if (this.getSetField() == null || this.getFieldValue() == null) {
            throw new TProtocolException("Cannot write a TUnion with no set value!");
        }
        oprot.writeStructBegin(this.getStructDesc());
        oprot.writeFieldBegin(this.getFieldDesc((_Fields)this.setField_));
        this.standardSchemeWriteValue(oprot);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    protected void standardSchemeWriteValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case BOOL_VAL: {
                boolean bool_val = this.primitiveValue != 0L;
                oprot.writeBool(bool_val);
                return;
            }
            case BYTE_VAL: {
                byte byte_val = (byte)this.primitiveValue;
                oprot.writeByte(byte_val);
                return;
            }
            case I16_VAL: {
                short i16_val = (short)this.primitiveValue;
                oprot.writeI16(i16_val);
                return;
            }
            case I32_VAL: {
                int i32_val = (int)this.primitiveValue;
                oprot.writeI32(i32_val);
                return;
            }
            case I64_VAL: {
                long i64_val = this.primitiveValue;
                oprot.writeI64(i64_val);
                return;
            }
            case FLOAT_VAL: {
                int float_val = (int)this.primitiveValue;
                oprot.writeI32(float_val);
                return;
            }
            case DOUBLE_VAL: {
                double double_val = Double.longBitsToDouble(this.primitiveValue);
                oprot.writeDouble(double_val);
                return;
            }
            case STRING_VAL: {
                String string_val = (String)this.value_;
                oprot.writeString(string_val);
                return;
            }
            case DECIMAL_VAL: {
                Decimal decimal_val = (Decimal)this.value_;
                decimal_val.write(oprot);
                return;
            }
            case DATE_VAL: {
                long date_val = this.primitiveValue;
                oprot.writeI64(date_val);
                return;
            }
            case TIME_VAL: {
                long time_val = this.primitiveValue;
                oprot.writeI64(time_val);
                return;
            }
            case TIMESTAMP_VAL: {
                long timestamp_val = this.primitiveValue;
                oprot.writeI64(timestamp_val);
                return;
            }
            case BINARY_VAL: {
                ByteBuffer binary_val = (ByteBuffer)this.value_;
                oprot.writeBinary(binary_val);
                return;
            }
            case BLOB_VAL: {
                BlobChunk blob_val = (BlobChunk)this.value_;
                blob_val.write(oprot);
                return;
            }
            case CLOB_VAL: {
                ClobChunk clob_val = (ClobChunk)this.value_;
                clob_val.write(oprot);
                return;
            }
            case ARRAY_VAL: {
                List array_val = (List)this.value_;
                oprot.writeListBegin(new TList(12, array_val.size()));
                for (ColumnValue _iter156 : array_val) {
                    _iter156.write(oprot);
                }
                oprot.writeListEnd();
                return;
            }
            case MAP_VAL: {
                Map map_val = (Map)this.value_;
                oprot.writeMapBegin(new TMap(12, 12, map_val.size()));
                for (Map.Entry _iter157 : map_val.entrySet()) {
                    ((ColumnValue)((Object)_iter157.getKey())).write(oprot);
                    ((ColumnValue)((Object)_iter157.getValue())).write(oprot);
                }
                oprot.writeMapEnd();
                return;
            }
            case STRUCT_VAL: {
                List struct_val = (List)this.value_;
                oprot.writeListBegin(new TList(12, struct_val.size()));
                for (ColumnValue _iter158 : struct_val) {
                    _iter158.write(oprot);
                }
                oprot.writeListEnd();
                return;
            }
            case NULL_VAL: {
                boolean null_val = this.primitiveValue != 0L;
                oprot.writeBool(null_val);
                return;
            }
            case JAVA_VAL: {
                ByteBuffer java_val = (ByteBuffer)this.value_;
                oprot.writeBinary(java_val);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected Object tupleSchemeReadValue(TProtocol iprot, short fieldID) throws TException {
        throw new TProtocolException("Tuple scheme not supported");
    }

    protected void tupleSchemeWriteValue(TProtocol oprot) throws TException {
        throw new TProtocolException("Tuple scheme not supported");
    }

    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case BOOL_VAL: {
                return BOOL_VAL_FIELD_DESC;
            }
            case BYTE_VAL: {
                return BYTE_VAL_FIELD_DESC;
            }
            case I16_VAL: {
                return I16_VAL_FIELD_DESC;
            }
            case I32_VAL: {
                return I32_VAL_FIELD_DESC;
            }
            case I64_VAL: {
                return I64_VAL_FIELD_DESC;
            }
            case FLOAT_VAL: {
                return FLOAT_VAL_FIELD_DESC;
            }
            case DOUBLE_VAL: {
                return DOUBLE_VAL_FIELD_DESC;
            }
            case STRING_VAL: {
                return STRING_VAL_FIELD_DESC;
            }
            case DECIMAL_VAL: {
                return DECIMAL_VAL_FIELD_DESC;
            }
            case DATE_VAL: {
                return DATE_VAL_FIELD_DESC;
            }
            case TIME_VAL: {
                return TIME_VAL_FIELD_DESC;
            }
            case TIMESTAMP_VAL: {
                return TIMESTAMP_VAL_FIELD_DESC;
            }
            case BINARY_VAL: {
                return BINARY_VAL_FIELD_DESC;
            }
            case BLOB_VAL: {
                return BLOB_VAL_FIELD_DESC;
            }
            case CLOB_VAL: {
                return CLOB_VAL_FIELD_DESC;
            }
            case ARRAY_VAL: {
                return ARRAY_VAL_FIELD_DESC;
            }
            case MAP_VAL: {
                return MAP_VAL_FIELD_DESC;
            }
            case STRUCT_VAL: {
                return STRUCT_VAL_FIELD_DESC;
            }
            case NULL_VAL: {
                return NULL_VAL_FIELD_DESC;
            }
            case JAVA_VAL: {
                return JAVA_VAL_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
    }

    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public final long getPrimitiveLong() {
        return this.primitiveValue;
    }

    public boolean getBool_val() {
        if (this.getSetField() == _Fields.BOOL_VAL) {
            return this.primitiveValue != 0L;
        }
        throw new RuntimeException("Cannot get field 'bool_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBool_val(boolean value) {
        this.setField_ = _Fields.BOOL_VAL;
        this.primitiveValue = value ? 1L : 0L;
        this.value_ = Boolean.TRUE;
    }

    public byte getByte_val() {
        if (this.getSetField() == _Fields.BYTE_VAL) {
            return (byte)this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'byte_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setByte_val(byte value) {
        this.setField_ = _Fields.BYTE_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public short getI16_val() {
        if (this.getSetField() == _Fields.I16_VAL) {
            return (short)this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'i16_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setI16_val(short value) {
        this.setField_ = _Fields.I16_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public int getI32_val() {
        if (this.getSetField() == _Fields.I32_VAL) {
            return (int)this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'i32_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setI32_val(int value) {
        this.setField_ = _Fields.I32_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public long getI64_val() {
        if (this.getSetField() == _Fields.I64_VAL) {
            return this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'i64_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setI64_val(long value) {
        this.setField_ = _Fields.I64_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public int getFloat_val() {
        if (this.getSetField() == _Fields.FLOAT_VAL) {
            return (int)this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'float_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setFloat_val(int value) {
        this.setField_ = _Fields.FLOAT_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public double getDouble_val() {
        if (this.getSetField() == _Fields.DOUBLE_VAL) {
            return Double.longBitsToDouble(this.primitiveValue);
        }
        throw new RuntimeException("Cannot get field 'double_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDouble_val(double value) {
        this.setField_ = _Fields.DOUBLE_VAL;
        this.primitiveValue = Double.doubleToLongBits(value);
        this.value_ = Boolean.TRUE;
    }

    public String getString_val() {
        if (this.getSetField() == _Fields.STRING_VAL) {
            return (String)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'string_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setString_val(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.STRING_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public Decimal getDecimal_val() {
        if (this.getSetField() == _Fields.DECIMAL_VAL) {
            return (Decimal)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'decimal_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDecimal_val(Decimal value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.DECIMAL_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public long getDate_val() {
        if (this.getSetField() == _Fields.DATE_VAL) {
            return this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'date_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setDate_val(long value) {
        this.setField_ = _Fields.DATE_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public long getTime_val() {
        if (this.getSetField() == _Fields.TIME_VAL) {
            return this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'time_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setTime_val(long value) {
        this.setField_ = _Fields.TIME_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public long getTimestamp_val() {
        if (this.getSetField() == _Fields.TIMESTAMP_VAL) {
            return this.primitiveValue;
        }
        throw new RuntimeException("Cannot get field 'timestamp_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setTimestamp_val(long value) {
        this.setField_ = _Fields.TIMESTAMP_VAL;
        this.primitiveValue = value;
        this.value_ = Boolean.TRUE;
    }

    public byte[] getBinary_val() {
        if (this.getSetField() == _Fields.BINARY_VAL) {
            ByteBuffer buffer = (ByteBuffer)this.getFieldValue();
            if (buffer == null) {
                return null;
            }
            if (!TBaseHelper.wrapsFullArray((ByteBuffer)buffer)) {
                buffer = ByteBuffer.wrap(ThriftUtils.toBytes(buffer));
                this.setBinary_val(buffer);
            }
            return buffer.array();
        }
        throw new RuntimeException("Cannot get field 'binary_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBinary_val(byte[] value) {
        this.setBinary_val(ByteBuffer.wrap(Arrays.copyOf(value, value.length)));
    }

    public void setBinary_val(ByteBuffer value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.BINARY_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public BlobChunk getBlob_val() {
        if (this.getSetField() == _Fields.BLOB_VAL) {
            return (BlobChunk)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'blob_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBlob_val(BlobChunk value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.BLOB_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public ClobChunk getClob_val() {
        if (this.getSetField() == _Fields.CLOB_VAL) {
            return (ClobChunk)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'clob_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setClob_val(ClobChunk value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.CLOB_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public List<ColumnValue> getArray_val() {
        if (this.getSetField() == _Fields.ARRAY_VAL) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'array_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setArray_val(List<ColumnValue> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.ARRAY_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public Map<ColumnValue, ColumnValue> getMap_val() {
        if (this.getSetField() == _Fields.MAP_VAL) {
            return (Map)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'map_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setMap_val(Map<ColumnValue, ColumnValue> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.MAP_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public List<ColumnValue> getStruct_val() {
        if (this.getSetField() == _Fields.STRUCT_VAL) {
            return (List)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'struct_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setStruct_val(List<ColumnValue> value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.STRUCT_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public boolean getNull_val() {
        if (this.getSetField() == _Fields.NULL_VAL) {
            return this.primitiveValue != 0L;
        }
        throw new RuntimeException("Cannot get field 'null_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setNull_val(boolean value) {
        this.setField_ = _Fields.NULL_VAL;
        this.primitiveValue = value ? 1L : 0L;
        this.value_ = Boolean.TRUE;
    }

    public byte[] getJava_val() {
        if (this.getSetField() == _Fields.JAVA_VAL) {
            ByteBuffer buffer = (ByteBuffer)this.getFieldValue();
            if (buffer == null) {
                return null;
            }
            if (!TBaseHelper.wrapsFullArray((ByteBuffer)buffer)) {
                buffer = ByteBuffer.wrap(ThriftUtils.toBytes(buffer));
                this.setJava_val(buffer);
            }
            return buffer.array();
        }
        throw new RuntimeException("Cannot get field 'java_val' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setJava_val(byte[] value) {
        this.setJava_val(ByteBuffer.wrap(Arrays.copyOf(value, value.length)));
    }

    public void setJava_val(ByteBuffer value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.JAVA_VAL;
        this.value_ = value;
        this.primitiveValue = 0L;
    }

    public boolean isSetBool_val() {
        return this.setField_ == _Fields.BOOL_VAL;
    }

    public boolean isSetByte_val() {
        return this.setField_ == _Fields.BYTE_VAL;
    }

    public boolean isSetI16_val() {
        return this.setField_ == _Fields.I16_VAL;
    }

    public boolean isSetI32_val() {
        return this.setField_ == _Fields.I32_VAL;
    }

    public boolean isSetI64_val() {
        return this.setField_ == _Fields.I64_VAL;
    }

    public boolean isSetFloat_val() {
        return this.setField_ == _Fields.FLOAT_VAL;
    }

    public boolean isSetDouble_val() {
        return this.setField_ == _Fields.DOUBLE_VAL;
    }

    public boolean isSetString_val() {
        return this.setField_ == _Fields.STRING_VAL;
    }

    public boolean isSetDecimal_val() {
        return this.setField_ == _Fields.DECIMAL_VAL;
    }

    public boolean isSetDate_val() {
        return this.setField_ == _Fields.DATE_VAL;
    }

    public boolean isSetTime_val() {
        return this.setField_ == _Fields.TIME_VAL;
    }

    public boolean isSetTimestamp_val() {
        return this.setField_ == _Fields.TIMESTAMP_VAL;
    }

    public boolean isSetBinary_val() {
        return this.setField_ == _Fields.BINARY_VAL;
    }

    public boolean isSetBlob_val() {
        return this.setField_ == _Fields.BLOB_VAL;
    }

    public boolean isSetClob_val() {
        return this.setField_ == _Fields.CLOB_VAL;
    }

    public boolean isSetArray_val() {
        return this.setField_ == _Fields.ARRAY_VAL;
    }

    public boolean isSetMap_val() {
        return this.setField_ == _Fields.MAP_VAL;
    }

    public boolean isSetStruct_val() {
        return this.setField_ == _Fields.STRUCT_VAL;
    }

    public boolean isSetNull_val() {
        return this.setField_ == _Fields.NULL_VAL;
    }

    public boolean isSetJava_val() {
        return this.setField_ == _Fields.JAVA_VAL;
    }

    public boolean equals(Object other) {
        return other instanceof ColumnValue && this.equals((ColumnValue)((Object)other));
    }

    public boolean equals(ColumnValue other) {
        return other != null && this.getSetField() == other.getSetField() && this.primitiveValue == other.primitiveValue && this.getFieldValue().equals(other.getFieldValue());
    }

    public int compareTo(ColumnValue other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)((Comparable)this.getSetField()), (Comparable)((Comparable)other.getSetField()));
        if (lastComparison == 0) {
            lastComparison = TBaseHelper.compareTo((long)this.primitiveValue, (long)other.primitiveValue);
        }
        if (lastComparison == 0) {
            return TBaseHelper.compareTo((Object)this.getFieldValue(), (Object)other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + ((Object)((Object)this)).getClass().getName().hashCode();
        TFieldIdEnum setField = this.getSetField();
        if (setField != null) {
            hash = 31 * hash + setField.getThriftFieldId();
            Object value = this.getFieldValue();
            hash = value == null ? 31 * hash + (int)(this.primitiveValue ^ this.primitiveValue >>> 32) : (value instanceof TEnum ? 31 * hash + ((TEnum)this.getFieldValue()).getValue() : 31 * hash + value.hashCode());
        }
        return hash;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.BOOL_VAL, new FieldMetaData("bool_val", 3, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.BYTE_VAL, new FieldMetaData("byte_val", 3, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.I16_VAL, new FieldMetaData("i16_val", 3, new FieldValueMetaData(6)));
        tmpMap.put(_Fields.I32_VAL, new FieldMetaData("i32_val", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.I64_VAL, new FieldMetaData("i64_val", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FLOAT_VAL, new FieldMetaData("float_val", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.DOUBLE_VAL, new FieldMetaData("double_val", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.STRING_VAL, new FieldMetaData("string_val", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DECIMAL_VAL, new FieldMetaData("decimal_val", 3, (FieldValueMetaData)new StructMetaData(12, Decimal.class)));
        tmpMap.put(_Fields.DATE_VAL, new FieldMetaData("date_val", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIME_VAL, new FieldMetaData("time_val", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIMESTAMP_VAL, new FieldMetaData("timestamp_val", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.BINARY_VAL, new FieldMetaData("binary_val", 3, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.BLOB_VAL, new FieldMetaData("blob_val", 3, (FieldValueMetaData)new StructMetaData(12, BlobChunk.class)));
        tmpMap.put(_Fields.CLOB_VAL, new FieldMetaData("clob_val", 3, (FieldValueMetaData)new StructMetaData(12, ClobChunk.class)));
        tmpMap.put(_Fields.ARRAY_VAL, new FieldMetaData("array_val", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "ColumnValue"))));
        tmpMap.put(_Fields.MAP_VAL, new FieldMetaData("map_val", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(12, "ColumnValue"), new FieldValueMetaData(12, "ColumnValue"))));
        tmpMap.put(_Fields.STRUCT_VAL, new FieldMetaData("struct_val", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "ColumnValue"))));
        tmpMap.put(_Fields.NULL_VAL, new FieldMetaData("null_val", 3, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.JAVA_VAL, new FieldMetaData("java_val", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ColumnValue.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        BOOL_VAL(1, "bool_val"),
        BYTE_VAL(2, "byte_val"),
        I16_VAL(3, "i16_val"),
        I32_VAL(4, "i32_val"),
        I64_VAL(5, "i64_val"),
        FLOAT_VAL(6, "float_val"),
        DOUBLE_VAL(7, "double_val"),
        STRING_VAL(8, "string_val"),
        DECIMAL_VAL(9, "decimal_val"),
        DATE_VAL(10, "date_val"),
        TIME_VAL(11, "time_val"),
        TIMESTAMP_VAL(12, "timestamp_val"),
        BINARY_VAL(13, "binary_val"),
        BLOB_VAL(14, "blob_val"),
        CLOB_VAL(15, "clob_val"),
        ARRAY_VAL(16, "array_val"),
        MAP_VAL(17, "map_val"),
        STRUCT_VAL(18, "struct_val"),
        NULL_VAL(19, "null_val"),
        JAVA_VAL(20, "java_val");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return BOOL_VAL;
                }
                case 2: {
                    return BYTE_VAL;
                }
                case 3: {
                    return I16_VAL;
                }
                case 4: {
                    return I32_VAL;
                }
                case 5: {
                    return I64_VAL;
                }
                case 6: {
                    return FLOAT_VAL;
                }
                case 7: {
                    return DOUBLE_VAL;
                }
                case 8: {
                    return STRING_VAL;
                }
                case 9: {
                    return DECIMAL_VAL;
                }
                case 10: {
                    return DATE_VAL;
                }
                case 11: {
                    return TIME_VAL;
                }
                case 12: {
                    return TIMESTAMP_VAL;
                }
                case 13: {
                    return BINARY_VAL;
                }
                case 14: {
                    return BLOB_VAL;
                }
                case 15: {
                    return CLOB_VAL;
                }
                case 16: {
                    return ARRAY_VAL;
                }
                case 17: {
                    return MAP_VAL;
                }
                case 18: {
                    return STRUCT_VAL;
                }
                case 19: {
                    return NULL_VAL;
                }
                case 20: {
                    return JAVA_VAL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

