/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.services.info;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class ProductVersionHolder
implements PrivilegedAction {
    private static final int BAD_NUMBER = -1;
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    private static final int MAINT_ENCODING = 1000000;
    private String productVendorName;
    private String productName;
    private String productTechnologyName;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int maintVersion = -1;
    private int drdaMaintVersion = -1;
    private String buildNumber = "????";
    private Boolean isBeta;
    private String productGenus;

    private ProductVersionHolder() {
    }

    private ProductVersionHolder(String productVendorName, String productName, String productTechnologyName, int majorVersion, int minorVersion, int maintVersion, int drdaMaintVersion, String buildNumber, Boolean isBeta) {
        if (productVendorName != null) {
            this.productVendorName = productVendorName.trim();
        }
        if (productName != null) {
            this.productName = productName.trim();
        }
        if (productTechnologyName != null) {
            this.productTechnologyName = productTechnologyName.trim();
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.maintVersion = maintVersion;
        this.drdaMaintVersion = drdaMaintVersion;
        this.buildNumber = buildNumber;
        this.isBeta = isBeta;
    }

    public static ProductVersionHolder getProductVersionHolder(String productVendorName, String productName, String productTechnologyName, int majorVersion, int minorVersion, int maintVersion, int drdaMaintVersion, String buildNumber, Boolean isBeta) {
        ProductVersionHolder pvh = new ProductVersionHolder(productVendorName, productName, productTechnologyName, majorVersion, minorVersion, maintVersion, drdaMaintVersion, buildNumber, isBeta);
        return pvh;
    }

    public static ProductVersionHolder getProductVersionHolderFromMyEnv(String productGenus) {
        ProductVersionHolder tempPVH = new ProductVersionHolder();
        tempPVH.productGenus = productGenus;
        Properties p = (Properties)AccessController.doPrivileged(tempPVH);
        if (p == null) {
            return null;
        }
        return ProductVersionHolder.getProductVersionHolder(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductVersionHolder getProductVersionHolderFromMyEnv(InputStream propertiesStream) {
        if (propertiesStream == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(propertiesStream);
        }
        catch (IOException ioe) {
            System.out.println("IOE " + ioe.getMessage());
            ProductVersionHolder productVersionHolder = null;
            return productVersionHolder;
        }
        finally {
            try {
                propertiesStream.close();
            }
            catch (IOException iOException) {}
        }
        return ProductVersionHolder.getProductVersionHolder(p);
    }

    public static ProductVersionHolder getProductVersionHolder(Properties p) {
        String pvn = p.getProperty("gemfirexd.product.vendor");
        String pn = p.getProperty("gemfirexd.product.external.name");
        String ptn = p.getProperty("gemfirexd.product.technology.name");
        int v1 = ProductVersionHolder.parseInt(p.getProperty("gemfirexd.version.major"));
        int v2 = ProductVersionHolder.parseInt(p.getProperty("gemfirexd.version.minor"));
        int v3 = ProductVersionHolder.parseInt(p.getProperty("gemfirexd.version.maint"));
        int v4 = ProductVersionHolder.parseInt(p.getProperty("gemfirexd.version.drdamaint"));
        String bn = p.getProperty("gemfirexd.build.number");
        Boolean isBeta = Boolean.valueOf(p.getProperty("gemfirexd.version.beta"));
        return ProductVersionHolder.getProductVersionHolder(pvn, pn, ptn, v1, v2, v3, v4, bn, isBeta);
    }

    public String getProductVendorName() {
        return this.productVendorName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductTechnologyName() {
        return this.productTechnologyName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintVersion() {
        return this.maintVersion;
    }

    public int getDrdaMaintVersion() {
        return this.drdaMaintVersion;
    }

    public int getFixPackVersion() {
        return this.maintVersion / 1000000;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public boolean isAlpha() {
        return this.majorVersion >= 5 && this.minorVersion > 2 && this.maintVersion / 1000000 == 0;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getBuildNumberAsInt() {
        if (this.buildNumber == null) {
            return -1;
        }
        boolean dubiousCode = false;
        int offset = this.buildNumber.indexOf(77);
        if (offset == -1) {
            offset = this.buildNumber.indexOf(58);
        } else {
            dubiousCode = true;
        }
        if (offset == -1) {
            offset = this.buildNumber.length();
        } else {
            dubiousCode = true;
        }
        try {
            int bnai = Integer.parseInt(this.buildNumber.substring(0, offset));
            if (dubiousCode) {
                bnai = -bnai;
            }
            return bnai;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static int parseInt(String s) {
        int result = -1;
        try {
            if (s != null) {
                result = Integer.parseInt(s);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (result < 0) {
            result = -1;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProductVendorName());
        sb.append(" - ");
        sb.append(this.getProductName());
        sb.append(" - ");
        sb.append(this.getVersionBuildString(true));
        return sb.toString();
    }

    public String getSimpleVersionString() {
        return ProductVersionHolder.simpleVersionString(this.majorVersion, this.minorVersion, this.isBeta());
    }

    public static String simpleVersionString(int major, int minor, boolean isBeta) {
        StringBuilder sb = new StringBuilder();
        sb.append(major);
        sb.append('.');
        sb.append(minor);
        if (isBeta) {
            sb.append(' ');
            sb.append(BETA);
        }
        return sb.toString();
    }

    public static String fullVersionString(int major, int minor, int maint, boolean isBeta, String build) {
        StringBuilder sb = new StringBuilder();
        sb.append(major);
        sb.append('.');
        sb.append(minor);
        sb.append('.');
        String preRelease = null;
        if (major == 5 && minor <= 2 && maint < 1000000) {
            sb.append(maint);
            if (isBeta) {
                preRelease = BETA;
            }
        } else {
            int fixPack = maint / 1000000;
            int bugVersion = maint % 1000000;
            sb.append(fixPack);
            sb.append('.');
            sb.append(bugVersion);
            if (fixPack == 0) {
                preRelease = ALPHA;
            } else if (isBeta) {
                preRelease = BETA;
            }
        }
        if (preRelease != null) {
            sb.append(' ');
            sb.append(preRelease);
        }
        if (build != null) {
            sb.append(" - (");
            sb.append(build);
            sb.append(')');
        }
        return sb.toString();
    }

    public String getVersionBuildString(boolean withBuild) {
        return ProductVersionHolder.fullVersionString(this.majorVersion, this.minorVersion, this.maintVersion, this.isBeta(), withBuild ? this.buildNumber : null);
    }

    public final Object run() {
        return this.loadProperties(this.productGenus);
    }

    private Properties loadProperties(String productGenus) {
        String resourceName = "/com/pivotal/gemfirexd/internal/info/" + productGenus + ".properties";
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is == null) {
            return null;
        }
        Properties p = new Properties();
        try {
            p.load(is);
            is.close();
            return p;
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

