/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.common.TProtocolDirectBinary;
import io.snappydata.thrift.common.ThriftUtils;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransport;

public final class TBinaryProtocolDirect
extends TBinaryProtocol
implements TProtocolDirectBinary {
    private final TNonblockingTransport nonBlockingTransport;
    private final boolean useDirectBuffers;

    public TBinaryProtocolDirect(TTransport trans, boolean useDirectBuffers) {
        super(trans);
        this.nonBlockingTransport = trans instanceof TNonblockingTransport ? (TNonblockingTransport)trans : null;
        this.useDirectBuffers = useDirectBuffers;
    }

    @Override
    public ByteBuffer readDirectBinary() throws TException {
        if (this.useDirectBuffers && this.nonBlockingTransport != null) {
            int length = this.readI32();
            if (length < 0) {
                throw new TProtocolException(2, "Negative length: " + length);
            }
            return ThriftUtils.readByteBuffer(this.nonBlockingTransport, length);
        }
        return super.readBinary();
    }

    public void writeBinary(ByteBuffer buffer) throws TException {
        int length = buffer.remaining();
        this.writeI32(length);
        ThriftUtils.writeByteBuffer(buffer, this.trans_, this.nonBlockingTransport, length);
    }

    public static class Factory
    extends TBinaryProtocol.Factory {
        protected final boolean useDirectBuffers;

        public Factory(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        public TProtocol getProtocol(TTransport trans) {
            return new TBinaryProtocolDirect(trans, this.useDirectBuffers);
        }
    }
}

