/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.common.SSLFactory;
import io.snappydata.thrift.common.SSLSocketChannel;
import io.snappydata.thrift.common.SocketParameters;
import io.snappydata.thrift.common.SocketTimeout;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnappyTSocket
extends TNonblockingTransport
implements SocketTimeout {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SnappyTSocket.class.getName());
    private final SocketChannel socketChannel;
    private final ByteChannel dataChannel;
    private InetSocketAddress socketAddress;
    private volatile int timeout;
    private int inputBufferSize = 32768;
    private int outputBufferSize = 32768;
    private InputStreamChannel inputStream;
    private OutputStreamChannel outputStream;
    private final boolean framedWrites;

    public SnappyTSocket(SocketChannel srvChannel, boolean useSSL, boolean blocking, SocketParameters params) throws TTransportException {
        if (!srvChannel.isConnected()) {
            throw new TTransportException(1, "Socket must already be connected");
        }
        this.socketChannel = srvChannel;
        this.socketAddress = new InetSocketAddress(this.getSocket().getInetAddress(), this.getSocket().getPort());
        try {
            srvChannel.configureBlocking(blocking);
            this.setProperties(srvChannel.socket(), params.getReadTimeout(), params);
            this.dataChannel = this.initChannel(srvChannel.getRemoteAddress().toString(), null, useSSL, params, false);
            this.inputStream = UnsafeHolder.newChannelBufferFramedInputStream((ReadableByteChannel)this.dataChannel, (int)this.inputBufferSize);
            this.outputStream = UnsafeHolder.newChannelBufferOutputStream((WritableByteChannel)this.dataChannel, (int)this.outputBufferSize);
            this.framedWrites = false;
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed to create or configure socket for client.", (Throwable)ioe);
            this.close();
            throw new TTransportException(1, "Failed to create or configure socket for client.", (Throwable)ioe);
        }
    }

    public SnappyTSocket(HostAddress host, String clientId, boolean useSSL, boolean blocking, boolean framedWrites, SocketParameters params) throws TTransportException {
        this(host.resolveHost(), host.getPort(), clientId, useSSL, blocking, framedWrites, params.getReadTimeout(), params);
    }

    public SnappyTSocket(InetAddress srvAddress, int port, String clientId, boolean useSSL, boolean blocking, boolean framedWrites, int timeout, SocketParameters params) throws TTransportException {
        try {
            this.socketChannel = SnappyTSocket.initSocket(blocking);
            this.socketAddress = new InetSocketAddress(srvAddress, port);
            this.framedWrites = framedWrites;
            this.setProperties(this.socketChannel.socket(), timeout, params);
            this.dataChannel = this.openChannel(clientId, useSSL, params);
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed to create or configure socket.", (Throwable)ioe);
            this.close();
            throw new TTransportException(1, "Failed to create or configure socket.", (Throwable)ioe);
        }
    }

    private static SocketChannel initSocket(boolean blocking) throws TTransportException, IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(blocking);
        return socketChannel;
    }

    private ByteChannel initChannel(String id, SelectionKey key, boolean ssl, SocketParameters params, boolean forClient) throws TTransportException, IOException {
        if (ssl) {
            SSLEngine engine = SSLFactory.createEngine(this.socketAddress.getHostName(), this.socketAddress.getPort(), params, forClient);
            return SSLSocketChannel.create(id, this.socketChannel, key, engine, true);
        }
        return this.socketChannel;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.getSocket().getSoTimeout();
    }

    @Override
    public int getRawTimeout() {
        return this.timeout;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.getSocket().setSoTimeout(timeout);
        this.timeout = timeout;
    }

    protected static void setTimeout(Socket socket, int timeout, SocketParameters params) throws SocketException {
        socket.setSoTimeout(timeout != 0 ? timeout : params.getReadTimeout());
        ClientSharedUtils.setKeepAliveOptions((Socket)socket, null, (int)params.getKeepAliveIdle(), (int)params.getKeepAliveInterval(), (int)params.getKeepAliveCount());
    }

    protected void setProperties(Socket socket, int timeout, SocketParameters params) throws TTransportException, IOException {
        this.inputBufferSize = params.getInputBufferSize();
        this.outputBufferSize = params.getOutputBufferSize();
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        SnappyTSocket.setTimeout(socket, timeout, params);
        this.timeout = timeout;
    }

    public final Socket getSocket() {
        return this.socketChannel.socket();
    }

    public final SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public final InputStreamChannel getInputStream() {
        return this.inputStream;
    }

    public final OutputStreamChannel getOutputStream() {
        return this.outputStream;
    }

    public boolean isOpen() {
        SocketChannel channel = this.socketChannel;
        return channel != null && channel.isConnected();
    }

    private ByteChannel openChannel(String clientId, boolean useSSL, SocketParameters params) throws TTransportException, IOException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.socketAddress == null) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.socketAddress.getPort() <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        Socket socket = this.getSocket();
        socket.connect(this.socketAddress, this.timeout);
        if (clientId == null) {
            clientId = socket.getLocalSocketAddress().toString();
        }
        ByteChannel channel = this.initChannel(clientId, null, useSSL, params, true);
        this.inputStream = UnsafeHolder.newChannelBufferFramedInputStream((ReadableByteChannel)channel, (int)this.inputBufferSize);
        this.outputStream = this.framedWrites ? UnsafeHolder.newChannelBufferFramedOutputStream((WritableByteChannel)channel, (int)this.outputBufferSize) : UnsafeHolder.newChannelBufferOutputStream((WritableByteChannel)channel, (int)this.outputBufferSize);
        return channel;
    }

    public void open() throws TTransportException {
        if (!this.isOpen()) {
            throw new TTransportException(1, "Expected the socket to be already connected.");
        }
    }

    public boolean startConnect() throws IOException {
        return this.socketChannel.connect(this.socketAddress);
    }

    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    public SelectionKey registerSelector(Selector selector, int interests) throws IOException {
        return this.socketChannel.register(selector, interests);
    }

    public final int read(ByteBuffer buffer) throws IOException {
        return this.inputStream.read(buffer);
    }

    public final int read(byte[] buf, int off, int len) throws TTransportException {
        try {
            int bytesRead = this.inputStream.read(buf, off, len);
            if (bytesRead >= 0) {
                return bytesRead;
            }
            throw new TTransportException(4, "Channel closed.");
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot read from closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
    }

    public final int write(ByteBuffer buffer) throws IOException {
        OutputStreamChannel outStream = this.outputStream;
        int numWritten = outStream.write(buffer);
        if (buffer.position() >= buffer.limit()) {
            outStream.flush();
        }
        return numWritten;
    }

    public final void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.outputStream.write(buf, off, len);
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot write to closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
    }

    public void flush() throws TTransportException {
        try {
            this.outputStream.flush();
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot write to closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
    }

    @Override
    public void close() {
        ByteChannel channel;
        ByteChannel byteChannel = channel = this.dataChannel != null ? this.dataChannel : this.socketChannel;
        if (channel == null || !channel.isOpen()) {
            return;
        }
        InputStreamChannel inStream = this.inputStream;
        OutputStreamChannel outStream = this.outputStream;
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

