/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.DirectBufferAllocator;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SSLSocketChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    private static final Logger log = LoggerFactory.getLogger(SSLSocketChannel.class);
    private final String channelId;
    private final SSLEngine sslEngine;
    private final SelectionKey key;
    private final SocketChannel socketChannel;
    private final boolean useDirectBuffers;
    private final boolean enableRenegotiation;
    private SSLEngineResult.HandshakeStatus handshakeStatus;
    private SSLEngineResult handshakeResult;
    private boolean handshakeComplete = false;
    private boolean closing = false;
    private ByteBuffer netReadBuffer;
    private ByteBuffer netWriteBuffer;
    private ByteBuffer appReadBuffer;
    private ByteBuffer emptyBuf = ByteBuffer.allocate(0);
    private final boolean isTraceEnabled = log.isTraceEnabled();
    private static final String BUFFER_OWNER = "SSLCHANNEL";

    public static SSLSocketChannel create(String channelId, SocketChannel channel, SelectionKey key, SSLEngine sslEngine, boolean useDirectBuffers) throws IOException {
        if (key == null) {
            key = new DummyReadWriteKey(channel);
        }
        SSLSocketChannel transportLayer = new SSLSocketChannel(channelId, key, sslEngine, useDirectBuffers, false);
        transportLayer.startHandshake();
        return transportLayer;
    }

    SSLSocketChannel(String channelId, SelectionKey key, SSLEngine sslEngine, boolean useDirectBuffers, boolean enableRenegotiation) {
        this.channelId = channelId;
        this.key = key;
        this.socketChannel = (SocketChannel)key.channel();
        this.sslEngine = sslEngine;
        this.useDirectBuffers = useDirectBuffers;
        this.enableRenegotiation = enableRenegotiation;
    }

    protected void startHandshake() throws IOException {
        if (this.useDirectBuffers) {
            DirectBufferAllocator allocator = DirectBufferAllocator.instance();
            this.netReadBuffer = allocator.allocate(this.netReadBufferSize(), BUFFER_OWNER);
            this.netWriteBuffer = allocator.allocate(this.netWriteBufferSize(), BUFFER_OWNER);
            this.appReadBuffer = allocator.allocate(this.applicationBufferSize(), BUFFER_OWNER);
        } else {
            this.netReadBuffer = ByteBuffer.allocate(this.netReadBufferSize());
            this.netWriteBuffer = ByteBuffer.allocate(this.netWriteBufferSize());
            this.appReadBuffer = ByteBuffer.allocate(this.applicationBufferSize());
        }
        this.netWriteBuffer.position(0);
        this.netWriteBuffer.limit(0);
        this.netReadBuffer.position(0);
        this.netReadBuffer.limit(0);
        this.handshakeComplete = false;
        this.closing = false;
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
    }

    public boolean finishConnect() throws IOException {
        boolean connected = this.socketChannel.finishConnect();
        if (connected) {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFF7 | 1);
        }
        return connected;
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.sslEngine.closeOutbound();
        try {
            if (this.isConnected()) {
                if (!this.flush(this.netWriteBuffer)) {
                    throw new IOException("Remaining data in the network buffer, can't send SSL close message.");
                }
                this.netWriteBuffer.clear();
                SSLEngineResult wrapResult = this.sslEngine.wrap(this.emptyBuf, this.netWriteBuffer);
                if (wrapResult.getStatus() != SSLEngineResult.Status.CLOSED) {
                    throw new IOException("Unexpected status returned by SSLEngine.wrap, expected CLOSED, received " + (Object)((Object)wrapResult.getStatus()) + ". Will not send close message to peer.");
                }
                this.netWriteBuffer.flip();
                this.flush(this.netWriteBuffer);
            }
            if (this.useDirectBuffers) {
                ByteBuffer buffer = this.netReadBuffer;
                this.netReadBuffer = null;
                DirectBufferAllocator allocator = DirectBufferAllocator.instance();
                allocator.release(buffer);
                buffer = this.netWriteBuffer;
                this.netWriteBuffer = null;
                allocator.release(buffer);
                buffer = this.appReadBuffer;
                this.appReadBuffer = null;
                allocator.release(buffer);
            }
        }
        catch (IOException ie) {
            log.warn("Failed to send SSL Close message.", (Throwable)ie);
        }
        finally {
            try {
                this.socketChannel.socket().close();
                this.socketChannel.close();
            }
            finally {
                this.key.attach(null);
                this.key.cancel();
            }
        }
    }

    public boolean hasPendingWrites() {
        return this.netWriteBuffer.hasRemaining();
    }

    private boolean flush(ByteBuffer buf) throws IOException {
        int remaining = buf.remaining();
        if (remaining > 0) {
            int written = this.socketChannel.write(buf);
            return written >= remaining;
        }
        return true;
    }

    public void handshake() throws IOException {
        boolean read = this.key.isReadable();
        boolean write = this.key.isWritable();
        this.handshakeComplete = false;
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        if (!this.flush(this.netWriteBuffer)) {
            this.key.interestOps(this.key.interestOps() | 4);
            return;
        }
        try {
            switch (this.handshakeStatus) {
                case NEED_TASK: {
                    if (this.isTraceEnabled) {
                        log.trace("SSLHandshake NEED_TASK channelId {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    this.handshakeStatus = this.runDelegatedTasks();
                    break;
                }
                case NEED_WRAP: {
                    if (this.isTraceEnabled) {
                        log.trace("SSLHandshake NEED_WRAP channelId {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    this.handshakeResult = this.handshakeWrap(write);
                    if (this.handshakeResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        int currentNetWriteBufferSize = this.netWriteBufferSize();
                        this.netWriteBuffer.compact();
                        this.netWriteBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.netWriteBuffer, (int)currentNetWriteBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
                        this.netWriteBuffer.flip();
                        if (this.netWriteBuffer.limit() >= currentNetWriteBufferSize) {
                            throw new IllegalStateException("Buffer overflow when available data size (" + this.netWriteBuffer.limit() + ") >= network buffer size (" + currentNetWriteBufferSize + ")");
                        }
                    } else {
                        if (this.handshakeResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            throw new IllegalStateException("Should not have received BUFFER_UNDERFLOW during handshake WRAP.");
                        }
                        if (this.handshakeResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            throw new EOFException();
                        }
                    }
                    if (this.isTraceEnabled) {
                        log.trace("SSLHandshake NEED_WRAP channelId {}, handshakeResult {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.handshakeResult, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.flush(this.netWriteBuffer)) {
                        this.key.interestOps(this.key.interestOps() | 4);
                        break;
                    }
                }
                case NEED_UNWRAP: {
                    if (this.isTraceEnabled) {
                        log.trace("SSLHandshake NEED_UNWRAP channelId {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    do {
                        this.handshakeResult = this.handshakeUnwrap(read);
                        if (this.handshakeResult.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue;
                        int currentAppBufferSize = this.applicationBufferSize();
                        this.appReadBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.appReadBuffer, (int)currentAppBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
                        if (this.appReadBuffer.position() <= currentAppBufferSize) continue;
                        throw new IllegalStateException("Buffer underflow when available data size (" + this.appReadBuffer.position() + ") > packet buffer size (" + currentAppBufferSize + ")");
                    } while (this.handshakeResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW);
                    if (this.handshakeResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        int currentNetReadBufferSize = this.netReadBufferSize();
                        this.netReadBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.netReadBuffer, (int)currentNetReadBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
                        if (this.netReadBuffer.position() >= currentNetReadBufferSize) {
                            throw new IllegalStateException("Buffer underflow when there is available data");
                        }
                    } else if (this.handshakeResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                        throw new EOFException("SSL handshake status CLOSED during handshake UNWRAP");
                    }
                    if (this.isTraceEnabled) {
                        log.trace("SSLHandshake NEED_UNWRAP channelId {}, handshakeResult {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.handshakeResult, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                            this.key.interestOps(this.key.interestOps() | 4);
                            break;
                        }
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
                        }
                        break;
                    }
                }
                case FINISHED: {
                    this.handshakeFinished();
                    break;
                }
                case NOT_HANDSHAKING: {
                    this.handshakeFinished();
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected status [%s]", new Object[]{this.handshakeStatus}));
                }
            }
        }
        catch (SSLException e) {
            this.handshakeFailure();
            throw e;
        }
    }

    private void renegotiate() throws IOException {
        if (!this.enableRenegotiation) {
            throw new SSLHandshakeException("Renegotiation is not supported");
        }
        this.handshake();
    }

    private SSLEngineResult.HandshakeStatus runDelegatedTasks() {
        Runnable task;
        while ((task = this.delegatedTask()) != null) {
            task.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    private void handshakeFinished() throws IOException {
        if (this.handshakeResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            boolean bl = this.handshakeComplete = !this.netWriteBuffer.hasRemaining();
            if (!this.handshakeComplete) {
                this.key.interestOps(this.key.interestOps() | 4);
            } else {
                this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
            }
            if (this.isTraceEnabled) {
                log.trace("SSLHandshake FINISHED channelId {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {} ", new Object[]{this.channelId, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
            }
        } else {
            throw new IOException("NOT_HANDSHAKING during handshake");
        }
    }

    private SSLEngineResult handshakeWrap(boolean doWrite) throws IOException {
        if (this.isTraceEnabled) {
            log.trace("SSLHandshake handshakeWrap {}", (Object)this.channelId);
        }
        if (this.netWriteBuffer.hasRemaining()) {
            throw new IllegalStateException("handshakeWrap called with netWriteBuffer not empty");
        }
        this.netWriteBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.emptyBuf, this.netWriteBuffer);
        this.netWriteBuffer.flip();
        this.handshakeStatus = result.getHandshakeStatus();
        if (result.getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.handshakeStatus = this.runDelegatedTasks();
        }
        if (doWrite) {
            this.flush(this.netWriteBuffer);
        }
        return result;
    }

    private SSLEngineResult handshakeUnwrap(boolean doRead) throws IOException {
        SSLEngineResult result;
        boolean cont;
        int read;
        if (this.isTraceEnabled) {
            log.trace("SSLHandshake handshakeUnwrap {}", (Object)this.channelId);
        }
        if (doRead && (read = this.socketChannel.read(this.netReadBuffer)) == -1) {
            throw new EOFException("EOF during handshake.");
        }
        do {
            this.netReadBuffer.flip();
            result = this.sslEngine.unwrap(this.netReadBuffer, this.appReadBuffer);
            this.netReadBuffer.compact();
            this.handshakeStatus = result.getHandshakeStatus();
            if (result.getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.handshakeStatus = this.runDelegatedTasks();
            }
            boolean bl = cont = result.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            if (!this.isTraceEnabled) continue;
            log.trace("SSLHandshake handshakeUnwrap: handshakeStatus {} status {}", (Object)this.handshakeStatus, (Object)result.getStatus());
        } while (this.netReadBuffer.position() != 0 && cont);
        return result;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.closing) {
            return -1;
        }
        int read = 0;
        if (!this.handshakeComplete) {
            return read;
        }
        if (this.appReadBuffer.position() > 0) {
            read = this.readFromAppBuffer(dst);
        }
        if (dst.remaining() > 0) {
            this.netReadBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.netReadBuffer, (int)this.netReadBufferSize(), (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
            if (this.netReadBuffer.remaining() > 0) {
                int netRead = this.socketChannel.read(this.netReadBuffer);
                if (netRead == 0 && this.netReadBuffer.position() == 0) {
                    return netRead;
                }
                if (netRead < 0) {
                    throw new EOFException("EOF during read");
                }
            }
            do {
                this.netReadBuffer.flip();
                SSLEngineResult unwrapResult = this.sslEngine.unwrap(this.netReadBuffer, this.appReadBuffer);
                this.netReadBuffer.compact();
                if (unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && unwrapResult.getStatus() == SSLEngineResult.Status.OK) {
                    if (this.isTraceEnabled) {
                        log.trace("SSLChannel Read begin renegotiation channelId {}, appReadBuffer pos {}, netReadBuffer pos {}, netWriteBuffer pos {}", new Object[]{this.channelId, this.appReadBuffer.position(), this.netReadBuffer.position(), this.netWriteBuffer.position()});
                    }
                    this.renegotiate();
                    break;
                }
                if (unwrapResult.getStatus() == SSLEngineResult.Status.OK) {
                    read += this.readFromAppBuffer(dst);
                    continue;
                }
                if (unwrapResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int currentApplicationBufferSize = this.applicationBufferSize();
                    this.appReadBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.appReadBuffer, (int)currentApplicationBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
                    if (this.appReadBuffer.position() >= currentApplicationBufferSize) {
                        throw new IllegalStateException("Buffer overflow when available data size (" + this.appReadBuffer.position() + ") >= application buffer size (" + currentApplicationBufferSize + ")");
                    }
                    if (!dst.hasRemaining()) break;
                    read += this.readFromAppBuffer(dst);
                    continue;
                }
                if (unwrapResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    int currentNetReadBufferSize = this.netReadBufferSize();
                    this.netReadBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.netReadBuffer, (int)currentNetReadBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
                    if (this.netReadBuffer.position() < currentNetReadBufferSize) break;
                    throw new IllegalStateException("Buffer underflow when available data size (" + this.netReadBuffer.position() + ") > packet buffer size (" + currentNetReadBufferSize + ")");
                }
                if (unwrapResult.getStatus() != SSLEngineResult.Status.CLOSED) continue;
                throw new EOFException();
            } while (this.netReadBuffer.position() != 0);
        }
        return read;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.read(dsts, 0, dsts.length);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > dsts.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int totalRead = 0;
        int i = offset;
        while (i < length) {
            if (dsts[i].hasRemaining()) {
                int read = this.read(dsts[i]);
                if (read <= 0) break;
                totalRead += read;
            }
            if (dsts[i].hasRemaining()) continue;
            ++i;
        }
        return totalRead;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int written = 0;
        if (this.closing) {
            throw new IllegalStateException("Channel is in closing state");
        }
        if (!this.handshakeComplete) {
            return written;
        }
        if (!this.flush(this.netWriteBuffer)) {
            return written;
        }
        this.netWriteBuffer.clear();
        SSLEngineResult wrapResult = this.sslEngine.wrap(src, this.netWriteBuffer);
        this.netWriteBuffer.flip();
        if (wrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && wrapResult.getStatus() == SSLEngineResult.Status.OK) {
            this.renegotiate();
            return written;
        }
        if (wrapResult.getStatus() == SSLEngineResult.Status.OK) {
            written = wrapResult.bytesConsumed();
            this.flush(this.netWriteBuffer);
        } else if (wrapResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            int currentNetWriteBufferSize = this.netWriteBufferSize();
            this.netWriteBuffer.compact();
            this.netWriteBuffer = ClientSharedUtils.ensureCapacity((ByteBuffer)this.netWriteBuffer, (int)currentNetWriteBufferSize, (boolean)this.useDirectBuffers, (String)BUFFER_OWNER);
            this.netWriteBuffer.flip();
            if (this.netWriteBuffer.limit() >= currentNetWriteBufferSize) {
                throw new IllegalStateException("SSL BUFFER_OVERFLOW when available data size (" + this.netWriteBuffer.limit() + ") >= network buffer size (" + currentNetWriteBufferSize + ")");
            }
        } else {
            if (wrapResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                throw new IllegalStateException("SSL BUFFER_UNDERFLOW during write");
            }
            if (wrapResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                throw new EOFException();
            }
        }
        return written;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || offset > srcs.length - length) {
            throw new IndexOutOfBoundsException();
        }
        int totalWritten = 0;
        for (int i = offset; i < length; ++i) {
            int written;
            if ((srcs[i].hasRemaining() || this.hasPendingWrites()) && (written = this.write(srcs[i])) > 0) {
                totalWritten += written;
            }
            if (srcs[i].hasRemaining() || this.hasPendingWrites()) break;
        }
        return totalWritten;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    protected Runnable delegatedTask() {
        return this.sslEngine.getDelegatedTask();
    }

    private int readFromAppBuffer(ByteBuffer dst) {
        this.appReadBuffer.flip();
        int remaining = Math.min(this.appReadBuffer.remaining(), dst.remaining());
        if (remaining > 0) {
            int limit = this.appReadBuffer.limit();
            this.appReadBuffer.limit(this.appReadBuffer.position() + remaining);
            dst.put(this.appReadBuffer);
            this.appReadBuffer.limit(limit);
        }
        this.appReadBuffer.compact();
        return remaining;
    }

    protected int netReadBufferSize() {
        return this.sslEngine.getSession().getPacketBufferSize();
    }

    protected int netWriteBufferSize() {
        return this.sslEngine.getSession().getPacketBufferSize();
    }

    protected int applicationBufferSize() {
        return this.sslEngine.getSession().getApplicationBufferSize();
    }

    private void handshakeFailure() {
        this.sslEngine.closeOutbound();
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            log.debug("SSLEngine.closeInBound() raised an exception.", (Throwable)e);
        }
    }

    private static final class DummyReadWriteKey
    extends SelectionKey {
        private final SocketChannel channel;
        private int ops;

        private DummyReadWriteKey(SocketChannel channel) {
            this.channel = channel;
            this.ops = 5;
        }

        @Override
        public SelectableChannel channel() {
            return this.channel;
        }

        @Override
        public Selector selector() {
            throw new IllegalArgumentException("not expected to be invoked");
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public int interestOps() {
            return this.ops;
        }

        @Override
        public SelectionKey interestOps(int ops) {
            this.ops = ops;
            return this;
        }

        @Override
        public int readyOps() {
            return this.ops;
        }
    }
}

