/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import io.snappydata.thrift.Decimal;
import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.common.ColumnValueConverter;
import io.snappydata.thrift.common.LobService;
import io.snappydata.thrift.common.OptimizedElementArray;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Converters {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Converters.class.getName());
    static final BigDecimal MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    static final BigDecimal MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    public static final long MICROS_PER_SECOND = 1000000L;
    public static final long NANOS_PER_SECOND = 1000000000L;
    public static final long NANOS_PER_MILLI = 1000000L;
    public static final ColumnValueConverter BOOLEAN_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BOOLEAN;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getBoolean(columnPosition - 1);
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getBoolean(columnPosition - 1) ? BigDecimal.ONE : BigDecimal.ZERO;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getBoolean(columnPosition - 1) ? "true" : "false";
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getBoolean(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setBoolean(columnPosition - 1, x);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0L);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0.0f);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != 0.0);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            row.setBoolean(columnPosition - 1, !BigDecimal.ZERO.equals(x));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setBoolean(columnPosition - 1, x != null && !x.equals("0") && !x.equalsIgnoreCase("false"));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "boolean", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter BYTE_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TINYINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getByte(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Byte.toString(row.getByte(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getByte(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setByte(columnPosition - 1, x ? (byte)1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setByte(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            if (x < -128 || x > 127) {
                throw Converters.newOutOfRangeException("byte", columnPosition);
            }
            row.setByte(columnPosition - 1, (byte)x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            if (x < -128 || x > 127) {
                throw Converters.newOutOfRangeException("byte", columnPosition);
            }
            row.setByte(columnPosition - 1, (byte)x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            if (x < -128L || x > 127L) {
                throw Converters.newOutOfRangeException("byte", columnPosition);
            }
            row.setByte(columnPosition - 1, (byte)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            if (!(x >= -128.0f) || !(x <= 127.0f)) {
                throw Converters.newOutOfRangeException("byte", columnPosition);
            }
            row.setByte(columnPosition - 1, (byte)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            if (!(x >= -128.0) || !(x <= 127.0)) {
                throw Converters.newOutOfRangeException("byte", columnPosition);
            }
            row.setByte(columnPosition - 1, (byte)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "byte", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter SHORT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.SMALLINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            short v = row.getShort(columnPosition - 1);
            if (v >= -128 && v <= 127) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getShort(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getShort(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Short.toString(row.getShort(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return (int)row.getShort(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setShort(columnPosition - 1, x ? (short)1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setShort(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setShort(columnPosition - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            if (x < Short.MIN_VALUE || x > Short.MAX_VALUE) {
                throw Converters.newOutOfRangeException("short", columnPosition);
            }
            row.setShort(columnPosition - 1, (short)x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            if (x < -32768L || x > 32767L) {
                throw Converters.newOutOfRangeException("short", columnPosition);
            }
            row.setShort(columnPosition - 1, (short)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            if (!(x >= -32768.0f) || !(x <= 32767.0f)) {
                throw Converters.newOutOfRangeException("short", columnPosition);
            }
            row.setShort(columnPosition - 1, (short)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            if (!(x >= -32768.0) || !(x <= 32767.0)) {
                throw Converters.newOutOfRangeException("short", columnPosition);
            }
            row.setShort(columnPosition - 1, (short)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "short", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter INT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.INTEGER;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getInt(columnPosition - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            int v = row.getInt(columnPosition - 1);
            if (v >= -128 && v <= 127) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            int v = row.getInt(columnPosition - 1);
            if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getInt(columnPosition - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getInt(columnPosition - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getInt(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getInt(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getInt(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Integer.toString(row.getInt(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getInt(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setInt(columnPosition - 1, x ? 1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setInt(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setInt(columnPosition - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            row.setInt(columnPosition - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
                throw Converters.newOutOfRangeException("int", columnPosition);
            }
            row.setInt(columnPosition - 1, (int)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            if (!(x >= -2.1474836E9f) || !(x <= 2.1474836E9f)) {
                throw Converters.newOutOfRangeException("int", columnPosition);
            }
            row.setInt(columnPosition - 1, (int)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            if (!(x >= -2.147483648E9) || !(x <= 2.147483647E9)) {
                throw Converters.newOutOfRangeException("int", columnPosition);
            }
            row.setInt(columnPosition - 1, (int)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "int", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter LONG_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BIGINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getLong(columnPosition - 1) != 0L;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = row.getLong(columnPosition - 1);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = row.getLong(columnPosition - 1);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = row.getLong(columnPosition - 1);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnPosition);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getLong(columnPosition - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getLong(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getLong(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getLong(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Long.toString(row.getLong(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getLong(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setLong(columnPosition - 1, x ? 1L : 0L);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setLong(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setLong(columnPosition - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            row.setLong(columnPosition - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            row.setLong(columnPosition - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            if (!(x >= -9.223372E18f) || !(x <= 9.223372E18f)) {
                throw Converters.newOutOfRangeException("long", columnPosition);
            }
            row.setLong(columnPosition - 1, (long)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            if (!(x >= -9.223372036854776E18) || !(x <= 9.223372036854776E18)) {
                throw Converters.newOutOfRangeException("long", columnPosition);
            }
            row.setLong(columnPosition - 1, (long)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setLong(row, columnPosition, Converters.getLong(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "long", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter FLOAT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.FLOAT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getFloat(columnPosition - 1) != 0.0f;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            float v = row.getFloat(columnPosition - 1);
            if (v >= -128.0f && v <= 127.0f) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            float v = row.getFloat(columnPosition - 1);
            if (v >= -32768.0f && v <= 32767.0f) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            float v = row.getFloat(columnPosition - 1);
            if (v >= -2.1474836E9f && v <= 2.1474836E9f) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnPosition);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            float v = row.getFloat(columnPosition - 1);
            if (v >= -9.223372E18f && v <= 9.223372E18f) {
                return (long)v;
            }
            throw Converters.newOutOfRangeException("long", columnPosition);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getFloat(columnPosition - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getFloat(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getFloat(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Float.toString(row.getFloat(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Float.valueOf(row.getFloat(columnPosition - 1));
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setFloat(columnPosition - 1, x ? 1.0f : 0.0f);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setFloat(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setFloat(columnPosition - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            row.setFloat(columnPosition - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            if (!((float)x >= Float.MIN_VALUE)) {
                throw Converters.newOutOfRangeException("float", columnPosition);
            }
            row.setFloat(columnPosition - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            row.setFloat(columnPosition - 1, x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            if (!(x >= (double)1.4E-45f) || !(x <= 3.4028234663852886E38)) {
                throw Converters.newOutOfRangeException("float", columnPosition);
            }
            row.setFloat(columnPosition - 1, (float)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setDouble(row, columnPosition, Converters.getDouble(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setDouble(row, columnPosition, Converters.getDouble(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "float", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter DOUBLE_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.DOUBLE;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getDouble(columnPosition - 1) != 0.0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = row.getDouble(columnPosition - 1);
            if (v >= -128.0 && v <= 127.0) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = row.getDouble(columnPosition - 1);
            if (v >= -32768.0 && v <= 32767.0) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = row.getDouble(columnPosition - 1);
            if (v >= -2.147483648E9 && v <= 2.147483647E9) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnPosition);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = row.getDouble(columnPosition - 1);
            if (v >= -9.223372036854776E18 && v <= 9.223372036854776E18) {
                return (long)v;
            }
            throw Converters.newOutOfRangeException("long", columnPosition);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = row.getDouble(columnPosition - 1);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnPosition);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return row.getDouble(columnPosition - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return new BigDecimal(row.getDouble(columnPosition - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return Double.toString(row.getDouble(columnPosition - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getDouble(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            row.setDouble(columnPosition - 1, x ? 1.0 : 0.0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            row.setDouble(columnPosition - 1, x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setDouble(row, columnPosition, Converters.getDouble(x, columnPosition));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setDouble(row, columnPosition, Converters.getDouble(x, columnPosition));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Integer.class) {
                    this.setInteger(row, (Integer)o, columnPosition);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "double", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter DECIMAL_TYPE = new ColumnValueConverter(){

        @Override
        public final SnappyType getType() {
            return SnappyType.DECIMAL;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            BigDecimal bd = (BigDecimal)row.getObject(columnPosition - 1);
            return bd != null && !bd.equals(BigDecimal.ZERO);
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnPosition);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            BigDecimal decimal = (BigDecimal)row.getObject(columnPosition - 1);
            return Converters.getLong(decimal, columnPosition);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = Converters.getDouble((BigDecimal)row.getObject(columnPosition - 1), columnPosition);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnPosition);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return Converters.getDouble((BigDecimal)row.getObject(columnPosition - 1), columnPosition);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return (BigDecimal)row.getObject(columnPosition - 1);
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            BigDecimal bd = (BigDecimal)row.getObject(columnPosition - 1);
            if (bd != null) {
                return bd.toPlainString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            this.setBigDecimal(row, columnPosition, x ? BigDecimal.ONE : BigDecimal.ZERO);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            this.setBigDecimal(row, columnPosition, new BigDecimal(x));
        }

        @Override
        public final void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.DECIMAL);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setObject(columnPosition - 1, Converters.getBigDecimal(x, columnPosition), SnappyType.DECIMAL);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnPosition, (BigDecimal)o);
            } else {
                Class<?> c = o.getClass();
                if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (o instanceof String) {
                    this.setString(row, columnPosition, (String)o);
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), "BigDecimal", columnPosition);
                }
            }
        }
    };
    public static final ColumnValueConverter DATE_TYPE = new ColumnValueConverter(){

        @Override
        public final SnappyType getType() {
            return SnappyType.DATE;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Date date = row.getDate(columnPosition - 1);
            return date.toString();
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Date(millis);
            }
            cal.setTimeInMillis(millis);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Timestamp(millis);
            }
            cal.setTimeInMillis(millis);
            return new Timestamp(cal.getTimeInMillis());
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Time(millis);
            }
            cal.setTimeInMillis(millis);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getDate(columnPosition - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            Date date = Date.valueOf(x);
            row.setDateTime(columnPosition - 1, date);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof java.util.Date) {
                row.setDateTime(columnPosition - 1, (java.util.Date)o);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "Date", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter TIME_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TIME;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Time time = row.getTime(columnPosition - 1);
            return time.toString();
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Date(millis);
            }
            cal.setTimeInMillis(millis);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Timestamp(millis);
            }
            cal.setTimeInMillis(millis);
            return new Timestamp(cal.getTimeInMillis());
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long millis = row.getDateTimeMillis(columnPosition - 1);
            if (cal == null) {
                return new Time(millis);
            }
            cal.setTimeInMillis(millis);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getTime(columnPosition - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            row.setDateTime(columnPosition - 1, x);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            Time dtime = Time.valueOf(x);
            row.setTimestamp(columnPosition - 1, dtime);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof java.util.Date) {
                row.setDateTime(columnPosition - 1, (java.util.Date)o);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "Time", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter TIMESTAMP_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TIMESTAMP;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Timestamp ts = row.getTimestamp(columnPosition - 1);
            return ts.toString();
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long ts = row.getLong(columnPosition - 1);
            if (cal == null) {
                return new Date(ts / 1000000L);
            }
            cal.setTimeInMillis(ts / 1000000L);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long ts = row.getLong(columnPosition - 1);
            if (cal == null) {
                return Converters.getTimestamp(ts);
            }
            long seconds = ts / 1000000000L;
            long nanos = ts % 1000000000L;
            if (nanos < 0L) {
                nanos += 1000000000L;
                --seconds;
            }
            cal.setTimeInMillis(seconds * 1000L);
            return Converters.getTimestamp(cal.getTimeInMillis() * 1000000L + nanos);
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            long ts = row.getLong(columnPosition - 1);
            if (cal == null) {
                return new Time(ts / 1000000L);
            }
            cal.setTimeInMillis(ts / 1000000L);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getTimestamp(columnPosition - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            row.setTimestamp(columnPosition - 1, x);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            row.setTimestamp(columnPosition - 1, x);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            row.setTimestamp(columnPosition - 1, x);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            Timestamp timestamp = Timestamp.valueOf(x);
            row.setTimestamp(columnPosition - 1, timestamp);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof Timestamp) {
                row.setTimestamp(columnPosition - 1, (Timestamp)o);
            } else if (o instanceof java.util.Date) {
                row.setTimestamp(columnPosition - 1, (java.util.Date)o);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "Timestamp", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter STRING_TYPE = new StringConverter();
    public static final ColumnValueConverter CLOB_TYPE = new ClobConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.CLOB;
        }
    };
    public static final ColumnValueConverter BINARY_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.VARBINARY;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            byte[] bytes = (byte[])row.getObject(columnPosition - 1);
            if (bytes != null) {
                return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
            }
            return null;
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return (byte[])row.getObject(columnPosition - 1);
        }

        @Override
        public InputStream toBinaryStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return new ByteArrayInputStream(this.toBytes(row, columnPosition, lobService));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public final void setBytes(OptimizedElementArray row, int columnPosition, byte[] x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.VARBINARY);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            try {
                byte[] bytes = ClientSharedUtils.fromHexString((String)x, (int)0, (int)x.length());
                this.setBytes(row, columnPosition, bytes);
            }
            catch (IllegalArgumentException iae) {
                throw Converters.newTypeSetConversionException("String", this.getType().toString(), Integer.toString(columnPosition), iae);
            }
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof byte[]) {
                this.setBytes(row, columnPosition, (byte[])o);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "byte[]", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter BLOB_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BLOB;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            byte[] bytes = this.toBytes(row, columnPosition, lobService);
            if (bytes != null) {
                return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
            }
            return null;
        }

        @Override
        public final byte[] toBytes(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Blob blob = (Blob)row.getObject(columnPosition - 1);
            return blob.getBytes(1L, (int)blob.length());
        }

        @Override
        public final Blob toBlob(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return (Blob)row.getObject(columnPosition - 1);
        }

        @Override
        public InputStream toBinaryStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Blob blob = (Blob)row.getObject(columnPosition - 1);
            return blob.getBinaryStream();
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return this.toBlob(row, columnPosition, lobService);
        }

        private void freeBlob(OptimizedElementArray row, int index) throws SQLException {
            Object o;
            if (!row.isNull(index) && (o = row.getObject(index)) != null) {
                ((Blob)o).free();
            }
        }

        @Override
        public final void setBytes(OptimizedElementArray row, int columnPosition, byte[] x) throws SQLException {
            int index = columnPosition - 1;
            this.freeBlob(row, index);
            row.setObject(index, x, SnappyType.VARBINARY);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            try {
                byte[] bytes = ClientSharedUtils.fromHexString((String)x, (int)0, (int)x.length());
                this.setBytes(row, columnPosition, bytes);
            }
            catch (IllegalArgumentException iae) {
                throw Converters.newTypeSetConversionException("String", this.getType().toString(), Integer.toString(columnPosition), iae);
            }
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                int index = columnPosition - 1;
                this.freeBlob(row, index);
                row.setNull(index);
            } else if (o instanceof byte[]) {
                this.setBytes(row, columnPosition, (byte[])o);
            } else if (o instanceof Blob) {
                Blob blob = (Blob)o;
                long blobLen = blob.length();
                if (blobLen > Integer.MAX_VALUE) {
                    throw ThriftExceptionUtil.newSQLException("XJ079.S", null, blobLen);
                }
                this.setBytes(row, columnPosition, blob.getBytes(1L, (int)blobLen));
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "Blob", columnPosition);
            }
        }
    };
    static final ObjectInputStreamCreator javaObjectCreator = new ObjectInputStreamCreator(){

        @Override
        public ObjectInputStream create(InputStream stream) throws IOException {
            return new ClientSharedUtils.ThreadContextObjectInputStream(stream);
        }
    };
    public static final ColumnValueConverter OBJECT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.JAVA_OBJECT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Byte) {
                return (Byte)o != 0;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "boolean", columnPosition);
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).byteValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "byte", columnPosition);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "short", columnPosition);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "int", columnPosition);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "long", columnPosition);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "float", columnPosition);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "double", columnPosition);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof BigDecimal) {
                return (BigDecimal)o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "BigDecimal", columnPosition);
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Date) {
                return (Date)o;
            }
            if (o instanceof Number) {
                return Converters.getDate(((Number)o).longValue());
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Date", columnPosition);
        }

        @Override
        public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Timestamp) {
                return (Timestamp)o;
            }
            if (o instanceof Number) {
                return Converters.getTimestamp(((Number)o).longValue());
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Timestamp", columnPosition);
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof Time) {
                return (Time)o;
            }
            if (o instanceof Number) {
                return Converters.getTime(((Number)o).longValue());
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Time", columnPosition);
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Object o = this.toObject(row, columnPosition);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "byte[]", columnPosition);
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return this.toObject(row, columnPosition);
        }

        private Object toObject(OptimizedElementArray row, int columnPosition) throws SQLException {
            JavaObjectWrapper jw = (JavaObjectWrapper)row.getObject(columnPosition - 1);
            if (jw != null) {
                return jw.getDeserialized(columnPosition, javaObjectCreator);
            }
            return null;
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            this.setObject(row, columnPosition, Float.valueOf(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public final void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            this.setObject(row, columnPosition, x);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            row.setObject(columnPosition - 1, new JavaObjectWrapper(o, columnPosition), SnappyType.JAVA_OBJECT);
        }
    };
    public static final ColumnValueConverter ARRAY_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.ARRAY;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Object o = row.getObject(columnPosition - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof List) {
                row.setObject(columnPosition - 1, o, SnappyType.ARRAY);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "ARRAY", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter MAP_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.MAP;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Object o = row.getObject(columnPosition - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof Map) {
                row.setObject(columnPosition - 1, o, SnappyType.MAP);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "MAP", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter STRUCT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.STRUCT;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Object o = row.getObject(columnPosition - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else if (o instanceof List) {
                row.setObject(columnPosition - 1, o, SnappyType.STRUCT);
            } else if (o instanceof String) {
                this.setString(row, columnPosition, (String)o);
            } else {
                throw Converters.newTypeSetConversionException(o.getClass().getName(), "STRUCT", columnPosition);
            }
        }
    };
    public static final ColumnValueConverter JSON_TYPE = new ClobConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.JSON;
        }
    };
    static final ColumnValueConverter NULL_ONLY_TYPE = new NullConverter();
    public static final ColumnValueConverter NULL_TYPE = new NullConverter(){

        private ColumnValueConverter getConverterForSet(int snappyTypeValue, String targetType, int columnPosition) throws SQLException {
            ColumnValueConverter conv = Converters.getConverter(snappyTypeValue, targetType, true, columnPosition);
            return conv != NULL_TYPE ? conv : NULL_ONLY_TYPE;
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "boolean", columnPosition).setBoolean(row, columnPosition, x);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "byte", columnPosition).setByte(row, columnPosition, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "short", columnPosition).setShort(row, columnPosition, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "int", columnPosition).setInteger(row, columnPosition, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "long", columnPosition).setLong(row, columnPosition, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "float", columnPosition).setFloat(row, columnPosition, x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            this.getConverterForSet(row.setNotNull(columnPosition - 1), "double", columnPosition).setDouble(row, columnPosition, x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "BigDecimal", columnPosition).setBigDecimal(row, columnPosition, x);
            }
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "string", columnPosition).setString(row, columnPosition, x);
            }
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "date", columnPosition).setDate(row, columnPosition, x);
            }
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "time", columnPosition).setTime(row, columnPosition, x);
            }
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "timestamp", columnPosition).setTimestamp(row, columnPosition, x);
            }
        }

        @Override
        public void setBytes(OptimizedElementArray row, int columnPosition, byte[] x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "byte[]", columnPosition).setBytes(row, columnPosition, x);
            }
        }

        @Override
        public void setBlob(OptimizedElementArray row, int columnPosition, Blob x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "blob", columnPosition).setBlob(row, columnPosition, x);
            }
        }

        @Override
        public void setBinaryStream(OptimizedElementArray row, int columnPosition, InputStream stream, long length, LobService lobService) throws SQLException {
            if (stream != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "BinaryStream", columnPosition).setBinaryStream(row, columnPosition, stream, length, lobService);
            }
        }

        @Override
        public void setClob(OptimizedElementArray row, int columnPosition, Clob x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "clob", columnPosition).setClob(row, columnPosition, x);
            }
        }

        @Override
        public void setCharacterStream(OptimizedElementArray row, int columnPosition, Reader reader, long length, LobService lobService) throws SQLException {
            if (reader != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "CharacterStream", columnPosition).setCharacterStream(row, columnPosition, reader, length, lobService);
            }
        }

        @Override
        public void setAsciiStream(OptimizedElementArray row, int columnPosition, InputStream stream, long length, LobService lobService) throws SQLException {
            if (stream != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "AsciiStream", columnPosition).setAsciiStream(row, columnPosition, stream, length, lobService);
            }
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object x) throws SQLException {
            if (x != null) {
                this.getConverterForSet(row.setNotNull(columnPosition - 1), "object", columnPosition).setObject(row, columnPosition, x);
            }
        }
    };
    static final ColumnValueConverter[] typeConverters;
    static final int[] jdbcTypes;

    private Converters() {
    }

    public static SQLException newTypeConversionException(String sourceType, String targetType, String column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22005", cause, targetType, sourceType, column);
    }

    public static SQLException newTypeConversionException(String sourceType, String targetType, int columnPosition) {
        return Converters.newTypeConversionException(sourceType, targetType, Integer.toString(columnPosition), null);
    }

    public static SQLException newTypeSetConversionException(String sourceType, String targetType, String column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("XCL12.S", cause, sourceType, targetType, column);
    }

    public static SQLException newTypeSetConversionException(String sourceType, String targetType, int columnPosition) {
        return Converters.newTypeSetConversionException(sourceType, targetType, Integer.toString(columnPosition), null);
    }

    public static SQLException newOutOfRangeException(String type, int column) {
        return Converters.newOutOfRangeException(type, column, null);
    }

    public static SQLException newOutOfRangeException(String type, int column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22003", cause, type, column);
    }

    public static SQLException newFormatException(String type, int column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22018", cause, type, column);
    }

    public static ColumnValueConverter getConverter(int snappyTypeValue, String targetType, boolean forSet, int columnPosition) throws SQLException {
        String typeString;
        ColumnValueConverter converter;
        ColumnValueConverter columnValueConverter = converter = snappyTypeValue > 0 ? typeConverters[snappyTypeValue] : NULL_TYPE;
        if (converter != null) {
            return converter;
        }
        SnappyType type = SnappyType.findByValue(snappyTypeValue);
        String string = typeString = type != null ? type.toString() : Integer.toString(snappyTypeValue);
        if (forSet) {
            throw Converters.newTypeSetConversionException(typeString, targetType, Integer.toString(columnPosition), null);
        }
        throw Converters.newTypeConversionException(typeString, targetType, Integer.toString(columnPosition), null);
    }

    public static BigDecimal getBigDecimal(Decimal decimal) {
        return new BigDecimal(new BigInteger((int)decimal.signum, decimal.getMagnitude()), decimal.scale);
    }

    public static BigDecimal getBigDecimal(String str, int columnPosition) throws SQLException {
        if (str != null) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("decimal", columnPosition, nfe);
            }
        }
        return null;
    }

    public static Decimal getDecimal(BigDecimal decimal) {
        decimal = Converters.adjustScale(decimal);
        BigInteger bi = decimal.unscaledValue();
        return new Decimal((byte)bi.signum(), decimal.scale(), ByteBuffer.wrap(bi.abs().toByteArray()));
    }

    public static Date getDate(long date) {
        return new Date(date * 1000L);
    }

    public static Time getTime(long time) {
        return new Time(time * 1000L);
    }

    public static long getDateTime(java.util.Date date) {
        return date.getTime() / 1000L;
    }

    public static BigDecimal adjustScale(BigDecimal decimal) {
        if (decimal.scale() >= 0) {
            return decimal;
        }
        return decimal.setScale(0, 7);
    }

    public static long getLong(String str, int columnPosition) throws SQLException {
        if (str != null) {
            try {
                return Long.parseLong(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("long", columnPosition, nfe);
            }
        }
        return 0L;
    }

    public static long getLong(BigDecimal decimal, int columnPosition) throws SQLException {
        if (decimal != null) {
            if (decimal.compareTo(MINLONG_MINUS_ONE) == 1 && decimal.compareTo(MAXLONG_PLUS_ONE) == -1) {
                return decimal.longValue();
            }
            throw Converters.newOutOfRangeException("long", columnPosition);
        }
        return 0L;
    }

    public static double getDouble(String str, int columnPosition) throws SQLException {
        if (str != null) {
            try {
                return Double.parseDouble(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("double", columnPosition, nfe);
            }
        }
        return 0.0;
    }

    public static double getDouble(BigDecimal decimal, int columnPosition) throws SQLException {
        if (decimal != null) {
            double v = decimal.doubleValue();
            if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                return v;
            }
            throw Converters.newOutOfRangeException("double", columnPosition);
        }
        return 0.0;
    }

    public static Timestamp getTimestamp(long ts) {
        long seconds = ts / 1000000000L;
        long nanos = ts % 1000000000L;
        if (nanos < 0L) {
            nanos += 1000000000L;
            --seconds;
        }
        Timestamp jts = new Timestamp(seconds * 1000L);
        jts.setNanos((int)nanos);
        return jts;
    }

    public static long getTimestampNanos(Timestamp ts) {
        return ts.getTime() * 1000000L + (long)ts.getNanos() % 1000000L;
    }

    public static long getTimestampNanos(java.util.Date date) {
        return date.getTime() * 1000000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object getJavaObject(byte[] bytes, int columnPosition, ObjectInputStreamCreator creator) throws SQLException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = creator.create(in);){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.warn("Exception in deserialization of java object", (Throwable)e);
            throw ThriftExceptionUtil.newSQLException("XCL30.S", e, "Java object deserialization at position=" + columnPosition);
        }
    }

    public static byte[] getJavaObjectAsBytes(Object o, int columnPosition) throws SQLException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.flush();
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            LOGGER.warn("Exception in serialization of java object", (Throwable)ioe);
            throw ThriftExceptionUtil.newSQLException("XCL30.S", ioe, "Java object serialization at position=" + columnPosition);
        }
    }

    public static int getJdbcType(SnappyType type) {
        return type != null ? jdbcTypes[type.getValue()] : 0;
    }

    public static SnappyType getThriftSQLType(int jdbcType) {
        return Converters.getThriftSQLType(jdbcType, false);
    }

    public static SnappyType getThriftSQLType(int jdbcType, boolean useStringForDecimal) {
        switch (jdbcType) {
            case 12: {
                return SnappyType.VARCHAR;
            }
            case 4: {
                return SnappyType.INTEGER;
            }
            case -5: {
                return SnappyType.BIGINT;
            }
            case 6: 
            case 8: {
                return SnappyType.DOUBLE;
            }
            case 2: 
            case 3: {
                return useStringForDecimal ? SnappyType.VARCHAR : SnappyType.DECIMAL;
            }
            case 1: {
                return SnappyType.CHAR;
            }
            case 91: {
                return SnappyType.DATE;
            }
            case 93: {
                return SnappyType.TIMESTAMP;
            }
            case 5: {
                return SnappyType.SMALLINT;
            }
            case -7: 
            case 16: {
                return SnappyType.BOOLEAN;
            }
            case 7: {
                return SnappyType.FLOAT;
            }
            case -1: {
                return SnappyType.LONGVARCHAR;
            }
            case 2004: {
                return SnappyType.BLOB;
            }
            case 2005: {
                return SnappyType.CLOB;
            }
            case 2003: {
                return SnappyType.ARRAY;
            }
            case -2: {
                return SnappyType.BINARY;
            }
            case 2000: {
                return SnappyType.JAVA_OBJECT;
            }
            case 4002: {
                return SnappyType.JSON;
            }
            case -4: {
                return SnappyType.LONGVARBINARY;
            }
            case 4001: {
                return SnappyType.MAP;
            }
            case 0: {
                return SnappyType.NULLTYPE;
            }
            case 1111: {
                return SnappyType.OTHER;
            }
            case 2009: {
                return SnappyType.SQLXML;
            }
            case 2002: {
                return SnappyType.STRUCT;
            }
            case 92: {
                return SnappyType.TIME;
            }
            case -6: {
                return SnappyType.TINYINT;
            }
            case -3: {
                return SnappyType.VARBINARY;
            }
        }
        return SnappyType.OTHER;
    }

    public static int getJdbcResultSetType(byte thriftType) {
        switch (thriftType) {
            case 1: {
                return 1003;
            }
            case 2: {
                return 1004;
            }
            case 3: {
                return 1005;
            }
        }
        throw new IllegalArgumentException("Thrift ResultSet type=" + thriftType);
    }

    public static int getThriftResultSetType(int jdbcType) {
        switch (jdbcType) {
            case 1003: {
                return 1;
            }
            case 1004: {
                return 2;
            }
            case 1005: {
                return 3;
            }
        }
        return 4;
    }

    public static int getJdbcIsolation(int thriftIsolationLevel) {
        switch (thriftIsolationLevel) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Thrift isolation level=" + thriftIsolationLevel);
    }

    public static byte getThriftTransactionIsolation(int jdbcIsolationLevel) {
        switch (jdbcIsolationLevel) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return 64;
    }

    static {
        SnappyType[] universe = SnappyType.values();
        typeConverters = new ColumnValueConverter[universe.length + 2];
        jdbcTypes = new int[universe.length + 2];
        block28: for (SnappyType type : universe) {
            int typeValue = type.getValue();
            switch (type) {
                case CHAR: {
                    Converters.jdbcTypes[typeValue] = 1;
                    Converters.typeConverters[typeValue] = STRING_TYPE;
                    continue block28;
                }
                case VARCHAR: {
                    Converters.jdbcTypes[typeValue] = 12;
                    Converters.typeConverters[typeValue] = STRING_TYPE;
                    continue block28;
                }
                case LONGVARCHAR: {
                    Converters.jdbcTypes[typeValue] = -1;
                    Converters.typeConverters[typeValue] = STRING_TYPE;
                    continue block28;
                }
                case INTEGER: {
                    Converters.jdbcTypes[typeValue] = 4;
                    Converters.typeConverters[typeValue] = INT_TYPE;
                    continue block28;
                }
                case BOOLEAN: {
                    Converters.jdbcTypes[typeValue] = 16;
                    Converters.typeConverters[typeValue] = BOOLEAN_TYPE;
                    continue block28;
                }
                case TINYINT: {
                    Converters.jdbcTypes[typeValue] = -6;
                    Converters.typeConverters[typeValue] = BYTE_TYPE;
                    continue block28;
                }
                case SMALLINT: {
                    Converters.jdbcTypes[typeValue] = 5;
                    Converters.typeConverters[typeValue] = SHORT_TYPE;
                    continue block28;
                }
                case BIGINT: {
                    Converters.jdbcTypes[typeValue] = -5;
                    Converters.typeConverters[typeValue] = LONG_TYPE;
                    continue block28;
                }
                case FLOAT: {
                    Converters.jdbcTypes[typeValue] = 7;
                    Converters.typeConverters[typeValue] = FLOAT_TYPE;
                    continue block28;
                }
                case DOUBLE: {
                    Converters.jdbcTypes[typeValue] = 8;
                    Converters.typeConverters[typeValue] = DOUBLE_TYPE;
                    continue block28;
                }
                case DECIMAL: {
                    Converters.jdbcTypes[typeValue] = 3;
                    Converters.typeConverters[typeValue] = DECIMAL_TYPE;
                    continue block28;
                }
                case DATE: {
                    Converters.jdbcTypes[typeValue] = 91;
                    Converters.typeConverters[typeValue] = DATE_TYPE;
                    continue block28;
                }
                case TIME: {
                    Converters.jdbcTypes[typeValue] = 92;
                    Converters.typeConverters[typeValue] = TIME_TYPE;
                    continue block28;
                }
                case TIMESTAMP: {
                    Converters.jdbcTypes[typeValue] = 93;
                    Converters.typeConverters[typeValue] = TIMESTAMP_TYPE;
                    continue block28;
                }
                case BINARY: {
                    Converters.jdbcTypes[typeValue] = -2;
                    Converters.typeConverters[typeValue] = BINARY_TYPE;
                    continue block28;
                }
                case VARBINARY: {
                    Converters.jdbcTypes[typeValue] = -3;
                    Converters.typeConverters[typeValue] = BINARY_TYPE;
                    continue block28;
                }
                case LONGVARBINARY: {
                    Converters.jdbcTypes[typeValue] = -4;
                    Converters.typeConverters[typeValue] = BINARY_TYPE;
                    continue block28;
                }
                case CLOB: {
                    Converters.jdbcTypes[typeValue] = 2005;
                    Converters.typeConverters[typeValue] = CLOB_TYPE;
                    continue block28;
                }
                case BLOB: {
                    Converters.jdbcTypes[typeValue] = 2004;
                    Converters.typeConverters[typeValue] = BLOB_TYPE;
                    continue block28;
                }
                case ARRAY: {
                    Converters.jdbcTypes[typeValue] = 2003;
                    Converters.typeConverters[typeValue] = ARRAY_TYPE;
                    continue block28;
                }
                case MAP: {
                    Converters.jdbcTypes[typeValue] = 4001;
                    Converters.typeConverters[typeValue] = MAP_TYPE;
                }
                case STRUCT: {
                    Converters.jdbcTypes[typeValue] = 2002;
                    Converters.typeConverters[typeValue] = STRUCT_TYPE;
                }
                case JSON: {
                    Converters.jdbcTypes[typeValue] = 4002;
                    Converters.typeConverters[typeValue] = JSON_TYPE;
                    continue block28;
                }
                case NULLTYPE: {
                    Converters.jdbcTypes[typeValue] = 0;
                    Converters.typeConverters[typeValue] = NULL_TYPE;
                    continue block28;
                }
                case JAVA_OBJECT: {
                    Converters.jdbcTypes[typeValue] = 2000;
                    Converters.typeConverters[typeValue] = OBJECT_TYPE;
                    continue block28;
                }
                case OTHER: {
                    Converters.jdbcTypes[typeValue] = 1111;
                    Converters.typeConverters[typeValue] = OBJECT_TYPE;
                    continue block28;
                }
                default: {
                    Converters.jdbcTypes[typeValue] = 1111;
                }
            }
        }
    }

    public static interface ObjectInputStreamCreator {
        public ObjectInputStream create(InputStream var1) throws IOException;
    }

    public static final class JavaObjectWrapper {
        private Object deserialized;
        private byte[] serialized;

        public JavaObjectWrapper(Object deserialized, int columnPosition) throws SQLException {
            this.deserialized = deserialized;
            this.serialized = Converters.getJavaObjectAsBytes(this.deserialized, columnPosition);
        }

        public JavaObjectWrapper(byte[] serialized) {
            this.serialized = serialized;
        }

        public Object getDeserialized(int columnPosition, ObjectInputStreamCreator creator) throws SQLException {
            Object deserialized = this.deserialized;
            if (deserialized != null) {
                return deserialized;
            }
            this.deserialized = Converters.getJavaObject(this.serialized, columnPosition, creator);
            return this.deserialized;
        }

        public byte[] getSerialized() {
            return this.serialized;
        }
    }

    public static class NullConverter
    extends ColumnValueConverter {
        @Override
        public SnappyType getType() {
            return SnappyType.NULLTYPE;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            return false;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0;
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0;
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0;
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0L;
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0.0f;
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return 0.0;
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            return null;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Blob toBlob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public InputStream toBinaryStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Clob toClob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Reader toCharacterStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public InputStream toAsciiStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            throw Converters.newTypeSetConversionException(this.getType().toString(), "String", columnPosition);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object x) throws SQLException {
            throw Converters.newTypeSetConversionException(this.getType().toString(), "Object", columnPosition);
        }

        @Override
        public boolean isNull() {
            return true;
        }
    }

    static class ClobConverter
    extends StringConverter {
        ClobConverter() {
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Clob clob = (Clob)row.getObject(columnPosition - 1);
            return clob.getSubString(1L, (int)clob.length());
        }

        @Override
        public final Clob toClob(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return (Clob)row.getObject(columnPosition - 1);
        }

        @Override
        public Reader toCharacterStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Clob clob = (Clob)row.getObject(columnPosition - 1);
            return clob.getCharacterStream();
        }

        @Override
        public InputStream toAsciiStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            Clob clob = (Clob)row.getObject(columnPosition - 1);
            return clob.getAsciiStream();
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return this.toClob(row, columnPosition, lobService);
        }

        private void freeClob(OptimizedElementArray row, int index) throws SQLException {
            Object o;
            if (!row.isNull(index) && (o = row.getObject(index)) != null) {
                ((Clob)o).free();
            }
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            int index = columnPosition - 1;
            this.freeClob(row, index);
            row.setObject(index, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                int index = columnPosition - 1;
                this.freeClob(row, index);
                row.setNull(index);
            } else if (o instanceof Clob) {
                Clob clob = (Clob)o;
                long clobLen = clob.length();
                if (clobLen > Integer.MAX_VALUE) {
                    throw ThriftExceptionUtil.newSQLException("XJ079.S", null, clobLen);
                }
                this.setString(row, columnPosition, clob.getSubString(1L, (int)clobLen));
            } else {
                super.setObject(row, columnPosition, o);
            }
        }
    }

    public static class StringConverter
    extends ColumnValueConverter {
        @Override
        public SnappyType getType() {
            return SnappyType.VARCHAR;
        }

        @Override
        public final boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
            String str = this.toString(row, columnPosition);
            if (str != null) {
                return !(str = str.trim()).equals("0") && !str.equalsIgnoreCase("false");
            }
            return false;
        }

        @Override
        public final byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnPosition);
        }

        @Override
        public final short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnPosition);
        }

        @Override
        public final int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
            long v = this.toLong(row, columnPosition);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnPosition);
        }

        @Override
        public final long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
            return Converters.getLong(this.toString(row, columnPosition), columnPosition);
        }

        @Override
        public final float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
            double v = this.toDouble(row, columnPosition);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnPosition);
        }

        @Override
        public final double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
            return Converters.getDouble(this.toString(row, columnPosition), columnPosition);
        }

        @Override
        public final BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
            String str = this.toString(row, columnPosition);
            try {
                return new BigDecimal(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("BigDecimal", columnPosition, nfe);
            }
        }

        private String toString(OptimizedElementArray row, int columnPosition) throws SQLException {
            return (String)row.getObject(columnPosition - 1);
        }

        @Override
        public String toString(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return this.toString(row, columnPosition);
        }

        @Override
        public final Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            String str = this.toString(row, columnPosition);
            if (str != null) {
                Date date;
                try {
                    date = Date.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return date;
                }
                cal.setTime(date);
                return new Date(cal.getTimeInMillis());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public final Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            String str = this.toString(row, columnPosition);
            if (str != null) {
                Timestamp ts;
                try {
                    ts = Timestamp.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return ts;
                }
                cal.setTime(ts);
                return Converters.getTimestamp(cal.getTimeInMillis() * 1000000L + (long)ts.getNanos());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public final Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
            String str = this.toString(row, columnPosition);
            if (str != null) {
                Time time;
                try {
                    time = Time.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return time;
                }
                cal.setTime(time);
                return new Time(cal.getTimeInMillis());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public Reader toCharacterStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return new StringReader(this.toString(row, columnPosition));
        }

        @Override
        public InputStream toAsciiStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return new ReaderInputStream((Reader)new StringReader(this.toString(row, columnPosition)), StandardCharsets.US_ASCII);
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
            return row.getObject(columnPosition - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
            this.setString(row, columnPosition, x ? "true" : "false");
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
            this.setString(row, columnPosition, Byte.toString(x));
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
            this.setString(row, columnPosition, Short.toString(x));
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
            this.setString(row, columnPosition, Integer.toString(x));
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
            this.setString(row, columnPosition, Long.toString(x));
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
            this.setString(row, columnPosition, Float.toString(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
            this.setString(row, columnPosition, Double.toString(x));
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
            this.setString(row, columnPosition, x.toPlainString());
        }

        @Override
        public void setString(OptimizedElementArray row, int columnPosition, String x) throws SQLException {
            row.setObject(columnPosition - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
            this.setString(row, columnPosition, x.toString());
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
            this.setString(row, columnPosition, x.toString());
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
            this.setString(row, columnPosition, x.toString());
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnPosition, Object o) throws SQLException {
            if (o == null) {
                row.setNull(columnPosition - 1);
            } else {
                Class<?> c = o.getClass();
                if (c == String.class) {
                    this.setString(row, columnPosition, (String)o);
                } else if (c == Double.class) {
                    this.setDouble(row, columnPosition, (Double)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnPosition, ((Float)o).floatValue());
                } else if (c == Integer.class) {
                    this.setInteger(row, columnPosition, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnPosition, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnPosition, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnPosition, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnPosition, (Boolean)o);
                } else if (o instanceof BigDecimal) {
                    this.setBigDecimal(row, columnPosition, (BigDecimal)o);
                } else if (o instanceof java.util.Date) {
                    this.setString(row, columnPosition, o.toString());
                } else {
                    throw Converters.newTypeSetConversionException(c.getName(), this.getType().toString(), columnPosition);
                }
            }
        }
    }
}

