/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.common.BufferedBlob;
import io.snappydata.thrift.common.Converters;
import io.snappydata.thrift.common.LobService;
import io.snappydata.thrift.common.OptimizedElementArray;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class ColumnValueConverter {
    public abstract SnappyType getType();

    public boolean toBoolean(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "boolean", columnPosition);
    }

    public byte toByte(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte", columnPosition);
    }

    public short toShort(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "short", columnPosition);
    }

    public int toInteger(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "int", columnPosition);
    }

    public long toLong(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "long", columnPosition);
    }

    public float toFloat(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "float", columnPosition);
    }

    public double toDouble(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "double", columnPosition);
    }

    public BigDecimal toBigDecimal(OptimizedElementArray row, int columnPosition) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "BigDecimal", columnPosition);
    }

    public abstract String toString(OptimizedElementArray var1, int var2, LobService var3) throws SQLException;

    public Date toDate(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Date", columnPosition);
    }

    public Time toTime(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Time", columnPosition);
    }

    public Timestamp toTimestamp(OptimizedElementArray row, int columnPosition, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Timestamp", columnPosition);
    }

    public byte[] toBytes(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte[]", columnPosition);
    }

    public Blob toBlob(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Blob", columnPosition);
    }

    public InputStream toBinaryStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "InputStream", columnPosition);
    }

    public Clob toClob(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Clob", columnPosition);
    }

    public Reader toCharacterStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "CharacterStream", columnPosition);
    }

    public InputStream toAsciiStream(OptimizedElementArray row, int columnPosition, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "AsciiStream", columnPosition);
    }

    public abstract Object toObject(OptimizedElementArray var1, int var2, LobService var3) throws SQLException;

    public void setBoolean(OptimizedElementArray row, int columnPosition, boolean x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "boolean", columnPosition);
    }

    public void setByte(OptimizedElementArray row, int columnPosition, byte x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "byte", columnPosition);
    }

    public void setShort(OptimizedElementArray row, int columnPosition, short x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "short", columnPosition);
    }

    public void setInteger(OptimizedElementArray row, int columnPosition, int x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "int", columnPosition);
    }

    public void setLong(OptimizedElementArray row, int columnPosition, long x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "long", columnPosition);
    }

    public void setFloat(OptimizedElementArray row, int columnPosition, float x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "float", columnPosition);
    }

    public void setDouble(OptimizedElementArray row, int columnPosition, double x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "double", columnPosition);
    }

    public void setBigDecimal(OptimizedElementArray row, int columnPosition, BigDecimal x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "BigDecimal", columnPosition);
    }

    public abstract void setString(OptimizedElementArray var1, int var2, String var3) throws SQLException;

    public void setDate(OptimizedElementArray row, int columnPosition, Date x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "Date", columnPosition);
    }

    public void setTime(OptimizedElementArray row, int columnPosition, Time x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "Time", columnPosition);
    }

    public void setTimestamp(OptimizedElementArray row, int columnPosition, Timestamp x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "Timestamp", columnPosition);
    }

    public void setBytes(OptimizedElementArray row, int columnPosition, byte[] x) throws SQLException {
        throw Converters.newTypeSetConversionException(this.getType().toString(), "byte[]", columnPosition);
    }

    public void setBlob(OptimizedElementArray row, int columnPosition, Blob x) throws SQLException {
        long len = x.length();
        if (len <= Integer.MAX_VALUE) {
            if (x instanceof BufferedBlob) {
                row.setObject(columnPosition - 1, ((BufferedBlob)x).getAsLastChunk(), SnappyType.BLOB);
            } else {
                this.setBytes(row, columnPosition, x.getBytes(1L, (int)len));
            }
        } else {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, len, Integer.MAX_VALUE);
        }
    }

    public void setBinaryStream(OptimizedElementArray row, int columnPosition, InputStream stream, long length, LobService lobService) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, length, Integer.MAX_VALUE);
        }
        this.setBlob(row, columnPosition, lobService.createBlob(stream, length));
    }

    public void setClob(OptimizedElementArray row, int columnPosition, Clob x) throws SQLException {
        long len = x.length();
        if (len > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, len, Integer.MAX_VALUE);
        }
        this.setString(row, columnPosition, x.getSubString(1L, (int)len));
    }

    public void setCharacterStream(OptimizedElementArray row, int columnPosition, Reader reader, long length, LobService lobService) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, length, Integer.MAX_VALUE);
        }
        this.setClob(row, columnPosition, lobService.createClob(reader, length));
    }

    public void setAsciiStream(OptimizedElementArray row, int columnPosition, InputStream stream, long length, LobService lobService) throws SQLException {
        if (length > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, length, Integer.MAX_VALUE);
        }
        this.setClob(row, columnPosition, lobService.createClob(stream, length));
    }

    public abstract void setObject(OptimizedElementArray var1, int var2, Object var3) throws SQLException;

    public boolean isNull() {
        return false;
    }
}

