/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import io.snappydata.thrift.SnappyType;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ServiceMetaDataArgs
implements TBase<ServiceMetaDataArgs, _Fields>,
Serializable,
Cloneable,
Comparable<ServiceMetaDataArgs> {
    private static final TStruct STRUCT_DESC = new TStruct("ServiceMetaDataArgs");
    private static final TField CONN_ID_FIELD_DESC = new TField("connId", 10, 1);
    private static final TField DRIVER_TYPE_FIELD_DESC = new TField("driverType", 3, 2);
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 3);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 11, 4);
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 5);
    private static final TField TABLE_TYPES_FIELD_DESC = new TField("tableTypes", 15, 6);
    private static final TField COLUMN_NAME_FIELD_DESC = new TField("columnName", 11, 7);
    private static final TField FOREIGN_SCHEMA_FIELD_DESC = new TField("foreignSchema", 11, 8);
    private static final TField FOREIGN_TABLE_FIELD_DESC = new TField("foreignTable", 11, 9);
    private static final TField PROCEDURE_NAME_FIELD_DESC = new TField("procedureName", 11, 10);
    private static final TField FUNCTION_NAME_FIELD_DESC = new TField("functionName", 11, 11);
    private static final TField ATTRIBUTE_NAME_FIELD_DESC = new TField("attributeName", 11, 12);
    private static final TField TYPE_NAME_FIELD_DESC = new TField("typeName", 11, 13);
    private static final TField TYPE_ID_FIELD_DESC = new TField("typeId", 8, 14);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long connId;
    public byte driverType;
    public ByteBuffer token;
    public String schema;
    public String table;
    public List<String> tableTypes;
    public String columnName;
    public String foreignSchema;
    public String foreignTable;
    public String procedureName;
    public String functionName;
    public String attributeName;
    public String typeName;
    public SnappyType typeId;
    private static final int __CONNID_ISSET_ID = 0;
    private static final int __DRIVERTYPE_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ServiceMetaDataArgs() {
    }

    public ServiceMetaDataArgs(long connId, byte driverType, ByteBuffer token) {
        this();
        this.connId = connId;
        this.setConnIdIsSet(true);
        this.driverType = driverType;
        this.setDriverTypeIsSet(true);
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
    }

    public ServiceMetaDataArgs(ServiceMetaDataArgs other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.connId = other.connId;
        this.driverType = other.driverType;
        if (other.isSetToken()) {
            this.token = TBaseHelper.copyBinary((ByteBuffer)other.token);
        }
        if (other.isSetSchema()) {
            this.schema = other.schema;
        }
        if (other.isSetTable()) {
            this.table = other.table;
        }
        if (other.isSetTableTypes()) {
            ArrayList<String> __this__tableTypes = new ArrayList<String>(other.tableTypes);
            this.tableTypes = __this__tableTypes;
        }
        if (other.isSetColumnName()) {
            this.columnName = other.columnName;
        }
        if (other.isSetForeignSchema()) {
            this.foreignSchema = other.foreignSchema;
        }
        if (other.isSetForeignTable()) {
            this.foreignTable = other.foreignTable;
        }
        if (other.isSetProcedureName()) {
            this.procedureName = other.procedureName;
        }
        if (other.isSetFunctionName()) {
            this.functionName = other.functionName;
        }
        if (other.isSetAttributeName()) {
            this.attributeName = other.attributeName;
        }
        if (other.isSetTypeName()) {
            this.typeName = other.typeName;
        }
        if (other.isSetTypeId()) {
            this.typeId = other.typeId;
        }
    }

    public ServiceMetaDataArgs deepCopy() {
        return new ServiceMetaDataArgs(this);
    }

    public void clear() {
        this.setConnIdIsSet(false);
        this.connId = 0L;
        this.setDriverTypeIsSet(false);
        this.driverType = 0;
        this.token = null;
        this.schema = null;
        this.table = null;
        this.tableTypes = null;
        this.columnName = null;
        this.foreignSchema = null;
        this.foreignTable = null;
        this.procedureName = null;
        this.functionName = null;
        this.attributeName = null;
        this.typeName = null;
        this.typeId = null;
    }

    public long getConnId() {
        return this.connId;
    }

    public ServiceMetaDataArgs setConnId(long connId) {
        this.connId = connId;
        this.setConnIdIsSet(true);
        return this;
    }

    public void unsetConnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetConnId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setConnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte getDriverType() {
        return this.driverType;
    }

    public ServiceMetaDataArgs setDriverType(byte driverType) {
        this.driverType = driverType;
        this.setDriverTypeIsSet(true);
        return this;
    }

    public void unsetDriverType() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetDriverType() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setDriverTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public byte[] getToken() {
        this.setToken(TBaseHelper.rightSize((ByteBuffer)this.token));
        return this.token == null ? null : this.token.array();
    }

    public ByteBuffer bufferForToken() {
        return TBaseHelper.copyBinary((ByteBuffer)this.token);
    }

    public ServiceMetaDataArgs setToken(byte[] token) {
        this.token = token == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(token, token.length));
        return this;
    }

    public ServiceMetaDataArgs setToken(ByteBuffer token) {
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    public String getSchema() {
        return this.schema;
    }

    public ServiceMetaDataArgs setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public String getTable() {
        return this.table;
    }

    public ServiceMetaDataArgs setTable(String table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    public int getTableTypesSize() {
        return this.tableTypes == null ? 0 : this.tableTypes.size();
    }

    public Iterator<String> getTableTypesIterator() {
        return this.tableTypes == null ? null : this.tableTypes.iterator();
    }

    public void addToTableTypes(String elem) {
        if (this.tableTypes == null) {
            this.tableTypes = new ArrayList<String>();
        }
        this.tableTypes.add(elem);
    }

    public List<String> getTableTypes() {
        return this.tableTypes;
    }

    public ServiceMetaDataArgs setTableTypes(List<String> tableTypes) {
        this.tableTypes = tableTypes;
        return this;
    }

    public void unsetTableTypes() {
        this.tableTypes = null;
    }

    public boolean isSetTableTypes() {
        return this.tableTypes != null;
    }

    public void setTableTypesIsSet(boolean value) {
        if (!value) {
            this.tableTypes = null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ServiceMetaDataArgs setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public void unsetColumnName() {
        this.columnName = null;
    }

    public boolean isSetColumnName() {
        return this.columnName != null;
    }

    public void setColumnNameIsSet(boolean value) {
        if (!value) {
            this.columnName = null;
        }
    }

    public String getForeignSchema() {
        return this.foreignSchema;
    }

    public ServiceMetaDataArgs setForeignSchema(String foreignSchema) {
        this.foreignSchema = foreignSchema;
        return this;
    }

    public void unsetForeignSchema() {
        this.foreignSchema = null;
    }

    public boolean isSetForeignSchema() {
        return this.foreignSchema != null;
    }

    public void setForeignSchemaIsSet(boolean value) {
        if (!value) {
            this.foreignSchema = null;
        }
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public ServiceMetaDataArgs setForeignTable(String foreignTable) {
        this.foreignTable = foreignTable;
        return this;
    }

    public void unsetForeignTable() {
        this.foreignTable = null;
    }

    public boolean isSetForeignTable() {
        return this.foreignTable != null;
    }

    public void setForeignTableIsSet(boolean value) {
        if (!value) {
            this.foreignTable = null;
        }
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public ServiceMetaDataArgs setProcedureName(String procedureName) {
        this.procedureName = procedureName;
        return this;
    }

    public void unsetProcedureName() {
        this.procedureName = null;
    }

    public boolean isSetProcedureName() {
        return this.procedureName != null;
    }

    public void setProcedureNameIsSet(boolean value) {
        if (!value) {
            this.procedureName = null;
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public ServiceMetaDataArgs setFunctionName(String functionName) {
        this.functionName = functionName;
        return this;
    }

    public void unsetFunctionName() {
        this.functionName = null;
    }

    public boolean isSetFunctionName() {
        return this.functionName != null;
    }

    public void setFunctionNameIsSet(boolean value) {
        if (!value) {
            this.functionName = null;
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public ServiceMetaDataArgs setAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public void unsetAttributeName() {
        this.attributeName = null;
    }

    public boolean isSetAttributeName() {
        return this.attributeName != null;
    }

    public void setAttributeNameIsSet(boolean value) {
        if (!value) {
            this.attributeName = null;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public ServiceMetaDataArgs setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public void unsetTypeName() {
        this.typeName = null;
    }

    public boolean isSetTypeName() {
        return this.typeName != null;
    }

    public void setTypeNameIsSet(boolean value) {
        if (!value) {
            this.typeName = null;
        }
    }

    public SnappyType getTypeId() {
        return this.typeId;
    }

    public ServiceMetaDataArgs setTypeId(SnappyType typeId) {
        this.typeId = typeId;
        return this;
    }

    public void unsetTypeId() {
        this.typeId = null;
    }

    public boolean isSetTypeId() {
        return this.typeId != null;
    }

    public void setTypeIdIsSet(boolean value) {
        if (!value) {
            this.typeId = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case CONN_ID: {
                if (value == null) {
                    this.unsetConnId();
                    break;
                }
                this.setConnId((Long)value);
                break;
            }
            case DRIVER_TYPE: {
                if (value == null) {
                    this.unsetDriverType();
                    break;
                }
                this.setDriverType((Byte)value);
                break;
            }
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((ByteBuffer)value);
                break;
            }
            case SCHEMA: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((String)value);
                break;
            }
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((String)value);
                break;
            }
            case TABLE_TYPES: {
                if (value == null) {
                    this.unsetTableTypes();
                    break;
                }
                this.setTableTypes((List)value);
                break;
            }
            case COLUMN_NAME: {
                if (value == null) {
                    this.unsetColumnName();
                    break;
                }
                this.setColumnName((String)value);
                break;
            }
            case FOREIGN_SCHEMA: {
                if (value == null) {
                    this.unsetForeignSchema();
                    break;
                }
                this.setForeignSchema((String)value);
                break;
            }
            case FOREIGN_TABLE: {
                if (value == null) {
                    this.unsetForeignTable();
                    break;
                }
                this.setForeignTable((String)value);
                break;
            }
            case PROCEDURE_NAME: {
                if (value == null) {
                    this.unsetProcedureName();
                    break;
                }
                this.setProcedureName((String)value);
                break;
            }
            case FUNCTION_NAME: {
                if (value == null) {
                    this.unsetFunctionName();
                    break;
                }
                this.setFunctionName((String)value);
                break;
            }
            case ATTRIBUTE_NAME: {
                if (value == null) {
                    this.unsetAttributeName();
                    break;
                }
                this.setAttributeName((String)value);
                break;
            }
            case TYPE_NAME: {
                if (value == null) {
                    this.unsetTypeName();
                    break;
                }
                this.setTypeName((String)value);
                break;
            }
            case TYPE_ID: {
                if (value == null) {
                    this.unsetTypeId();
                    break;
                }
                this.setTypeId((SnappyType)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CONN_ID: {
                return this.getConnId();
            }
            case DRIVER_TYPE: {
                return this.getDriverType();
            }
            case TOKEN: {
                return this.getToken();
            }
            case SCHEMA: {
                return this.getSchema();
            }
            case TABLE: {
                return this.getTable();
            }
            case TABLE_TYPES: {
                return this.getTableTypes();
            }
            case COLUMN_NAME: {
                return this.getColumnName();
            }
            case FOREIGN_SCHEMA: {
                return this.getForeignSchema();
            }
            case FOREIGN_TABLE: {
                return this.getForeignTable();
            }
            case PROCEDURE_NAME: {
                return this.getProcedureName();
            }
            case FUNCTION_NAME: {
                return this.getFunctionName();
            }
            case ATTRIBUTE_NAME: {
                return this.getAttributeName();
            }
            case TYPE_NAME: {
                return this.getTypeName();
            }
            case TYPE_ID: {
                return this.getTypeId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CONN_ID: {
                return this.isSetConnId();
            }
            case DRIVER_TYPE: {
                return this.isSetDriverType();
            }
            case TOKEN: {
                return this.isSetToken();
            }
            case SCHEMA: {
                return this.isSetSchema();
            }
            case TABLE: {
                return this.isSetTable();
            }
            case TABLE_TYPES: {
                return this.isSetTableTypes();
            }
            case COLUMN_NAME: {
                return this.isSetColumnName();
            }
            case FOREIGN_SCHEMA: {
                return this.isSetForeignSchema();
            }
            case FOREIGN_TABLE: {
                return this.isSetForeignTable();
            }
            case PROCEDURE_NAME: {
                return this.isSetProcedureName();
            }
            case FUNCTION_NAME: {
                return this.isSetFunctionName();
            }
            case ATTRIBUTE_NAME: {
                return this.isSetAttributeName();
            }
            case TYPE_NAME: {
                return this.isSetTypeName();
            }
            case TYPE_ID: {
                return this.isSetTypeId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ServiceMetaDataArgs) {
            return this.equals((ServiceMetaDataArgs)that);
        }
        return false;
    }

    public boolean equals(ServiceMetaDataArgs that) {
        if (that == null) {
            return false;
        }
        boolean this_present_connId = true;
        boolean that_present_connId = true;
        if (this_present_connId || that_present_connId) {
            if (!this_present_connId || !that_present_connId) {
                return false;
            }
            if (this.connId != that.connId) {
                return false;
            }
        }
        boolean this_present_driverType = true;
        boolean that_present_driverType = true;
        if (this_present_driverType || that_present_driverType) {
            if (!this_present_driverType || !that_present_driverType) {
                return false;
            }
            if (this.driverType != that.driverType) {
                return false;
            }
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!this.schema.equals(that.schema)) {
                return false;
            }
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_tableTypes = this.isSetTableTypes();
        boolean that_present_tableTypes = that.isSetTableTypes();
        if (this_present_tableTypes || that_present_tableTypes) {
            if (!this_present_tableTypes || !that_present_tableTypes) {
                return false;
            }
            if (!this.tableTypes.equals(that.tableTypes)) {
                return false;
            }
        }
        boolean this_present_columnName = this.isSetColumnName();
        boolean that_present_columnName = that.isSetColumnName();
        if (this_present_columnName || that_present_columnName) {
            if (!this_present_columnName || !that_present_columnName) {
                return false;
            }
            if (!this.columnName.equals(that.columnName)) {
                return false;
            }
        }
        boolean this_present_foreignSchema = this.isSetForeignSchema();
        boolean that_present_foreignSchema = that.isSetForeignSchema();
        if (this_present_foreignSchema || that_present_foreignSchema) {
            if (!this_present_foreignSchema || !that_present_foreignSchema) {
                return false;
            }
            if (!this.foreignSchema.equals(that.foreignSchema)) {
                return false;
            }
        }
        boolean this_present_foreignTable = this.isSetForeignTable();
        boolean that_present_foreignTable = that.isSetForeignTable();
        if (this_present_foreignTable || that_present_foreignTable) {
            if (!this_present_foreignTable || !that_present_foreignTable) {
                return false;
            }
            if (!this.foreignTable.equals(that.foreignTable)) {
                return false;
            }
        }
        boolean this_present_procedureName = this.isSetProcedureName();
        boolean that_present_procedureName = that.isSetProcedureName();
        if (this_present_procedureName || that_present_procedureName) {
            if (!this_present_procedureName || !that_present_procedureName) {
                return false;
            }
            if (!this.procedureName.equals(that.procedureName)) {
                return false;
            }
        }
        boolean this_present_functionName = this.isSetFunctionName();
        boolean that_present_functionName = that.isSetFunctionName();
        if (this_present_functionName || that_present_functionName) {
            if (!this_present_functionName || !that_present_functionName) {
                return false;
            }
            if (!this.functionName.equals(that.functionName)) {
                return false;
            }
        }
        boolean this_present_attributeName = this.isSetAttributeName();
        boolean that_present_attributeName = that.isSetAttributeName();
        if (this_present_attributeName || that_present_attributeName) {
            if (!this_present_attributeName || !that_present_attributeName) {
                return false;
            }
            if (!this.attributeName.equals(that.attributeName)) {
                return false;
            }
        }
        boolean this_present_typeName = this.isSetTypeName();
        boolean that_present_typeName = that.isSetTypeName();
        if (this_present_typeName || that_present_typeName) {
            if (!this_present_typeName || !that_present_typeName) {
                return false;
            }
            if (!this.typeName.equals(that.typeName)) {
                return false;
            }
        }
        boolean this_present_typeId = this.isSetTypeId();
        boolean that_present_typeId = that.isSetTypeId();
        if (this_present_typeId || that_present_typeId) {
            if (!this_present_typeId || !that_present_typeId) {
                return false;
            }
            if (!this.typeId.equals((Object)that.typeId)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_connId = true;
        list.add(present_connId);
        if (present_connId) {
            list.add(this.connId);
        }
        boolean present_driverType = true;
        list.add(present_driverType);
        if (present_driverType) {
            list.add(this.driverType);
        }
        boolean present_token = this.isSetToken();
        list.add(present_token);
        if (present_token) {
            list.add(this.token);
        }
        boolean present_schema = this.isSetSchema();
        list.add(present_schema);
        if (present_schema) {
            list.add(this.schema);
        }
        boolean present_table = this.isSetTable();
        list.add(present_table);
        if (present_table) {
            list.add(this.table);
        }
        boolean present_tableTypes = this.isSetTableTypes();
        list.add(present_tableTypes);
        if (present_tableTypes) {
            list.add(this.tableTypes);
        }
        boolean present_columnName = this.isSetColumnName();
        list.add(present_columnName);
        if (present_columnName) {
            list.add(this.columnName);
        }
        boolean present_foreignSchema = this.isSetForeignSchema();
        list.add(present_foreignSchema);
        if (present_foreignSchema) {
            list.add(this.foreignSchema);
        }
        boolean present_foreignTable = this.isSetForeignTable();
        list.add(present_foreignTable);
        if (present_foreignTable) {
            list.add(this.foreignTable);
        }
        boolean present_procedureName = this.isSetProcedureName();
        list.add(present_procedureName);
        if (present_procedureName) {
            list.add(this.procedureName);
        }
        boolean present_functionName = this.isSetFunctionName();
        list.add(present_functionName);
        if (present_functionName) {
            list.add(this.functionName);
        }
        boolean present_attributeName = this.isSetAttributeName();
        list.add(present_attributeName);
        if (present_attributeName) {
            list.add(this.attributeName);
        }
        boolean present_typeName = this.isSetTypeName();
        list.add(present_typeName);
        if (present_typeName) {
            list.add(this.typeName);
        }
        boolean present_typeId = this.isSetTypeId();
        list.add(present_typeId);
        if (present_typeId) {
            list.add(this.typeId.getValue());
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ServiceMetaDataArgs other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetConnId()).compareTo(other.isSetConnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConnId() && (lastComparison = TBaseHelper.compareTo((long)this.connId, (long)other.connId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDriverType()).compareTo(other.isSetDriverType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDriverType() && (lastComparison = TBaseHelper.compareTo((byte)this.driverType, (byte)other.driverType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetToken()).compareTo(other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((Comparable)this.token, (Comparable)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(other.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchema() && (lastComparison = TBaseHelper.compareTo((String)this.schema, (String)other.schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTable()).compareTo(other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((String)this.table, (String)other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTableTypes()).compareTo(other.isSetTableTypes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableTypes() && (lastComparison = TBaseHelper.compareTo(this.tableTypes, other.tableTypes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnName()).compareTo(other.isSetColumnName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnName() && (lastComparison = TBaseHelper.compareTo((String)this.columnName, (String)other.columnName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetForeignSchema()).compareTo(other.isSetForeignSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetForeignSchema() && (lastComparison = TBaseHelper.compareTo((String)this.foreignSchema, (String)other.foreignSchema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetForeignTable()).compareTo(other.isSetForeignTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetForeignTable() && (lastComparison = TBaseHelper.compareTo((String)this.foreignTable, (String)other.foreignTable)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetProcedureName()).compareTo(other.isSetProcedureName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProcedureName() && (lastComparison = TBaseHelper.compareTo((String)this.procedureName, (String)other.procedureName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFunctionName()).compareTo(other.isSetFunctionName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFunctionName() && (lastComparison = TBaseHelper.compareTo((String)this.functionName, (String)other.functionName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAttributeName()).compareTo(other.isSetAttributeName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAttributeName() && (lastComparison = TBaseHelper.compareTo((String)this.attributeName, (String)other.attributeName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTypeName()).compareTo(other.isSetTypeName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTypeName() && (lastComparison = TBaseHelper.compareTo((String)this.typeName, (String)other.typeName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTypeId()).compareTo(other.isSetTypeId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTypeId() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.typeId), (Comparable)((Object)other.typeId))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceMetaDataArgs(");
        boolean first = true;
        sb.append("connId:");
        sb.append(this.connId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("driverType:");
        sb.append(this.driverType);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("token:");
        if (this.token == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.token, (StringBuilder)sb);
        }
        first = false;
        if (this.isSetSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("schema:");
            if (this.schema == null) {
                sb.append("null");
            } else {
                sb.append(this.schema);
            }
            first = false;
        }
        if (this.isSetTable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("table:");
            if (this.table == null) {
                sb.append("null");
            } else {
                sb.append(this.table);
            }
            first = false;
        }
        if (this.isSetTableTypes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tableTypes:");
            if (this.tableTypes == null) {
                sb.append("null");
            } else {
                sb.append(this.tableTypes);
            }
            first = false;
        }
        if (this.isSetColumnName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columnName:");
            if (this.columnName == null) {
                sb.append("null");
            } else {
                sb.append(this.columnName);
            }
            first = false;
        }
        if (this.isSetForeignSchema()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("foreignSchema:");
            if (this.foreignSchema == null) {
                sb.append("null");
            } else {
                sb.append(this.foreignSchema);
            }
            first = false;
        }
        if (this.isSetForeignTable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("foreignTable:");
            if (this.foreignTable == null) {
                sb.append("null");
            } else {
                sb.append(this.foreignTable);
            }
            first = false;
        }
        if (this.isSetProcedureName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("procedureName:");
            if (this.procedureName == null) {
                sb.append("null");
            } else {
                sb.append(this.procedureName);
            }
            first = false;
        }
        if (this.isSetFunctionName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("functionName:");
            if (this.functionName == null) {
                sb.append("null");
            } else {
                sb.append(this.functionName);
            }
            first = false;
        }
        if (this.isSetAttributeName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("attributeName:");
            if (this.attributeName == null) {
                sb.append("null");
            } else {
                sb.append(this.attributeName);
            }
            first = false;
        }
        if (this.isSetTypeName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("typeName:");
            if (this.typeName == null) {
                sb.append("null");
            } else {
                sb.append(this.typeName);
            }
            first = false;
        }
        if (this.isSetTypeId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("typeId:");
            if (this.typeId == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.typeId);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.token == null) {
            throw new TProtocolException("Required field 'token' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ServiceMetaDataArgsStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ServiceMetaDataArgsTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.SCHEMA, _Fields.TABLE, _Fields.TABLE_TYPES, _Fields.COLUMN_NAME, _Fields.FOREIGN_SCHEMA, _Fields.FOREIGN_TABLE, _Fields.PROCEDURE_NAME, _Fields.FUNCTION_NAME, _Fields.ATTRIBUTE_NAME, _Fields.TYPE_NAME, _Fields.TYPE_ID};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CONN_ID, new FieldMetaData("connId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DRIVER_TYPE, new FieldMetaData("driverType", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.SCHEMA, new FieldMetaData("schema", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_TYPES, new FieldMetaData("tableTypes", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.COLUMN_NAME, new FieldMetaData("columnName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.FOREIGN_SCHEMA, new FieldMetaData("foreignSchema", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.FOREIGN_TABLE, new FieldMetaData("foreignTable", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROCEDURE_NAME, new FieldMetaData("procedureName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.FUNCTION_NAME, new FieldMetaData("functionName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ATTRIBUTE_NAME, new FieldMetaData("attributeName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE_NAME, new FieldMetaData("typeName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE_ID, new FieldMetaData("typeId", 2, (FieldValueMetaData)new EnumMetaData(16, SnappyType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ServiceMetaDataArgs.class, metaDataMap);
    }

    private static class ServiceMetaDataArgsTupleScheme
    extends TupleScheme<ServiceMetaDataArgs> {
        private ServiceMetaDataArgsTupleScheme() {
        }

        public void write(TProtocol prot, ServiceMetaDataArgs struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.connId);
            oprot.writeByte(struct.driverType);
            oprot.writeBinary(struct.token);
            BitSet optionals = new BitSet();
            if (struct.isSetSchema()) {
                optionals.set(0);
            }
            if (struct.isSetTable()) {
                optionals.set(1);
            }
            if (struct.isSetTableTypes()) {
                optionals.set(2);
            }
            if (struct.isSetColumnName()) {
                optionals.set(3);
            }
            if (struct.isSetForeignSchema()) {
                optionals.set(4);
            }
            if (struct.isSetForeignTable()) {
                optionals.set(5);
            }
            if (struct.isSetProcedureName()) {
                optionals.set(6);
            }
            if (struct.isSetFunctionName()) {
                optionals.set(7);
            }
            if (struct.isSetAttributeName()) {
                optionals.set(8);
            }
            if (struct.isSetTypeName()) {
                optionals.set(9);
            }
            if (struct.isSetTypeId()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetSchema()) {
                oprot.writeString(struct.schema);
            }
            if (struct.isSetTable()) {
                oprot.writeString(struct.table);
            }
            if (struct.isSetTableTypes()) {
                oprot.writeI32(struct.tableTypes.size());
                for (String _iter98 : struct.tableTypes) {
                    oprot.writeString(_iter98);
                }
            }
            if (struct.isSetColumnName()) {
                oprot.writeString(struct.columnName);
            }
            if (struct.isSetForeignSchema()) {
                oprot.writeString(struct.foreignSchema);
            }
            if (struct.isSetForeignTable()) {
                oprot.writeString(struct.foreignTable);
            }
            if (struct.isSetProcedureName()) {
                oprot.writeString(struct.procedureName);
            }
            if (struct.isSetFunctionName()) {
                oprot.writeString(struct.functionName);
            }
            if (struct.isSetAttributeName()) {
                oprot.writeString(struct.attributeName);
            }
            if (struct.isSetTypeName()) {
                oprot.writeString(struct.typeName);
            }
            if (struct.isSetTypeId()) {
                oprot.writeI32(struct.typeId.getValue());
            }
        }

        public void read(TProtocol prot, ServiceMetaDataArgs struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.connId = iprot.readI64();
            struct.setConnIdIsSet(true);
            struct.driverType = iprot.readByte();
            struct.setDriverTypeIsSet(true);
            struct.token = iprot.readBinary();
            struct.setTokenIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.schema = iprot.readString();
                struct.setSchemaIsSet(true);
            }
            if (incoming.get(1)) {
                struct.table = iprot.readString();
                struct.setTableIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list99 = new TList(11, iprot.readI32());
                struct.tableTypes = new ArrayList<String>(_list99.size);
                for (int _i101 = 0; _i101 < _list99.size; ++_i101) {
                    String _elem100 = iprot.readString();
                    struct.tableTypes.add(_elem100);
                }
                struct.setTableTypesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.columnName = iprot.readString();
                struct.setColumnNameIsSet(true);
            }
            if (incoming.get(4)) {
                struct.foreignSchema = iprot.readString();
                struct.setForeignSchemaIsSet(true);
            }
            if (incoming.get(5)) {
                struct.foreignTable = iprot.readString();
                struct.setForeignTableIsSet(true);
            }
            if (incoming.get(6)) {
                struct.procedureName = iprot.readString();
                struct.setProcedureNameIsSet(true);
            }
            if (incoming.get(7)) {
                struct.functionName = iprot.readString();
                struct.setFunctionNameIsSet(true);
            }
            if (incoming.get(8)) {
                struct.attributeName = iprot.readString();
                struct.setAttributeNameIsSet(true);
            }
            if (incoming.get(9)) {
                struct.typeName = iprot.readString();
                struct.setTypeNameIsSet(true);
            }
            if (incoming.get(10)) {
                struct.typeId = SnappyType.findByValue(iprot.readI32());
                struct.setTypeIdIsSet(true);
            }
        }
    }

    private static class ServiceMetaDataArgsTupleSchemeFactory
    implements SchemeFactory {
        private ServiceMetaDataArgsTupleSchemeFactory() {
        }

        public ServiceMetaDataArgsTupleScheme getScheme() {
            return new ServiceMetaDataArgsTupleScheme();
        }
    }

    private static class ServiceMetaDataArgsStandardScheme
    extends StandardScheme<ServiceMetaDataArgs> {
        private ServiceMetaDataArgsStandardScheme() {
        }

        public void read(TProtocol iprot, ServiceMetaDataArgs struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.connId = iprot.readI64();
                            struct.setConnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 3) {
                            struct.driverType = iprot.readByte();
                            struct.setDriverTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readBinary();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.schema = iprot.readString();
                            struct.setSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readString();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list94 = iprot.readListBegin();
                            struct.tableTypes = new ArrayList<String>(_list94.size);
                            for (int _i96 = 0; _i96 < _list94.size; ++_i96) {
                                String _elem95 = iprot.readString();
                                struct.tableTypes.add(_elem95);
                            }
                            iprot.readListEnd();
                            struct.setTableTypesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.columnName = iprot.readString();
                            struct.setColumnNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.foreignSchema = iprot.readString();
                            struct.setForeignSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.foreignTable = iprot.readString();
                            struct.setForeignTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.procedureName = iprot.readString();
                            struct.setProcedureNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.functionName = iprot.readString();
                            struct.setFunctionNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.attributeName = iprot.readString();
                            struct.setAttributeNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 11) {
                            struct.typeName = iprot.readString();
                            struct.setTypeNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 8) {
                            struct.typeId = SnappyType.findByValue(iprot.readI32());
                            struct.setTypeIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetConnId()) {
                throw new TProtocolException("Required field 'connId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetDriverType()) {
                throw new TProtocolException("Required field 'driverType' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, ServiceMetaDataArgs struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(CONN_ID_FIELD_DESC);
            oprot.writeI64(struct.connId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DRIVER_TYPE_FIELD_DESC);
            oprot.writeByte(struct.driverType);
            oprot.writeFieldEnd();
            if (struct.token != null) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeBinary(struct.token);
                oprot.writeFieldEnd();
            }
            if (struct.schema != null && struct.isSetSchema()) {
                oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
                oprot.writeString(struct.schema);
                oprot.writeFieldEnd();
            }
            if (struct.table != null && struct.isSetTable()) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeString(struct.table);
                oprot.writeFieldEnd();
            }
            if (struct.tableTypes != null && struct.isSetTableTypes()) {
                oprot.writeFieldBegin(TABLE_TYPES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.tableTypes.size()));
                for (String _iter97 : struct.tableTypes) {
                    oprot.writeString(_iter97);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.columnName != null && struct.isSetColumnName()) {
                oprot.writeFieldBegin(COLUMN_NAME_FIELD_DESC);
                oprot.writeString(struct.columnName);
                oprot.writeFieldEnd();
            }
            if (struct.foreignSchema != null && struct.isSetForeignSchema()) {
                oprot.writeFieldBegin(FOREIGN_SCHEMA_FIELD_DESC);
                oprot.writeString(struct.foreignSchema);
                oprot.writeFieldEnd();
            }
            if (struct.foreignTable != null && struct.isSetForeignTable()) {
                oprot.writeFieldBegin(FOREIGN_TABLE_FIELD_DESC);
                oprot.writeString(struct.foreignTable);
                oprot.writeFieldEnd();
            }
            if (struct.procedureName != null && struct.isSetProcedureName()) {
                oprot.writeFieldBegin(PROCEDURE_NAME_FIELD_DESC);
                oprot.writeString(struct.procedureName);
                oprot.writeFieldEnd();
            }
            if (struct.functionName != null && struct.isSetFunctionName()) {
                oprot.writeFieldBegin(FUNCTION_NAME_FIELD_DESC);
                oprot.writeString(struct.functionName);
                oprot.writeFieldEnd();
            }
            if (struct.attributeName != null && struct.isSetAttributeName()) {
                oprot.writeFieldBegin(ATTRIBUTE_NAME_FIELD_DESC);
                oprot.writeString(struct.attributeName);
                oprot.writeFieldEnd();
            }
            if (struct.typeName != null && struct.isSetTypeName()) {
                oprot.writeFieldBegin(TYPE_NAME_FIELD_DESC);
                oprot.writeString(struct.typeName);
                oprot.writeFieldEnd();
            }
            if (struct.typeId != null && struct.isSetTypeId()) {
                oprot.writeFieldBegin(TYPE_ID_FIELD_DESC);
                oprot.writeI32(struct.typeId.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ServiceMetaDataArgsStandardSchemeFactory
    implements SchemeFactory {
        private ServiceMetaDataArgsStandardSchemeFactory() {
        }

        public ServiceMetaDataArgsStandardScheme getScheme() {
            return new ServiceMetaDataArgsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CONN_ID(1, "connId"),
        DRIVER_TYPE(2, "driverType"),
        TOKEN(3, "token"),
        SCHEMA(4, "schema"),
        TABLE(5, "table"),
        TABLE_TYPES(6, "tableTypes"),
        COLUMN_NAME(7, "columnName"),
        FOREIGN_SCHEMA(8, "foreignSchema"),
        FOREIGN_TABLE(9, "foreignTable"),
        PROCEDURE_NAME(10, "procedureName"),
        FUNCTION_NAME(11, "functionName"),
        ATTRIBUTE_NAME(12, "attributeName"),
        TYPE_NAME(13, "typeName"),
        TYPE_ID(14, "typeId");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CONN_ID;
                }
                case 2: {
                    return DRIVER_TYPE;
                }
                case 3: {
                    return TOKEN;
                }
                case 4: {
                    return SCHEMA;
                }
                case 5: {
                    return TABLE;
                }
                case 6: {
                    return TABLE_TYPES;
                }
                case 7: {
                    return COLUMN_NAME;
                }
                case 8: {
                    return FOREIGN_SCHEMA;
                }
                case 9: {
                    return FOREIGN_TABLE;
                }
                case 10: {
                    return PROCEDURE_NAME;
                }
                case 11: {
                    return FUNCTION_NAME;
                }
                case 12: {
                    return ATTRIBUTE_NAME;
                }
                case 13: {
                    return TYPE_NAME;
                }
                case 14: {
                    return TYPE_ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

